// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package lambda provides a client for AWS Lambda.
package lambda

import (
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddPermission = "AddPermission"

// AddPermissionRequest generates a request for the AddPermission operation.
func (c *Lambda) AddPermissionRequest(input *AddPermissionInput) (req *request.Request, output *AddPermissionOutput) {
	op := &request.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddPermissionOutput{}
	req.Data = output
	return
}

// Adds a permission to the resource policy associated with the specified AWS
// Lambda function. You use resource policies to grant permissions to event
// sources that use push model. In a push model, event sources (such as Amazon
// S3 and custom applications) invoke your Lambda function. Each permission
// you add to the resource policy allows an event source, permission to invoke
// the Lambda function.
//
// For information about the push model, see AWS Lambda: How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html).
//
// If you are using versioning, the permissions you add are specific to the
// Lambda function version or alias you specify in the AddPermission request
// via the Qualifier parameter. For more information about versioning, see AWS
// Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:AddPermission action.
func (c *Lambda) AddPermission(input *AddPermissionInput) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a request for the CreateAlias operation.
func (c *Lambda) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AliasConfiguration{}
	req.Data = output
	return
}

// Creates an alias that points to the specified Lambda function version. For
// more information, see Introduction to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// Alias names are unique for a given function. This requires permission for
// the lambda:CreateAlias action.
func (c *Lambda) CreateAlias(input *CreateAliasInput) (*AliasConfiguration, error) {
	req, out := c.CreateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateEventSourceMapping = "CreateEventSourceMapping"

// CreateEventSourceMappingRequest generates a request for the CreateEventSourceMapping operation.
func (c *Lambda) CreateEventSourceMappingRequest(input *CreateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opCreateEventSourceMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
	}

	if input == nil {
		input = &CreateEventSourceMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EventSourceMappingConfiguration{}
	req.Data = output
	return
}

// Identifies a stream as an event source for a Lambda function. It can be either
// an Amazon Kinesis stream or an Amazon DynamoDB stream. AWS Lambda invokes
// the specified function when records are posted to the stream.
//
// This association between a stream source and a Lambda function is called
// the event source mapping.
//
// This event source mapping is relevant only in the AWS Lambda pull model,
// where AWS Lambda invokes the function. For more information, go to AWS Lambda:
// How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html)
// in the AWS Lambda Developer Guide.  You provide mapping information (for
// example, which stream to read from and which Lambda function to invoke) in
// the request body.
//
//  Each event source, such as an Amazon Kinesis or a DynamoDB stream, can
// be associated with multiple AWS Lambda function. A given Lambda function
// can be associated with multiple AWS event sources.
//
//  If you are using versioning, you can specify a specific function version
// or an alias via the function name parameter. For more information about versioning,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
//  This operation requires permission for the lambda:CreateEventSourceMapping
// action.
func (c *Lambda) CreateEventSourceMapping(input *CreateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.CreateEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opCreateFunction = "CreateFunction"

// CreateFunctionRequest generates a request for the CreateFunction operation.
func (c *Lambda) CreateFunctionRequest(input *CreateFunctionInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opCreateFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions",
	}

	if input == nil {
		input = &CreateFunctionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FunctionConfiguration{}
	req.Data = output
	return
}

// Creates a new Lambda function. The function metadata is created from the
// request parameters, and the code for the function is provided by a .zip file
// in the request body. If the function name already exists, the operation will
// fail. Note that the function name is case-sensitive.
//
//  If you are using versioning, you can also publish a version of the Lambda
// function you are creating using the Publish parameter. For more information
// about versioning, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:CreateFunction action.
func (c *Lambda) CreateFunction(input *CreateFunctionInput) (*FunctionConfiguration, error) {
	req, out := c.CreateFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a request for the DeleteAlias operation.
func (c *Lambda) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteAliasOutput{}
	req.Data = output
	return
}

// Deletes the specified Lambda function alias. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:DeleteAlias action.
func (c *Lambda) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEventSourceMapping = "DeleteEventSourceMapping"

// DeleteEventSourceMappingRequest generates a request for the DeleteEventSourceMapping operation.
func (c *Lambda) DeleteEventSourceMappingRequest(input *DeleteEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opDeleteEventSourceMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &DeleteEventSourceMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EventSourceMappingConfiguration{}
	req.Data = output
	return
}

// Removes an event source mapping. This means AWS Lambda will no longer invoke
// the function for events in the associated source.
//
// This operation requires permission for the lambda:DeleteEventSourceMapping
// action.
func (c *Lambda) DeleteEventSourceMapping(input *DeleteEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.DeleteEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteFunction = "DeleteFunction"

// DeleteFunctionRequest generates a request for the DeleteFunction operation.
func (c *Lambda) DeleteFunctionRequest(input *DeleteFunctionInput) (req *request.Request, output *DeleteFunctionOutput) {
	op := &request.Operation{
		Name:       opDeleteFunction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &DeleteFunctionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteFunctionOutput{}
	req.Data = output
	return
}

// Deletes the specified Lambda function code and configuration.
//
// If you are using the versioning feature and you don't specify a function
// version in your DeleteFunction request, AWS Lambda will delete the function,
// including all its versions, and any aliases pointing to the function versions.
// To delete a specific function version, you must provide the function version
// via the Qualifier parameter. For information about function versioning, see
// AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// When you delete a function the associated resource policy is also deleted.
// You will need to delete the event source mappings explicitly.
//
// This operation requires permission for the lambda:DeleteFunction action.
func (c *Lambda) DeleteFunction(input *DeleteFunctionInput) (*DeleteFunctionOutput, error) {
	req, out := c.DeleteFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opGetAlias = "GetAlias"

// GetAliasRequest generates a request for the GetAlias operation.
func (c *Lambda) GetAliasRequest(input *GetAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opGetAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &GetAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AliasConfiguration{}
	req.Data = output
	return
}

// Returns the specified alias information such as the alias ARN, description,
// and function version it is pointing to. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:GetAlias action.
func (c *Lambda) GetAlias(input *GetAliasInput) (*AliasConfiguration, error) {
	req, out := c.GetAliasRequest(input)
	err := req.Send()
	return out, err
}

const opGetEventSourceMapping = "GetEventSourceMapping"

// GetEventSourceMappingRequest generates a request for the GetEventSourceMapping operation.
func (c *Lambda) GetEventSourceMappingRequest(input *GetEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opGetEventSourceMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &GetEventSourceMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EventSourceMappingConfiguration{}
	req.Data = output
	return
}

// Returns configuration information for the specified event source mapping
// (see CreateEventSourceMapping).
//
// This operation requires permission for the lambda:GetEventSourceMapping
// action.
func (c *Lambda) GetEventSourceMapping(input *GetEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.GetEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opGetFunction = "GetFunction"

// GetFunctionRequest generates a request for the GetFunction operation.
func (c *Lambda) GetFunctionRequest(input *GetFunctionInput) (req *request.Request, output *GetFunctionOutput) {
	op := &request.Operation{
		Name:       opGetFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &GetFunctionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetFunctionOutput{}
	req.Data = output
	return
}

// Returns the configuration information of the Lambda function and a presigned
// URL link to the .zip file you uploaded with CreateFunction so you can download
// the .zip file. Note that the URL is valid for up to 10 minutes. The configuration
// information is the same information you provided as parameters when uploading
// the function.
//
// Using the optional Qualifier parameter, you can specify a specific function
// version for which you want this information. If you don't specify this parameter,
// the API uses unqualified function ARN which return information about the
// $LATEST version of the Lambda function. For more information, see AWS Lambda
// Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:GetFunction action.
func (c *Lambda) GetFunction(input *GetFunctionInput) (*GetFunctionOutput, error) {
	req, out := c.GetFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opGetFunctionConfiguration = "GetFunctionConfiguration"

// GetFunctionConfigurationRequest generates a request for the GetFunctionConfiguration operation.
func (c *Lambda) GetFunctionConfigurationRequest(input *GetFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opGetFunctionConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &GetFunctionConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FunctionConfiguration{}
	req.Data = output
	return
}

// Returns the configuration information of the Lambda function. This the same
// information you provided as parameters when uploading the function by using
// CreateFunction.
//
// If you are using the versioning feature, you can retrieve this information
// for a specific function version by using the optional Qualifier parameter
// and specifying the function version or alias that points to it. If you don't
// provide it, the API returns information about the $LATEST version of the
// function. For more information about versioning, see AWS Lambda Function
// Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:GetFunctionConfiguration
// operation.
func (c *Lambda) GetFunctionConfiguration(input *GetFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.GetFunctionConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a request for the GetPolicy operation.
func (c *Lambda) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPolicyOutput{}
	req.Data = output
	return
}

// Returns the resource policy associated with the specified Lambda function.
//
//  If you are using the versioning feature, you can get the resource policy
// associated with the specific Lambda function version or alias by specifying
// the version or alias name using the Qualifier parameter. For more information
// about versioning, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// For information about adding permissions, see AddPermission.
//
// You need permission for the lambda:GetPolicy action.
func (c *Lambda) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opInvoke = "Invoke"

// InvokeRequest generates a request for the Invoke operation.
func (c *Lambda) InvokeRequest(input *InvokeInput) (req *request.Request, output *InvokeOutput) {
	op := &request.Operation{
		Name:       opInvoke,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/invocations",
	}

	if input == nil {
		input = &InvokeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &InvokeOutput{}
	req.Data = output
	return
}

// Invokes a specific Lambda function.
//
// If you are using the versioning feature, you can invoke the specific function
// version by providing function version or alias name that is pointing to the
// function version using the Qualifier parameter in the request. If you don't
// provide the Qualifier parameter, the $LATEST version of the Lambda function
// is invoked. For information about the versioning feature, see AWS Lambda
// Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:InvokeFunction action.
func (c *Lambda) Invoke(input *InvokeInput) (*InvokeOutput, error) {
	req, out := c.InvokeRequest(input)
	err := req.Send()
	return out, err
}

const opInvokeAsync = "InvokeAsync"

// InvokeAsyncRequest generates a request for the InvokeAsync operation.
func (c *Lambda) InvokeAsyncRequest(input *InvokeAsyncInput) (req *request.Request, output *InvokeAsyncOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, InvokeAsync, has been deprecated")
	}
	op := &request.Operation{
		Name:       opInvokeAsync,
		HTTPMethod: "POST",
		HTTPPath:   "/2014-11-13/functions/{FunctionName}/invoke-async/",
	}

	if input == nil {
		input = &InvokeAsyncInput{}
	}

	req = c.newRequest(op, input, output)
	output = &InvokeAsyncOutput{}
	req.Data = output
	return
}

// This API is deprecated. We recommend you use Invoke API (see Invoke). Submits
// an invocation request to AWS Lambda. Upon receiving the request, Lambda executes
// the specified function asynchronously. To see the logs generated by the Lambda
// function execution, see the CloudWatch Logs console.
//
// This operation requires permission for the lambda:InvokeFunction action.
func (c *Lambda) InvokeAsync(input *InvokeAsyncInput) (*InvokeAsyncOutput, error) {
	req, out := c.InvokeAsyncRequest(input)
	err := req.Send()
	return out, err
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a request for the ListAliases operation.
func (c *Lambda) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAliasesOutput{}
	req.Data = output
	return
}

// Returns list of aliases created for a Lambda function. For each alias, the
// response includes information such as the alias ARN, description, alias name,
// and the function version to which it points. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:ListAliases action.
func (c *Lambda) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	err := req.Send()
	return out, err
}

const opListEventSourceMappings = "ListEventSourceMappings"

// ListEventSourceMappingsRequest generates a request for the ListEventSourceMappings operation.
func (c *Lambda) ListEventSourceMappingsRequest(input *ListEventSourceMappingsInput) (req *request.Request, output *ListEventSourceMappingsOutput) {
	op := &request.Operation{
		Name:       opListEventSourceMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventSourceMappingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListEventSourceMappingsOutput{}
	req.Data = output
	return
}

// Returns a list of event source mappings you created using the CreateEventSourceMapping
// (see CreateEventSourceMapping).
//
// For each mapping, the API returns configuration information. You can optionally
// specify filters to retrieve specific event source mappings.
//
// If you are using the versioning feature, you can get list of event source
// mappings for a specific Lambda function version or an alias as described
// in the FunctionName parameter. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:ListEventSourceMappings
// action.
func (c *Lambda) ListEventSourceMappings(input *ListEventSourceMappingsInput) (*ListEventSourceMappingsOutput, error) {
	req, out := c.ListEventSourceMappingsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Lambda) ListEventSourceMappingsPages(input *ListEventSourceMappingsInput, fn func(p *ListEventSourceMappingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListEventSourceMappingsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListEventSourceMappingsOutput), lastPage)
	})
}

const opListFunctions = "ListFunctions"

// ListFunctionsRequest generates a request for the ListFunctions operation.
func (c *Lambda) ListFunctionsRequest(input *ListFunctionsInput) (req *request.Request, output *ListFunctionsOutput) {
	op := &request.Operation{
		Name:       opListFunctions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFunctionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListFunctionsOutput{}
	req.Data = output
	return
}

// Returns a list of your Lambda functions. For each function, the response
// includes the function configuration information. You must use GetFunction
// to retrieve the code for your function.
//
// This operation requires permission for the lambda:ListFunctions action.
//
// If you are using versioning feature, the response returns list of $LATEST
// versions of your functions. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
func (c *Lambda) ListFunctions(input *ListFunctionsInput) (*ListFunctionsOutput, error) {
	req, out := c.ListFunctionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Lambda) ListFunctionsPages(input *ListFunctionsInput, fn func(p *ListFunctionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListFunctionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListFunctionsOutput), lastPage)
	})
}

const opListVersionsByFunction = "ListVersionsByFunction"

// ListVersionsByFunctionRequest generates a request for the ListVersionsByFunction operation.
func (c *Lambda) ListVersionsByFunctionRequest(input *ListVersionsByFunctionInput) (req *request.Request, output *ListVersionsByFunctionOutput) {
	op := &request.Operation{
		Name:       opListVersionsByFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
	}

	if input == nil {
		input = &ListVersionsByFunctionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVersionsByFunctionOutput{}
	req.Data = output
	return
}

// List all versions of a function. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
func (c *Lambda) ListVersionsByFunction(input *ListVersionsByFunctionInput) (*ListVersionsByFunctionOutput, error) {
	req, out := c.ListVersionsByFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opPublishVersion = "PublishVersion"

// PublishVersionRequest generates a request for the PublishVersion operation.
func (c *Lambda) PublishVersionRequest(input *PublishVersionInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opPublishVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
	}

	if input == nil {
		input = &PublishVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FunctionConfiguration{}
	req.Data = output
	return
}

// Publishes a version of your function from the current snapshot of $LATEST.
// That is, AWS Lambda takes a snapshot of the function code and configuration
// information from $LATEST and publishes a new version. The code and configuration
// cannot be modified after publication. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
func (c *Lambda) PublishVersion(input *PublishVersionInput) (*FunctionConfiguration, error) {
	req, out := c.PublishVersionRequest(input)
	err := req.Send()
	return out, err
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a request for the RemovePermission operation.
func (c *Lambda) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy/{StatementId}",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RemovePermissionOutput{}
	req.Data = output
	return
}

// You can remove individual permissions from an resource policy associated
// with a Lambda function by providing a statement ID that you provided when
// you added the permission.
//
// If you are using versioning, the permissions you remove are specific to
// the Lambda function version or alias you specify in the AddPermission request
// via the Qualifier parameter. For more information about versioning, see AWS
// Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Note that removal of a permission will cause an active event source to lose
// permission to the function.
//
// You need permission for the lambda:RemovePermission action.
func (c *Lambda) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a request for the UpdateAlias operation.
func (c *Lambda) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AliasConfiguration{}
	req.Data = output
	return
}

// Using this API you can update the function version to which the alias points
// and the alias description. For more information, see Introduction to AWS
// Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:UpdateAlias action.
func (c *Lambda) UpdateAlias(input *UpdateAliasInput) (*AliasConfiguration, error) {
	req, out := c.UpdateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateEventSourceMapping = "UpdateEventSourceMapping"

// UpdateEventSourceMappingRequest generates a request for the UpdateEventSourceMapping operation.
func (c *Lambda) UpdateEventSourceMappingRequest(input *UpdateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opUpdateEventSourceMapping,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &UpdateEventSourceMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EventSourceMappingConfiguration{}
	req.Data = output
	return
}

// You can update an event source mapping. This is useful if you want to change
// the parameters of the existing mapping without losing your position in the
// stream. You can change which function will receive the stream records, but
// to change the stream itself, you must create a new mapping.
//
// If you are using the versioning feature, you can update the event source
// mapping to map to a specific Lambda function version or alias as described
// in the FunctionName parameter. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// If you disable the event source mapping, AWS Lambda stops polling. If you
// enable again, it will resume polling from the time it had stopped polling,
// so you don't lose processing of any records. However, if you delete event
// source mapping and create it again, it will reset.
//
// This operation requires permission for the lambda:UpdateEventSourceMapping
// action.
func (c *Lambda) UpdateEventSourceMapping(input *UpdateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.UpdateEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFunctionCode = "UpdateFunctionCode"

// UpdateFunctionCodeRequest generates a request for the UpdateFunctionCode operation.
func (c *Lambda) UpdateFunctionCodeRequest(input *UpdateFunctionCodeInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionCode,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/code",
	}

	if input == nil {
		input = &UpdateFunctionCodeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FunctionConfiguration{}
	req.Data = output
	return
}

// Updates the code for the specified Lambda function. This operation must only
// be used on an existing Lambda function and cannot be used to update the function
// configuration.
//
// If you are using the versioning feature, note this API will always update
// the $LATEST version of your Lambda function. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:UpdateFunctionCode action.
func (c *Lambda) UpdateFunctionCode(input *UpdateFunctionCodeInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionCodeRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFunctionConfiguration = "UpdateFunctionConfiguration"

// UpdateFunctionConfigurationRequest generates a request for the UpdateFunctionConfiguration operation.
func (c *Lambda) UpdateFunctionConfigurationRequest(input *UpdateFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &UpdateFunctionConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FunctionConfiguration{}
	req.Data = output
	return
}

// Updates the configuration parameters for the specified Lambda function by
// using the values provided in the request. You provide only the parameters
// you want to change. This operation must only be used on an existing Lambda
// function and cannot be used to update the function's code.
//
// If you are using the versioning feature, note this API will always update
// the $LATEST version of your Lambda function. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:UpdateFunctionConfiguration
// action.
func (c *Lambda) UpdateFunctionConfiguration(input *UpdateFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionConfigurationRequest(input)
	err := req.Send()
	return out, err
}

type AddPermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS Lambda action you want to allow in this statement. Each Lambda action
	// is a string starting with lambda: followed by the API name (see Operations).
	// For example, lambda:CreateFunction. You can use wildcard (lambda:*) to grant
	// permission for all AWS Lambda actions.
	Action *string `type:"string" required:"true"`

	// Name of the Lambda function whose resource policy you are updating by adding
	// a new permission.
	//
	//  You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The principal who is getting this permission. It can be Amazon S3 service
	// Principal (s3.amazonaws.com) if you want Amazon S3 to invoke the function,
	// an AWS account ID if you are granting cross-account permission, or any valid
	// AWS service principal such as sns.amazonaws.com. For example, you might want
	// to allow a custom application in another AWS account to push events to AWS
	// Lambda by invoking your function.
	Principal *string `type:"string" required:"true"`

	// You can use this optional query parameter to describe a qualified ARN using
	// a function version or an alias name. The permission will then apply to the
	// specific qualified ARN. For example, if you specify function version 2 as
	// the qualifier, then permission applies only when request is made using qualified
	// function ARN:
	//
	// arn:aws:lambda:aws-region:acct-id:function:function-name:2
	//
	// If you specify an alias name, for example PROD, then the permission is valid
	// only for requests made using the alias ARN:
	//
	// arn:aws:lambda:aws-region:acct-id:function:function-name:PROD
	//
	// If the qualifier is not specified, the permission is valid only when requests
	// is made using unqualified function ARN.
	//
	// arn:aws:lambda:aws-region:acct-id:function:function-name
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// The AWS account ID (without a hyphen) of the source owner. For example, if
	// the SourceArn identifies a bucket, then this is the bucket owner's account
	// ID. You can use this additional condition to ensure the bucket you specify
	// is owned by a specific account (it is possible the bucket owner deleted the
	// bucket and some other AWS account created the bucket). You can also use this
	// condition to specify all sources (that is, you don't specify the SourceArn)
	// owned by a specific account.
	SourceAccount *string `type:"string"`

	// This is optional; however, when granting Amazon S3 permission to invoke your
	// function, you should specify this field with the bucket Amazon Resource Name
	// (ARN) as its value. This ensures that only events generated from the specified
	// bucket can invoke the function.
	//
	// If you add a permission for the Amazon S3 principal without providing the
	// source ARN, any AWS account that creates a mapping to your function ARN can
	// send events to invoke your Lambda function from Amazon S3.
	SourceArn *string `type:"string"`

	// A unique statement identifier.
	StatementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionInput) GoString() string {
	return s.String()
}

type AddPermissionOutput struct {
	_ struct{} `type:"structure"`

	// The permission statement you specified in the request. The response returns
	// the same as a string using a backslash ("\") as an escape character in the
	// JSON.
	Statement *string `type:"string"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionOutput) GoString() string {
	return s.String()
}

// Provides configuration information about a Lambda function version alias.
type AliasConfiguration struct {
	_ struct{} `type:"structure"`

	// Lambda function ARN that is qualified using the alias name as the suffix.
	// For example, if you create an alias called BETA that points to a helloworld
	// function version, the ARN is arn:aws:lambda:aws-regions:acct-id:function:helloworld:BETA.
	AliasArn *string `type:"string"`

	// Alias description.
	Description *string `type:"string"`

	// Function version to which the alias points.
	FunctionVersion *string `min:"1" type:"string"`

	// Alias name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AliasConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasConfiguration) GoString() string {
	return s.String()
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Description of the alias.
	Description *string `type:"string"`

	// Name of the Lambda function for which you want to create an alias.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Lambda function version for which you are creating the alias.
	FunctionVersion *string `min:"1" type:"string" required:"true"`

	// Name for the alias you are creating.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

type CreateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The largest number of records that AWS Lambda will retrieve from your event
	// source at the time of invoking your function. Your function receives an event
	// with all the retrieved records. The default is 100 records.
	BatchSize *int64 `min:"1" type:"integer"`

	// Indicates whether AWS Lambda should begin polling the event source. By default,
	// Enabled is true.
	Enabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis or the Amazon DynamoDB
	// stream that is the event source. Any record added to this stream could cause
	// AWS Lambda to invoke your Lambda function, it depends on the BatchSize. AWS
	// Lambda POSTs the Amazon Kinesis event, containing records, to your Lambda
	// function as JSON.
	EventSourceArn *string `type:"string" required:"true"`

	// The Lambda function to invoke when AWS Lambda detects an event on the stream.
	//
	//  You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	//
	//  If you are using versioning, you can also provide a qualified function
	// ARN (ARN that is qualified with function version or alias name as suffix).
	// For more information about versioning, see AWS Lambda Function Versioning
	// and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
	//
	// AWS Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail).
	//
	//  Note that the length constraint applies only to the ARN. If you specify
	// only the function name, it is limited to 64 character in length.
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The position in the stream where AWS Lambda should start reading. For more
	// information, go to ShardIteratorType (http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType)
	// in the Amazon Kinesis API Reference.
	StartingPosition *string `type:"string" required:"true" enum:"EventSourcePosition"`
}

// String returns the string representation
func (s CreateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSourceMappingInput) GoString() string {
	return s.String()
}

type CreateFunctionInput struct {
	_ struct{} `type:"structure"`

	// The code for the Lambda function.
	Code *FunctionCode `type:"structure" required:"true"`

	// A short, user-defined function description. Lambda does not use this value.
	// Assign a meaningful description as you see fit.
	Description *string `type:"string"`

	// The name you want to assign to the function you are uploading. The function
	// names appear in the console and are returned in the ListFunctions API. Function
	// names are used to specify functions to other AWS Lambda APIs, such as Invoke.
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The function within your code that Lambda calls to begin execution. For Node.js,
	// it is the module-name.export value in your function. For Java, it can be
	// package.class-name::handler or package.class-name. For more information,
	// see Lambda Function Handler (Java) (http://docs.aws.amazon.com/lambda/latest/dg/java-programming-model-handler-types.html).
	Handler *string `type:"string" required:"true"`

	// The amount of memory, in MB, your Lambda function is given. Lambda uses this
	// memory size to infer the amount of CPU and memory allocated to your function.
	// Your function use-case determines your CPU and memory requirements. For example,
	// a database operation might need less memory compared to an image processing
	// function. The default value is 128 MB. The value must be a multiple of 64
	// MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// This boolean parameter can be used to request AWS Lambda to create the Lambda
	// function and publish a version as an atomic operation.
	Publish *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it
	// executes your function to access any other Amazon Web Services (AWS) resources.
	// For more information, see AWS Lambda: How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html).
	Role *string `type:"string" required:"true"`

	// The runtime environment for the Lambda function you are uploading.
	Runtime *string `type:"string" required:"true" enum:"Runtime"`

	// The function execution time at which Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// If your Lambda function accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and one subnet
	// ID.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionInput) GoString() string {
	return s.String()
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The Lambda function name for which the alias is created. Deleting an alias
	// does not delete the function version to which it is pointing.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Name of the alias to delete.
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The event source mapping ID.
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSourceMappingInput) GoString() string {
	return s.String()
}

type DeleteFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Lambda function to delete.
	//
	//  You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). AWS
	// Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail). Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this optional parameter you can specify a function version (but not
	// the $LATEST version) to direct AWS Lambda to delete a specific function version.
	// If the function version has one or more aliases pointing to it, you will
	// get an error because you cannot have aliases pointing to it. You can delete
	// any function version but not the $LATEST, that is, you cannot specify $LATEST
	// as the value of this parameter. The $LATEST version can be deleted only when
	// you want to delete all the function versions and aliases.
	//
	// You can only specify a function version, not an alias name, using this parameter.
	// You cannot delete a function version using its alias.
	//
	// If you don't specify this parameter, AWS Lambda will delete the function,
	// including all of its versions and aliases.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionInput) GoString() string {
	return s.String()
}

type DeleteFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionOutput) GoString() string {
	return s.String()
}

// Describes mapping between an Amazon Kinesis stream and a Lambda function.
type EventSourceMappingConfiguration struct {
	_ struct{} `type:"structure"`

	// The largest number of records that AWS Lambda will retrieve from your event
	// source at the time of invoking your function. Your function receives an event
	// with all the retrieved records.
	BatchSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream that is the source
	// of events.
	EventSourceArn *string `type:"string"`

	// The Lambda function to invoke when AWS Lambda detects an event on the stream.
	FunctionArn *string `type:"string"`

	// The UTC time string indicating the last time the event mapping was updated.
	LastModified *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// The state of the event source mapping. It can be Creating, Enabled, Disabled,
	// Enabling, Disabling, Updating, or Deleting.
	State *string `type:"string"`

	// The reason the event source mapping is in its current state. It is either
	// user-requested or an AWS Lambda-initiated state transition.
	StateTransitionReason *string `type:"string"`

	// The AWS Lambda assigned opaque identifier for the mapping.
	UUID *string `type:"string"`
}

// String returns the string representation
func (s EventSourceMappingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSourceMappingConfiguration) GoString() string {
	return s.String()
}

// The code for the Lambda function.
type FunctionCode struct {
	_ struct{} `type:"structure"`

	// Amazon S3 bucket name where the .zip file containing your deployment package
	// is stored. This bucket must reside in the same AWS region where you are creating
	// the Lambda function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 object (the deployment package) key name you want to upload.
	S3Key *string `min:"1" type:"string"`

	// The Amazon S3 object (the deployment package) version you want to upload.
	S3ObjectVersion *string `min:"1" type:"string"`

	// A zip file containing your deployment package. If you are using the API directly,
	// the zip file must be base64-encoded (if you are using the AWS SDKs or the
	// AWS CLI, the SDKs or CLI will do the encoding for you). For more information
	// about creating a .zip file, go to Execution Permissions (http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html)
	// in the AWS Lambda Developer Guide.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s FunctionCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCode) GoString() string {
	return s.String()
}

// The object for the Lambda function location.
type FunctionCodeLocation struct {
	_ struct{} `type:"structure"`

	// The presigned URL you can use to download the function's .zip file that you
	// previously uploaded. The URL is valid for up to 10 minutes.
	Location *string `type:"string"`

	// The repository from which you can download the function.
	RepositoryType *string `type:"string"`
}

// String returns the string representation
func (s FunctionCodeLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCodeLocation) GoString() string {
	return s.String()
}

// A complex type that describes function metadata.
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// It is the SHA256 hash of your function deployment package.
	CodeSha256 *string `type:"string"`

	// The size, in bytes, of the function .zip file you uploaded.
	CodeSize *int64 `type:"long"`

	// The user-provided description.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) assigned to the function.
	FunctionArn *string `type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The function Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The time stamp of the last time you updated the function.
	LastModified *string `type:"string"`

	// The memory size, in MB, you configured for the function. Must be a multiple
	// of 64 MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it
	// executes your function to access any other Amazon Web Services (AWS) resources.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime *string `type:"string" enum:"Runtime"`

	// The function execution time at which Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// The version of the Lambda function.
	Version *string `min:"1" type:"string"`

	// VPC configuration associated with your Lambda function.
	VpcConfig *VpcConfigResponse `type:"structure"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfiguration) GoString() string {
	return s.String()
}

type GetAliasInput struct {
	_ struct{} `type:"structure"`

	// Function name for which the alias is created. An alias is a subresource that
	// exists only in the context of an existing Lambda function so you must specify
	// the function name.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Name of the alias for which you want to retrieve information.
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAliasInput) GoString() string {
	return s.String()
}

type GetEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The AWS Lambda assigned ID of the event source mapping.
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventSourceMappingInput) GoString() string {
	return s.String()
}

type GetFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function for which you want to retrieve the configuration
	// information.
	//
	//  You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this optional parameter you can specify a function version or an alias
	// name. If you specify function version, the API uses qualified function ARN
	// and returns information about the specific function version. If you specify
	// an alias name, the API uses the alias ARN and returns information about the
	// function version to which the alias points.
	//
	// If you don't specify this parameter, the API uses unqualified function ARN,
	// and returns information about the $LATEST function version.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionConfigurationInput) GoString() string {
	return s.String()
}

type GetFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Lambda function name.
	//
	//  You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this optional parameter to specify a function version or an alias name.
	// If you specify function version, the API uses qualified function ARN for
	// the request and returns information about the specific Lambda function version.
	// If you specify an alias name, the API uses the alias ARN and returns information
	// about the function version to which the alias points. If you don't provide
	// this parameter, the API uses unqualified function ARN and returns information
	// about the $LATEST version of the Lambda function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionInput) GoString() string {
	return s.String()
}

// This response contains the object for the Lambda function location (see API_FunctionCodeLocation.
type GetFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The object for the Lambda function location.
	Code *FunctionCodeLocation `type:"structure"`

	// A complex type that describes function metadata.
	Configuration *FunctionConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionOutput) GoString() string {
	return s.String()
}

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// Function name whose resource policy you want to retrieve.
	//
	//  You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). AWS
	// Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail). Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// You can specify this optional query parameter to specify a function version
	// or an alias name in which case this API will return all permissions associated
	// with the specific qualified ARN. If you don't provide this parameter, the
	// API will return permissions that apply to the unqualified function ARN.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The resource policy associated with the specified function. The response
	// returns the same as a string using a backslash ("\") as an escape character
	// in the JSON.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

type InvokeAsyncInput struct {
	_ struct{} `deprecated:"true" type:"structure" payload:"InvokeArgs"`

	// The Lambda function name.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// JSON that you want to provide to your Lambda function as input.
	InvokeArgs io.ReadSeeker `type:"blob" required:"true"`
}

// String returns the string representation
func (s InvokeAsyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncInput) GoString() string {
	return s.String()
}

// Upon success, it returns empty response. Otherwise, throws an exception.
type InvokeAsyncOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// It will be 202 upon success.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeAsyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncOutput) GoString() string {
	return s.String()
}

type InvokeInput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// Using the ClientContext you can pass client-specific information to the Lambda
	// function you are invoking. You can then process the client information in
	// your Lambda function as you choose through the context variable. For an example
	// of a ClientContext JSON, see PutEvents (http://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html)
	// in the Amazon Mobile Analytics API Reference and User Guide.
	//
	// The ClientContext JSON must be base64-encoded.
	ClientContext *string `location:"header" locationName:"X-Amz-Client-Context" type:"string"`

	// The Lambda function name.
	//
	//  You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// By default, the Invoke API assumes RequestResponse invocation type. You can
	// optionally request asynchronous execution by specifying Event as the InvocationType.
	// You can also use this parameter to request AWS Lambda to not execute the
	// function but do some verification, such as if the caller is authorized to
	// invoke the function and if the inputs are valid. You request this by specifying
	// DryRun as the InvocationType. This is useful in a cross-account scenario
	// when you want to verify access to a function without running it.
	InvocationType *string `location:"header" locationName:"X-Amz-Invocation-Type" type:"string" enum:"InvocationType"`

	// You can set this optional parameter to Tail in the request only if you specify
	// the InvocationType parameter with value RequestResponse. In this case, AWS
	// Lambda returns the base64-encoded last 4 KB of log data produced by your
	// Lambda function in the x-amz-log-results header.
	LogType *string `location:"header" locationName:"X-Amz-Log-Type" type:"string" enum:"LogType"`

	// JSON that you want to provide to your Lambda function as input.
	Payload []byte `type:"blob"`

	// You can use this optional parameter to specify a Lambda function version
	// or alias name. If you specify a function version, the API uses the qualified
	// function ARN to invoke a specific Lambda function. If you specify an alias
	// name, the API uses the alias ARN to invoke the Lambda function version to
	// which the alias points.
	//
	// If you don't provide this parameter, then the API uses unqualified function
	// ARN which results in invocation of the $LATEST version.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s InvokeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeInput) GoString() string {
	return s.String()
}

// Upon success, returns an empty response. Otherwise, throws an exception.
type InvokeOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// Indicates whether an error occurred while executing the Lambda function.
	// If an error occurred this field will have one of two values; Handled or Unhandled.
	// Handled errors are errors that are reported by the function while the Unhandled
	// errors are those detected and reported by AWS Lambda. Unhandled errors include
	// out of memory errors and function timeouts. For information about how to
	// report an Handled error, see Programming Model (http://docs.aws.amazon.com/lambda/latest/dg/programming-model.html).
	FunctionError *string `location:"header" locationName:"X-Amz-Function-Error" type:"string"`

	// It is the base64-encoded logs for the Lambda function invocation. This is
	// present only if the invocation type is RequestResponse and the logs were
	// requested.
	LogResult *string `location:"header" locationName:"X-Amz-Log-Result" type:"string"`

	// It is the JSON representation of the object returned by the Lambda function.
	// In This is present only if the invocation type is RequestResponse.
	//
	// In the event of a function error this field contains a message describing
	// the error. For the Handled errors the Lambda function will report this message.
	// For Unhandled errors AWS Lambda reports the message.
	Payload []byte `type:"blob"`

	// The HTTP status code will be in the 200 range for successful request. For
	// the RequestResonse invocation type this status code will be 200. For the
	// Event invocation type this status code will be 202. For the DryRun invocation
	// type the status code will be 204.
	StatusCode *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeOutput) GoString() string {
	return s.String()
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// Lambda function name for which the alias is created.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// If you specify this optional parameter, the API returns only the aliases
	// that are pointing to the specific Lambda function version, otherwise the
	// API returns all of the aliases created for the Lambda function.
	FunctionVersion *string `location:"querystring" locationName:"FunctionVersion" min:"1" type:"string"`

	// Optional string. An opaque pagination token returned from a previous ListAliases
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of aliases to return in response.
	// This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of aliases.
	Aliases []*AliasConfiguration `type:"list"`

	// A string, present if there are more aliases.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

type ListEventSourceMappingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream.
	EventSourceArn *string `location:"querystring" locationName:"EventSourceArn" type:"string"`

	// The name of the Lambda function.
	//
	//  You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). AWS
	// Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail). Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 character in length.
	FunctionName *string `location:"querystring" locationName:"FunctionName" min:"1" type:"string"`

	// Optional string. An opaque pagination token returned from a previous ListEventSourceMappings
	// operation. If present, specifies to continue the list from where the returning
	// call left off.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of event sources to return
	// in response. This value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListEventSourceMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsInput) GoString() string {
	return s.String()
}

// Contains a list of event sources (see API_EventSourceMappingConfiguration)
type ListEventSourceMappingsOutput struct {
	_ struct{} `type:"structure"`

	// An array of EventSourceMappingConfiguration objects.
	EventSourceMappings []*EventSourceMappingConfiguration `type:"list"`

	// A string, present if there are more event source mappings.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListEventSourceMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsOutput) GoString() string {
	return s.String()
}

type ListFunctionsInput struct {
	_ struct{} `type:"structure"`

	// Optional string. An opaque pagination token returned from a previous ListFunctions
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of AWS Lambda functions to
	// return in response. This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListFunctionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsInput) GoString() string {
	return s.String()
}

// Contains a list of AWS Lambda function configurations (see FunctionConfiguration.
type ListFunctionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Lambda functions.
	Functions []*FunctionConfiguration `type:"list"`

	// A string, present if there are more functions.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListFunctionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsOutput) GoString() string {
	return s.String()
}

type ListVersionsByFunctionInput struct {
	_ struct{} `type:"structure"`

	// Function name whose versions to list. You can specify a function name (for
	// example, Thumbnail) or you can specify Amazon Resource Name (ARN) of the
	// function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Optional string. An opaque pagination token returned from a previous ListVersionsByFunction
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of AWS Lambda function versions
	// to return in response. This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListVersionsByFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionInput) GoString() string {
	return s.String()
}

type ListVersionsByFunctionOutput struct {
	_ struct{} `type:"structure"`

	// A string, present if there are more function versions.
	NextMarker *string `type:"string"`

	// A list of Lambda function versions.
	Versions []*FunctionConfiguration `type:"list"`
}

// String returns the string representation
func (s ListVersionsByFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionOutput) GoString() string {
	return s.String()
}

type PublishVersionInput struct {
	_ struct{} `type:"structure"`

	// The SHA256 hash of the deployment package you want to publish. This provides
	// validation on the code you are publishing. If you provide this parameter
	// value must match the SHA256 of the $LATEST version for the publication to
	// succeed.
	CodeSha256 *string `type:"string"`

	// The description for the version you are publishing. If not provided, AWS
	// Lambda copies the description from the $LATEST version.
	Description *string `type:"string"`

	// The Lambda function name. You can specify a function name (for example, Thumbnail)
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// arn:aws:lambda:us-west-2:account-id:function:ThumbNail). AWS Lambda also
	// allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PublishVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishVersionInput) GoString() string {
	return s.String()
}

type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// Lambda function whose resource policy you want to remove a permission from.
	//
	//  You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// You can specify this optional parameter to remove permission associated with
	// a specific function version or function alias. If you don't specify this
	// parameter, the API removes permission associated with the unqualified function
	// ARN.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// Statement ID of the permission to remove.
	StatementId *string `location:"uri" locationName:"StatementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// You can change the description of the alias using this parameter.
	Description *string `type:"string"`

	// The function name for which the alias is created.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this parameter you can change the Lambda function version to which
	// the alias points.
	FunctionVersion *string `min:"1" type:"string"`

	// The alias name.
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

type UpdateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of stream records that can be sent to your Lambda function
	// for a single invocation.
	BatchSize *int64 `min:"1" type:"integer"`

	// Specifies whether AWS Lambda should actively poll the stream or not. If disabled,
	// AWS Lambda will not poll the stream.
	Enabled *bool `type:"boolean"`

	// The Lambda function to which you want the stream records sent.
	//
	//  You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	//
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). For
	// more information about versioning, see AWS Lambda Function Versioning and
	// Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
	//
	// Note that the length constraint applies only to the ARN. If you specify
	// only the function name, it is limited to 64 character in length.
	FunctionName *string `min:"1" type:"string"`

	// The event source mapping identifier.
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEventSourceMappingInput) GoString() string {
	return s.String()
}

type UpdateFunctionCodeInput struct {
	_ struct{} `type:"structure"`

	// The existing Lambda function name whose code you want to replace.
	//
	//  You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// This boolean parameter can be used to request AWS Lambda to update the Lambda
	// function and publish a version as an atomic operation.
	Publish *bool `type:"boolean"`

	// Amazon S3 bucket name where the .zip file containing your deployment package
	// is stored. This bucket must reside in the same AWS region where you are creating
	// the Lambda function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 object (the deployment package) key name you want to upload.
	S3Key *string `min:"1" type:"string"`

	// The Amazon S3 object (the deployment package) version you want to upload.
	S3ObjectVersion *string `min:"1" type:"string"`

	// Based64-encoded .zip file containing your packaged source code.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s UpdateFunctionCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionCodeInput) GoString() string {
	return s.String()
}

type UpdateFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A short user-defined function description. AWS Lambda does not use this value.
	// Assign a meaningful description as you see fit.
	Description *string `type:"string"`

	// The name of the Lambda function.
	//
	//  You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The function that Lambda calls to begin executing your function. For Node.js,
	// it is the module-name.export value in your function.
	Handler *string `type:"string"`

	// The amount of memory, in MB, your Lambda function is given. AWS Lambda uses
	// this memory size to infer the amount of CPU allocated to your function. Your
	// function use-case determines your CPU and memory requirements. For example,
	// a database operation might need less memory compared to an image processing
	// function. The default value is 128 MB. The value must be a multiple of 64
	// MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda will assume when
	// it executes your function.
	Role *string `type:"string"`

	// The function execution time at which AWS Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// If your Lambda function accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and one subnet
	// ID.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionConfigurationInput) GoString() string {
	return s.String()
}

// If your Lambda function accesses resources in a VPC, you provide this parameter
// identifying the list of security group IDs and subnet IDs. These must belong
// to the same VPC. You must provide at least one security group and one subnet
// ID.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security groups IDs in your VPC.
	SecurityGroupIds []*string `type:"list"`

	// A list of one or more subnet IDs in your VPC.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// VPC configuration associated with your Lambda function.
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// A list of security group IDs associated with the Lambda function.
	SecurityGroupIds []*string `type:"list"`

	// A list of subnet IDs associated with the Lambda function.
	SubnetIds []*string `type:"list"`

	// The VPC ID associated with you Lambda function.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigResponse) GoString() string {
	return s.String()
}

const (
	// @enum EventSourcePosition
	EventSourcePositionTrimHorizon = "TRIM_HORIZON"
	// @enum EventSourcePosition
	EventSourcePositionLatest = "LATEST"
)

const (
	// @enum InvocationType
	InvocationTypeEvent = "Event"
	// @enum InvocationType
	InvocationTypeRequestResponse = "RequestResponse"
	// @enum InvocationType
	InvocationTypeDryRun = "DryRun"
)

const (
	// @enum LogType
	LogTypeNone = "None"
	// @enum LogType
	LogTypeTail = "Tail"
)

const (
	// @enum Runtime
	RuntimeNodejs = "nodejs"
	// @enum Runtime
	RuntimeJava8 = "java8"
	// @enum Runtime
	RuntimePython27 = "python2.7"
)
