// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package redshift provides a client for Amazon Redshift.
package redshift

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAuthorizeClusterSecurityGroupIngress = "AuthorizeClusterSecurityGroupIngress"

// AuthorizeClusterSecurityGroupIngressRequest generates a request for the AuthorizeClusterSecurityGroupIngress operation.
func (c *Redshift) AuthorizeClusterSecurityGroupIngressRequest(input *AuthorizeClusterSecurityGroupIngressInput) (req *request.Request, output *AuthorizeClusterSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeClusterSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeClusterSecurityGroupIngressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AuthorizeClusterSecurityGroupIngressOutput{}
	req.Data = output
	return
}

// Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending
// on whether the application accessing your cluster is running on the Internet
// or an Amazon EC2 instance, you can authorize inbound access to either a Classless
// Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2
// security group. You can add as many as 20 ingress rules to an Amazon Redshift
// security group.
//
// If you authorize access to an Amazon EC2 security group, specify EC2SecurityGroupName
// and EC2SecurityGroupOwnerId. The Amazon EC2 security group and Amazon Redshift
// cluster must be in the same AWS region.
//
//  If you authorize access to a CIDR/IP address range, specify CIDRIP. For
// an overview of CIDR blocks, see the Wikipedia article on Classless Inter-Domain
// Routing (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
//  You must also associate the security group with a cluster so that clients
// running on these IP addresses or the EC2 instance are authorized to connect
// to the cluster. For information about managing security groups, go to Working
// with Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) AuthorizeClusterSecurityGroupIngress(input *AuthorizeClusterSecurityGroupIngressInput) (*AuthorizeClusterSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeClusterSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opAuthorizeSnapshotAccess = "AuthorizeSnapshotAccess"

// AuthorizeSnapshotAccessRequest generates a request for the AuthorizeSnapshotAccess operation.
func (c *Redshift) AuthorizeSnapshotAccessRequest(input *AuthorizeSnapshotAccessInput) (req *request.Request, output *AuthorizeSnapshotAccessOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSnapshotAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSnapshotAccessInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AuthorizeSnapshotAccessOutput{}
	req.Data = output
	return
}

// Authorizes the specified AWS customer account to restore the specified snapshot.
//
//  For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) AuthorizeSnapshotAccess(input *AuthorizeSnapshotAccessInput) (*AuthorizeSnapshotAccessOutput, error) {
	req, out := c.AuthorizeSnapshotAccessRequest(input)
	err := req.Send()
	return out, err
}

const opCopyClusterSnapshot = "CopyClusterSnapshot"

// CopyClusterSnapshotRequest generates a request for the CopyClusterSnapshot operation.
func (c *Redshift) CopyClusterSnapshotRequest(input *CopyClusterSnapshotInput) (req *request.Request, output *CopyClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyClusterSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopyClusterSnapshotOutput{}
	req.Data = output
	return
}

// Copies the specified automated cluster snapshot to a new manual cluster snapshot.
// The source must be an automated snapshot and it must be in the available
// state.
//
//  When you delete a cluster, Amazon Redshift deletes any automated snapshots
// of the cluster. Also, when the retention period of the snapshot expires,
// Amazon Redshift automatically deletes it. If you want to keep an automated
// snapshot for a longer period, you can make a manual copy of the snapshot.
// Manual snapshots are retained until you delete them.
//
//  For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) CopyClusterSnapshot(input *CopyClusterSnapshotInput) (*CopyClusterSnapshotOutput, error) {
	req, out := c.CopyClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a request for the CreateCluster operation.
func (c *Redshift) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateClusterOutput{}
	req.Data = output
	return
}

// Creates a new cluster. To create the cluster in virtual private cloud (VPC),
// you must provide cluster subnet group name. If you don't provide a cluster
// subnet group name or the cluster security group parameter, Amazon Redshift
// creates a non-VPC cluster, it associates the default cluster security group
// with the cluster. For more information about managing clusters, go to Amazon
// Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide .
func (c *Redshift) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	err := req.Send()
	return out, err
}

const opCreateClusterParameterGroup = "CreateClusterParameterGroup"

// CreateClusterParameterGroupRequest generates a request for the CreateClusterParameterGroup operation.
func (c *Redshift) CreateClusterParameterGroupRequest(input *CreateClusterParameterGroupInput) (req *request.Request, output *CreateClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateClusterParameterGroupOutput{}
	req.Data = output
	return
}

// Creates an Amazon Redshift parameter group.
//
// Creating parameter groups is independent of creating clusters. You can associate
// a cluster with a parameter group when you create the cluster. You can also
// associate an existing cluster with a parameter group after the cluster is
// created by using ModifyCluster.
//
//  Parameters in the parameter group define specific behavior that applies
// to the databases you create on the cluster. For more information about parameters
// and parameter groups, go to Amazon Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) CreateClusterParameterGroup(input *CreateClusterParameterGroupInput) (*CreateClusterParameterGroupOutput, error) {
	req, out := c.CreateClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateClusterSecurityGroup = "CreateClusterSecurityGroup"

// CreateClusterSecurityGroupRequest generates a request for the CreateClusterSecurityGroup operation.
func (c *Redshift) CreateClusterSecurityGroupRequest(input *CreateClusterSecurityGroupInput) (req *request.Request, output *CreateClusterSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSecurityGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateClusterSecurityGroupOutput{}
	req.Data = output
	return
}

// Creates a new Amazon Redshift security group. You use security groups to
// control access to non-VPC clusters.
//
//  For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) CreateClusterSecurityGroup(input *CreateClusterSecurityGroupInput) (*CreateClusterSecurityGroupOutput, error) {
	req, out := c.CreateClusterSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateClusterSnapshot = "CreateClusterSnapshot"

// CreateClusterSnapshotRequest generates a request for the CreateClusterSnapshot operation.
func (c *Redshift) CreateClusterSnapshotRequest(input *CreateClusterSnapshotInput) (req *request.Request, output *CreateClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateClusterSnapshotOutput{}
	req.Data = output
	return
}

// Creates a manual snapshot of the specified cluster. The cluster must be in
// the available state.
//
//  For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) CreateClusterSnapshot(input *CreateClusterSnapshotInput) (*CreateClusterSnapshotOutput, error) {
	req, out := c.CreateClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateClusterSubnetGroup = "CreateClusterSubnetGroup"

// CreateClusterSubnetGroupRequest generates a request for the CreateClusterSubnetGroup operation.
func (c *Redshift) CreateClusterSubnetGroupRequest(input *CreateClusterSubnetGroupInput) (req *request.Request, output *CreateClusterSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateClusterSubnetGroupOutput{}
	req.Data = output
	return
}

// Creates a new Amazon Redshift subnet group. You must provide a list of one
// or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC)
// when creating Amazon Redshift subnet group.
//
//  For information about subnet groups, go to Amazon Redshift Cluster Subnet
// Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) CreateClusterSubnetGroup(input *CreateClusterSubnetGroupInput) (*CreateClusterSubnetGroupOutput, error) {
	req, out := c.CreateClusterSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a request for the CreateEventSubscription operation.
func (c *Redshift) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateEventSubscriptionOutput{}
	req.Data = output
	return
}

// Creates an Amazon Redshift event notification subscription. This action requires
// an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the
// Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To
// obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and
// subscribe to the topic. The ARN is displayed in the SNS console.
//
//  You can specify the source type, and lists of Amazon Redshift source IDs,
// event categories, and event severities. Notifications will be sent for all
// events you want that match those criteria. For example, you can specify source
// type = cluster, source ID = my-cluster-1 and mycluster2, event categories
// = Availability, Backup, and severity = ERROR. The subscription will only
// send notifications for those ERROR events in the Availability and Backup
// categories for the specified clusters.
//
//  If you specify both the source type and source IDs, such as source type
// = cluster and source identifier = my-cluster-1, notifications will be sent
// for all the cluster events for my-cluster-1. If you specify a source type
// but do not specify a source identifier, you will receive notice of the events
// for the objects of that type in your AWS account. If you do not specify either
// the SourceType nor the SourceIdentifier, you will be notified of events generated
// from all Amazon Redshift sources belonging to your AWS account. You must
// specify a source type if you specify a source ID.
func (c *Redshift) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHsmClientCertificate = "CreateHsmClientCertificate"

// CreateHsmClientCertificateRequest generates a request for the CreateHsmClientCertificate operation.
func (c *Redshift) CreateHsmClientCertificateRequest(input *CreateHsmClientCertificateInput) (req *request.Request, output *CreateHsmClientCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateHsmClientCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmClientCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHsmClientCertificateOutput{}
	req.Data = output
	return
}

// Creates an HSM client certificate that an Amazon Redshift cluster will use
// to connect to the client's HSM in order to store and retrieve the keys used
// to encrypt the cluster databases.
//
// The command returns a public key, which you must store in the HSM. In addition
// to creating the HSM certificate, you must create an Amazon Redshift HSM configuration
// that provides a cluster the information needed to store and use encryption
// keys in the HSM. For more information, go to Hardware Security Modules (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) CreateHsmClientCertificate(input *CreateHsmClientCertificateInput) (*CreateHsmClientCertificateOutput, error) {
	req, out := c.CreateHsmClientCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHsmConfiguration = "CreateHsmConfiguration"

// CreateHsmConfigurationRequest generates a request for the CreateHsmConfiguration operation.
func (c *Redshift) CreateHsmConfigurationRequest(input *CreateHsmConfigurationInput) (req *request.Request, output *CreateHsmConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateHsmConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHsmConfigurationOutput{}
	req.Data = output
	return
}

// Creates an HSM configuration that contains the information required by an
// Amazon Redshift cluster to store and use database encryption keys in a Hardware
// Security Module (HSM). After creating the HSM configuration, you can specify
// it as a parameter when creating a cluster. The cluster will then store its
// encryption keys in the HSM.
//
// In addition to creating an HSM configuration, you must also create an HSM
// client certificate. For more information, go to Hardware Security Modules
// (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html) in
// the Amazon Redshift Cluster Management Guide.
func (c *Redshift) CreateHsmConfiguration(input *CreateHsmConfigurationInput) (*CreateHsmConfigurationOutput, error) {
	req, out := c.CreateHsmConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshotCopyGrant = "CreateSnapshotCopyGrant"

// CreateSnapshotCopyGrantRequest generates a request for the CreateSnapshotCopyGrant operation.
func (c *Redshift) CreateSnapshotCopyGrantRequest(input *CreateSnapshotCopyGrantInput) (req *request.Request, output *CreateSnapshotCopyGrantOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshotCopyGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotCopyGrantInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSnapshotCopyGrantOutput{}
	req.Data = output
	return
}

// Creates a snapshot copy grant that permits Amazon Redshift to use a customer
// master key (CMK) from AWS Key Management Service (AWS KMS) to encrypt copied
// snapshots in a destination region.
//
//  For more information about managing snapshot copy grants, go to Amazon
// Redshift Database Encryption (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) CreateSnapshotCopyGrant(input *CreateSnapshotCopyGrantInput) (*CreateSnapshotCopyGrantOutput, error) {
	req, out := c.CreateSnapshotCopyGrantRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a request for the CreateTags operation.
func (c *Redshift) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateTagsOutput{}
	req.Data = output
	return
}

// Adds one or more tags to a specified resource.
//
//  A resource can have up to 10 tags. If you try to create more than 10 tags
// for a resource, you will receive an error and the attempt will fail.
//
//  If you specify a key that already exists for the resource, the value for
// that key will be updated with the new value.
func (c *Redshift) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a request for the DeleteCluster operation.
func (c *Redshift) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteClusterOutput{}
	req.Data = output
	return
}

// Deletes a previously provisioned cluster. A successful response from the
// web service indicates that the request was received correctly. Use DescribeClusters
// to monitor the status of the deletion. The delete operation cannot be canceled
// or reverted once submitted. For more information about managing clusters,
// go to Amazon Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide .
//
//  If you want to shut down the cluster and retain it for future use, set
// SkipFinalClusterSnapshot to false and specify a name for FinalClusterSnapshotIdentifier.
// You can later restore this snapshot to resume using the cluster. If a final
// cluster snapshot is requested, the status of the cluster will be "final-snapshot"
// while the snapshot is being taken, then it's "deleting" once Amazon Redshift
// begins deleting the cluster.
//
//  For more information about managing clusters, go to Amazon Redshift Clusters
// (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide .
func (c *Redshift) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteClusterParameterGroup = "DeleteClusterParameterGroup"

// DeleteClusterParameterGroupRequest generates a request for the DeleteClusterParameterGroup operation.
func (c *Redshift) DeleteClusterParameterGroupRequest(input *DeleteClusterParameterGroupInput) (req *request.Request, output *DeleteClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteClusterParameterGroupOutput{}
	req.Data = output
	return
}

// Deletes a specified Amazon Redshift parameter group. You cannot delete a
// parameter group if it is associated with a cluster.
func (c *Redshift) DeleteClusterParameterGroup(input *DeleteClusterParameterGroupInput) (*DeleteClusterParameterGroupOutput, error) {
	req, out := c.DeleteClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteClusterSecurityGroup = "DeleteClusterSecurityGroup"

// DeleteClusterSecurityGroupRequest generates a request for the DeleteClusterSecurityGroup operation.
func (c *Redshift) DeleteClusterSecurityGroupRequest(input *DeleteClusterSecurityGroupInput) (req *request.Request, output *DeleteClusterSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSecurityGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteClusterSecurityGroupOutput{}
	req.Data = output
	return
}

// Deletes an Amazon Redshift security group.
//
// You cannot delete a security group that is associated with any clusters.
// You cannot delete the default security group.  For information about managing
// security groups, go to Amazon Redshift Cluster Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) DeleteClusterSecurityGroup(input *DeleteClusterSecurityGroupInput) (*DeleteClusterSecurityGroupOutput, error) {
	req, out := c.DeleteClusterSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteClusterSnapshot = "DeleteClusterSnapshot"

// DeleteClusterSnapshotRequest generates a request for the DeleteClusterSnapshot operation.
func (c *Redshift) DeleteClusterSnapshotRequest(input *DeleteClusterSnapshotInput) (req *request.Request, output *DeleteClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteClusterSnapshotOutput{}
	req.Data = output
	return
}

// Deletes the specified manual snapshot. The snapshot must be in the available
// state, with no other users authorized to access the snapshot.
//
//  Unlike automated snapshots, manual snapshots are retained even after you
// delete your cluster. Amazon Redshift does not delete your manual snapshots.
// You must delete manual snapshot explicitly to avoid getting charged. If other
// accounts are authorized to access the snapshot, you must revoke all of the
// authorizations before you can delete the snapshot.
func (c *Redshift) DeleteClusterSnapshot(input *DeleteClusterSnapshotInput) (*DeleteClusterSnapshotOutput, error) {
	req, out := c.DeleteClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteClusterSubnetGroup = "DeleteClusterSubnetGroup"

// DeleteClusterSubnetGroupRequest generates a request for the DeleteClusterSubnetGroup operation.
func (c *Redshift) DeleteClusterSubnetGroupRequest(input *DeleteClusterSubnetGroupInput) (req *request.Request, output *DeleteClusterSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteClusterSubnetGroupOutput{}
	req.Data = output
	return
}

// Deletes the specified cluster subnet group.
func (c *Redshift) DeleteClusterSubnetGroup(input *DeleteClusterSubnetGroupInput) (*DeleteClusterSubnetGroupOutput, error) {
	req, out := c.DeleteClusterSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a request for the DeleteEventSubscription operation.
func (c *Redshift) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteEventSubscriptionOutput{}
	req.Data = output
	return
}

// Deletes an Amazon Redshift event notification subscription.
func (c *Redshift) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHsmClientCertificate = "DeleteHsmClientCertificate"

// DeleteHsmClientCertificateRequest generates a request for the DeleteHsmClientCertificate operation.
func (c *Redshift) DeleteHsmClientCertificateRequest(input *DeleteHsmClientCertificateInput) (req *request.Request, output *DeleteHsmClientCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteHsmClientCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmClientCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteHsmClientCertificateOutput{}
	req.Data = output
	return
}

// Deletes the specified HSM client certificate.
func (c *Redshift) DeleteHsmClientCertificate(input *DeleteHsmClientCertificateInput) (*DeleteHsmClientCertificateOutput, error) {
	req, out := c.DeleteHsmClientCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHsmConfiguration = "DeleteHsmConfiguration"

// DeleteHsmConfigurationRequest generates a request for the DeleteHsmConfiguration operation.
func (c *Redshift) DeleteHsmConfigurationRequest(input *DeleteHsmConfigurationInput) (req *request.Request, output *DeleteHsmConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteHsmConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteHsmConfigurationOutput{}
	req.Data = output
	return
}

// Deletes the specified Amazon Redshift HSM configuration.
func (c *Redshift) DeleteHsmConfiguration(input *DeleteHsmConfigurationInput) (*DeleteHsmConfigurationOutput, error) {
	req, out := c.DeleteHsmConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSnapshotCopyGrant = "DeleteSnapshotCopyGrant"

// DeleteSnapshotCopyGrantRequest generates a request for the DeleteSnapshotCopyGrant operation.
func (c *Redshift) DeleteSnapshotCopyGrantRequest(input *DeleteSnapshotCopyGrantInput) (req *request.Request, output *DeleteSnapshotCopyGrantOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshotCopyGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotCopyGrantInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteSnapshotCopyGrantOutput{}
	req.Data = output
	return
}

// Deletes the specified snapshot copy grant.
func (c *Redshift) DeleteSnapshotCopyGrant(input *DeleteSnapshotCopyGrantInput) (*DeleteSnapshotCopyGrantOutput, error) {
	req, out := c.DeleteSnapshotCopyGrantRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a request for the DeleteTags operation.
func (c *Redshift) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteTagsOutput{}
	req.Data = output
	return
}

// Deletes a tag or tags from a resource. You must provide the ARN of the resource
// from which you want to delete the tag or tags.
func (c *Redshift) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeClusterParameterGroups = "DescribeClusterParameterGroups"

// DescribeClusterParameterGroupsRequest generates a request for the DescribeClusterParameterGroups operation.
func (c *Redshift) DescribeClusterParameterGroupsRequest(input *DescribeClusterParameterGroupsInput) (req *request.Request, output *DescribeClusterParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterParameterGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClusterParameterGroupsOutput{}
	req.Data = output
	return
}

// Returns a list of Amazon Redshift parameter groups, including parameter groups
// you created and the default parameter group. For each parameter group, the
// response includes the parameter group name, description, and parameter group
// family name. You can optionally specify a name to retrieve the description
// of a specific parameter group.
//
//  For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon
// Redshift returns all parameter groups that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all parameter groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, parameter groups
// are returned regardless of whether they have tag keys or values associated
// with them.
func (c *Redshift) DescribeClusterParameterGroups(input *DescribeClusterParameterGroupsInput) (*DescribeClusterParameterGroupsOutput, error) {
	req, out := c.DescribeClusterParameterGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeClusterParameterGroupsPages(input *DescribeClusterParameterGroupsInput, fn func(p *DescribeClusterParameterGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterParameterGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterParameterGroupsOutput), lastPage)
	})
}

const opDescribeClusterParameters = "DescribeClusterParameters"

// DescribeClusterParametersRequest generates a request for the DescribeClusterParameters operation.
func (c *Redshift) DescribeClusterParametersRequest(input *DescribeClusterParametersInput) (req *request.Request, output *DescribeClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClusterParametersOutput{}
	req.Data = output
	return
}

// Returns a detailed list of parameters contained within the specified Amazon
// Redshift parameter group. For each parameter the response includes information
// such as parameter name, description, data type, value, whether the parameter
// value is modifiable, and so on.
//
// You can specify source filter to retrieve parameters of only specific type.
// For example, to retrieve parameters that were modified by a user action such
// as from ModifyClusterParameterGroup, you can specify source equal to user.
//
//  For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) DescribeClusterParameters(input *DescribeClusterParametersInput) (*DescribeClusterParametersOutput, error) {
	req, out := c.DescribeClusterParametersRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeClusterParametersPages(input *DescribeClusterParametersInput, fn func(p *DescribeClusterParametersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterParametersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterParametersOutput), lastPage)
	})
}

const opDescribeClusterSecurityGroups = "DescribeClusterSecurityGroups"

// DescribeClusterSecurityGroupsRequest generates a request for the DescribeClusterSecurityGroups operation.
func (c *Redshift) DescribeClusterSecurityGroupsRequest(input *DescribeClusterSecurityGroupsInput) (req *request.Request, output *DescribeClusterSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSecurityGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClusterSecurityGroupsOutput{}
	req.Data = output
	return
}

// Returns information about Amazon Redshift security groups. If the name of
// a security group is specified, the response will contain only information
// about only that security group.
//
//  For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon
// Redshift returns all security groups that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all security groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, security groups
// are returned regardless of whether they have tag keys or values associated
// with them.
func (c *Redshift) DescribeClusterSecurityGroups(input *DescribeClusterSecurityGroupsInput) (*DescribeClusterSecurityGroupsOutput, error) {
	req, out := c.DescribeClusterSecurityGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeClusterSecurityGroupsPages(input *DescribeClusterSecurityGroupsInput, fn func(p *DescribeClusterSecurityGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterSecurityGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterSecurityGroupsOutput), lastPage)
	})
}

const opDescribeClusterSnapshots = "DescribeClusterSnapshots"

// DescribeClusterSnapshotsRequest generates a request for the DescribeClusterSnapshots operation.
func (c *Redshift) DescribeClusterSnapshotsRequest(input *DescribeClusterSnapshotsInput) (req *request.Request, output *DescribeClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSnapshotsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClusterSnapshotsOutput{}
	req.Data = output
	return
}

// Returns one or more snapshot objects, which contain metadata about your cluster
// snapshots. By default, this operation returns information about all snapshots
// of all clusters that are owned by you AWS customer account. No information
// is returned for snapshots owned by inactive AWS customer accounts.
//
// If you specify both tag keys and tag values in the same request, Amazon
// Redshift returns all snapshots that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all snapshots that have any combination
// of those values are returned. Only snapshots that you own are returned in
// the response; shared snapshots are not returned with the tag key and tag
// value request parameters.
//
// If both tag keys and values are omitted from the request, snapshots are
// returned regardless of whether they have tag keys or values associated with
// them.
func (c *Redshift) DescribeClusterSnapshots(input *DescribeClusterSnapshotsInput) (*DescribeClusterSnapshotsOutput, error) {
	req, out := c.DescribeClusterSnapshotsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeClusterSnapshotsPages(input *DescribeClusterSnapshotsInput, fn func(p *DescribeClusterSnapshotsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterSnapshotsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterSnapshotsOutput), lastPage)
	})
}

const opDescribeClusterSubnetGroups = "DescribeClusterSubnetGroups"

// DescribeClusterSubnetGroupsRequest generates a request for the DescribeClusterSubnetGroups operation.
func (c *Redshift) DescribeClusterSubnetGroupsRequest(input *DescribeClusterSubnetGroupsInput) (req *request.Request, output *DescribeClusterSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSubnetGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClusterSubnetGroupsOutput{}
	req.Data = output
	return
}

// Returns one or more cluster subnet group objects, which contain metadata
// about your cluster subnet groups. By default, this operation returns information
// about all cluster subnet groups that are defined in you AWS account.
//
// If you specify both tag keys and tag values in the same request, Amazon
// Redshift returns all subnet groups that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all subnet groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, subnet groups
// are returned regardless of whether they have tag keys or values associated
// with them.
func (c *Redshift) DescribeClusterSubnetGroups(input *DescribeClusterSubnetGroupsInput) (*DescribeClusterSubnetGroupsOutput, error) {
	req, out := c.DescribeClusterSubnetGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeClusterSubnetGroupsPages(input *DescribeClusterSubnetGroupsInput, fn func(p *DescribeClusterSubnetGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterSubnetGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterSubnetGroupsOutput), lastPage)
	})
}

const opDescribeClusterVersions = "DescribeClusterVersions"

// DescribeClusterVersionsRequest generates a request for the DescribeClusterVersions operation.
func (c *Redshift) DescribeClusterVersionsRequest(input *DescribeClusterVersionsInput) (req *request.Request, output *DescribeClusterVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClusterVersionsOutput{}
	req.Data = output
	return
}

// Returns descriptions of the available Amazon Redshift cluster versions. You
// can call this operation even before creating any clusters to learn more about
// the Amazon Redshift versions. For more information about managing clusters,
// go to Amazon Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide
func (c *Redshift) DescribeClusterVersions(input *DescribeClusterVersionsInput) (*DescribeClusterVersionsOutput, error) {
	req, out := c.DescribeClusterVersionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeClusterVersionsPages(input *DescribeClusterVersionsInput, fn func(p *DescribeClusterVersionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterVersionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterVersionsOutput), lastPage)
	})
}

const opDescribeClusters = "DescribeClusters"

// DescribeClustersRequest generates a request for the DescribeClusters operation.
func (c *Redshift) DescribeClustersRequest(input *DescribeClustersInput) (req *request.Request, output *DescribeClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClustersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClustersOutput{}
	req.Data = output
	return
}

// Returns properties of provisioned clusters including general cluster properties,
// cluster database properties, maintenance and backup properties, and security
// and access properties. This operation supports pagination. For more information
// about managing clusters, go to Amazon Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide .
//
// If you specify both tag keys and tag values in the same request, Amazon
// Redshift returns all clusters that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all clusters that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, clusters are returned
// regardless of whether they have tag keys or values associated with them.
func (c *Redshift) DescribeClusters(input *DescribeClustersInput) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeClustersPages(input *DescribeClustersInput, fn func(p *DescribeClustersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClustersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClustersOutput), lastPage)
	})
}

const opDescribeDefaultClusterParameters = "DescribeDefaultClusterParameters"

// DescribeDefaultClusterParametersRequest generates a request for the DescribeDefaultClusterParameters operation.
func (c *Redshift) DescribeDefaultClusterParametersRequest(input *DescribeDefaultClusterParametersInput) (req *request.Request, output *DescribeDefaultClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDefaultClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"DefaultClusterParameters.Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDefaultClusterParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDefaultClusterParametersOutput{}
	req.Data = output
	return
}

// Returns a list of parameter settings for the specified parameter group family.
//
//  For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) DescribeDefaultClusterParameters(input *DescribeDefaultClusterParametersInput) (*DescribeDefaultClusterParametersOutput, error) {
	req, out := c.DescribeDefaultClusterParametersRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeDefaultClusterParametersPages(input *DescribeDefaultClusterParametersInput, fn func(p *DescribeDefaultClusterParametersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDefaultClusterParametersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDefaultClusterParametersOutput), lastPage)
	})
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a request for the DescribeEventCategories operation.
func (c *Redshift) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEventCategoriesOutput{}
	req.Data = output
	return
}

// Displays a list of event categories for all event source types, or for a
// specified source type. For a list of the event categories and source types,
// go to Amazon Redshift Event Notifications (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html).
func (c *Redshift) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a request for the DescribeEventSubscriptions operation.
func (c *Redshift) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEventSubscriptionsOutput{}
	req.Data = output
	return
}

// Lists descriptions of all the Amazon Redshift event notifications subscription
// for a customer account. If you specify a subscription name, lists the description
// for that subscription.
func (c *Redshift) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(p *DescribeEventSubscriptionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEventSubscriptionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEventSubscriptionsOutput), lastPage)
	})
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a request for the DescribeEvents operation.
func (c *Redshift) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEventsOutput{}
	req.Data = output
	return
}

// Returns events related to clusters, security groups, snapshots, and parameter
// groups for the past 14 days. Events specific to a particular cluster, security
// group, snapshot or parameter group can be obtained by providing the name
// as a parameter. By default, the past hour of events are returned.
func (c *Redshift) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeEventsPages(input *DescribeEventsInput, fn func(p *DescribeEventsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEventsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEventsOutput), lastPage)
	})
}

const opDescribeHsmClientCertificates = "DescribeHsmClientCertificates"

// DescribeHsmClientCertificatesRequest generates a request for the DescribeHsmClientCertificates operation.
func (c *Redshift) DescribeHsmClientCertificatesRequest(input *DescribeHsmClientCertificatesInput) (req *request.Request, output *DescribeHsmClientCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeHsmClientCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHsmClientCertificatesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeHsmClientCertificatesOutput{}
	req.Data = output
	return
}

// Returns information about the specified HSM client certificate. If no certificate
// ID is specified, returns information about all the HSM certificates owned
// by your AWS customer account.
//
// If you specify both tag keys and tag values in the same request, Amazon
// Redshift returns all HSM client certificates that match any combination of
// the specified keys and values. For example, if you have owner and environment
// for tag keys, and admin and test for tag values, all HSM client certificates
// that have any combination of those values are returned.
//
// If both tag keys and values are omitted from the request, HSM client certificates
// are returned regardless of whether they have tag keys or values associated
// with them.
func (c *Redshift) DescribeHsmClientCertificates(input *DescribeHsmClientCertificatesInput) (*DescribeHsmClientCertificatesOutput, error) {
	req, out := c.DescribeHsmClientCertificatesRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeHsmClientCertificatesPages(input *DescribeHsmClientCertificatesInput, fn func(p *DescribeHsmClientCertificatesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeHsmClientCertificatesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeHsmClientCertificatesOutput), lastPage)
	})
}

const opDescribeHsmConfigurations = "DescribeHsmConfigurations"

// DescribeHsmConfigurationsRequest generates a request for the DescribeHsmConfigurations operation.
func (c *Redshift) DescribeHsmConfigurationsRequest(input *DescribeHsmConfigurationsInput) (req *request.Request, output *DescribeHsmConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeHsmConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHsmConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeHsmConfigurationsOutput{}
	req.Data = output
	return
}

// Returns information about the specified Amazon Redshift HSM configuration.
// If no configuration ID is specified, returns information about all the HSM
// configurations owned by your AWS customer account.
//
// If you specify both tag keys and tag values in the same request, Amazon
// Redshift returns all HSM connections that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all HSM connections that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, HSM connections
// are returned regardless of whether they have tag keys or values associated
// with them.
func (c *Redshift) DescribeHsmConfigurations(input *DescribeHsmConfigurationsInput) (*DescribeHsmConfigurationsOutput, error) {
	req, out := c.DescribeHsmConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeHsmConfigurationsPages(input *DescribeHsmConfigurationsInput, fn func(p *DescribeHsmConfigurationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeHsmConfigurationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeHsmConfigurationsOutput), lastPage)
	})
}

const opDescribeLoggingStatus = "DescribeLoggingStatus"

// DescribeLoggingStatusRequest generates a request for the DescribeLoggingStatus operation.
func (c *Redshift) DescribeLoggingStatusRequest(input *DescribeLoggingStatusInput) (req *request.Request, output *LoggingStatus) {
	op := &request.Operation{
		Name:       opDescribeLoggingStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoggingStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &LoggingStatus{}
	req.Data = output
	return
}

// Describes whether information, such as queries and connection attempts, is
// being logged for the specified Amazon Redshift cluster.
func (c *Redshift) DescribeLoggingStatus(input *DescribeLoggingStatusInput) (*LoggingStatus, error) {
	req, out := c.DescribeLoggingStatusRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeOrderableClusterOptions = "DescribeOrderableClusterOptions"

// DescribeOrderableClusterOptionsRequest generates a request for the DescribeOrderableClusterOptions operation.
func (c *Redshift) DescribeOrderableClusterOptionsRequest(input *DescribeOrderableClusterOptionsInput) (req *request.Request, output *DescribeOrderableClusterOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableClusterOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableClusterOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeOrderableClusterOptionsOutput{}
	req.Data = output
	return
}

// Returns a list of orderable cluster options. Before you create a new cluster
// you can use this operation to find what options are available, such as the
// EC2 Availability Zones (AZ) in the specific AWS region that you can specify,
// and the node types you can request. The node types differ by available storage,
// memory, CPU and price. With the cost involved you might want to obtain a
// list of cluster options in the specific region and specify values when creating
// a cluster. For more information about managing clusters, go to Amazon Redshift
// Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide
func (c *Redshift) DescribeOrderableClusterOptions(input *DescribeOrderableClusterOptionsInput) (*DescribeOrderableClusterOptionsOutput, error) {
	req, out := c.DescribeOrderableClusterOptionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeOrderableClusterOptionsPages(input *DescribeOrderableClusterOptionsInput, fn func(p *DescribeOrderableClusterOptionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeOrderableClusterOptionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeOrderableClusterOptionsOutput), lastPage)
	})
}

const opDescribeReservedNodeOfferings = "DescribeReservedNodeOfferings"

// DescribeReservedNodeOfferingsRequest generates a request for the DescribeReservedNodeOfferings operation.
func (c *Redshift) DescribeReservedNodeOfferingsRequest(input *DescribeReservedNodeOfferingsInput) (req *request.Request, output *DescribeReservedNodeOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedNodeOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedNodeOfferingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedNodeOfferingsOutput{}
	req.Data = output
	return
}

// Returns a list of the available reserved node offerings by Amazon Redshift
// with their descriptions including the node type, the fixed and recurring
// costs of reserving the node and duration the node will be reserved for you.
// These descriptions help you determine which reserve node offering you want
// to purchase. You then use the unique offering ID in you call to PurchaseReservedNodeOffering
// to reserve one or more nodes for your Amazon Redshift cluster.
//
//  For more information about reserved node offerings, go to Purchasing Reserved
// Nodes (http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) DescribeReservedNodeOfferings(input *DescribeReservedNodeOfferingsInput) (*DescribeReservedNodeOfferingsOutput, error) {
	req, out := c.DescribeReservedNodeOfferingsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeReservedNodeOfferingsPages(input *DescribeReservedNodeOfferingsInput, fn func(p *DescribeReservedNodeOfferingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedNodeOfferingsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedNodeOfferingsOutput), lastPage)
	})
}

const opDescribeReservedNodes = "DescribeReservedNodes"

// DescribeReservedNodesRequest generates a request for the DescribeReservedNodes operation.
func (c *Redshift) DescribeReservedNodesRequest(input *DescribeReservedNodesInput) (req *request.Request, output *DescribeReservedNodesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedNodesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedNodesOutput{}
	req.Data = output
	return
}

// Returns the descriptions of the reserved nodes.
func (c *Redshift) DescribeReservedNodes(input *DescribeReservedNodesInput) (*DescribeReservedNodesOutput, error) {
	req, out := c.DescribeReservedNodesRequest(input)
	err := req.Send()
	return out, err
}

func (c *Redshift) DescribeReservedNodesPages(input *DescribeReservedNodesInput, fn func(p *DescribeReservedNodesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedNodesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedNodesOutput), lastPage)
	})
}

const opDescribeResize = "DescribeResize"

// DescribeResizeRequest generates a request for the DescribeResize operation.
func (c *Redshift) DescribeResizeRequest(input *DescribeResizeInput) (req *request.Request, output *DescribeResizeOutput) {
	op := &request.Operation{
		Name:       opDescribeResize,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResizeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeResizeOutput{}
	req.Data = output
	return
}

// Returns information about the last resize operation for the specified cluster.
// If no resize operation has ever been initiated for the specified cluster,
// a HTTP 404 error is returned. If a resize operation was initiated and completed,
// the status of the resize remains as SUCCEEDED until the next resize.
//
//  A resize operation can be requested using ModifyCluster and specifying
// a different number or type of nodes for the cluster.
func (c *Redshift) DescribeResize(input *DescribeResizeInput) (*DescribeResizeOutput, error) {
	req, out := c.DescribeResizeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshotCopyGrants = "DescribeSnapshotCopyGrants"

// DescribeSnapshotCopyGrantsRequest generates a request for the DescribeSnapshotCopyGrants operation.
func (c *Redshift) DescribeSnapshotCopyGrantsRequest(input *DescribeSnapshotCopyGrantsInput) (req *request.Request, output *DescribeSnapshotCopyGrantsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotCopyGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotCopyGrantsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSnapshotCopyGrantsOutput{}
	req.Data = output
	return
}

// Returns a list of snapshot copy grants owned by the AWS account in the destination
// region.
//
//  For more information about managing snapshot copy grants, go to Amazon
// Redshift Database Encryption (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) DescribeSnapshotCopyGrants(input *DescribeSnapshotCopyGrantsInput) (*DescribeSnapshotCopyGrantsOutput, error) {
	req, out := c.DescribeSnapshotCopyGrantsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTableRestoreStatus = "DescribeTableRestoreStatus"

// DescribeTableRestoreStatusRequest generates a request for the DescribeTableRestoreStatus operation.
func (c *Redshift) DescribeTableRestoreStatusRequest(input *DescribeTableRestoreStatusInput) (req *request.Request, output *DescribeTableRestoreStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeTableRestoreStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableRestoreStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTableRestoreStatusOutput{}
	req.Data = output
	return
}

// Lists the status of one or more table restore requests made using the RestoreTableFromClusterSnapshot
// API action. If you don't specify a value for the TableRestoreRequestId parameter,
// then DescribeTableRestoreStatus returns the status of all in-progress table
// restore requests. Otherwise DescribeTableRestoreStatus returns the status
// of the table specified by TableRestoreRequestId.
func (c *Redshift) DescribeTableRestoreStatus(input *DescribeTableRestoreStatusInput) (*DescribeTableRestoreStatusOutput, error) {
	req, out := c.DescribeTableRestoreStatusRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a request for the DescribeTags operation.
func (c *Redshift) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTagsOutput{}
	req.Data = output
	return
}

// Returns a list of tags. You can return tags from a specific resource by specifying
// an ARN, or you can return all tags for a given type of resource, such as
// clusters, snapshots, and so on.
//
//  The following are limitations for DescribeTags:  You cannot specify an
// ARN and a resource-type value together in the same request. You cannot use
// the MaxRecords and Marker parameters together with the ARN parameter. The
// MaxRecords parameter can be a range from 10 to 50 results to return in a
// request.
//
// If you specify both tag keys and tag values in the same request, Amazon
// Redshift returns all resources that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all resources that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, resources are
// returned regardless of whether they have tag keys or values associated with
// them.
func (c *Redshift) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDisableLogging = "DisableLogging"

// DisableLoggingRequest generates a request for the DisableLogging operation.
func (c *Redshift) DisableLoggingRequest(input *DisableLoggingInput) (req *request.Request, output *LoggingStatus) {
	op := &request.Operation{
		Name:       opDisableLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableLoggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &LoggingStatus{}
	req.Data = output
	return
}

// Stops logging information, such as queries and connection attempts, for the
// specified Amazon Redshift cluster.
func (c *Redshift) DisableLogging(input *DisableLoggingInput) (*LoggingStatus, error) {
	req, out := c.DisableLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opDisableSnapshotCopy = "DisableSnapshotCopy"

// DisableSnapshotCopyRequest generates a request for the DisableSnapshotCopy operation.
func (c *Redshift) DisableSnapshotCopyRequest(input *DisableSnapshotCopyInput) (req *request.Request, output *DisableSnapshotCopyOutput) {
	op := &request.Operation{
		Name:       opDisableSnapshotCopy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableSnapshotCopyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableSnapshotCopyOutput{}
	req.Data = output
	return
}

// Disables the automatic copying of snapshots from one region to another region
// for a specified cluster.
//
// If your cluster and its snapshots are encrypted using a customer master
// key (CMK) from AWS KMS, use DeleteSnapshotCopyGrant to delete the grant that
// grants Amazon Redshift permission to the CMK in the destination region.
func (c *Redshift) DisableSnapshotCopy(input *DisableSnapshotCopyInput) (*DisableSnapshotCopyOutput, error) {
	req, out := c.DisableSnapshotCopyRequest(input)
	err := req.Send()
	return out, err
}

const opEnableLogging = "EnableLogging"

// EnableLoggingRequest generates a request for the EnableLogging operation.
func (c *Redshift) EnableLoggingRequest(input *EnableLoggingInput) (req *request.Request, output *LoggingStatus) {
	op := &request.Operation{
		Name:       opEnableLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableLoggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &LoggingStatus{}
	req.Data = output
	return
}

// Starts logging information, such as queries and connection attempts, for
// the specified Amazon Redshift cluster.
func (c *Redshift) EnableLogging(input *EnableLoggingInput) (*LoggingStatus, error) {
	req, out := c.EnableLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opEnableSnapshotCopy = "EnableSnapshotCopy"

// EnableSnapshotCopyRequest generates a request for the EnableSnapshotCopy operation.
func (c *Redshift) EnableSnapshotCopyRequest(input *EnableSnapshotCopyInput) (req *request.Request, output *EnableSnapshotCopyOutput) {
	op := &request.Operation{
		Name:       opEnableSnapshotCopy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableSnapshotCopyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableSnapshotCopyOutput{}
	req.Data = output
	return
}

// Enables the automatic copy of snapshots from one region to another region
// for a specified cluster.
func (c *Redshift) EnableSnapshotCopy(input *EnableSnapshotCopyInput) (*EnableSnapshotCopyOutput, error) {
	req, out := c.EnableSnapshotCopyRequest(input)
	err := req.Send()
	return out, err
}

const opModifyCluster = "ModifyCluster"

// ModifyClusterRequest generates a request for the ModifyCluster operation.
func (c *Redshift) ModifyClusterRequest(input *ModifyClusterInput) (req *request.Request, output *ModifyClusterOutput) {
	op := &request.Operation{
		Name:       opModifyCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyClusterOutput{}
	req.Data = output
	return
}

// Modifies the settings for a cluster. For example, you can add another security
// or parameter group, update the preferred maintenance window, or change the
// master user password. Resetting a cluster password or modifying the security
// groups associated with a cluster do not need a reboot. However, modifying
// a parameter group requires a reboot for parameters to take effect. For more
// information about managing clusters, go to Amazon Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide .
//
// You can also change node type and the number of nodes to scale up or down
// the cluster. When resizing a cluster, you must specify both the number of
// nodes and the node type even if one of the parameters does not change.
func (c *Redshift) ModifyCluster(input *ModifyClusterInput) (*ModifyClusterOutput, error) {
	req, out := c.ModifyClusterRequest(input)
	err := req.Send()
	return out, err
}

const opModifyClusterParameterGroup = "ModifyClusterParameterGroup"

// ModifyClusterParameterGroupRequest generates a request for the ModifyClusterParameterGroup operation.
func (c *Redshift) ModifyClusterParameterGroupRequest(input *ModifyClusterParameterGroupInput) (req *request.Request, output *ClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ClusterParameterGroupNameMessage{}
	req.Data = output
	return
}

// Modifies the parameters of a parameter group.
//
//  For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) ModifyClusterParameterGroup(input *ModifyClusterParameterGroupInput) (*ClusterParameterGroupNameMessage, error) {
	req, out := c.ModifyClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyClusterSubnetGroup = "ModifyClusterSubnetGroup"

// ModifyClusterSubnetGroupRequest generates a request for the ModifyClusterSubnetGroup operation.
func (c *Redshift) ModifyClusterSubnetGroupRequest(input *ModifyClusterSubnetGroupInput) (req *request.Request, output *ModifyClusterSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyClusterSubnetGroupOutput{}
	req.Data = output
	return
}

// Modifies a cluster subnet group to include the specified list of VPC subnets.
// The operation replaces the existing list of subnets with the new list of
// subnets.
func (c *Redshift) ModifyClusterSubnetGroup(input *ModifyClusterSubnetGroupInput) (*ModifyClusterSubnetGroupOutput, error) {
	req, out := c.ModifyClusterSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a request for the ModifyEventSubscription operation.
func (c *Redshift) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyEventSubscriptionOutput{}
	req.Data = output
	return
}

// Modifies an existing Amazon Redshift event notification subscription.
func (c *Redshift) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opModifySnapshotCopyRetentionPeriod = "ModifySnapshotCopyRetentionPeriod"

// ModifySnapshotCopyRetentionPeriodRequest generates a request for the ModifySnapshotCopyRetentionPeriod operation.
func (c *Redshift) ModifySnapshotCopyRetentionPeriodRequest(input *ModifySnapshotCopyRetentionPeriodInput) (req *request.Request, output *ModifySnapshotCopyRetentionPeriodOutput) {
	op := &request.Operation{
		Name:       opModifySnapshotCopyRetentionPeriod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySnapshotCopyRetentionPeriodInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifySnapshotCopyRetentionPeriodOutput{}
	req.Data = output
	return
}

// Modifies the number of days to retain automated snapshots in the destination
// region after they are copied from the source region.
func (c *Redshift) ModifySnapshotCopyRetentionPeriod(input *ModifySnapshotCopyRetentionPeriodInput) (*ModifySnapshotCopyRetentionPeriodOutput, error) {
	req, out := c.ModifySnapshotCopyRetentionPeriodRequest(input)
	err := req.Send()
	return out, err
}

const opPurchaseReservedNodeOffering = "PurchaseReservedNodeOffering"

// PurchaseReservedNodeOfferingRequest generates a request for the PurchaseReservedNodeOffering operation.
func (c *Redshift) PurchaseReservedNodeOfferingRequest(input *PurchaseReservedNodeOfferingInput) (req *request.Request, output *PurchaseReservedNodeOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedNodeOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedNodeOfferingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PurchaseReservedNodeOfferingOutput{}
	req.Data = output
	return
}

// Allows you to purchase reserved nodes. Amazon Redshift offers a predefined
// set of reserved node offerings. You can purchase one or more of the offerings.
// You can call the DescribeReservedNodeOfferings API to obtain the available
// reserved node offerings. You can call this API by providing a specific reserved
// node offering and the number of nodes you want to reserve.
//
//  For more information about reserved node offerings, go to Purchasing Reserved
// Nodes (http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) PurchaseReservedNodeOffering(input *PurchaseReservedNodeOfferingInput) (*PurchaseReservedNodeOfferingOutput, error) {
	req, out := c.PurchaseReservedNodeOfferingRequest(input)
	err := req.Send()
	return out, err
}

const opRebootCluster = "RebootCluster"

// RebootClusterRequest generates a request for the RebootCluster operation.
func (c *Redshift) RebootClusterRequest(input *RebootClusterInput) (req *request.Request, output *RebootClusterOutput) {
	op := &request.Operation{
		Name:       opRebootCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RebootClusterOutput{}
	req.Data = output
	return
}

// Reboots a cluster. This action is taken as soon as possible. It results in
// a momentary outage to the cluster, during which the cluster status is set
// to rebooting. A cluster event is created when the reboot is completed. Any
// pending cluster modifications (see ModifyCluster) are applied at this reboot.
// For more information about managing clusters, go to Amazon Redshift Clusters
// (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide
func (c *Redshift) RebootCluster(input *RebootClusterInput) (*RebootClusterOutput, error) {
	req, out := c.RebootClusterRequest(input)
	err := req.Send()
	return out, err
}

const opResetClusterParameterGroup = "ResetClusterParameterGroup"

// ResetClusterParameterGroupRequest generates a request for the ResetClusterParameterGroup operation.
func (c *Redshift) ResetClusterParameterGroupRequest(input *ResetClusterParameterGroupInput) (req *request.Request, output *ClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetClusterParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ClusterParameterGroupNameMessage{}
	req.Data = output
	return
}

// Sets one or more parameters of the specified parameter group to their default
// values and sets the source values of the parameters to "engine-default".
// To reset the entire parameter group specify the ResetAllParameters parameter.
// For parameter changes to take effect you must reboot any associated clusters.
func (c *Redshift) ResetClusterParameterGroup(input *ResetClusterParameterGroupInput) (*ClusterParameterGroupNameMessage, error) {
	req, out := c.ResetClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreFromClusterSnapshot = "RestoreFromClusterSnapshot"

// RestoreFromClusterSnapshotRequest generates a request for the RestoreFromClusterSnapshot operation.
func (c *Redshift) RestoreFromClusterSnapshotRequest(input *RestoreFromClusterSnapshotInput) (req *request.Request, output *RestoreFromClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreFromClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreFromClusterSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreFromClusterSnapshotOutput{}
	req.Data = output
	return
}

// Creates a new cluster from a snapshot. By default, Amazon Redshift creates
// the resulting cluster with the same configuration as the original cluster
// from which the snapshot was created, except that the new cluster is created
// with the default cluster security and parameter groups. After Amazon Redshift
// creates the cluster, you can use the ModifyCluster API to associate a different
// security group and different parameter group with the restored cluster. If
// you are using a DS node type, you can also choose to change to another DS
// node type of the same size during restore.
//
//  If you restore a cluster into a VPC, you must provide a cluster subnet
// group where you want the cluster restored.
//
//  For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) RestoreFromClusterSnapshot(input *RestoreFromClusterSnapshotInput) (*RestoreFromClusterSnapshotOutput, error) {
	req, out := c.RestoreFromClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreTableFromClusterSnapshot = "RestoreTableFromClusterSnapshot"

// RestoreTableFromClusterSnapshotRequest generates a request for the RestoreTableFromClusterSnapshot operation.
func (c *Redshift) RestoreTableFromClusterSnapshotRequest(input *RestoreTableFromClusterSnapshotInput) (req *request.Request, output *RestoreTableFromClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreTableFromClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableFromClusterSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreTableFromClusterSnapshotOutput{}
	req.Data = output
	return
}

// Creates a new table from a table in an Amazon Redshift cluster snapshot.
// You must create the new table within the Amazon Redshift cluster that the
// snapshot was taken from.
//
// You cannot use RestoreTableFromClusterSnapshot to restore a table with the
// same name as an existing table in an Amazon Redshift cluster. That is, you
// cannot overwrite an existing table in a cluster with a restored table. If
// you want to replace your original table with a new, restored table, then
// rename or drop your original table before you call RestoreTableFromClusterSnapshot.
// When you have renamed your original table, then you can pass the original
// name of the table as the NewTableName parameter value in the call to RestoreTableFromClusterSnapshot.
// This way, you can replace the original table with the table created from
// the snapshot.
func (c *Redshift) RestoreTableFromClusterSnapshot(input *RestoreTableFromClusterSnapshotInput) (*RestoreTableFromClusterSnapshotOutput, error) {
	req, out := c.RestoreTableFromClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeClusterSecurityGroupIngress = "RevokeClusterSecurityGroupIngress"

// RevokeClusterSecurityGroupIngressRequest generates a request for the RevokeClusterSecurityGroupIngress operation.
func (c *Redshift) RevokeClusterSecurityGroupIngressRequest(input *RevokeClusterSecurityGroupIngressInput) (req *request.Request, output *RevokeClusterSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opRevokeClusterSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeClusterSecurityGroupIngressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RevokeClusterSecurityGroupIngressOutput{}
	req.Data = output
	return
}

// Revokes an ingress rule in an Amazon Redshift security group for a previously
// authorized IP range or Amazon EC2 security group. To add an ingress rule,
// see AuthorizeClusterSecurityGroupIngress. For information about managing
// security groups, go to Amazon Redshift Cluster Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) RevokeClusterSecurityGroupIngress(input *RevokeClusterSecurityGroupIngressInput) (*RevokeClusterSecurityGroupIngressOutput, error) {
	req, out := c.RevokeClusterSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeSnapshotAccess = "RevokeSnapshotAccess"

// RevokeSnapshotAccessRequest generates a request for the RevokeSnapshotAccess operation.
func (c *Redshift) RevokeSnapshotAccessRequest(input *RevokeSnapshotAccessInput) (req *request.Request, output *RevokeSnapshotAccessOutput) {
	op := &request.Operation{
		Name:       opRevokeSnapshotAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSnapshotAccessInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RevokeSnapshotAccessOutput{}
	req.Data = output
	return
}

// Removes the ability of the specified AWS customer account to restore the
// specified snapshot. If the account is currently restoring the snapshot, the
// restore will run to completion.
//
//  For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
func (c *Redshift) RevokeSnapshotAccess(input *RevokeSnapshotAccessInput) (*RevokeSnapshotAccessOutput, error) {
	req, out := c.RevokeSnapshotAccessRequest(input)
	err := req.Send()
	return out, err
}

const opRotateEncryptionKey = "RotateEncryptionKey"

// RotateEncryptionKeyRequest generates a request for the RotateEncryptionKey operation.
func (c *Redshift) RotateEncryptionKeyRequest(input *RotateEncryptionKeyInput) (req *request.Request, output *RotateEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opRotateEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RotateEncryptionKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RotateEncryptionKeyOutput{}
	req.Data = output
	return
}

// Rotates the encryption keys for a cluster.
func (c *Redshift) RotateEncryptionKey(input *RotateEncryptionKeyInput) (*RotateEncryptionKeyOutput, error) {
	req, out := c.RotateEncryptionKeyRequest(input)
	err := req.Send()
	return out, err
}

// Describes an AWS customer account authorized to restore a snapshot.
type AccountWithRestoreAccess struct {
	_ struct{} `type:"structure"`

	// The identifier of an AWS customer account authorized to restore a snapshot.
	AccountId *string `type:"string"`
}

// String returns the string representation
func (s AccountWithRestoreAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountWithRestoreAccess) GoString() string {
	return s.String()
}

type AuthorizeClusterSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range to be added the Amazon Redshift security group.
	CIDRIP *string `type:"string"`

	// The name of the security group to which the ingress rule is added.
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// The EC2 security group to be added the Amazon Redshift security group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account number of the owner of the security group specified by the
	// EC2SecurityGroupName parameter. The AWS Access Key ID is not an acceptable
	// value.
	//
	//  Example: 111122223333
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s AuthorizeClusterSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeClusterSecurityGroupIngressInput) GoString() string {
	return s.String()
}

type AuthorizeClusterSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s AuthorizeClusterSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeClusterSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

type AuthorizeSnapshotAccessInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS customer account authorized to restore the specified
	// snapshot.
	AccountWithRestoreAccess *string `type:"string" required:"true"`

	// The identifier of the cluster the snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The identifier of the snapshot the account is authorized to restore.
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AuthorizeSnapshotAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSnapshotAccessInput) GoString() string {
	return s.String()
}

type AuthorizeSnapshotAccessOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s AuthorizeSnapshotAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSnapshotAccessOutput) GoString() string {
	return s.String()
}

// Describes an availability zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// Describes a cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// If true, major version upgrades will be applied automatically to the cluster
	// during the maintenance window.
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automatic cluster snapshots are retained.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The name of the Availability Zone in which the cluster is located.
	AvailabilityZone *string `type:"string"`

	// The date and time that the cluster was created.
	ClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the cluster.
	ClusterIdentifier *string `type:"string"`

	// The nodes in a cluster.
	ClusterNodes []*ClusterNode `type:"list"`

	// The list of cluster parameter groups that are associated with this cluster.
	// Each parameter group in the list is returned with its status.
	ClusterParameterGroups []*ClusterParameterGroupStatus `locationNameList:"ClusterParameterGroup" type:"list"`

	// The public key for the cluster.
	ClusterPublicKey *string `type:"string"`

	// The specific revision number of the database in the cluster.
	ClusterRevisionNumber *string `type:"string"`

	// A list of cluster security group that are associated with the cluster. Each
	// security group is represented by an element that contains ClusterSecurityGroup.Name
	// and ClusterSecurityGroup.Status subelements.
	//
	// Cluster security groups are used when the cluster is not created in a VPC.
	// Clusters that are created in a VPC use VPC security groups, which are listed
	// by the VpcSecurityGroups parameter.
	ClusterSecurityGroups []*ClusterSecurityGroupMembership `locationNameList:"ClusterSecurityGroup" type:"list"`

	// Returns the destination region and retention period that are configured for
	// cross-region snapshot copy.
	ClusterSnapshotCopyStatus *ClusterSnapshotCopyStatus `type:"structure"`

	// The current state of the cluster. Possible values are:  available creating
	// deleting final-snapshot hardware-failure incompatible-hsm incompatible-network
	// incompatible-parameters incompatible-restore modifying rebooting renaming
	// resizing rotating-keys storage-full updating-hsm
	ClusterStatus *string `type:"string"`

	// The name of the subnet group that is associated with the cluster. This parameter
	// is valid only when the cluster is in a VPC.
	ClusterSubnetGroupName *string `type:"string"`

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string `type:"string"`

	// The name of the initial database that was created when the cluster was created.
	// This same name is returned for the life of the cluster. If an initial database
	// was not specified, a database named "dev" was created by default.
	DBName *string `type:"string"`

	// The status of the elastic IP (EIP) address.
	ElasticIpStatus *ElasticIpStatus `type:"structure"`

	// If true, data in the cluster is encrypted at rest.
	Encrypted *bool `type:"boolean"`

	// The connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// Reports whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command.
	//
	// Values: active, applying
	HsmStatus *HsmStatus `type:"structure"`

	// The AWS Key Management Service (KMS) key ID of the encryption key used to
	// encrypt data in the cluster.
	KmsKeyId *string `type:"string"`

	// The master user name for the cluster. This name is used to connect to the
	// database that is specified in DBName.
	MasterUsername *string `type:"string"`

	// The status of a modify operation, if any, initiated for the cluster.
	ModifyStatus *string `type:"string"`

	// The node type for the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of compute nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// If present, changes to the cluster are pending. Specific pending changes
	// are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// The weekly time range (in UTC) during which system maintenance can occur.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// Describes the status of a cluster restore action. Returns null if the cluster
	// was not created by restoring a snapshot.
	RestoreStatus *RestoreStatus `type:"structure"`

	// The list of tags for the cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the VPC the cluster is in, if the cluster is in a VPC.
	VpcId *string `type:"string"`

	// A list of Virtual Private Cloud (VPC) security groups that are associated
	// with the cluster. This parameter is returned only if the cluster is in a
	// VPC.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroup" type:"list"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cluster) GoString() string {
	return s.String()
}

// The identifier of a node in a cluster.
type ClusterNode struct {
	_ struct{} `type:"structure"`

	// Whether the node is a leader node or a compute node.
	NodeRole *string `type:"string"`

	// The private IP address of a node within a cluster.
	PrivateIPAddress *string `type:"string"`

	// The public IP address of a node within a cluster.
	PublicIPAddress *string `type:"string"`
}

// String returns the string representation
func (s ClusterNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterNode) GoString() string {
	return s.String()
}

// Describes a parameter group.
type ClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The description of the parameter group.
	Description *string `type:"string"`

	// The name of the cluster parameter group family that this cluster parameter
	// group is compatible with.
	ParameterGroupFamily *string `type:"string"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`

	// The list of tags for the cluster parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterGroup) GoString() string {
	return s.String()
}

type ClusterParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`

	// The status of the parameter group. For example, if you made a change to a
	// parameter group name-value pair, then the change could be pending a reboot
	// of an associated cluster.
	ParameterGroupStatus *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterGroupNameMessage) GoString() string {
	return s.String()
}

// Describes the status of a parameter group.
type ClusterParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The list of parameter statuses.
	//
	//  For more information about parameters and parameter groups, go to Amazon
	// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ClusterParameterStatusList []*ClusterParameterStatus `type:"list"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterGroupStatus) GoString() string {
	return s.String()
}

// Describes the status of a parameter group.
type ClusterParameterStatus struct {
	_ struct{} `type:"structure"`

	// The error that prevented the parameter from being applied to the database.
	ParameterApplyErrorDescription *string `type:"string"`

	// The status of the parameter that indicates whether the parameter is in sync
	// with the database, waiting for a cluster reboot, or encountered an error
	// when being applied.
	//
	// The following are possible statuses and descriptions. in-sync: The parameter
	// value is in sync with the database. pending-reboot: The parameter value will
	// be applied after the cluster reboots. applying: The parameter value is being
	// applied to the database. invalid-parameter: Cannot apply the parameter value
	// because it has an invalid value or syntax. apply-deferred: The parameter
	// contains static property changes. The changes are deferred until the cluster
	// reboots. apply-error: Cannot connect to the cluster. The parameter change
	// will be applied after the cluster reboots. unknown-error: Cannot apply the
	// parameter change right now. The change will be applied after the cluster
	// reboots.
	ParameterApplyStatus *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterStatus) GoString() string {
	return s.String()
}

// Describes a security group.
type ClusterSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group to which the operation was applied.
	ClusterSecurityGroupName *string `type:"string"`

	// A description of the security group.
	Description *string `type:"string"`

	// A list of EC2 security groups that are permitted to access clusters associated
	// with this cluster security group.
	EC2SecurityGroups []*EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// A list of IP ranges (CIDR blocks) that are permitted to access clusters associated
	// with this cluster security group.
	IPRanges []*IPRange `locationNameList:"IPRange" type:"list"`

	// The list of tags for the cluster security group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ClusterSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSecurityGroup) GoString() string {
	return s.String()
}

// Describes a cluster security group.
type ClusterSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group.
	ClusterSecurityGroupName *string `type:"string"`

	// The status of the cluster security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ClusterSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSecurityGroupMembership) GoString() string {
	return s.String()
}

// Returns the destination region and retention period that are configured for
// cross-region snapshot copy.
type ClusterSnapshotCopyStatus struct {
	_ struct{} `type:"structure"`

	// The destination region that snapshots are automatically copied to when cross-region
	// snapshot copy is enabled.
	DestinationRegion *string `type:"string"`

	// The number of days that automated snapshots are retained in the destination
	// region after they are copied from a source region.
	RetentionPeriod *int64 `type:"long"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`
}

// String returns the string representation
func (s ClusterSnapshotCopyStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSnapshotCopyStatus) GoString() string {
	return s.String()
}

// Describes a subnet group.
type ClusterSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group.
	ClusterSubnetGroupName *string `type:"string"`

	// The description of the cluster subnet group.
	Description *string `type:"string"`

	// The status of the cluster subnet group. Possible values are Complete, Incomplete
	// and Invalid.
	SubnetGroupStatus *string `type:"string"`

	// A list of the VPC Subnet elements.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// The list of tags for the cluster subnet group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The VPC ID of the cluster subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ClusterSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSubnetGroup) GoString() string {
	return s.String()
}

// Describes a cluster version, including the parameter group family and description
// of the version.
type ClusterVersion struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group family for the cluster.
	ClusterParameterGroupFamily *string `type:"string"`

	// The version number used by the cluster.
	ClusterVersion *string `type:"string"`

	// The description of the cluster version.
	Description *string `type:"string"`
}

// String returns the string representation
func (s ClusterVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterVersion) GoString() string {
	return s.String()
}

type CopyClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster the source snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints:
	//
	//  Must be the identifier for a valid cluster.
	SourceSnapshotClusterIdentifier *string `type:"string"`

	// The identifier for the source snapshot.
	//
	// Constraints:
	//
	//  Must be the identifier for a valid automated snapshot whose state is available.
	SourceSnapshotIdentifier *string `type:"string" required:"true"`

	// The identifier given to the new manual snapshot.
	//
	// Constraints:
	//
	//  Cannot be null, empty, or blank. Must contain from 1 to 255 alphanumeric
	// characters or hyphens. First character must be a letter. Cannot end with
	// a hyphen or contain two consecutive hyphens. Must be unique for the AWS account
	// that is making the request.
	TargetSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyClusterSnapshotInput) GoString() string {
	return s.String()
}

type CopyClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CopyClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyClusterSnapshotOutput) GoString() string {
	return s.String()
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `type:"string"`

	// If true, major version upgrades can be applied during the maintenance window
	// to the Amazon Redshift engine that is running on the cluster.
	//
	//  When a new major version of the Amazon Redshift engine is released, you
	// can request that the service automatically apply upgrades during the maintenance
	// window to the Amazon Redshift engine that is running on your cluster.
	//
	// Default: true
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automated snapshots are retained. If the value is
	// 0, automated snapshots are disabled. Even if automated snapshots are disabled,
	// you can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	//  Default: 1
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision
	// the cluster. For example, if you have several EC2 instances running in a
	// specific Availability Zone, then you might want the cluster to be provisioned
	// in the same zone in order to decrease network latency.
	//
	//  Default: A random, system-chosen Availability Zone in the region that is
	// specified by the endpoint.
	//
	//  Example: us-east-1d
	//
	//  Constraint: The specified Availability Zone must be in the same region
	// as the current endpoint.
	AvailabilityZone *string `type:"string"`

	// A unique identifier for the cluster. You use this identifier to refer to
	// the cluster for any subsequent cluster operations such as deleting or modifying.
	// The identifier also appears in the Amazon Redshift console.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens. Alphabetic
	// characters must be lowercase. First character must be a letter. Cannot end
	// with a hyphen or contain two consecutive hyphens. Must be unique for all
	// clusters within an AWS account.  Example: myexamplecluster
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the parameter group to be associated with this cluster.
	//
	// Default: The default Amazon Redshift cluster parameter group. For information
	// about the default parameter group, go to Working with Amazon Redshift Parameter
	// Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	//
	//  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters or hyphens. First character must
	// be a letter. Cannot end with a hyphen or contain two consecutive hyphens.
	ClusterParameterGroupName *string `type:"string"`

	// A list of security groups to be associated with this cluster.
	//
	//  Default: The default cluster security group for Amazon Redshift.
	ClusterSecurityGroups []*string `locationNameList:"ClusterSecurityGroupName" type:"list"`

	// The name of a cluster subnet group to be associated with this cluster.
	//
	//  If this parameter is not provided the resulting cluster will be deployed
	// outside virtual private cloud (VPC).
	ClusterSubnetGroupName *string `type:"string"`

	// The type of the cluster. When cluster type is specified as  single-node,
	// the NumberOfNodes parameter is not required. multi-node, the NumberOfNodes
	// parameter is required.
	//
	//  Valid Values: multi-node | single-node
	//
	// Default: multi-node
	ClusterType *string `type:"string"`

	// The version of the Amazon Redshift engine software that you want to deploy
	// on the cluster.
	//
	//  The version selected runs on all the nodes in the cluster.
	//
	// Constraints: Only version 1.0 is currently available.
	//
	// Example: 1.0
	ClusterVersion *string `type:"string"`

	// The name of the first database to be created when the cluster is created.
	//
	// To create additional databases after the cluster is created, connect to
	// the cluster with a SQL client and use SQL commands to create a database.
	// For more information, go to Create a Database (http://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html)
	// in the Amazon Redshift Database Developer Guide.
	//
	// Default: dev
	//
	// Constraints:
	//
	//  Must contain 1 to 64 alphanumeric characters. Must contain only lowercase
	// letters. Cannot be a word that is reserved by the service. A list of reserved
	// words can be found in Reserved Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	// in the Amazon Redshift Database Developer Guide.
	DBName *string `type:"string"`

	// The Elastic IP (EIP) address for the cluster.
	//
	// Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
	// through an Internet gateway. For more information about provisioning clusters
	// in EC2-VPC, go to Supported Platforms to Launch Your Cluster (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms)
	// in the Amazon Redshift Cluster Management Guide.
	ElasticIp *string `type:"string"`

	// If true, the data in the cluster is encrypted at rest.
	//
	// Default: false
	Encrypted *bool `type:"boolean"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that you
	// want to use to encrypt data in the cluster.
	KmsKeyId *string `type:"string"`

	// The password associated with the master user account for the cluster that
	// is being created.
	//
	//  Constraints:
	//
	//  Must be between 8 and 64 characters in length. Must contain at least one
	// uppercase letter. Must contain at least one lowercase letter. Must contain
	// one number. Can be any printable ASCII character (ASCII code 33 to 126) except
	// ' (single quote), " (double quote), \, /, @, or space.
	MasterUserPassword *string `type:"string" required:"true"`

	// The user name associated with the master user account for the cluster that
	// is being created.
	//
	// Constraints:
	//
	//  Must be 1 - 128 alphanumeric characters. First character must be a letter.
	// Cannot be a reserved word. A list of reserved words can be found in Reserved
	// Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	// in the Amazon Redshift Database Developer Guide.
	MasterUsername *string `type:"string" required:"true"`

	// The node type to be provisioned for the cluster. For information about node
	// types, go to  Working with Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes)
	// in the Amazon Redshift Cluster Management Guide.
	//
	//  Valid Values: ds1.xlarge | ds1.8xlarge | ds2.xlarge | ds2.8xlarge | dc1.large
	// | dc1.8xlarge.
	NodeType *string `type:"string" required:"true"`

	// The number of compute nodes in the cluster. This parameter is required when
	// the ClusterType parameter is specified as multi-node.
	//
	// For information about determining how many nodes you need, go to  Working
	// with Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If you don't specify this parameter, you get a single-node cluster. When
	// requesting a multi-node cluster, you must specify the number of nodes that
	// you want in the cluster.
	//
	// Default: 1
	//
	// Constraints: Value must be at least 1 and no more than 100.
	NumberOfNodes *int64 `type:"integer"`

	// The port number on which the cluster accepts incoming connections.
	//
	// The cluster is accessible only via the JDBC and ODBC connection strings.
	// Part of the connection string requires the port on which the cluster will
	// listen for incoming connections.
	//
	//  Default: 5439
	//
	//  Valid Values: 1150-65535
	Port *int64 `type:"integer"`

	// The weekly time range (in UTC) during which automated cluster maintenance
	// can occur.
	//
	//  Format: ddd:hh24:mi-ddd:hh24:mi
	//
	//  Default: A 30-minute window selected at random from an 8-hour block of
	// time per region, occurring on a random day of the week. For more information
	// about the time blocks for each region, see Maintenance Windows (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows)
	// in Amazon Redshift Cluster Management Guide.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of Virtual Private Cloud (VPC) security groups to be associated with
	// the cluster.
	//
	// Default: The default VPC security group is associated with the cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

type CreateClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the parameter group.
	Description *string `type:"string" required:"true"`

	// The Amazon Redshift engine version to which the cluster parameter group applies.
	// The cluster engine version determines the set of parameters.
	//
	// To get a list of valid parameter group family names, you can call DescribeClusterParameterGroups.
	// By default, Amazon Redshift returns a list of all the parameter groups that
	// are owned by your AWS account, including the default parameter groups for
	// each Amazon Redshift engine version. The parameter group family names associated
	// with the default parameter groups provide you the valid values. For example,
	// a valid family name is "redshift-1.0".
	ParameterGroupFamily *string `type:"string" required:"true"`

	// The name of the cluster parameter group.
	//
	//  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters or hyphens First character must
	// be a letter. Cannot end with a hyphen or contain two consecutive hyphens.
	// Must be unique withing your AWS account.  This value is stored as a lower-case
	// string.
	ParameterGroupName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterParameterGroupInput) GoString() string {
	return s.String()
}

type CreateClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a parameter group.
	ClusterParameterGroup *ClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterParameterGroupOutput) GoString() string {
	return s.String()
}

type CreateClusterSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name for the security group. Amazon Redshift stores the value as a lowercase
	// string.
	//
	// Constraints:
	//
	//  Must contain no more than 255 alphanumeric characters or hyphens. Must
	// not be "Default". Must be unique for all security groups that are created
	// by your AWS account.  Example: examplesecuritygroup
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// A description for the security group.
	Description *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSecurityGroupInput) GoString() string {
	return s.String()
}

type CreateClusterSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSecurityGroupOutput) GoString() string {
	return s.String()
}

type CreateClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier for which you want a snapshot.
	ClusterIdentifier *string `type:"string" required:"true"`

	// A unique identifier for the snapshot that you are requesting. This identifier
	// must be unique for all snapshots within the AWS account.
	//
	// Constraints:
	//
	//  Cannot be null, empty, or blank Must contain from 1 to 255 alphanumeric
	// characters or hyphens First character must be a letter Cannot end with a
	// hyphen or contain two consecutive hyphens  Example: my-snapshot-id
	SnapshotIdentifier *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSnapshotInput) GoString() string {
	return s.String()
}

type CreateClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSnapshotOutput) GoString() string {
	return s.String()
}

type CreateClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name for the subnet group. Amazon Redshift stores the value as a lowercase
	// string.
	//
	// Constraints:
	//
	//  Must contain no more than 255 alphanumeric characters or hyphens. Must
	// not be "Default". Must be unique for all subnet groups that are created by
	// your AWS account.  Example: examplesubnetgroup
	ClusterSubnetGroupName *string `type:"string" required:"true"`

	// A description for the subnet group.
	Description *string `type:"string" required:"true"`

	// An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
	// single request.
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSubnetGroupInput) GoString() string {
	return s.String()
}

type CreateClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a subnet group.
	ClusterSubnetGroup *ClusterSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSubnetGroupOutput) GoString() string {
	return s.String()
}

type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription, set to false to
	// create the subscription but not active it.
	Enabled *bool `type:"boolean"`

	// Specifies the Amazon Redshift event categories to be published by the event
	// notification subscription.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Specifies the Amazon Redshift event severity to be published by the event
	// notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the
	// event notifications. The ARN is created by Amazon SNS when you create a topic
	// and subscribe to it.
	SnsTopicArn *string `type:"string" required:"true"`

	// A list of one or more identifiers of Amazon Redshift source objects. All
	// of the objects must be of the same type as was specified in the source type
	// parameter. The event subscription will return only events generated by the
	// specified objects. If not specified, then events are returned for all objects
	// within the source type specified.
	//
	// Example: my-cluster-1, my-cluster-2
	//
	// Example: my-snapshot-20131010
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a cluster, you would set this
	// parameter to cluster. If this value is not specified, events are returned
	// for all Amazon Redshift objects in your AWS account. You must specify a source
	// type in order to specify source IDs.
	//
	// Valid values: cluster, cluster-parameter-group, cluster-security-group,
	// and cluster-snapshot.
	SourceType *string `type:"string"`

	// The name of the event subscription to be created.
	//
	// Constraints:
	//
	//  Cannot be null, empty, or blank. Must contain from 1 to 255 alphanumeric
	// characters or hyphens. First character must be a letter. Cannot end with
	// a hyphen or contain two consecutive hyphens.
	SubscriptionName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Describes event subscriptions.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

type CreateHsmClientCertificateInput struct {
	_ struct{} `type:"structure"`

	// The identifier to be assigned to the new HSM client certificate that the
	// cluster will use to connect to the HSM to use the database encryption keys.
	HsmClientCertificateIdentifier *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateHsmClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmClientCertificateInput) GoString() string {
	return s.String()
}

type CreateHsmClientCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about an HSM client certificate. The certificate is stored
	// in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift
	// cluster to encrypt data files.
	HsmClientCertificate *HsmClientCertificate `type:"structure"`
}

// String returns the string representation
func (s CreateHsmClientCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmClientCertificateOutput) GoString() string {
	return s.String()
}

type CreateHsmConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A text description of the HSM configuration to be created.
	Description *string `type:"string" required:"true"`

	// The identifier to be assigned to the new Amazon Redshift HSM configuration.
	HsmConfigurationIdentifier *string `type:"string" required:"true"`

	// The IP address that the Amazon Redshift cluster must use to access the HSM.
	HsmIpAddress *string `type:"string" required:"true"`

	// The name of the partition in the HSM where the Amazon Redshift clusters will
	// store their database encryption keys.
	HsmPartitionName *string `type:"string" required:"true"`

	// The password required to access the HSM partition.
	HsmPartitionPassword *string `type:"string" required:"true"`

	// The HSMs public certificate file. When using Cloud HSM, the file name is
	// server.pem.
	HsmServerPublicCertificate *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateHsmConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmConfigurationInput) GoString() string {
	return s.String()
}

type CreateHsmConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about an HSM configuration, which is an object that describes
	// to Amazon Redshift clusters the information they require to connect to an
	// HSM where they can store database encryption keys.
	HsmConfiguration *HsmConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateHsmConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmConfigurationOutput) GoString() string {
	return s.String()
}

// The result of the CreateSnapshotCopyGrant action.
type CreateSnapshotCopyGrantInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the customer master key (CMK) to which to grant
	// Amazon Redshift permission. If no key is specified, the default key is used.
	KmsKeyId *string `type:"string"`

	// The name of the snapshot copy grant. This name must be unique in the region
	// for the AWS account.
	//
	//  Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens. Alphabetic
	// characters must be lowercase. First character must be a letter. Cannot end
	// with a hyphen or contain two consecutive hyphens. Must be unique for all
	// clusters within an AWS account.
	SnapshotCopyGrantName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateSnapshotCopyGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotCopyGrantInput) GoString() string {
	return s.String()
}

type CreateSnapshotCopyGrantOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot copy grant that grants Amazon Redshift permission to encrypt
	// copied snapshots with the specified customer master key (CMK) from AWS KMS
	// in the destination region.
	//
	//  For more information about managing snapshot copy grants, go to Amazon
	// Redshift Database Encryption (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
	// in the Amazon Redshift Cluster Management Guide.
	SnapshotCopyGrant *SnapshotCopyGrant `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotCopyGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotCopyGrantOutput) GoString() string {
	return s.String()
}

// Contains the output from the CreateTags action.
type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) to which you want to add the tag or tags.
	// For example, arn:aws:redshift:us-east-1:123456789:cluster:t1.
	ResourceName *string `type:"string" required:"true"`

	// One or more name/value pairs to add as tags to the specified resource. Each
	// tag name is passed in with the parameter Key and the corresponding value
	// is passed in with the parameter Value. The Key and Value parameters are separated
	// by a comma (,). Separate multiple tags with a space. For example, --tags
	// "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0".
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

// Describes the default cluster parameters for a parameter group family.
type DefaultClusterParameters struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The name of the cluster parameter group family to which the engine default
	// parameters apply.
	ParameterGroupFamily *string `type:"string"`

	// The list of cluster default parameters.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DefaultClusterParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultClusterParameters) GoString() string {
	return s.String()
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to be deleted.
	//
	// Constraints:
	//
	//  Must contain lowercase characters. Must contain from 1 to 63 alphanumeric
	// characters or hyphens. First character must be a letter. Cannot end with
	// a hyphen or contain two consecutive hyphens.
	ClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the final snapshot that is to be created immediately before
	// deleting the cluster. If this parameter is provided, SkipFinalClusterSnapshot
	// must be false.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters. First character must be a letter.
	// Cannot end with a hyphen or contain two consecutive hyphens.
	FinalClusterSnapshotIdentifier *string `type:"string"`

	// Determines whether a final snapshot of the cluster is created before Amazon
	// Redshift deletes the cluster. If true, a final cluster snapshot is not created.
	// If false, a final cluster snapshot is created before the cluster is deleted.
	//
	// The FinalClusterSnapshotIdentifier parameter must be specified if SkipFinalClusterSnapshot
	// is false. Default: false
	SkipFinalClusterSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

type DeleteClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to be deleted.
	//
	// Constraints:
	//
	//  Must be the name of an existing cluster parameter group. Cannot delete
	// a default cluster parameter group.
	ParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterParameterGroupInput) GoString() string {
	return s.String()
}

type DeleteClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterParameterGroupOutput) GoString() string {
	return s.String()
}

type DeleteClusterSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group to be deleted.
	ClusterSecurityGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSecurityGroupInput) GoString() string {
	return s.String()
}

type DeleteClusterSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSecurityGroupOutput) GoString() string {
	return s.String()
}

type DeleteClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster the snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints: Must be the name of valid cluster.
	SnapshotClusterIdentifier *string `type:"string"`

	// The unique identifier of the manual snapshot to be deleted.
	//
	// Constraints: Must be the name of an existing snapshot that is in the available
	// state.
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSnapshotInput) GoString() string {
	return s.String()
}

type DeleteClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSnapshotOutput) GoString() string {
	return s.String()
}

type DeleteClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group name to be deleted.
	ClusterSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSubnetGroupInput) GoString() string {
	return s.String()
}

type DeleteClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSubnetGroupOutput) GoString() string {
	return s.String()
}

type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Redshift event notification subscription to be deleted.
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteHsmClientCertificateInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the HSM client certificate to be deleted.
	HsmClientCertificateIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmClientCertificateInput) GoString() string {
	return s.String()
}

type DeleteHsmClientCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHsmClientCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmClientCertificateOutput) GoString() string {
	return s.String()
}

type DeleteHsmConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift HSM configuration to be deleted.
	HsmConfigurationIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmConfigurationInput) GoString() string {
	return s.String()
}

type DeleteHsmConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHsmConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmConfigurationOutput) GoString() string {
	return s.String()
}

// The result of the DeleteSnapshotCopyGrant action.
type DeleteSnapshotCopyGrantInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot copy grant to delete.
	SnapshotCopyGrantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotCopyGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotCopyGrantInput) GoString() string {
	return s.String()
}

type DeleteSnapshotCopyGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotCopyGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotCopyGrantOutput) GoString() string {
	return s.String()
}

// Contains the output from the DeleteTags action.
type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) from which you want to remove the tag or tags.
	// For example, arn:aws:redshift:us-east-1:123456789:cluster:t1.
	ResourceName *string `type:"string" required:"true"`

	// The tag key that you want to delete.
	TagKeys []*string `locationNameList:"TagKey" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeClusterParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterParameterGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of a specific parameter group for which to return details. By default,
	// details about all parameter groups and the default parameter group are returned.
	ParameterGroupName *string `type:"string"`

	// A tag key or keys for which you want to return all matching cluster parameter
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have parameter groups that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the parameter groups that have either or
	// both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster parameter
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have parameter groups that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the parameter groups that have either or
	// both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParameterGroupsInput) GoString() string {
	return s.String()
}

// Contains the output from the DescribeClusterParameterGroups action.
type DescribeClusterParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of ClusterParameterGroup instances. Each instance describes one cluster
	// parameter group.
	ParameterGroups []*ClusterParameterGroup `locationNameList:"ClusterParameterGroup" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParameterGroupsOutput) GoString() string {
	return s.String()
}

type DescribeClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterParameters request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of a cluster parameter group for which to return details.
	ParameterGroupName *string `type:"string" required:"true"`

	// The parameter types to return. Specify user to show parameters that are different
	// form the default. Similarly, specify engine-default to show parameters that
	// are the same as the default parameter group.
	//
	// Default: All parameter types returned.
	//
	// Valid Values: user | engine-default
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParametersInput) GoString() string {
	return s.String()
}

// Contains the output from the DescribeClusterParameters action.
type DescribeClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of Parameter instances. Each instance lists the parameters of one
	// cluster parameter group.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParametersOutput) GoString() string {
	return s.String()
}

type DescribeClusterSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a cluster security group for which you are requesting details.
	// You can specify either the Marker parameter or a ClusterSecurityGroupName
	// parameter, but not both.
	//
	//  Example: securitygroup1
	ClusterSecurityGroupName *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSecurityGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	//  Constraints: You can specify either the ClusterSecurityGroupName parameter
	// or the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching cluster security
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have security groups that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the security groups that have either or
	// both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster security
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have security groups that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the security groups that have either or
	// both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSecurityGroupsInput) GoString() string {
	return s.String()
}

type DescribeClusterSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ClusterSecurityGroup instances.
	ClusterSecurityGroups []*ClusterSecurityGroup `locationNameList:"ClusterSecurityGroup" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSecurityGroupsOutput) GoString() string {
	return s.String()
}

type DescribeClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster for which information about snapshots is requested.
	ClusterIdentifier *string `type:"string"`

	// A time value that requests only snapshots created at or before the specified
	// time. The time value is specified in ISO 8601 format. For more information
	// about ISO 8601, go to the ISO8601 Wikipedia page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2012-07-16T18:00:00Z
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSnapshots request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The AWS customer account used to create or copy the snapshot. Use this field
	// to filter the results to snapshots owned by a particular account. To describe
	// snapshots you own, either specify your AWS customer account, or do not specify
	// the parameter.
	OwnerAccount *string `type:"string"`

	// The snapshot identifier of the snapshot about which to return information.
	SnapshotIdentifier *string `type:"string"`

	// The type of snapshots for which you are requesting information. By default,
	// snapshots of all types are returned.
	//
	//  Valid Values: automated | manual
	SnapshotType *string `type:"string"`

	// A value that requests only snapshots created at or after the specified time.
	// The time value is specified in ISO 8601 format. For more information about
	// ISO 8601, go to the ISO8601 Wikipedia page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2012-07-16T18:00:00Z
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A tag key or keys for which you want to return all matching cluster snapshots
	// that are associated with the specified key or keys. For example, suppose
	// that you have snapshots that are tagged with keys called owner and environment.
	// If you specify both of these tag keys in the request, Amazon Redshift returns
	// a response with the snapshots that have either or both of these tag keys
	// associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster snapshots
	// that are associated with the specified tag value or values. For example,
	// suppose that you have snapshots that are tagged with values called admin
	// and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the snapshots that have either or both of
	// these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Contains the output from the DescribeClusterSnapshots action.
type DescribeClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of Snapshot instances.
	Snapshots []*Snapshot `locationNameList:"Snapshot" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSnapshotsOutput) GoString() string {
	return s.String()
}

type DescribeClusterSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group for which information is requested.
	ClusterSubnetGroupName *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSubnetGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching cluster subnet
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have subnet groups that are tagged with keys called owner and environment.
	// If you specify both of these tag keys in the request, Amazon Redshift returns
	// a response with the subnet groups that have either or both of these tag keys
	// associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster subnet
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have subnet groups that are tagged with values called admin
	// and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the subnet groups that have either or both
	// of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSubnetGroupsInput) GoString() string {
	return s.String()
}

// Contains the output from the DescribeClusterSubnetGroups action.
type DescribeClusterSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ClusterSubnetGroup instances.
	ClusterSubnetGroups []*ClusterSubnetGroup `locationNameList:"ClusterSubnetGroup" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSubnetGroupsOutput) GoString() string {
	return s.String()
}

type DescribeClusterVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific cluster parameter group family to return details for.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	ClusterParameterGroupFamily *string `type:"string"`

	// The specific cluster version to return.
	//
	// Example: 1.0
	ClusterVersion *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterVersions request exceed
	// the value specified in MaxRecords, AWS returns a value in the Marker field
	// of the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeClusterVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterVersionsInput) GoString() string {
	return s.String()
}

// Contains the output from the DescribeClusterVersions action.
type DescribeClusterVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Version elements.
	ClusterVersions []*ClusterVersion `locationNameList:"ClusterVersion" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterVersionsOutput) GoString() string {
	return s.String()
}

type DescribeClustersInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a cluster whose properties you are requesting. This
	// parameter is case sensitive.
	//
	// The default is that all clusters defined for an account are returned.
	ClusterIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusters request exceed the
	// value specified in MaxRecords, AWS returns a value in the Marker field of
	// the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	//
	//  Constraints: You can specify either the ClusterIdentifier parameter or
	// the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching clusters that
	// are associated with the specified key or keys. For example, suppose that
	// you have clusters that are tagged with keys called owner and environment.
	// If you specify both of these tag keys in the request, Amazon Redshift returns
	// a response with the clusters that have either or both of these tag keys associated
	// with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching clusters
	// that are associated with the specified tag value or values. For example,
	// suppose that you have clusters that are tagged with values called admin and
	// test. If you specify both of these tag values in the request, Amazon Redshift
	// returns a response with the clusters that have either or both of these tag
	// values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClustersInput) GoString() string {
	return s.String()
}

// Contains the output from the DescribeClusters action.
type DescribeClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of Cluster objects, where each object describes one cluster.
	Clusters []*Cluster `locationNameList:"Cluster" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClustersOutput) GoString() string {
	return s.String()
}

type DescribeDefaultClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeDefaultClusterParameters
	// request exceed the value specified in MaxRecords, AWS returns a value in
	// the Marker field of the response. You can retrieve the next set of response
	// records by providing the returned marker value in the Marker parameter and
	// retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the cluster parameter group family.
	ParameterGroupFamily *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDefaultClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultClusterParametersInput) GoString() string {
	return s.String()
}

type DescribeDefaultClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// Describes the default cluster parameters for a parameter group family.
	DefaultClusterParameters *DefaultClusterParameters `type:"structure"`
}

// String returns the string representation
func (s DescribeDefaultClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultClusterParametersOutput) GoString() string {
	return s.String()
}

type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// The source type, such as cluster or parameter group, to which the described
	// event categories apply.
	//
	//  Valid values: cluster, cluster-snapshot, cluster-parameter-group, and cluster-security-group.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of event categories descriptions.
	EventCategoriesMapList []*EventCategoriesMap `locationNameList:"EventCategoriesMap" type:"list"`
}

// String returns the string representation
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

type DescribeEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeEventSubscriptions request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the Amazon Redshift event notification subscription to be described.
	SubscriptionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsInput) GoString() string {
	return s.String()
}

type DescribeEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of event subscriptions.
	EventSubscriptionsList []*EventSubscription `locationNameList:"EventSubscription" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsOutput) GoString() string {
	return s.String()
}

type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes prior to the time of the request for which to retrieve
	// events. For example, if the request is sent at 18:00 and you specify a duration
	// of 60, then only events which have occurred after 17:00 will be returned.
	//
	// Default: 60
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeEvents request exceed the
	// value specified in MaxRecords, AWS returns a value in the Marker field of
	// the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source for which events will be returned. If
	// this parameter is not specified, then all sources are included in the response.
	//
	// Constraints:
	//
	// If SourceIdentifier is supplied, SourceType must also be provided.
	//
	//  Specify a cluster identifier when SourceType is cluster. Specify a cluster
	// security group name when SourceType is cluster-security-group. Specify a
	// cluster parameter group name when SourceType is cluster-parameter-group.
	// Specify a cluster snapshot identifier when SourceType is cluster-snapshot.
	SourceIdentifier *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	//
	// Constraints:
	//
	// If SourceType is supplied, SourceIdentifier must also be provided.
	//
	//  Specify cluster when SourceIdentifier is a cluster identifier. Specify
	// cluster-security-group when SourceIdentifier is a cluster security group
	// name. Specify cluster-parameter-group when SourceIdentifier is a cluster
	// parameter group name. Specify cluster-snapshot when SourceIdentifier is a
	// cluster snapshot identifier.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Event instances.
	Events []*Event `locationNameList:"Event" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

type DescribeHsmClientCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a specific HSM client certificate for which you want information.
	// If no identifier is specified, information is returned for all HSM client
	// certificates owned by your AWS customer account.
	HsmClientCertificateIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeHsmClientCertificates request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching HSM client certificates
	// that are associated with the specified key or keys. For example, suppose
	// that you have HSM client certificates that are tagged with keys called owner
	// and environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the HSM client certificates that have either
	// or both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching HSM client
	// certificates that are associated with the specified tag value or values.
	// For example, suppose that you have HSM client certificates that are tagged
	// with values called admin and test. If you specify both of these tag values
	// in the request, Amazon Redshift returns a response with the HSM client certificates
	// that have either or both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeHsmClientCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmClientCertificatesInput) GoString() string {
	return s.String()
}

type DescribeHsmClientCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the identifiers for one or more HSM client certificates used by
	// Amazon Redshift clusters to store and retrieve database encryption keys in
	// an HSM.
	HsmClientCertificates []*HsmClientCertificate `locationNameList:"HsmClientCertificate" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmClientCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmClientCertificatesOutput) GoString() string {
	return s.String()
}

type DescribeHsmConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a specific Amazon Redshift HSM configuration to be described.
	// If no identifier is specified, information is returned for all HSM configurations
	// owned by your AWS customer account.
	HsmConfigurationIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeHsmConfigurations request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching HSM configurations
	// that are associated with the specified key or keys. For example, suppose
	// that you have HSM configurations that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the HSM configurations that have either
	// or both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching HSM configurations
	// that are associated with the specified tag value or values. For example,
	// suppose that you have HSM configurations that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the HSM configurations that have either
	// or both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeHsmConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmConfigurationsInput) GoString() string {
	return s.String()
}

type DescribeHsmConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of HsmConfiguration objects.
	HsmConfigurations []*HsmConfiguration `locationNameList:"HsmConfiguration" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmConfigurationsOutput) GoString() string {
	return s.String()
}

type DescribeLoggingStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster from which to get the logging status.
	//
	// Example: examplecluster
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLoggingStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoggingStatusInput) GoString() string {
	return s.String()
}

type DescribeOrderableClusterOptionsInput struct {
	_ struct{} `type:"structure"`

	// The version filter value. Specify this parameter to show only the available
	// offerings matching the specified version.
	//
	// Default: All versions.
	//
	// Constraints: Must be one of the version returned from DescribeClusterVersions.
	ClusterVersion *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeOrderableClusterOptions request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The node type filter value. Specify this parameter to show only the available
	// offerings matching the specified node type.
	NodeType *string `type:"string"`
}

// String returns the string representation
func (s DescribeOrderableClusterOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableClusterOptionsInput) GoString() string {
	return s.String()
}

// Contains the output from the DescribeOrderableClusterOptions action.
type DescribeOrderableClusterOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// An OrderableClusterOption structure containing information about orderable
	// options for the cluster.
	OrderableClusterOptions []*OrderableClusterOption `locationNameList:"OrderableClusterOption" type:"list"`
}

// String returns the string representation
func (s DescribeOrderableClusterOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableClusterOptionsOutput) GoString() string {
	return s.String()
}

type DescribeReservedNodeOfferingsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeReservedNodeOfferings request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The unique identifier for the offering.
	ReservedNodeOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedNodeOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodeOfferingsInput) GoString() string {
	return s.String()
}

type DescribeReservedNodeOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of ReservedNodeOffering objects.
	ReservedNodeOfferings []*ReservedNodeOffering `locationNameList:"ReservedNodeOffering" type:"list"`
}

// String returns the string representation
func (s DescribeReservedNodeOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodeOfferingsOutput) GoString() string {
	return s.String()
}

type DescribeReservedNodesInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeReservedNodes request exceed
	// the value specified in MaxRecords, AWS returns a value in the Marker field
	// of the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// Identifier for the node reservation.
	ReservedNodeId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodesInput) GoString() string {
	return s.String()
}

type DescribeReservedNodesOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The list of ReservedNode objects.
	ReservedNodes []*ReservedNode `locationNameList:"ReservedNode" type:"list"`
}

// String returns the string representation
func (s DescribeReservedNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodesOutput) GoString() string {
	return s.String()
}

type DescribeResizeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a cluster whose resize progress you are requesting.
	// This parameter is case-sensitive.
	//
	// By default, resize operations for all clusters defined for an AWS account
	// are returned.
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResizeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResizeInput) GoString() string {
	return s.String()
}

// Describes the result of a cluster resize operation.
type DescribeResizeOutput struct {
	_ struct{} `type:"structure"`

	// The average rate of the resize operation over the last few minutes, measured
	// in megabytes per second. After the resize operation completes, this value
	// shows the average rate of the entire resize operation.
	AvgResizeRateInMegaBytesPerSecond *float64 `type:"double"`

	// The amount of seconds that have elapsed since the resize operation began.
	// After the resize operation completes, this value shows the total actual time,
	// in seconds, for the resize operation.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimated time remaining, in seconds, until the resize operation is complete.
	// This value is calculated based on the average resize rate and the estimated
	// amount of data remaining to be processed. Once the resize operation is complete,
	// this value will be 0.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The names of tables that have been completely imported .
	//
	// Valid Values: List of table names.
	ImportTablesCompleted []*string `type:"list"`

	// The names of tables that are being currently imported.
	//
	// Valid Values: List of table names.
	ImportTablesInProgress []*string `type:"list"`

	// The names of tables that have not been yet imported.
	//
	// Valid Values: List of table names
	ImportTablesNotStarted []*string `type:"list"`

	// While the resize operation is in progress, this value shows the current amount
	// of data, in megabytes, that has been processed so far. When the resize operation
	// is complete, this value shows the total amount of data, in megabytes, on
	// the cluster, which may be more or less than TotalResizeDataInMegaBytes (the
	// estimated total amount of data before resize).
	ProgressInMegaBytes *int64 `type:"long"`

	// The status of the resize operation.
	//
	// Valid Values: NONE | IN_PROGRESS | FAILED | SUCCEEDED
	Status *string `type:"string"`

	// The cluster type after the resize operation is complete.
	//
	// Valid Values: multi-node | single-node
	TargetClusterType *string `type:"string"`

	// The node type that the cluster will have after the resize operation is complete.
	TargetNodeType *string `type:"string"`

	// The number of nodes that the cluster will have after the resize operation
	// is complete.
	TargetNumberOfNodes *int64 `type:"integer"`

	// The estimated total amount of data, in megabytes, on the cluster before the
	// resize operation began.
	TotalResizeDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeResizeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResizeOutput) GoString() string {
	return s.String()
}

// The result of the DescribeSnapshotCopyGrants action.
type DescribeSnapshotCopyGrantsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeSnapshotCopyGrant request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	//  Constraints: You can specify either the SnapshotCopyGrantName parameter
	// or the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`

	// A tag key or keys for which you want to return all matching resources that
	// are associated with the specified key or keys. For example, suppose that
	// you have resources tagged with keys called owner and environment. If you
	// specify both of these tag keys in the request, Amazon Redshift returns a
	// response with all resources that have either or both of these tag keys associated
	// with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching resources
	// that are associated with the specified value or values. For example, suppose
	// that you have resources tagged with values called admin and test. If you
	// specify both of these tag values in the request, Amazon Redshift returns
	// a response with all resources that have either or both of these tag values
	// associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotCopyGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotCopyGrantsInput) GoString() string {
	return s.String()
}

type DescribeSnapshotCopyGrantsOutput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeSnapshotCopyGrant request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	//  Constraints: You can specify either the SnapshotCopyGrantName parameter
	// or the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The list of SnapshotCopyGrant objects.
	SnapshotCopyGrants []*SnapshotCopyGrant `locationNameList:"SnapshotCopyGrant" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotCopyGrantsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotCopyGrantsOutput) GoString() string {
	return s.String()
}

type DescribeTableRestoreStatusInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Redshift cluster that the table is being restored to.
	ClusterIdentifier *string `type:"string"`

	// An optional pagination token provided by a previous DescribeTableRestoreStatus
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by the MaxRecords parameter.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the table restore request to return status for. If you
	// don't specify a TableRestoreRequestId value, then DescribeTableRestoreStatus
	// returns the status of all in-progress table restore requests.
	TableRestoreRequestId *string `type:"string"`
}

// String returns the string representation
func (s DescribeTableRestoreStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableRestoreStatusInput) GoString() string {
	return s.String()
}

type DescribeTableRestoreStatusOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that can be used in a subsequent DescribeTableRestoreStatus
	// request.
	Marker *string `type:"string"`

	// A list of status details for one or more table restore requests.
	TableRestoreStatusDetails []*TableRestoreStatus `locationNameList:"TableRestoreStatus" type:"list"`
}

// String returns the string representation
func (s DescribeTableRestoreStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableRestoreStatusOutput) GoString() string {
	return s.String()
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the marker
	// parameter and retrying the command. If the marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The maximum number or response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for which you want to describe the tag or
	// tags. For example, arn:aws:redshift:us-east-1:123456789:cluster:t1.
	ResourceName *string `type:"string"`

	// The type of resource with which you want to view tags. Valid resource types
	// are:  Cluster CIDR/IP EC2 security group Snapshot Cluster security group
	// Subnet group HSM connection HSM certificate Parameter group Snapshot copy
	// grant
	//
	//  For more information about Amazon Redshift resource types and constructing
	// ARNs, go to Constructing an Amazon Redshift Amazon Resource Name (ARN) (http://docs.aws.amazon.com/redshift/latest/mgmt/constructing-redshift-arn.html)
	// in the Amazon Redshift Cluster Management Guide.
	ResourceType *string `type:"string"`

	// A tag key or keys for which you want to return all matching resources that
	// are associated with the specified key or keys. For example, suppose that
	// you have resources tagged with keys called owner and environment. If you
	// specify both of these tag keys in the request, Amazon Redshift returns a
	// response with all resources that have either or both of these tag keys associated
	// with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching resources
	// that are associated with the specified value or values. For example, suppose
	// that you have resources tagged with values called admin and test. If you
	// specify both of these tag values in the request, Amazon Redshift returns
	// a response with all resources that have either or both of these tag values
	// associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of tags with their associated resources.
	TaggedResources []*TaggedResource `locationNameList:"TaggedResource" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

type DisableLoggingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster on which logging is to be stopped.
	//
	// Example: examplecluster
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableLoggingInput) GoString() string {
	return s.String()
}

type DisableSnapshotCopyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the source cluster that you want to disable copying
	// of snapshots to a destination region.
	//
	//  Constraints: Must be the valid name of an existing cluster that has cross-region
	// snapshot copy enabled.
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableSnapshotCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSnapshotCopyInput) GoString() string {
	return s.String()
}

type DisableSnapshotCopyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DisableSnapshotCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSnapshotCopyOutput) GoString() string {
	return s.String()
}

// Describes an Amazon EC2 security group.
type EC2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the EC2 Security Group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS ID of the owner of the EC2 security group specified in the EC2SecurityGroupName
	// field.
	EC2SecurityGroupOwnerId *string `type:"string"`

	// The status of the EC2 security group.
	Status *string `type:"string"`

	// The list of tags for the EC2 security group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2SecurityGroup) GoString() string {
	return s.String()
}

// Describes the status of the elastic IP (EIP) address.
type ElasticIpStatus struct {
	_ struct{} `type:"structure"`

	// The elastic IP (EIP) address for the cluster.
	ElasticIp *string `type:"string"`

	// The status of the elastic IP (EIP) address.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ElasticIpStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticIpStatus) GoString() string {
	return s.String()
}

type EnableLoggingInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing S3 bucket where the log files are to be stored.
	//
	// Constraints:
	//
	//  Must be in the same region as the cluster The cluster must have read bucket
	// and put object permissions
	BucketName *string `type:"string" required:"true"`

	// The identifier of the cluster on which logging is to be started.
	//
	// Example: examplecluster
	ClusterIdentifier *string `type:"string" required:"true"`

	// The prefix applied to the log file names.
	//
	// Constraints:
	//
	//  Cannot exceed 512 characters Cannot contain spaces( ), double quotes ("),
	// single quotes ('), a backslash (\), or control characters. The hexadecimal
	// codes for invalid characters are:  x00 to x20 x22 x27 x5c x7f or larger
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation
func (s EnableLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableLoggingInput) GoString() string {
	return s.String()
}

type EnableSnapshotCopyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the source cluster to copy snapshots from.
	//
	//  Constraints: Must be the valid name of an existing cluster that does not
	// already have cross-region snapshot copy enabled.
	ClusterIdentifier *string `type:"string" required:"true"`

	// The destination region that you want to copy snapshots to.
	//
	//  Constraints: Must be the name of a valid region. For more information,
	// see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region)
	// in the Amazon Web Services General Reference.
	DestinationRegion *string `type:"string" required:"true"`

	// The number of days to retain automated snapshots in the destination region
	// after they are copied from the source region.
	//
	//  Default: 7.
	//
	//  Constraints: Must be at least 1 and no more than 35.
	RetentionPeriod *int64 `type:"integer"`

	// The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted
	// cluster are copied to the destination region.
	SnapshotCopyGrantName *string `type:"string"`
}

// String returns the string representation
func (s EnableSnapshotCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSnapshotCopyInput) GoString() string {
	return s.String()
}

type EnableSnapshotCopyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s EnableSnapshotCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSnapshotCopyOutput) GoString() string {
	return s.String()
}

// Describes a connection endpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The DNS address of the Cluster.
	Address *string `type:"string"`

	// The port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// Describes an event.
type Event struct {
	_ struct{} `type:"structure"`

	// The date and time of the event.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of the event categories.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The identifier of the event.
	EventId *string `type:"string"`

	// The text of this event.
	Message *string `type:"string"`

	// The severity of the event.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// The source type for this event.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// Describes event categories.
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The events in the event category.
	Events []*EventInfoMap `locationNameList:"EventInfoMap" type:"list"`

	// The source type, such as cluster or cluster-snapshot, that the returned categories
	// belong to.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCategoriesMap) GoString() string {
	return s.String()
}

// Describes event information.
type EventInfoMap struct {
	_ struct{} `type:"structure"`

	// The category of an Amazon Redshift event.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The description of an Amazon Redshift event.
	EventDescription *string `type:"string"`

	// The identifier of an Amazon Redshift event.
	EventId *string `type:"string"`

	// The severity of the event.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`
}

// String returns the string representation
func (s EventInfoMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventInfoMap) GoString() string {
	return s.String()
}

// Describes event subscriptions.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Redshift event notification subscription.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the Amazon Redshift event notification
	// subscription.
	CustomerAwsId *string `type:"string"`

	// A Boolean value indicating whether the subscription is enabled. true indicates
	// the subscription is enabled.
	Enabled *bool `type:"boolean"`

	// The list of Amazon Redshift event categories specified in the event notification
	// subscription.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategoriesList []*string `locationNameList:"EventCategory" type:"list"`

	// The event severity specified in the Amazon Redshift event notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event
	// notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of the sources that publish events to the Amazon Redshift event notification
	// subscription.
	SourceIdsList []*string `locationNameList:"SourceId" type:"list"`

	// The source type of the events returned the Amazon Redshift event notification,
	// such as cluster, or cluster-snapshot.
	SourceType *string `type:"string"`

	// The status of the Amazon Redshift event notification subscription.
	//
	// Constraints:
	//
	//  Can be one of the following: active | no-permission | topic-not-exist The
	// status "no-permission" indicates that Amazon Redshift no longer has permission
	// to post to the Amazon SNS topic. The status "topic-not-exist" indicates that
	// the topic was deleted after the subscription was created.
	Status *string `type:"string"`

	// The date and time the Amazon Redshift event notification subscription was
	// created.
	SubscriptionCreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The list of tags for the event subscription.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSubscription) GoString() string {
	return s.String()
}

// Returns information about an HSM client certificate. The certificate is stored
// in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift
// cluster to encrypt data files.
type HsmClientCertificate struct {
	_ struct{} `type:"structure"`

	// The identifier of the HSM client certificate.
	HsmClientCertificateIdentifier *string `type:"string"`

	// The public key that the Amazon Redshift cluster will use to connect to the
	// HSM. You must register the public key in the HSM.
	HsmClientCertificatePublicKey *string `type:"string"`

	// The list of tags for the HSM client certificate.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s HsmClientCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HsmClientCertificate) GoString() string {
	return s.String()
}

// Returns information about an HSM configuration, which is an object that describes
// to Amazon Redshift clusters the information they require to connect to an
// HSM where they can store database encryption keys.
type HsmConfiguration struct {
	_ struct{} `type:"structure"`

	// A text description of the HSM configuration.
	Description *string `type:"string"`

	// The name of the Amazon Redshift HSM configuration.
	HsmConfigurationIdentifier *string `type:"string"`

	// The IP address that the Amazon Redshift cluster must use to access the HSM.
	HsmIpAddress *string `type:"string"`

	// The name of the partition in the HSM where the Amazon Redshift clusters will
	// store their database encryption keys.
	HsmPartitionName *string `type:"string"`

	// The list of tags for the HSM configuration.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s HsmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HsmConfiguration) GoString() string {
	return s.String()
}

// Describes the status of changes to HSM settings.
type HsmStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// Reports whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command.
	//
	// Values: active, applying
	Status *string `type:"string"`
}

// String returns the string representation
func (s HsmStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HsmStatus) GoString() string {
	return s.String()
}

// Describes an IP range used in a security group.
type IPRange struct {
	_ struct{} `type:"structure"`

	// The IP range in Classless Inter-Domain Routing (CIDR) notation.
	CIDRIP *string `type:"string"`

	// The status of the IP range, for example, "authorized".
	Status *string `type:"string"`

	// The list of tags for the IP range.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s IPRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPRange) GoString() string {
	return s.String()
}

// Describes the status of logging for a cluster.
type LoggingStatus struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket where the log files are stored.
	BucketName *string `type:"string"`

	// The message indicating that logs failed to be delivered.
	LastFailureMessage *string `type:"string"`

	// The last time when logs failed to be delivered.
	LastFailureTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The last time that logs were delivered.
	LastSuccessfulDeliveryTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// true if logging is on, false if logging is off.
	LoggingEnabled *bool `type:"boolean"`

	// The prefix applied to the log file names.
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation
func (s LoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingStatus) GoString() string {
	return s.String()
}

type ModifyClusterInput struct {
	_ struct{} `type:"structure"`

	// If true, major version upgrades will be applied automatically to the cluster
	// during the maintenance window.
	//
	// Default: false
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automated snapshots are retained. If the value is
	// 0, automated snapshots are disabled. Even if automated snapshots are disabled,
	// you can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	//  If you decrease the automated snapshot retention period from its current
	// value, existing automated snapshots that fall outside of the new retention
	// period will be immediately deleted.
	//
	// Default: Uses existing setting.
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The unique identifier of the cluster to be modified.
	//
	// Example: examplecluster
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the cluster parameter group to apply to this cluster. This change
	// is applied only after the cluster is rebooted. To reboot a cluster use RebootCluster.
	//
	// Default: Uses existing setting.
	//
	// Constraints: The cluster parameter group must be in the same parameter group
	// family that matches the cluster version.
	ClusterParameterGroupName *string `type:"string"`

	// A list of cluster security groups to be authorized on this cluster. This
	// change is asynchronously applied as soon as possible.
	//
	// Security groups currently associated with the cluster, and not in the list
	// of groups to apply, will be revoked from the cluster.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters or hyphens First character must
	// be a letter Cannot end with a hyphen or contain two consecutive hyphens
	ClusterSecurityGroups []*string `locationNameList:"ClusterSecurityGroupName" type:"list"`

	// The new cluster type.
	//
	//  When you submit your cluster resize request, your existing cluster goes
	// into a read-only mode. After Amazon Redshift provisions a new cluster based
	// on your resize requirements, there will be outage for a period while the
	// old cluster is deleted and your connection is switched to the new cluster.
	// You can use DescribeResize to track the progress of the resize request.
	//
	// Valid Values:  multi-node | single-node
	ClusterType *string `type:"string"`

	// The new version number of the Amazon Redshift engine to upgrade to.
	//
	//  For major version upgrades, if a non-default cluster parameter group is
	// currently in use, a new cluster parameter group in the cluster parameter
	// group family for the new version must be specified. The new cluster parameter
	// group can be the default for that cluster parameter group family. For more
	// information about parameters and parameter groups, go to Amazon Redshift
	// Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// Example: 1.0
	ClusterVersion *string `type:"string"`

	// The Elastic IP (EIP) address for the cluster.
	//
	// Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
	// through an Internet gateway. For more information about provisioning clusters
	// in EC2-VPC, go to Supported Platforms to Launch Your Cluster (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms)
	// in the Amazon Redshift Cluster Management Guide.
	ElasticIp *string `type:"string"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// The new password for the cluster master user. This change is asynchronously
	// applied as soon as possible. Between the time of the request and the completion
	// of the request, the MasterUserPassword element exists in the PendingModifiedValues
	// element of the operation response.  Operations never return the password,
	// so this operation provides a way to regain access to the master user account
	// for a cluster if the password is lost.
	//
	// Default: Uses existing setting.
	//
	//  Constraints:
	//
	//  Must be between 8 and 64 characters in length. Must contain at least one
	// uppercase letter. Must contain at least one lowercase letter. Must contain
	// one number. Can be any printable ASCII character (ASCII code 33 to 126) except
	// ' (single quote), " (double quote), \, /, @, or space.
	MasterUserPassword *string `type:"string"`

	// The new identifier for the cluster.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens. Alphabetic
	// characters must be lowercase. First character must be a letter. Cannot end
	// with a hyphen or contain two consecutive hyphens. Must be unique for all
	// clusters within an AWS account.  Example: examplecluster
	NewClusterIdentifier *string `type:"string"`

	// The new node type of the cluster. If you specify a new node type, you must
	// also specify the number of nodes parameter.
	//
	//  When you submit your request to resize a cluster, Amazon Redshift sets
	// access permissions for the cluster to read-only. After Amazon Redshift provisions
	// a new cluster according to your resize requirements, there will be a temporary
	// outage while the old cluster is deleted and your connection is switched to
	// the new cluster. When the new connection is complete, the original access
	// permissions for the cluster are restored. You can use DescribeResize to track
	// the progress of the resize request.
	//
	// Valid Values:  ds1.xlarge | ds1.8xlarge |  ds2.xlarge | ds2.8xlarge | dc1.large
	// | dc1.8xlarge.
	NodeType *string `type:"string"`

	// The new number of nodes of the cluster. If you specify a new number of nodes,
	// you must also specify the node type parameter.
	//
	//  When you submit your request to resize a cluster, Amazon Redshift sets
	// access permissions for the cluster to read-only. After Amazon Redshift provisions
	// a new cluster according to your resize requirements, there will be a temporary
	// outage while the old cluster is deleted and your connection is switched to
	// the new cluster. When the new connection is complete, the original access
	// permissions for the cluster are restored. You can use DescribeResize to track
	// the progress of the resize request.
	//
	// Valid Values: Integer greater than 0.
	NumberOfNodes *int64 `type:"integer"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// if necessary. If system maintenance is necessary during the window, it may
	// result in an outage.
	//
	//  This maintenance window change is made immediately. If the new maintenance
	// window indicates the current time, there must be at least 120 minutes between
	// the current time and end of the window in order to ensure that pending changes
	// are applied.
	//
	// Default: Uses existing setting.
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi, for example wed:07:30-wed:08:00.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network. Only clusters
	// in VPCs can be set to be publicly available.
	PubliclyAccessible *bool `type:"boolean"`

	// A list of virtual private cloud (VPC) security groups to be associated with
	// the cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterInput) GoString() string {
	return s.String()
}

type ModifyClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterOutput) GoString() string {
	return s.String()
}

type ModifyClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to be modified.
	ParameterGroupName *string `type:"string" required:"true"`

	// An array of parameters to be modified. A maximum of 20 parameters can be
	// modified in a single request.
	//
	//  For each parameter to be modified, you must supply at least the parameter
	// name and parameter value; other name-value pairs of the parameter are optional.
	//
	//  For the workload management (WLM) configuration, you must supply all the
	// name-value pairs in the wlm_json_configuration parameter.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterParameterGroupInput) GoString() string {
	return s.String()
}

type ModifyClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the subnet group to be modified.
	ClusterSubnetGroupName *string `type:"string" required:"true"`

	// A text description of the subnet group to be modified.
	Description *string `type:"string"`

	// An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
	// single request.
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSubnetGroupInput) GoString() string {
	return s.String()
}

type ModifyClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a subnet group.
	ClusterSubnetGroup *ClusterSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSubnetGroupOutput) GoString() string {
	return s.String()
}

type ModifyEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating if the subscription is enabled. true indicates
	// the subscription is enabled
	Enabled *bool `type:"boolean"`

	// Specifies the Amazon Redshift event categories to be published by the event
	// notification subscription.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Specifies the Amazon Redshift event severity to be published by the event
	// notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the SNS topic to be used by the event notification
	// subscription.
	SnsTopicArn *string `type:"string"`

	// A list of one or more identifiers of Amazon Redshift source objects. All
	// of the objects must be of the same type as was specified in the source type
	// parameter. The event subscription will return only events generated by the
	// specified objects. If not specified, then events are returned for all objects
	// within the source type specified.
	//
	// Example: my-cluster-1, my-cluster-2
	//
	// Example: my-snapshot-20131010
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a cluster, you would set this
	// parameter to cluster. If this value is not specified, events are returned
	// for all Amazon Redshift objects in your AWS account. You must specify a source
	// type in order to specify source IDs.
	//
	// Valid values: cluster, cluster-parameter-group, cluster-security-group,
	// and cluster-snapshot.
	SourceType *string `type:"string"`

	// The name of the modified Amazon Redshift event notification subscription.
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionInput) GoString() string {
	return s.String()
}

type ModifyEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Describes event subscriptions.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s ModifyEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionOutput) GoString() string {
	return s.String()
}

type ModifySnapshotCopyRetentionPeriodInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster for which you want to change the retention
	// period for automated snapshots that are copied to a destination region.
	//
	//  Constraints: Must be the valid name of an existing cluster that has cross-region
	// snapshot copy enabled.
	ClusterIdentifier *string `type:"string" required:"true"`

	// The number of days to retain automated snapshots in the destination region
	// after they are copied from the source region.
	//
	//  If you decrease the retention period for automated snapshots that are copied
	// to a destination region, Amazon Redshift will delete any existing automated
	// snapshots that were copied to the destination region and that fall outside
	// of the new retention period.
	//
	//  Constraints: Must be at least 1 and no more than 35.
	RetentionPeriod *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ModifySnapshotCopyRetentionPeriodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotCopyRetentionPeriodInput) GoString() string {
	return s.String()
}

type ModifySnapshotCopyRetentionPeriodOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifySnapshotCopyRetentionPeriodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotCopyRetentionPeriodOutput) GoString() string {
	return s.String()
}

// Describes an orderable cluster option.
type OrderableClusterOption struct {
	_ struct{} `type:"structure"`

	// A list of availability zones for the orderable cluster.
	AvailabilityZones []*AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The cluster type, for example multi-node.
	ClusterType *string `type:"string"`

	// The version of the orderable cluster.
	ClusterVersion *string `type:"string"`

	// The node type for the orderable cluster.
	NodeType *string `type:"string"`
}

// String returns the string representation
func (s OrderableClusterOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableClusterOption) GoString() string {
	return s.String()
}

// Describes a parameter in a cluster parameter group.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Specifies how to apply the WLM configuration parameter. Some properties can
	// be applied dynamically, while other properties require that any associated
	// clusters be rebooted for the configuration changes to be applied. For more
	// information about parameters and parameter groups, go to Amazon Redshift
	// Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ApplyType *string `type:"string" enum:"ParameterApplyType"`

	// The data type of the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// If true, the parameter can be modified. Some parameters have security or
	// operational implications that prevent them from being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`

	// The source of the parameter value, such as "engine-default" or "user".
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// Describes cluster attributes that are in a pending state. A change to one
// or more the attributes was requested and is in progress or will be applied.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The pending or in-progress change of the automated snapshot retention period.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The pending or in-progress change of the new identifier for the cluster.
	ClusterIdentifier *string `type:"string"`

	// The pending or in-progress change of the cluster type.
	ClusterType *string `type:"string"`

	// The pending or in-progress change of the service version.
	ClusterVersion *string `type:"string"`

	// The pending or in-progress change of the master user password for the cluster.
	MasterUserPassword *string `type:"string"`

	// The pending or in-progress change of the cluster's node type.
	NodeType *string `type:"string"`

	// The pending or in-progress change of the number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// The pending or in-progress change of the ability to connect to the cluster
	// from the public network.
	PubliclyAccessible *bool `type:"boolean"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedValues) GoString() string {
	return s.String()
}

type PurchaseReservedNodeOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of reserved nodes that you want to purchase.
	//
	// Default: 1
	NodeCount *int64 `type:"integer"`

	// The unique identifier of the reserved node offering you want to purchase.
	ReservedNodeOfferingId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PurchaseReservedNodeOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedNodeOfferingInput) GoString() string {
	return s.String()
}

type PurchaseReservedNodeOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Describes a reserved node. You can call the DescribeReservedNodeOfferings
	// API to obtain the available reserved node offerings.
	ReservedNode *ReservedNode `type:"structure"`
}

// String returns the string representation
func (s PurchaseReservedNodeOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedNodeOfferingOutput) GoString() string {
	return s.String()
}

type RebootClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier.
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootClusterInput) GoString() string {
	return s.String()
}

type RebootClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RebootClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootClusterOutput) GoString() string {
	return s.String()
}

// Describes a recurring charge.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The amount charged per the period of time specified by the recurring charge
	// frequency.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency at which the recurring charge amount is applied.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

// Describes a reserved node. You can call the DescribeReservedNodeOfferings
// API to obtain the available reserved node offerings.
type ReservedNode struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved cluster.
	CurrencyCode *string `type:"string"`

	// The duration of the node reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed cost Amazon Redshift charges you for this reserved node.
	FixedPrice *float64 `type:"double"`

	// The number of reserved compute nodes.
	NodeCount *int64 `type:"integer"`

	// The node type of the reserved node.
	NodeType *string `type:"string"`

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string `type:"string"`

	// The recurring charges for the reserved node.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The unique identifier for the reservation.
	ReservedNodeId *string `type:"string"`

	// The identifier for the reserved node offering.
	ReservedNodeOfferingId *string `type:"string"`

	// The time the reservation started. You purchase a reserved node offering for
	// a duration. This is the start time of that duration.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the reserved compute node.
	//
	// Possible Values:
	//
	//  pending-payment-This reserved node has recently been purchased, and the
	// sale has been approved, but payment has not yet been confirmed. active-This
	// reserved node is owned by the caller and is available for use. payment-failed-Payment
	// failed for the purchase attempt.
	State *string `type:"string"`

	// The hourly rate Amazon Redshift charges you for this reserved node.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedNode) GoString() string {
	return s.String()
}

// Describes a reserved node offering.
type ReservedNodeOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the compute nodes offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the offering will reserve the node.
	Duration *int64 `type:"integer"`

	// The upfront fixed charge you will pay to purchase the specific reserved node
	// offering.
	FixedPrice *float64 `type:"double"`

	// The node type offered by the reserved node offering.
	NodeType *string `type:"string"`

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string `type:"string"`

	// The charge to your account regardless of whether you are creating any clusters
	// using the node offering. Recurring charges are only in effect for heavy-utilization
	// reserved nodes.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The offering identifier.
	ReservedNodeOfferingId *string `type:"string"`

	// The rate you are charged for each hour the cluster that is using the offering
	// is running.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedNodeOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedNodeOffering) GoString() string {
	return s.String()
}

type ResetClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group to be reset.
	ParameterGroupName *string `type:"string" required:"true"`

	// An array of names of parameters to be reset. If ResetAllParameters option
	// is not used, then at least one parameter name must be supplied.
	//
	// Constraints: A maximum of 20 parameters can be reset in a single request.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// If true, all parameters in the specified parameter group will be reset to
	// their default values.
	//
	// Default: true
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetClusterParameterGroupInput) GoString() string {
	return s.String()
}

type RestoreFromClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `type:"string"`

	// If true, major version upgrades can be applied during the maintenance window
	// to the Amazon Redshift engine that is running on the cluster.
	//
	// Default: true
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automated snapshots are retained. If the value is
	// 0, automated snapshots are disabled. Even if automated snapshots are disabled,
	// you can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	//  Default: The value selected for the cluster from which the snapshot was
	// taken.
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The Amazon EC2 Availability Zone in which to restore the cluster.
	//
	// Default: A random, system-chosen Availability Zone.
	//
	// Example: us-east-1a
	AvailabilityZone *string `type:"string"`

	// The identifier of the cluster that will be created from restoring the snapshot.
	//
	//  Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens. Alphabetic
	// characters must be lowercase. First character must be a letter. Cannot end
	// with a hyphen or contain two consecutive hyphens. Must be unique for all
	// clusters within an AWS account.
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the parameter group to be associated with this cluster.
	//
	// Default: The default Amazon Redshift cluster parameter group. For information
	// about the default parameter group, go to Working with Amazon Redshift Parameter
	// Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html).
	//
	//  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters or hyphens. First character must
	// be a letter. Cannot end with a hyphen or contain two consecutive hyphens.
	ClusterParameterGroupName *string `type:"string"`

	// A list of security groups to be associated with this cluster.
	//
	//  Default: The default cluster security group for Amazon Redshift.
	//
	// Cluster security groups only apply to clusters outside of VPCs.
	ClusterSecurityGroups []*string `locationNameList:"ClusterSecurityGroupName" type:"list"`

	// The name of the subnet group where you want to cluster restored.
	//
	//  A snapshot of cluster in VPC can be restored only in VPC. Therefore, you
	// must provide subnet group name where you want the cluster restored.
	ClusterSubnetGroupName *string `type:"string"`

	// The elastic IP (EIP) address for the cluster.
	ElasticIp *string `type:"string"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that you
	// want to use to encrypt data in the cluster that you restore from a shared
	// snapshot.
	KmsKeyId *string `type:"string"`

	// The node type that the restored cluster will be provisioned with.
	//
	//  Default: The node type of the cluster from which the snapshot was taken.
	// You can modify this if you are using any DS node type. In that case, you
	// can choose to restore into another DS node type of the same size. For example,
	// you can restore ds1.8xlarge into ds2.8xlarge, or ds2.xlarge into ds1.xlarge.
	// If you have a DC instance type, you must restore into that same instance
	// type and size. In other words, you can only restore a dc1.large instance
	// type into another dc1.large instance type. For more information about node
	// types, see  About Clusters and Nodes (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes)
	// in the Amazon Redshift Cluster Management Guide
	NodeType *string `type:"string"`

	// The AWS customer account used to create or copy the snapshot. Required if
	// you are restoring a snapshot you do not own, optional if you own the snapshot.
	OwnerAccount *string `type:"string"`

	// The port number on which the cluster accepts connections.
	//
	// Default: The same port as the original cluster.
	//
	// Constraints: Must be between 1115 and 65535.
	Port *int64 `type:"integer"`

	// The weekly time range (in UTC) during which automated cluster maintenance
	// can occur.
	//
	//  Format: ddd:hh24:mi-ddd:hh24:mi
	//
	//  Default: The value selected for the cluster from which the snapshot was
	// taken. For more information about the time blocks for each region, see Maintenance
	// Windows (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows)
	// in Amazon Redshift Cluster Management Guide.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// The name of the cluster the source snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The name of the snapshot from which to create the new cluster. This parameter
	// isn't case sensitive.
	//
	// Example: my-snapshot-id
	SnapshotIdentifier *string `type:"string" required:"true"`

	// A list of Virtual Private Cloud (VPC) security groups to be associated with
	// the cluster.
	//
	//  Default: The default VPC security group is associated with the cluster.
	//
	//  VPC security groups only apply to clusters in VPCs.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreFromClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromClusterSnapshotInput) GoString() string {
	return s.String()
}

type RestoreFromClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RestoreFromClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromClusterSnapshotOutput) GoString() string {
	return s.String()
}

// Describes the status of a cluster restore action. Returns null if the cluster
// was not created by restoring a snapshot.
type RestoreStatus struct {
	_ struct{} `type:"structure"`

	// The number of megabytes per second being transferred from the backup storage.
	// Returns the average rate for a completed backup.
	CurrentRestoreRateInMegaBytesPerSecond *float64 `type:"double"`

	// The amount of time an in-progress restore has been running, or the amount
	// of time it took a completed restore to finish.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimate of the time remaining before the restore will complete. Returns
	// 0 for a completed restore.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The number of megabytes that have been transferred from snapshot storage.
	ProgressInMegaBytes *int64 `type:"long"`

	// The size of the set of snapshot data used to restore the cluster.
	SnapshotSizeInMegaBytes *int64 `type:"long"`

	// The status of the restore action. Returns starting, restoring, completed,
	// or failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s RestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreStatus) GoString() string {
	return s.String()
}

type RestoreTableFromClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift cluster to restore the table to.
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the table to create as a result of the current request.
	NewTableName *string `type:"string" required:"true"`

	// The identifier of the snapshot to restore the table from. This snapshot must
	// have been created from the Amazon Redshift cluster specified by the ClusterIdentifier
	// parameter.
	SnapshotIdentifier *string `type:"string" required:"true"`

	// The name of the source database that contains the table to restore from.
	SourceDatabaseName *string `type:"string" required:"true"`

	// The name of the source schema that contains the table to restore from.
	SourceSchemaName *string `type:"string"`

	// The name of the source table to restore from.
	SourceTableName *string `type:"string" required:"true"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `type:"string"`
}

// String returns the string representation
func (s RestoreTableFromClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableFromClusterSnapshotInput) GoString() string {
	return s.String()
}

type RestoreTableFromClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes the status of a RestoreTableFromClusterSnapshot operation.
	TableRestoreStatus *TableRestoreStatus `type:"structure"`
}

// String returns the string representation
func (s RestoreTableFromClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableFromClusterSnapshotOutput) GoString() string {
	return s.String()
}

type RevokeClusterSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range for which to revoke access. This range must be a valid Classless
	// Inter-Domain Routing (CIDR) block of IP addresses. If CIDRIP is specified,
	// EC2SecurityGroupName and EC2SecurityGroupOwnerId cannot be provided.
	CIDRIP *string `type:"string"`

	// The name of the security Group from which to revoke the ingress rule.
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// The name of the EC2 Security Group whose access is to be revoked. If EC2SecurityGroupName
	// is specified, EC2SecurityGroupOwnerId must also be provided and CIDRIP cannot
	// be provided.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account number of the owner of the security group specified in the
	// EC2SecurityGroupName parameter. The AWS access key ID is not an acceptable
	// value. If EC2SecurityGroupOwnerId is specified, EC2SecurityGroupName must
	// also be provided. and CIDRIP cannot be provided.
	//
	// Example: 111122223333
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s RevokeClusterSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeClusterSecurityGroupIngressInput) GoString() string {
	return s.String()
}

type RevokeClusterSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s RevokeClusterSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeClusterSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

type RevokeSnapshotAccessInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS customer account that can no longer restore the
	// specified snapshot.
	AccountWithRestoreAccess *string `type:"string" required:"true"`

	// The identifier of the cluster the snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The identifier of the snapshot that the account can no longer access.
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeSnapshotAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSnapshotAccessInput) GoString() string {
	return s.String()
}

type RevokeSnapshotAccessOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s RevokeSnapshotAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSnapshotAccessOutput) GoString() string {
	return s.String()
}

type RotateEncryptionKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster that you want to rotate the encryption
	// keys for.
	//
	//  Constraints: Must be the name of valid cluster that has encryption enabled.
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RotateEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateEncryptionKeyInput) GoString() string {
	return s.String()
}

type RotateEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RotateEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateEncryptionKeyOutput) GoString() string {
	return s.String()
}

// Describes a snapshot.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// A list of the AWS customer accounts authorized to restore the snapshot. Returns
	// null if no accounts are authorized. Visible only to the snapshot owner.
	AccountsWithRestoreAccess []*AccountWithRestoreAccess `locationNameList:"AccountWithRestoreAccess" type:"list"`

	// The size of the incremental backup.
	ActualIncrementalBackupSizeInMegaBytes *float64 `type:"double"`

	// The Availability Zone in which the cluster was created.
	AvailabilityZone *string `type:"string"`

	// The number of megabytes that have been transferred to the snapshot backup.
	BackupProgressInMegaBytes *float64 `type:"double"`

	// The time (UTC) when the cluster was originally created.
	ClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the cluster for which the snapshot was taken.
	ClusterIdentifier *string `type:"string"`

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string `type:"string"`

	// The number of megabytes per second being transferred to the snapshot backup.
	// Returns 0 for a completed backup.
	CurrentBackupRateInMegaBytesPerSecond *float64 `type:"double"`

	// The name of the database that was created when the cluster was created.
	DBName *string `type:"string"`

	// The amount of time an in-progress snapshot backup has been running, or the
	// amount of time it took a completed backup to finish.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// If true, the data in the snapshot is encrypted at rest.
	Encrypted *bool `type:"boolean"`

	// A boolean that indicates whether the snapshot data is encrypted using the
	// HSM keys of the source cluster. true indicates that the data is encrypted
	// using HSM keys.
	EncryptedWithHSM *bool `type:"boolean"`

	// The estimate of the time remaining before the snapshot backup will complete.
	// Returns 0 for a completed backup.
	EstimatedSecondsToCompletion *int64 `type:"long"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that was
	// used to encrypt data in the cluster from which the snapshot was taken.
	KmsKeyId *string `type:"string"`

	// The master user name for the cluster.
	MasterUsername *string `type:"string"`

	// The node type of the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// For manual snapshots, the AWS customer account used to create or copy the
	// snapshot. For automatic snapshots, the owner of the cluster. The owner can
	// perform all snapshot actions, such as sharing a manual snapshot.
	OwnerAccount *string `type:"string"`

	// The port that the cluster is listening on.
	Port *int64 `type:"integer"`

	// The list of node types that this cluster snapshot is able to restore into.
	RestorableNodeTypes []*string `locationNameList:"NodeType" type:"list"`

	// The time (UTC) when Amazon Redshift began the snapshot. A snapshot contains
	// a copy of the cluster data as of this exact time.
	SnapshotCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The snapshot identifier that is provided in the request.
	SnapshotIdentifier *string `type:"string"`

	// The snapshot type. Snapshots created using CreateClusterSnapshot and CopyClusterSnapshot
	// will be of type "manual".
	SnapshotType *string `type:"string"`

	// The source region from which the snapshot was copied.
	SourceRegion *string `type:"string"`

	// The snapshot status. The value of the status depends on the API operation
	// used.  CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
	//  DescribeClusterSnapshots returns status as "creating", "available", "final
	// snapshot", or "failed". DeleteClusterSnapshot returns status as "deleted".
	Status *string `type:"string"`

	// The list of tags for the cluster snapshot.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The size of the complete set of backup data that would be used to restore
	// the cluster.
	TotalBackupSizeInMegaBytes *float64 `type:"double"`

	// The VPC identifier of the cluster if the snapshot is from a cluster in a
	// VPC. Otherwise, this field is not in the output.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Snapshot) GoString() string {
	return s.String()
}

// The snapshot copy grant that grants Amazon Redshift permission to encrypt
// copied snapshots with the specified customer master key (CMK) from AWS KMS
// in the destination region.
//
//  For more information about managing snapshot copy grants, go to Amazon
// Redshift Database Encryption (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
type SnapshotCopyGrant struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the customer master key (CMK) in AWS KMS to which
	// Amazon Redshift is granted permission.
	KmsKeyId *string `type:"string"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s SnapshotCopyGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotCopyGrant) GoString() string {
	return s.String()
}

// Describes a subnet.
type Subnet struct {
	_ struct{} `type:"structure"`

	// Describes an availability zone.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// The status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// Describes the status of a RestoreTableFromClusterSnapshot operation.
type TableRestoreStatus struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift cluster that the table is being restored
	// to.
	ClusterIdentifier *string `type:"string"`

	// A description of the status of the table restore request. Status values include
	// SUCCEEDED, FAILED, CANCELLED, PENDING, IN_PROGRESS.
	Message *string `type:"string"`

	// The name of the table to create as a result of the table restore request.
	NewTableName *string `type:"string"`

	// The amount of data restored to the new table so far, in megabytes (MB).
	ProgressInMegaBytes *int64 `type:"long"`

	// The time that the table restore request was made, in Universal Coordinated
	// Time (UTC).
	RequestTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the snapshot that the table is being restored from.
	SnapshotIdentifier *string `type:"string"`

	// The name of the source database that contains the table being restored.
	SourceDatabaseName *string `type:"string"`

	// The name of the source schema that contains the table being restored.
	SourceSchemaName *string `type:"string"`

	// The name of the source table being restored.
	SourceTableName *string `type:"string"`

	// A value that describes the current state of the table restore request.
	//
	// Valid Values: SUCCEEDED, FAILED, CANCELLED, PENDING, IN_PROGRESS
	Status *string `type:"string" enum:"TableRestoreStatusType"`

	// The unique identifier for the table restore request.
	TableRestoreRequestId *string `type:"string"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `type:"string"`

	// The total amount of data to restore to the new table, in megabytes (MB).
	TotalDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s TableRestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableRestoreStatus) GoString() string {
	return s.String()
}

// A tag consisting of a name/value pair for a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key, or name, for the resource tag.
	Key *string `type:"string"`

	// The value for the resource tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// A tag and its associated resource.
type TaggedResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) with which the tag is associated. For example,
	// arn:aws:redshift:us-east-1:123456789:cluster:t1.
	ResourceName *string `type:"string"`

	// The type of resource with which the tag is associated. Valid resource types
	// are:  Cluster CIDR/IP EC2 security group Snapshot Cluster security group
	// Subnet group HSM connection HSM certificate Parameter group
	//
	//  For more information about Amazon Redshift resource types and constructing
	// ARNs, go to Constructing an Amazon Redshift Amazon Resource Name (ARN) (http://docs.aws.amazon.com/redshift/latest/mgmt/constructing-redshift-arn.html)
	// in the Amazon Redshift Cluster Management Guide.
	ResourceType *string `type:"string"`

	// The tag for the resource.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s TaggedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaggedResource) GoString() string {
	return s.String()
}

// Describes the members of a VPC security group.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The identifier of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

const (
	// @enum ParameterApplyType
	ParameterApplyTypeStatic = "static"
	// @enum ParameterApplyType
	ParameterApplyTypeDynamic = "dynamic"
)

const (
	// @enum SourceType
	SourceTypeCluster = "cluster"
	// @enum SourceType
	SourceTypeClusterParameterGroup = "cluster-parameter-group"
	// @enum SourceType
	SourceTypeClusterSecurityGroup = "cluster-security-group"
	// @enum SourceType
	SourceTypeClusterSnapshot = "cluster-snapshot"
)

const (
	// @enum TableRestoreStatusType
	TableRestoreStatusTypePending = "PENDING"
	// @enum TableRestoreStatusType
	TableRestoreStatusTypeInProgress = "IN_PROGRESS"
	// @enum TableRestoreStatusType
	TableRestoreStatusTypeSucceeded = "SUCCEEDED"
	// @enum TableRestoreStatusType
	TableRestoreStatusTypeFailed = "FAILED"
	// @enum TableRestoreStatusType
	TableRestoreStatusTypeCanceled = "CANCELED"
)
