// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/ad_group.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad group.
type AdGroup struct {
	// Immutable. The resource name of the ad group.
	// Ad group resource names have the form:
	//
	// `customers/{customer_id}/adGroups/{ad_group_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the ad group.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the ad group.
	//
	// This field is required and should not be empty when creating new ad
	// groups.
	//
	// It must contain fewer than 255 UTF-8 full-width characters.
	//
	// It must not contain any null (code point 0x0), NL line feed
	// (code point 0xA) or carriage return (code point 0xD) characters.
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The status of the ad group.
	Status enums.AdGroupStatusEnum_AdGroupStatus `protobuf:"varint,5,opt,name=status,proto3,enum=google.ads.googleads.v2.enums.AdGroupStatusEnum_AdGroupStatus" json:"status,omitempty"`
	// Immutable. The type of the ad group.
	Type enums.AdGroupTypeEnum_AdGroupType `protobuf:"varint,12,opt,name=type,proto3,enum=google.ads.googleads.v2.enums.AdGroupTypeEnum_AdGroupType" json:"type,omitempty"`
	// The ad rotation mode of the ad group.
	AdRotationMode enums.AdGroupAdRotationModeEnum_AdGroupAdRotationMode `protobuf:"varint,22,opt,name=ad_rotation_mode,json=adRotationMode,proto3,enum=google.ads.googleads.v2.enums.AdGroupAdRotationModeEnum_AdGroupAdRotationMode" json:"ad_rotation_mode,omitempty"`
	// Output only. For draft or experiment ad groups, this field is the resource name of the
	// base ad group from which this ad group was created. If a draft or
	// experiment ad group does not have a base ad group, then this field is null.
	//
	// For base ad groups, this field equals the ad group resource name.
	//
	// This field is read-only.
	BaseAdGroup *wrappers.StringValue `protobuf:"bytes,18,opt,name=base_ad_group,json=baseAdGroup,proto3" json:"base_ad_group,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,6,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// Immutable. The campaign to which the ad group belongs.
	Campaign *wrappers.StringValue `protobuf:"bytes,10,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// The maximum CPC (cost-per-click) bid.
	CpcBidMicros *wrappers.Int64Value `protobuf:"bytes,14,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// The maximum CPM (cost-per-thousand viewable impressions) bid.
	CpmBidMicros *wrappers.Int64Value `protobuf:"bytes,15,opt,name=cpm_bid_micros,json=cpmBidMicros,proto3" json:"cpm_bid_micros,omitempty"`
	// The target CPA (cost-per-acquisition).
	TargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,27,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// Output only. The CPV (cost-per-view) bid.
	CpvBidMicros *wrappers.Int64Value `protobuf:"bytes,17,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// Average amount in micros that the advertiser is willing to pay for every
	// thousand times the ad is shown.
	TargetCpmMicros *wrappers.Int64Value `protobuf:"bytes,26,opt,name=target_cpm_micros,json=targetCpmMicros,proto3" json:"target_cpm_micros,omitempty"`
	// The target ROAS (return-on-ad-spend) override. If the ad group's campaign
	// bidding strategy is a standard Target ROAS strategy, then this field
	// overrides the target ROAS specified in the campaign's bidding strategy.
	// Otherwise, this value is ignored.
	TargetRoas *wrappers.DoubleValue `protobuf:"bytes,30,opt,name=target_roas,json=targetRoas,proto3" json:"target_roas,omitempty"`
	// The percent cpc bid amount, expressed as a fraction of the advertised price
	// for some good or service. The valid range for the fraction is [0,1) and the
	// value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,20,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3" json:"percent_cpc_bid_micros,omitempty"`
	// Settings for the Display Campaign Optimizer, initially termed "Explorer".
	ExplorerAutoOptimizerSetting *common.ExplorerAutoOptimizerSetting `protobuf:"bytes,21,opt,name=explorer_auto_optimizer_setting,json=explorerAutoOptimizerSetting,proto3" json:"explorer_auto_optimizer_setting,omitempty"`
	// Allows advertisers to specify a targeting dimension on which to place
	// absolute bids. This is only applicable for campaigns that target only the
	// display network and not search.
	DisplayCustomBidDimension enums.TargetingDimensionEnum_TargetingDimension `protobuf:"varint,23,opt,name=display_custom_bid_dimension,json=displayCustomBidDimension,proto3,enum=google.ads.googleads.v2.enums.TargetingDimensionEnum_TargetingDimension" json:"display_custom_bid_dimension,omitempty"`
	// URL template for appending params to Final URL.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,24,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// Setting for targeting related features.
	TargetingSetting *common.TargetingSetting `protobuf:"bytes,25,opt,name=targeting_setting,json=targetingSetting,proto3" json:"targeting_setting,omitempty"`
	// Output only. The effective target CPA (cost-per-acquisition).
	// This field is read-only.
	EffectiveTargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,28,opt,name=effective_target_cpa_micros,json=effectiveTargetCpaMicros,proto3" json:"effective_target_cpa_micros,omitempty"`
	// Output only. Source of the effective target CPA.
	// This field is read-only.
	EffectiveTargetCpaSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,29,opt,name=effective_target_cpa_source,json=effectiveTargetCpaSource,proto3,enum=google.ads.googleads.v2.enums.BiddingSourceEnum_BiddingSource" json:"effective_target_cpa_source,omitempty"`
	// Output only. The effective target ROAS (return-on-ad-spend).
	// This field is read-only.
	EffectiveTargetRoas *wrappers.DoubleValue `protobuf:"bytes,31,opt,name=effective_target_roas,json=effectiveTargetRoas,proto3" json:"effective_target_roas,omitempty"`
	// Output only. Source of the effective target ROAS.
	// This field is read-only.
	EffectiveTargetRoasSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,32,opt,name=effective_target_roas_source,json=effectiveTargetRoasSource,proto3,enum=google.ads.googleads.v2.enums.BiddingSourceEnum_BiddingSource" json:"effective_target_roas_source,omitempty"`
	// Output only. The resource names of labels attached to this ad group.
	Labels               []*wrappers.StringValue `protobuf:"bytes,33,rep,name=labels,proto3" json:"labels,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *AdGroup) Reset()         { *m = AdGroup{} }
func (m *AdGroup) String() string { return proto.CompactTextString(m) }
func (*AdGroup) ProtoMessage()    {}
func (*AdGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_a1544ca6322174f1, []int{0}
}

func (m *AdGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroup.Unmarshal(m, b)
}
func (m *AdGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroup.Marshal(b, m, deterministic)
}
func (m *AdGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroup.Merge(m, src)
}
func (m *AdGroup) XXX_Size() int {
	return xxx_messageInfo_AdGroup.Size(m)
}
func (m *AdGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroup.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroup proto.InternalMessageInfo

func (m *AdGroup) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroup) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *AdGroup) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *AdGroup) GetStatus() enums.AdGroupStatusEnum_AdGroupStatus {
	if m != nil {
		return m.Status
	}
	return enums.AdGroupStatusEnum_UNSPECIFIED
}

func (m *AdGroup) GetType() enums.AdGroupTypeEnum_AdGroupType {
	if m != nil {
		return m.Type
	}
	return enums.AdGroupTypeEnum_UNSPECIFIED
}

func (m *AdGroup) GetAdRotationMode() enums.AdGroupAdRotationModeEnum_AdGroupAdRotationMode {
	if m != nil {
		return m.AdRotationMode
	}
	return enums.AdGroupAdRotationModeEnum_UNSPECIFIED
}

func (m *AdGroup) GetBaseAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.BaseAdGroup
	}
	return nil
}

func (m *AdGroup) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *AdGroup) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *AdGroup) GetCampaign() *wrappers.StringValue {
	if m != nil {
		return m.Campaign
	}
	return nil
}

func (m *AdGroup) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

func (m *AdGroup) GetCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpmBidMicros
	}
	return nil
}

func (m *AdGroup) GetTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpaMicros
	}
	return nil
}

func (m *AdGroup) GetCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpvBidMicros
	}
	return nil
}

func (m *AdGroup) GetTargetCpmMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpmMicros
	}
	return nil
}

func (m *AdGroup) GetTargetRoas() *wrappers.DoubleValue {
	if m != nil {
		return m.TargetRoas
	}
	return nil
}

func (m *AdGroup) GetPercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.PercentCpcBidMicros
	}
	return nil
}

func (m *AdGroup) GetExplorerAutoOptimizerSetting() *common.ExplorerAutoOptimizerSetting {
	if m != nil {
		return m.ExplorerAutoOptimizerSetting
	}
	return nil
}

func (m *AdGroup) GetDisplayCustomBidDimension() enums.TargetingDimensionEnum_TargetingDimension {
	if m != nil {
		return m.DisplayCustomBidDimension
	}
	return enums.TargetingDimensionEnum_UNSPECIFIED
}

func (m *AdGroup) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *AdGroup) GetTargetingSetting() *common.TargetingSetting {
	if m != nil {
		return m.TargetingSetting
	}
	return nil
}

func (m *AdGroup) GetEffectiveTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveTargetCpaMicros
	}
	return nil
}

func (m *AdGroup) GetEffectiveTargetCpaSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveTargetCpaSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroup) GetEffectiveTargetRoas() *wrappers.DoubleValue {
	if m != nil {
		return m.EffectiveTargetRoas
	}
	return nil
}

func (m *AdGroup) GetEffectiveTargetRoasSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveTargetRoasSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroup) GetLabels() []*wrappers.StringValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func init() {
	proto.RegisterType((*AdGroup)(nil), "google.ads.googleads.v2.resources.AdGroup")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/ad_group.proto", fileDescriptor_a1544ca6322174f1)
}

var fileDescriptor_a1544ca6322174f1 = []byte{
	// 1106 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x97, 0xdd, 0x72, 0xdb, 0x44,
	0x14, 0xc7, 0xc7, 0x71, 0x13, 0x60, 0xf3, 0xd1, 0x54, 0x21, 0x45, 0x49, 0x4c, 0xe3, 0x94, 0xc9,
	0x60, 0x2e, 0x90, 0x82, 0x0b, 0x65, 0xc6, 0x50, 0x66, 0xe4, 0xa4, 0x0d, 0x30, 0x4d, 0x9b, 0x91,
	0x93, 0x5c, 0x30, 0x61, 0x34, 0x6b, 0x69, 0x2d, 0x16, 0x24, 0xad, 0x66, 0x77, 0x65, 0x12, 0x3a,
	0xbd, 0x01, 0x6e, 0xb8, 0xe2, 0x1d, 0xb8, 0xe4, 0x51, 0x78, 0x8a, 0x5e, 0xf7, 0x0d, 0xe0, 0x8a,
	0xd1, 0x7e, 0x28, 0xb6, 0x13, 0x5b, 0x62, 0x86, 0xbb, 0xf5, 0xee, 0xf9, 0xff, 0xf6, 0x9c, 0x3d,
	0x7b, 0xf6, 0xc8, 0x60, 0x2f, 0x24, 0x24, 0x8c, 0x90, 0x0d, 0x03, 0x66, 0xcb, 0x61, 0x3e, 0x1a,
	0xb6, 0x6d, 0x8a, 0x18, 0xc9, 0xa8, 0x8f, 0x98, 0x0d, 0x03, 0x2f, 0xa4, 0x24, 0x4b, 0xad, 0x94,
	0x12, 0x4e, 0x8c, 0x1d, 0x69, 0x66, 0xc1, 0x80, 0x59, 0x85, 0xc2, 0x1a, 0xb6, 0xad, 0x42, 0xb1,
	0xf9, 0xc9, 0x34, 0xa8, 0x4f, 0xe2, 0x98, 0x24, 0xb6, 0x9f, 0x31, 0x4e, 0x62, 0x2f, 0x85, 0x14,
	0xc6, 0x88, 0x23, 0x2a, 0xc9, 0x9b, 0x07, 0x25, 0x32, 0x74, 0x91, 0x46, 0x84, 0x22, 0xea, 0xc1,
	0x8c, 0x13, 0x8f, 0xa4, 0x1c, 0xc7, 0xf8, 0x27, 0x44, 0x3d, 0x86, 0x38, 0xc7, 0x49, 0xa8, 0x28,
	0x0f, 0x4b, 0x28, 0x1c, 0xd2, 0x10, 0xe5, 0xf6, 0x13, 0xba, 0x47, 0xd3, 0x74, 0x28, 0xc9, 0xe2,
	0xab, 0x53, 0xf0, 0x60, 0xe0, 0x51, 0xc2, 0x21, 0xc7, 0x24, 0xf1, 0x62, 0x12, 0x20, 0x25, 0x7f,
	0x50, 0x51, 0xce, 0x38, 0xe4, 0x19, 0x53, 0xa2, 0x8f, 0x2a, 0x8a, 0xf8, 0x65, 0xaa, 0xf7, 0x69,
	0xcf, 0x96, 0xf4, 0x71, 0x10, 0x88, 0xd8, 0x44, 0x2a, 0x94, 0xe6, 0xd3, 0xd9, 0x9a, 0xab, 0x13,
	0x09, 0x70, 0x8c, 0x12, 0x86, 0x49, 0xa2, 0x84, 0xdb, 0x5a, 0x98, 0x62, 0x7b, 0x80, 0x51, 0x14,
	0x78, 0x7d, 0xf4, 0x1d, 0x1c, 0x62, 0xa2, 0x53, 0xb6, 0x31, 0x62, 0xa0, 0xf3, 0xaf, 0x96, 0xee,
	0xa9, 0x25, 0xf1, 0xab, 0x9f, 0x0d, 0xec, 0x1f, 0x29, 0x4c, 0x53, 0x44, 0x75, 0xec, 0x8d, 0x11,
	0x29, 0x4c, 0x12, 0x75, 0xa4, 0x6a, 0xf5, 0xfe, 0xef, 0x6b, 0xe0, 0x0d, 0x27, 0x38, 0xcc, 0xa3,
	0x37, 0x8e, 0xc0, 0xb2, 0x66, 0x7b, 0x09, 0x8c, 0x91, 0x59, 0x6b, 0xd6, 0x5a, 0x6f, 0x75, 0x5b,
	0xaf, 0x9c, 0xf9, 0x7f, 0x9c, 0xfb, 0xa0, 0x79, 0x75, 0x0b, 0xd5, 0x28, 0xc5, 0xcc, 0xf2, 0x49,
	0x6c, 0x2b, 0x80, 0xbb, 0xa4, 0xe5, 0xcf, 0x60, 0x8c, 0x8c, 0x3d, 0x30, 0x87, 0x03, 0xb3, 0xde,
	0xac, 0xb5, 0x16, 0xdb, 0x5b, 0x4a, 0x62, 0x69, 0x2f, 0xad, 0xaf, 0x12, 0xfe, 0xf0, 0xe3, 0x33,
	0x18, 0x65, 0xa8, 0x5b, 0x7f, 0xe5, 0xd4, 0xdd, 0x39, 0x1c, 0x18, 0x7b, 0xe0, 0x96, 0xd8, 0xf7,
	0x96, 0xd0, 0x34, 0xae, 0x69, 0x7a, 0x9c, 0xe2, 0x24, 0x14, 0x22, 0x57, 0x58, 0x1a, 0x67, 0x60,
	0x41, 0x26, 0xda, 0x9c, 0x6f, 0xd6, 0x5a, 0x2b, 0xed, 0x2f, 0xac, 0x69, 0x55, 0x23, 0x52, 0x60,
	0x29, 0x4f, 0x7b, 0x42, 0xf3, 0x38, 0xc9, 0xe2, 0xf1, 0x19, 0x57, 0xd1, 0x8c, 0x1e, 0xb8, 0x95,
	0xdf, 0x05, 0x73, 0x49, 0x50, 0x3b, 0xd5, 0xa8, 0x27, 0x97, 0x29, 0x1a, 0x65, 0xe6, 0xbf, 0xf3,
	0xe0, 0xe6, 0x5d, 0x01, 0x33, 0x2e, 0xc0, 0xea, 0xe4, 0xa5, 0x36, 0xef, 0x8a, 0x0d, 0x9e, 0x55,
	0xdb, 0xc0, 0x09, 0x5c, 0x25, 0x3e, 0x22, 0xc1, 0xd8, 0x56, 0xe3, 0x2b, 0xee, 0x0a, 0x1c, 0xfb,
	0x6d, 0x7c, 0x0f, 0x96, 0xfb, 0x90, 0x21, 0x4f, 0x5f, 0x74, 0xd3, 0x28, 0x3f, 0xe1, 0x3c, 0xef,
	0xf5, 0x6a, 0x79, 0x5f, 0xcc, 0xe1, 0xfa, 0x16, 0x1d, 0x83, 0x75, 0x4e, 0xa1, 0xff, 0x43, 0x7e,
	0xcf, 0x33, 0x1a, 0x79, 0x1c, 0xc5, 0x69, 0x04, 0x39, 0x32, 0x97, 0x2b, 0x64, 0x75, 0x4d, 0x4b,
	0x4f, 0x69, 0x74, 0xa2, 0x84, 0x86, 0x0f, 0xd6, 0x73, 0xd0, 0xe4, 0x6b, 0xc6, 0xcc, 0x85, 0x66,
	0xbd, 0xb5, 0xd8, 0xb6, 0xa7, 0x1e, 0x9e, 0x7c, 0x89, 0xac, 0x7d, 0x21, 0x3c, 0xd6, 0x3a, 0x77,
	0x2d, 0xa3, 0xd1, 0xc4, 0x1c, 0x33, 0x7c, 0xf0, 0xa6, 0x0f, 0xe3, 0x14, 0xe2, 0x30, 0x31, 0x41,
	0x85, 0xd3, 0xf9, 0x40, 0x54, 0xc5, 0x7b, 0x60, 0x67, 0xea, 0xe9, 0xec, 0x2b, 0x9c, 0x5b, 0x80,
	0x0d, 0x07, 0xac, 0xf8, 0xa9, 0xef, 0xf5, 0x71, 0xe0, 0xc5, 0xd8, 0xa7, 0x84, 0x99, 0x2b, 0xa5,
	0xe5, 0xe1, 0x2e, 0xf9, 0xa9, 0xdf, 0xc5, 0xc1, 0x91, 0x10, 0x48, 0x44, 0x3c, 0x8a, 0xb8, 0x5d,
	0x09, 0x11, 0x5f, 0x21, 0x0e, 0xc1, 0x1d, 0xf9, 0x14, 0x79, 0x7e, 0x0a, 0x35, 0x65, 0xab, 0x9c,
	0x72, 0x5b, 0xaa, 0xf6, 0x53, 0xa8, 0x40, 0x4f, 0x72, 0x5f, 0x86, 0xa3, 0xbe, 0xdc, 0xa9, 0x58,
	0xed, 0x4b, 0x7e, 0x3a, 0xbc, 0xd9, 0xa1, 0x58, 0xa3, 0x36, 0xff, 0x83, 0x43, 0xb1, 0x02, 0x3d,
	0x02, 0x8b, 0x0a, 0x44, 0x09, 0x64, 0xe6, 0xbd, 0x29, 0x79, 0x3c, 0x20, 0x59, 0x3f, 0x42, 0x92,
	0x01, 0xa4, 0xc0, 0x25, 0x90, 0x19, 0xc7, 0xe0, 0x6e, 0x8a, 0xa8, 0x8f, 0x92, 0xdc, 0x91, 0xb1,
	0x34, 0xbd, 0x5d, 0xee, 0xcc, 0x9a, 0x92, 0xee, 0x8f, 0x66, 0xeb, 0x97, 0x1a, 0xd8, 0x2e, 0x69,
	0xa7, 0xe6, 0xba, 0x60, 0x7f, 0x5e, 0x76, 0x8b, 0x1f, 0x2b, 0x8c, 0x93, 0x71, 0xf2, 0x5c, 0x43,
	0x7a, 0x92, 0xe1, 0x36, 0xd0, 0x8c, 0x55, 0xe3, 0xb7, 0x1a, 0x68, 0x04, 0x98, 0xa5, 0x11, 0xbc,
	0xd4, 0x55, 0x94, 0xc7, 0x56, 0x74, 0x21, 0xf3, 0x1d, 0xf1, 0x0a, 0x7d, 0x59, 0xf2, 0x0a, 0x9d,
	0xe8, 0xfe, 0x75, 0xa0, 0x85, 0xe2, 0x09, 0xba, 0x3e, 0xed, 0x6e, 0xa8, 0xdd, 0x64, 0x95, 0x75,
	0x71, 0x50, 0x2c, 0x19, 0x4f, 0xc0, 0xea, 0x00, 0x27, 0x30, 0x12, 0x6f, 0x03, 0xcb, 0x06, 0x03,
	0x7c, 0x61, 0x9a, 0x15, 0x5e, 0x86, 0x15, 0xa1, 0x3a, 0xa5, 0x51, 0x4f, 0x68, 0x8c, 0x6f, 0xf5,
	0x9d, 0x19, 0xf9, 0xc2, 0x30, 0x37, 0x04, 0x68, 0xaf, 0xec, 0x28, 0x0b, 0x8f, 0xf5, 0xf1, 0xad,
	0xf2, 0x89, 0x19, 0xc3, 0x03, 0x5b, 0x68, 0x30, 0x40, 0x3e, 0xc7, 0x43, 0xe4, 0x5d, 0xaf, 0x96,
	0x46, 0xc5, 0x7b, 0x6e, 0x16, 0x90, 0x93, 0x89, 0xda, 0xf9, 0xb9, 0x36, 0x65, 0x07, 0xd9, 0x41,
	0xcd, 0x77, 0x2b, 0xf5, 0xb3, 0xae, 0xfc, 0x0c, 0xe9, 0x09, 0x8d, 0xc8, 0xc6, 0xd8, 0xcc, 0x54,
	0x27, 0xe4, 0xb2, 0x71, 0x0a, 0xd6, 0xaf, 0xf9, 0x20, 0x2a, 0x67, 0xbb, 0xbc, 0x72, 0x24, 0x7b,
	0x6d, 0x82, 0x2d, 0xea, 0xe8, 0xd7, 0x1a, 0x68, 0xdc, 0xc8, 0xd5, 0xc1, 0x35, 0xff, 0xbf, 0xe0,
	0x36, 0x6e, 0x70, 0x40, 0x45, 0xe7, 0x83, 0x85, 0x08, 0xf6, 0x51, 0xc4, 0xcc, 0x1d, 0xd1, 0x28,
	0x66, 0x3f, 0xe8, 0x1f, 0x8a, 0x76, 0xf7, 0x3e, 0xd8, 0x2d, 0x6b, 0x77, 0x4f, 0x73, 0xa6, 0xab,
	0xd0, 0x9d, 0xe7, 0xaf, 0x9d, 0xa7, 0xe5, 0x2d, 0xd2, 0x68, 0xc9, 0xba, 0x43, 0x94, 0xd9, 0x2f,
	0xf4, 0xf0, 0xa5, 0x0d, 0xe5, 0x2a, 0xb3, 0x5f, 0xe8, 0xce, 0xfc, 0xb2, 0xfb, 0x77, 0x0d, 0xec,
	0xfa, 0x24, 0xb6, 0x4a, 0x3f, 0xff, 0xbb, 0x4b, 0x0a, 0x7e, 0x9c, 0x87, 0x73, 0x5c, 0xfb, 0xe6,
	0x6b, 0x25, 0x09, 0x49, 0x04, 0x93, 0xd0, 0x22, 0x34, 0xb4, 0x43, 0x94, 0x88, 0x60, 0xed, 0x2b,
	0xb7, 0x66, 0xfc, 0x05, 0xf9, 0xac, 0x18, 0xfd, 0x31, 0x57, 0x3f, 0x74, 0x9c, 0x3f, 0xe7, 0x76,
	0x0e, 0x25, 0xd2, 0x09, 0x98, 0x25, 0x87, 0xf9, 0xe8, 0xac, 0x6d, 0xb9, 0xda, 0xf2, 0x2f, 0x6d,
	0x73, 0xee, 0x04, 0xec, 0xbc, 0xb0, 0x39, 0x3f, 0x6b, 0x9f, 0x17, 0x36, 0xaf, 0xe7, 0x76, 0xe5,
	0x42, 0xa7, 0xe3, 0x04, 0xac, 0xd3, 0x29, 0xac, 0x3a, 0x9d, 0xb3, 0x76, 0xa7, 0x53, 0xd8, 0xf5,
	0x17, 0x84, 0xb3, 0x0f, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff, 0xde, 0x17, 0xd9, 0xdc, 0x2e, 0x0d,
	0x00, 0x00,
}
