const PARSED = [
    {
        query: '<P>',
        elems: [],
        foundElems: 0,
        userQuery: "<P>",
        returned: [],
        error: "Found generics without a path",
    },
    {
        query: '-> <P>',
        elems: [],
        foundElems: 0,
        userQuery: "-> <P>",
        returned: [],
        error: "Found generics without a path",
    },
    {
        query: '-> *',
        elems: [],
        foundElems: 0,
        userQuery: "-> *",
        returned: [],
        error: "Unexpected `*` after ` ` (not a valid identifier)",
    },
    {
        query: 'a<"P">',
        elems: [],
        foundElems: 0,
        userQuery: "a<\"P\">",
        returned: [],
        error: "Unexpected `\"` in generics",
    },
    {
        query: '"P" "P"',
        elems: [],
        foundElems: 0,
        userQuery: "\"P\" \"P\"",
        returned: [],
        error: "Cannot have more than one element if you use quotes",
    },
    {
        query: '"P","P"',
        elems: [],
        foundElems: 0,
        userQuery: "\"P\",\"P\"",
        returned: [],
        error: "Cannot have more than one literal search element",
    },
    {
        query: "P,\"P\"",
        elems: [],
        foundElems: 0,
        userQuery: "P,\"P\"",
        returned: [],
        error: "Cannot use literal search when there is more than one element",
    },
    {
        query: '"p" p',
        elems: [],
        foundElems: 0,
        userQuery: "\"p\" p",
        returned: [],
        error: "Cannot have more than one element if you use quotes",
    },
    {
        query: '"p",p',
        elems: [],
        foundElems: 0,
        userQuery: "\"p\",p",
        returned: [],
        error: "Cannot have more than one element if you use quotes",
    },
    {
        query: '"const": p',
        elems: [],
        foundElems: 0,
        userQuery: "\"const\": p",
        returned: [],
        error: "Cannot use quotes on type filter",
    },
    {
        query: "a<:a>",
        elems: [],
        foundElems: 0,
        userQuery: "a<:a>",
        returned: [],
        error: "Expected type filter before `:`",
    },
    {
        query: "a<::a>",
        elems: [],
        foundElems: 0,
        userQuery: "a<::a>",
        returned: [],
        error: "Unexpected `::`: paths cannot start with `::`",
    },
    {
        query: "(p -> p",
        elems: [],
        foundElems: 0,
        userQuery: "(p -> p",
        returned: [],
        error: "Unclosed `(`",
    },
    {
        query: "::a::b",
        elems: [],
        foundElems: 0,
        userQuery: "::a::b",
        returned: [],
        error: "Paths cannot start with `::`",
    },
    {
        query: " ::a::b",
        elems: [],
        foundElems: 0,
        userQuery: "::a::b",
        returned: [],
        error: "Paths cannot start with `::`",
    },
    {
        query: "a::::b",
        elems: [],
        foundElems: 0,
        userQuery: "a::::b",
        returned: [],
        error: "Unexpected `::::`",
    },
    {
        query: "a:: ::b",
        elems: [],
        foundElems: 0,
        userQuery: "a:: ::b",
        returned: [],
        error: "Unexpected `:: ::`",
    },
    {
        query: "a::\t::b",
        elems: [],
        foundElems: 0,
        userQuery: "a:: ::b",
        returned: [],
        error: "Unexpected `:: ::`",
    },
    {
        query: ":a",
        elems: [],
        foundElems: 0,
        userQuery: ":a",
        returned: [],
        error: "Expected type filter before `:`",
    },
    {
        query: "a,b:",
        elems: [],
        foundElems: 0,
        userQuery: "a,b:",
        returned: [],
        error: "Unexpected `:` (expected path after type filter `b:`)",
    },
    {
        query: "a (b:",
        elems: [],
        foundElems: 0,
        userQuery: "a (b:",
        returned: [],
        error: "Unclosed `(`",
    },
    {
        query: "_:",
        elems: [],
        foundElems: 0,
        userQuery: "_:",
        returned: [],
        error: "Unexpected `_` (not a valid identifier)",
    },
    {
        query: "ab:",
        elems: [],
        foundElems: 0,
        userQuery: "ab:",
        returned: [],
        error: "Unexpected `:` (expected path after type filter `ab:`)",
    },
    {
        query: "a:b",
        elems: [],
        foundElems: 0,
        userQuery: "a:b",
        returned: [],
        error: "Unknown type filter `a`",
    },
    {
        query: "a-bb",
        elems: [],
        foundElems: 0,
        userQuery: "a-bb",
        returned: [],
        error: "Unexpected `-` (did you mean `->`?)",
    },
    {
        query: "a>bb",
        elems: [],
        foundElems: 0,
        userQuery: "a>bb",
        returned: [],
        error: "Unexpected `>` (did you mean `->`?)",
    },
    {
        query: "ab'",
        elems: [],
        foundElems: 0,
        userQuery: "ab'",
        returned: [],
        error: "Unexpected `'` after `b` (not a valid identifier)",
    },
    {
        query: '"p" <a>',
        elems: [],
        foundElems: 0,
        userQuery: '"p" <a>',
        returned: [],
        error: "Cannot have more than one element if you use quotes",
    },
    {
        query: '"p",<a>',
        elems: [],
        foundElems: 0,
        userQuery: '"p",<a>',
        returned: [],
        error: "Found generics without a path",
    },
    {
        query: '"p" a<a>',
        elems: [],
        foundElems: 0,
        userQuery: '"p" a<a>',
        returned: [],
        error: "Cannot have more than one element if you use quotes",
    },
    {
        query: '"p",a<a>',
        elems: [],
        foundElems: 0,
        userQuery: '"p",a<a>',
        returned: [],
        error: "Cannot have more than one element if you use quotes",
    },
    {
        query: "a,<",
        elems: [],
        foundElems: 0,
        userQuery: 'a,<',
        returned: [],
        error: 'Found generics without a path',
    },
    {
        query: "aaaaa<>b",
        elems: [],
        foundElems: 0,
        userQuery: 'aaaaa<>b',
        returned: [],
        error: 'Expected `,`, `:` or `->` after `>`, found `b`',
    },
    {
        query: "fn:aaaaa<>b",
        elems: [],
        foundElems: 0,
        userQuery: 'fn:aaaaa<>b',
        returned: [],
        error: 'Expected `,`, `:` or `->` after `>`, found `b`',
    },
    {
        query: "->a<>b",
        elems: [],
        foundElems: 0,
        userQuery: '->a<>b',
        returned: [],
        error: 'Expected `,` or `=` after `>`, found `b`',
    },
    {
        query: "a<->",
        elems: [],
        foundElems: 0,
        userQuery: 'a<->',
        returned: [],
        error: 'Unclosed `<`',
    },
    {
        query: "a<a>:",
        elems: [],
        foundElems: 0,
        userQuery: "a<a>:",
        returned: [],
        error: 'Unexpected `<` in type filter (before `:`)',
    },
    {
        query: "a<>:",
        elems: [],
        foundElems: 0,
        userQuery: "a<>:",
        returned: [],
        error: 'Unexpected `<` in type filter (before `:`)',
    },
    {
        query: "a,:",
        elems: [],
        foundElems: 0,
        userQuery: "a,:",
        returned: [],
        error: 'Expected type filter before `:`',
    },
    {
        query: "a!:",
        elems: [],
        foundElems: 0,
        userQuery: "a!:",
        returned: [],
        error: 'Unexpected `!` in type filter (before `:`)',
    },
    {
        query: "  a<>  :",
        elems: [],
        foundElems: 0,
        userQuery: "a<>  :",
        returned: [],
        error: 'Expected `,`, `:` or `->` after `>`, found `:`',
    },
    {
        query: "mod : :",
        elems: [],
        foundElems: 0,
        userQuery: "mod : :",
        returned: [],
        error: 'Unexpected `:` (expected path after type filter `mod:`)',
    },
    {
        query: "mod: :",
        elems: [],
        foundElems: 0,
        userQuery: "mod: :",
        returned: [],
        error: 'Unexpected `:` (expected path after type filter `mod:`)',
    },
    {
        query: "a!a",
        elems: [],
        foundElems: 0,
        userQuery: "a!a",
        returned: [],
        error: 'Unexpected `!`: it can only be at the end of an ident',
    },
    {
        query: "a!!",
        elems: [],
        foundElems: 0,
        userQuery: "a!!",
        returned: [],
        error: 'Cannot have more than one `!` in an ident',
    },
    {
        query: "mod:a!",
        elems: [],
        foundElems: 0,
        userQuery: "mod:a!",
        returned: [],
        error: 'Invalid search type: macro `!` and `mod` both specified',
    },
    {
        query: "mod:!",
        elems: [],
        foundElems: 0,
        userQuery: "mod:!",
        returned: [],
        error: 'Invalid search type: primitive never type `!` and `mod` both specified',
    },
    {
        query: "a!::a",
        elems: [],
        foundElems: 0,
        userQuery: "a!::a",
        returned: [],
        error: 'Cannot have associated items in macros',
    },
    {
        query: "a<",
        elems: [],
        foundElems: 0,
        userQuery: "a<",
        returned: [],
        error: "Unclosed `<`",
    },
    {
        query: "p<x> , y",
        elems: [
            {
                name: "p",
                fullPath: ["p"],
                pathWithoutLast: [],
                pathLast: "p",
                generics: [
                    {
                        name: "x",
                        fullPath: ["x"],
                        pathWithoutLast: [],
                        pathLast: "x",
                        generics: [],
                        typeFilter: -1,
                    },
                ],
                typeFilter: -1,
            },
            {
                name: "y",
                fullPath: ["y"],
                pathWithoutLast: [],
                pathLast: "y",
                generics: [],
                typeFilter: -1,
            },
        ],
        foundElems: 2,
        userQuery: "p<x> , y",
        returned: [],
        error: null,
    },
    {
        query: "p<x , y>",
        elems: [
            {
                name: "p",
                fullPath: ["p"],
                pathWithoutLast: [],
                pathLast: "p",
                generics: [
                    {
                        name: "x",
                        fullPath: ["x"],
                        pathWithoutLast: [],
                        pathLast: "x",
                        generics: [],
                        typeFilter: -1,
                    },
                    {
                        name: "y",
                        fullPath: ["y"],
                        pathWithoutLast: [],
                        pathLast: "y",
                        generics: [],
                        typeFilter: -1,
                    },
                ],
                typeFilter: -1,
            },
        ],
        foundElems: 1,
        userQuery: "p<x , y>",
        returned: [],
        error: null,
    },
    {
        query: "p ,x , y",
        elems: [
            {
                name: "p",
                fullPath: ["p"],
                pathWithoutLast: [],
                pathLast: "p",
                generics: [],
                typeFilter: -1,
            },
            {
                name: "x",
                fullPath: ["x"],
                pathWithoutLast: [],
                pathLast: "x",
                generics: [],
                typeFilter: -1,
            },
            {
                name: "y",
                fullPath: ["y"],
                pathWithoutLast: [],
                pathLast: "y",
                generics: [],
                typeFilter: -1,
            },
        ],
        foundElems: 3,
        userQuery: "p ,x , y",
        returned: [],
        error: null,
    },
];
