//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerregistry

import "time"

// ActivationProperties - The activation properties of the connected registry.
type ActivationProperties struct {
	// READ-ONLY; The activation status of the connected registry.
	Status *ActivationStatus `json:"status,omitempty" azure:"ro"`
}

// ActiveDirectoryObject - The Active Directory Object that will be used for authenticating the token of a container registry.
type ActiveDirectoryObject struct {
	// The user/group/application object ID for Active Directory Object that will be used for authenticating the token of a container
	// registry.
	ObjectID *string `json:"objectId,omitempty"`

	// The tenant ID of user/group/application object Active Directory Object that will be used for authenticating the token of
	// a container registry.
	TenantID *string `json:"tenantId,omitempty"`
}

// Actor - The agent that initiated the event. For most situations, this could be from the authorization context of the request.
type Actor struct {
	// The subject or username associated with the request context that generated the event.
	Name *string `json:"name,omitempty"`
}

// AgentPool - The agentpool that has the ARM resource and properties. The agentpool will have all information to create an
// agent pool.
type AgentPool struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`

	// The properties associated with the agent pool
	Properties *AgentPoolProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolListResult - The collection of agent pools.
type AgentPoolListResult struct {
	// The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`

	// The collection value.
	Value []*AgentPool `json:"value,omitempty"`
}

// AgentPoolProperties - The properties of agent pool.
type AgentPoolProperties struct {
	// The count of agent machine
	Count *int32 `json:"count,omitempty"`

	// The OS of agent machine
	OS *OS `json:"os,omitempty"`

	// The Tier of agent machine
	Tier *string `json:"tier,omitempty"`

	// The Virtual Network Subnet Resource Id of the agent machine
	VirtualNetworkSubnetResourceID *string `json:"virtualNetworkSubnetResourceId,omitempty"`

	// READ-ONLY; The provisioning state of this agent pool
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

type AgentPoolPropertiesUpdateParameters struct {
	// The count of agent machine
	Count *int32 `json:"count,omitempty"`
}

// AgentPoolQueueStatus - The QueueStatus of Agent Pool
type AgentPoolQueueStatus struct {
	// The number of pending runs in the queue
	Count *int32 `json:"count,omitempty"`
}

// AgentPoolUpdateParameters - The parameters for updating an agent pool.
type AgentPoolUpdateParameters struct {
	// The properties associated with the agent pool
	Properties *AgentPoolPropertiesUpdateParameters `json:"properties,omitempty"`

	// The ARM resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AgentPoolsClientBeginCreateOptions contains the optional parameters for the AgentPoolsClient.BeginCreate method.
type AgentPoolsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientBeginDeleteOptions contains the optional parameters for the AgentPoolsClient.BeginDelete method.
type AgentPoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientBeginUpdateOptions contains the optional parameters for the AgentPoolsClient.BeginUpdate method.
type AgentPoolsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientGetOptions contains the optional parameters for the AgentPoolsClient.Get method.
type AgentPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientGetQueueStatusOptions contains the optional parameters for the AgentPoolsClient.GetQueueStatus method.
type AgentPoolsClientGetQueueStatusOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientListOptions contains the optional parameters for the AgentPoolsClient.List method.
type AgentPoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// AgentProperties - The properties that determine the run agent configuration.
type AgentProperties struct {
	// The CPU configuration in terms of number of cores required for the run.
	CPU *int32 `json:"cpu,omitempty"`
}

// Argument - The properties of a run argument.
type Argument struct {
	// REQUIRED; The name of the argument.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The value of the argument.
	Value *string `json:"value,omitempty"`

	// Flag to indicate whether the argument represents a secret and want to be removed from build logs.
	IsSecret *bool `json:"isSecret,omitempty"`
}

// AuthInfo - The authorization properties for accessing the source code repository.
type AuthInfo struct {
	// REQUIRED; The access token used to access the source control provider.
	Token *string `json:"token,omitempty"`

	// REQUIRED; The type of Auth token.
	TokenType *TokenType `json:"tokenType,omitempty"`

	// Time in seconds that the token remains valid
	ExpiresIn *int32 `json:"expiresIn,omitempty"`

	// The refresh token used to refresh the access token.
	RefreshToken *string `json:"refreshToken,omitempty"`

	// The scope of the access token.
	Scope *string `json:"scope,omitempty"`
}

// AuthInfoUpdateParameters - The authorization properties for accessing the source code repository.
type AuthInfoUpdateParameters struct {
	// Time in seconds that the token remains valid
	ExpiresIn *int32 `json:"expiresIn,omitempty"`

	// The refresh token used to refresh the access token.
	RefreshToken *string `json:"refreshToken,omitempty"`

	// The scope of the access token.
	Scope *string `json:"scope,omitempty"`

	// The access token used to access the source control provider.
	Token *string `json:"token,omitempty"`

	// The type of Auth token.
	TokenType *TokenType `json:"tokenType,omitempty"`
}

// AzureADAuthenticationAsArmPolicy - The policy for using ARM audience token for a container registry.
type AzureADAuthenticationAsArmPolicy struct {
	// The value that indicates whether the policy is enabled or not.
	Status *AzureADAuthenticationAsArmPolicyStatus `json:"status,omitempty"`
}

// BaseImageDependency - Properties that describe a base image dependency.
type BaseImageDependency struct {
	// The sha256-based digest of the image manifest.
	Digest *string `json:"digest,omitempty"`

	// The registry login server.
	Registry *string `json:"registry,omitempty"`

	// The repository name.
	Repository *string `json:"repository,omitempty"`

	// The tag name.
	Tag *string `json:"tag,omitempty"`

	// The type of the base image dependency.
	Type *BaseImageDependencyType `json:"type,omitempty"`
}

// BaseImageTrigger - The trigger based on base image dependency.
type BaseImageTrigger struct {
	// REQUIRED; The type of the auto trigger for base image dependency updates.
	BaseImageTriggerType *BaseImageTriggerType `json:"baseImageTriggerType,omitempty"`

	// REQUIRED; The name of the trigger.
	Name *string `json:"name,omitempty"`

	// The current status of trigger.
	Status *TriggerStatus `json:"status,omitempty"`

	// The endpoint URL for receiving update triggers.
	UpdateTriggerEndpoint *string `json:"updateTriggerEndpoint,omitempty"`

	// Type of Payload body for Base image update triggers.
	UpdateTriggerPayloadType *UpdateTriggerPayloadType `json:"updateTriggerPayloadType,omitempty"`
}

// BaseImageTriggerUpdateParameters - The properties for updating base image dependency trigger.
type BaseImageTriggerUpdateParameters struct {
	// REQUIRED; The name of the trigger.
	Name *string `json:"name,omitempty"`

	// The type of the auto trigger for base image dependency updates.
	BaseImageTriggerType *BaseImageTriggerType `json:"baseImageTriggerType,omitempty"`

	// The current status of trigger.
	Status *TriggerStatus `json:"status,omitempty"`

	// The endpoint URL for receiving update triggers.
	UpdateTriggerEndpoint *string `json:"updateTriggerEndpoint,omitempty"`

	// Type of Payload body for Base image update triggers.
	UpdateTriggerPayloadType *UpdateTriggerPayloadType `json:"updateTriggerPayloadType,omitempty"`
}

// CallbackConfig - The configuration of service URI and custom headers for the webhook.
type CallbackConfig struct {
	// REQUIRED; The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`

	// Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders,omitempty"`
}

// ConnectedRegistriesClientBeginCreateOptions contains the optional parameters for the ConnectedRegistriesClient.BeginCreate
// method.
type ConnectedRegistriesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectedRegistriesClientBeginDeactivateOptions contains the optional parameters for the ConnectedRegistriesClient.BeginDeactivate
// method.
type ConnectedRegistriesClientBeginDeactivateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectedRegistriesClientBeginDeleteOptions contains the optional parameters for the ConnectedRegistriesClient.BeginDelete
// method.
type ConnectedRegistriesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectedRegistriesClientBeginUpdateOptions contains the optional parameters for the ConnectedRegistriesClient.BeginUpdate
// method.
type ConnectedRegistriesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectedRegistriesClientGetOptions contains the optional parameters for the ConnectedRegistriesClient.Get method.
type ConnectedRegistriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectedRegistriesClientListOptions contains the optional parameters for the ConnectedRegistriesClient.List method.
type ConnectedRegistriesClientListOptions struct {
	// An OData filter expression that describes a subset of connectedRegistries to return. The parameters that can be filtered
	// are parent.id (the resource id of the connectedRegistry parent), mode, and
	// connectionState. The supported operator is eq.
	Filter *string
}

// ConnectedRegistry - An object that represents a connected registry for a container registry.
type ConnectedRegistry struct {
	// The properties of the connected registry.
	Properties *ConnectedRegistryProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectedRegistryListResult - The result of a request to list connected registries for a container registry.
type ConnectedRegistryListResult struct {
	// The URI that can be used to request the next list of connected registries.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of connected registries. Since this list may be incomplete, the nextLink field should be used to request the next
	// list of connected registries.
	Value []*ConnectedRegistry `json:"value,omitempty"`
}

// ConnectedRegistryProperties - The properties of a connected registry.
type ConnectedRegistryProperties struct {
	// REQUIRED; The mode of the connected registry resource that indicates the permissions of the registry.
	Mode *ConnectedRegistryMode `json:"mode,omitempty"`

	// REQUIRED; The parent of the connected registry.
	Parent *ParentProperties `json:"parent,omitempty"`

	// The list of the ACR token resource IDs used to authenticate clients to the connected registry.
	ClientTokenIDs []*string `json:"clientTokenIds,omitempty"`

	// The logging properties of the connected registry.
	Logging *LoggingProperties `json:"logging,omitempty"`

	// The login server properties of the connected registry.
	LoginServer *LoginServerProperties `json:"loginServer,omitempty"`

	// The list of notifications subscription information for the connected registry.
	NotificationsList []*string `json:"notificationsList,omitempty"`

	// READ-ONLY; The activation properties of the connected registry.
	Activation *ActivationProperties `json:"activation,omitempty" azure:"ro"`

	// READ-ONLY; The current connection state of the connected registry.
	ConnectionState *ConnectionState `json:"connectionState,omitempty" azure:"ro"`

	// READ-ONLY; The last activity time of the connected registry.
	LastActivityTime *time.Time `json:"lastActivityTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The list of current statuses of the connected registry.
	StatusDetails []*StatusDetailProperties `json:"statusDetails,omitempty" azure:"ro"`

	// READ-ONLY; The current version of ACR runtime on the connected registry.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ConnectedRegistryUpdateParameters - The parameters for updating a connected registry.
type ConnectedRegistryUpdateParameters struct {
	// The properties of the connected registry update parameters.
	Properties *ConnectedRegistryUpdateProperties `json:"properties,omitempty"`
}

// ConnectedRegistryUpdateProperties - The parameters for updating token properties.
type ConnectedRegistryUpdateProperties struct {
	// The list of the ACR token resource IDs used to authenticate clients to the connected registry.
	ClientTokenIDs []*string `json:"clientTokenIds,omitempty"`

	// The logging properties of the connected registry.
	Logging *LoggingProperties `json:"logging,omitempty"`

	// The list of notifications subscription information for the connected registry.
	NotificationsList []*string `json:"notificationsList,omitempty"`

	// The sync properties of the connected registry with its parent.
	SyncProperties *SyncUpdateProperties `json:"syncProperties,omitempty"`
}

// Credentials - The parameters that describes a set of credentials that will be used when a run is invoked.
type Credentials struct {
	// Describes the credential parameters for accessing other custom registries. The key for the dictionary item will be the
	// registry login server (myregistry.azurecr.io) and the value of the item will be
	// the registry credentials for accessing the registry.
	CustomRegistries map[string]*CustomRegistryCredentials `json:"customRegistries,omitempty"`

	// Describes the credential parameters for accessing the source registry.
	SourceRegistry *SourceRegistryCredentials `json:"sourceRegistry,omitempty"`
}

// CustomRegistryCredentials - Describes the credentials that will be used to access a custom registry during a run.
type CustomRegistryCredentials struct {
	// Indicates the managed identity assigned to the custom credential. If a user-assigned identity this value is the Client
	// ID. If a system-assigned identity, the value will be system. In the case of a
	// system-assigned identity, the Client ID will be determined by the runner. This identity may be used to authenticate to
	// key vault to retrieve credentials or it may be the only source of authentication
	// used for accessing the registry.
	Identity *string `json:"identity,omitempty"`

	// The password for logging into the custom registry. The password is a secret object that allows multiple ways of providing
	// the value for it.
	Password *SecretObject `json:"password,omitempty"`

	// The username for logging into the custom registry.
	UserName *SecretObject `json:"userName,omitempty"`
}

// DockerBuildRequest - The parameters for a docker quick build.
type DockerBuildRequest struct {
	// REQUIRED; The Docker file path relative to the source location.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`

	// REQUIRED; The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`

	// REQUIRED; The type of the run request.
	Type *string `json:"type,omitempty"`

	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`

	// The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`

	// The collection of override arguments to be used when executing the run.
	Arguments []*Argument `json:"arguments,omitempty"`

	// The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`

	// The fully qualified image names including the repository and tag.
	ImageNames []*string `json:"imageNames,omitempty"`

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`

	// The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`

	// The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository. If it is relative URL,
	// the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`

	// The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`

	// Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
}

// GetRunRequest implements the RunRequestClassification interface for type DockerBuildRequest.
func (d *DockerBuildRequest) GetRunRequest() *RunRequest {
	return &RunRequest{
		Type:             d.Type,
		IsArchiveEnabled: d.IsArchiveEnabled,
		AgentPoolName:    d.AgentPoolName,
		LogTemplate:      d.LogTemplate,
	}
}

// DockerBuildStep - The Docker build step.
type DockerBuildStep struct {
	// REQUIRED; The Docker file path relative to the source context.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`

	// REQUIRED; The type of the step.
	Type *StepType `json:"type,omitempty"`

	// The collection of override arguments to be used when executing this build step.
	Arguments []*Argument `json:"arguments,omitempty"`

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`

	// The fully qualified image names including the repository and tag.
	ImageNames []*string `json:"imageNames,omitempty"`

	// The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`

	// The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`

	// The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`

	// READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies []*BaseImageDependency `json:"baseImageDependencies,omitempty" azure:"ro"`
}

// GetTaskStepProperties implements the TaskStepPropertiesClassification interface for type DockerBuildStep.
func (d *DockerBuildStep) GetTaskStepProperties() *TaskStepProperties {
	return &TaskStepProperties{
		Type:                  d.Type,
		BaseImageDependencies: d.BaseImageDependencies,
		ContextPath:           d.ContextPath,
		ContextAccessToken:    d.ContextAccessToken,
	}
}

// DockerBuildStepUpdateParameters - The properties for updating a docker build step.
type DockerBuildStepUpdateParameters struct {
	// REQUIRED; The type of the step.
	Type *StepType `json:"type,omitempty"`

	// The collection of override arguments to be used when executing this build step.
	Arguments []*Argument `json:"arguments,omitempty"`

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`

	// The Docker file path relative to the source context.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`

	// The fully qualified image names including the repository and tag.
	ImageNames []*string `json:"imageNames,omitempty"`

	// The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`

	// The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`

	// The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`
}

// GetTaskStepUpdateParameters implements the TaskStepUpdateParametersClassification interface for type DockerBuildStepUpdateParameters.
func (d *DockerBuildStepUpdateParameters) GetTaskStepUpdateParameters() *TaskStepUpdateParameters {
	return &TaskStepUpdateParameters{
		Type:               d.Type,
		ContextPath:        d.ContextPath,
		ContextAccessToken: d.ContextAccessToken,
	}
}

// EncodedTaskRunRequest - The parameters for a quick task run request.
type EncodedTaskRunRequest struct {
	// REQUIRED; Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string `json:"encodedTaskContent,omitempty"`

	// REQUIRED; The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`

	// REQUIRED; The type of the run request.
	Type *string `json:"type,omitempty"`

	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`

	// The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`

	// The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`

	// Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string `json:"encodedValuesContent,omitempty"`

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`

	// The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository. If it is relative URL,
	// the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`

	// Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue `json:"values,omitempty"`
}

// GetRunRequest implements the RunRequestClassification interface for type EncodedTaskRunRequest.
func (e *EncodedTaskRunRequest) GetRunRequest() *RunRequest {
	return &RunRequest{
		Type:             e.Type,
		IsArchiveEnabled: e.IsArchiveEnabled,
		AgentPoolName:    e.AgentPoolName,
		LogTemplate:      e.LogTemplate,
	}
}

// EncodedTaskStep - The properties of a encoded task step.
type EncodedTaskStep struct {
	// REQUIRED; Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string `json:"encodedTaskContent,omitempty"`

	// REQUIRED; The type of the step.
	Type *StepType `json:"type,omitempty"`

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`

	// Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string `json:"encodedValuesContent,omitempty"`

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue `json:"values,omitempty"`

	// READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies []*BaseImageDependency `json:"baseImageDependencies,omitempty" azure:"ro"`
}

// GetTaskStepProperties implements the TaskStepPropertiesClassification interface for type EncodedTaskStep.
func (e *EncodedTaskStep) GetTaskStepProperties() *TaskStepProperties {
	return &TaskStepProperties{
		Type:                  e.Type,
		BaseImageDependencies: e.BaseImageDependencies,
		ContextPath:           e.ContextPath,
		ContextAccessToken:    e.ContextAccessToken,
	}
}

// EncodedTaskStepUpdateParameters - The properties for updating encoded task step.
type EncodedTaskStepUpdateParameters struct {
	// REQUIRED; The type of the step.
	Type *StepType `json:"type,omitempty"`

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`

	// Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string `json:"encodedTaskContent,omitempty"`

	// Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string `json:"encodedValuesContent,omitempty"`

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue `json:"values,omitempty"`
}

// GetTaskStepUpdateParameters implements the TaskStepUpdateParametersClassification interface for type EncodedTaskStepUpdateParameters.
func (e *EncodedTaskStepUpdateParameters) GetTaskStepUpdateParameters() *TaskStepUpdateParameters {
	return &TaskStepUpdateParameters{
		Type:               e.Type,
		ContextPath:        e.ContextPath,
		ContextAccessToken: e.ContextAccessToken,
	}
}

type EncryptionProperty struct {
	// Key vault properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// Indicates whether or not the encryption is enabled for container registry.
	Status *EncryptionStatus `json:"status,omitempty"`
}

// ErrorResponse - An error response from the Azure Container Registry service.
type ErrorResponse struct {
	// Azure container registry build API error body.
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ErrorResponseBody - An error response from the Azure Container Registry service.
type ErrorResponseBody struct {
	// REQUIRED; error code.
	Code *string `json:"code,omitempty"`

	// REQUIRED; error message.
	Message *string `json:"message,omitempty"`

	// an array of additional nested error response info objects, as described by this contract.
	Details []*InnerErrorDescription `json:"details,omitempty"`

	// target of the particular error.
	Target *string `json:"target,omitempty"`
}

// Event - The event for a webhook.
type Event struct {
	// The event request message sent to the service URI.
	EventRequestMessage *EventRequestMessage `json:"eventRequestMessage,omitempty"`

	// The event response message received from the service URI.
	EventResponseMessage *EventResponseMessage `json:"eventResponseMessage,omitempty"`

	// The event ID.
	ID *string `json:"id,omitempty"`
}

// EventContent - The content of the event request message.
type EventContent struct {
	// The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`

	// The agent that initiated the event. For most situations, this could be from the authorization context of the request.
	Actor *Actor `json:"actor,omitempty"`

	// The event ID.
	ID *string `json:"id,omitempty"`

	// The request that generated the event.
	Request *Request `json:"request,omitempty"`

	// The registry node that generated the event. Put differently, while the actor initiates the event, the source generates
	// it.
	Source *Source `json:"source,omitempty"`

	// The target of the event.
	Target *Target `json:"target,omitempty"`

	// The time at which the event occurred.
	Timestamp *time.Time `json:"timestamp,omitempty"`
}

// EventInfo - The basic information of an event.
type EventInfo struct {
	// The event ID.
	ID *string `json:"id,omitempty"`
}

// EventListResult - The result of a request to list events for a webhook.
type EventListResult struct {
	// The URI that can be used to request the next list of events.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of events. Since this list may be incomplete, the nextLink field should be used to request the next list of events.
	Value []*Event `json:"value,omitempty"`
}

// EventRequestMessage - The event request message sent to the service URI.
type EventRequestMessage struct {
	// The content of the event request message.
	Content *EventContent `json:"content,omitempty"`

	// The headers of the event request message.
	Headers map[string]*string `json:"headers,omitempty"`

	// The HTTP method used to send the event request message.
	Method *string `json:"method,omitempty"`

	// The URI used to send the event request message.
	RequestURI *string `json:"requestUri,omitempty"`

	// The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// EventResponseMessage - The event response message received from the service URI.
type EventResponseMessage struct {
	// The content of the event response message.
	Content *string `json:"content,omitempty"`

	// The headers of the event response message.
	Headers map[string]*string `json:"headers,omitempty"`

	// The reason phrase of the event response message.
	ReasonPhrase *string `json:"reasonPhrase,omitempty"`

	// The status code of the event response message.
	StatusCode *string `json:"statusCode,omitempty"`

	// The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// ExportPipeline - An object that represents an export pipeline for a container registry.
type ExportPipeline struct {
	// The identity of the export pipeline.
	Identity *IdentityProperties `json:"identity,omitempty"`

	// The location of the export pipeline.
	Location *string `json:"location,omitempty"`

	// The properties of the export pipeline.
	Properties *ExportPipelineProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExportPipelineListResult - The result of a request to list export pipelines for a container registry.
type ExportPipelineListResult struct {
	// The URI that can be used to request the next list of pipeline runs.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of export pipelines. Since this list may be incomplete, the nextLink field should be used to request the next
	// list of export pipelines.
	Value []*ExportPipeline `json:"value,omitempty"`
}

// ExportPipelineProperties - The properties of an export pipeline.
type ExportPipelineProperties struct {
	// REQUIRED; The target properties of the export pipeline.
	Target *ExportPipelineTargetProperties `json:"target,omitempty"`

	// The list of all options configured for the pipeline.
	Options []*PipelineOptions `json:"options,omitempty"`

	// READ-ONLY; The provisioning state of the pipeline at the time the operation was called.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ExportPipelineTargetProperties - The properties of the export pipeline target.
type ExportPipelineTargetProperties struct {
	// REQUIRED; They key vault secret uri to obtain the target storage SAS token.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// The type of target for the export pipeline.
	Type *string `json:"type,omitempty"`

	// The target uri of the export pipeline. When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
	// When 'AzureStorageBlobContainer':
	// "https://accountName.blob.core.windows.net/containerName"
	URI *string `json:"uri,omitempty"`
}

// ExportPipelinesClientBeginCreateOptions contains the optional parameters for the ExportPipelinesClient.BeginCreate method.
type ExportPipelinesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExportPipelinesClientBeginDeleteOptions contains the optional parameters for the ExportPipelinesClient.BeginDelete method.
type ExportPipelinesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExportPipelinesClientGetOptions contains the optional parameters for the ExportPipelinesClient.Get method.
type ExportPipelinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExportPipelinesClientListOptions contains the optional parameters for the ExportPipelinesClient.List method.
type ExportPipelinesClientListOptions struct {
	// placeholder for future optional parameters
}

// ExportPolicy - The export policy for a container registry.
type ExportPolicy struct {
	// The value that indicates whether the policy is enabled or not.
	Status *ExportPolicyStatus `json:"status,omitempty"`
}

// FileTaskRunRequest - The request parameters for a scheduling run against a task file.
type FileTaskRunRequest struct {
	// REQUIRED; The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`

	// REQUIRED; The template/definition file path relative to the source.
	TaskFilePath *string `json:"taskFilePath,omitempty"`

	// REQUIRED; The type of the run request.
	Type *string `json:"type,omitempty"`

	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`

	// The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`

	// The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`

	// The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository. If it is relative URL,
	// the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`

	// Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue `json:"values,omitempty"`

	// The values/parameters file path relative to the source.
	ValuesFilePath *string `json:"valuesFilePath,omitempty"`
}

// GetRunRequest implements the RunRequestClassification interface for type FileTaskRunRequest.
func (f *FileTaskRunRequest) GetRunRequest() *RunRequest {
	return &RunRequest{
		Type:             f.Type,
		IsArchiveEnabled: f.IsArchiveEnabled,
		AgentPoolName:    f.AgentPoolName,
		LogTemplate:      f.LogTemplate,
	}
}

// FileTaskStep - The properties of a task step.
type FileTaskStep struct {
	// REQUIRED; The task template/definition file path relative to the source context.
	TaskFilePath *string `json:"taskFilePath,omitempty"`

	// REQUIRED; The type of the step.
	Type *StepType `json:"type,omitempty"`

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue `json:"values,omitempty"`

	// The task values/parameters file path relative to the source context.
	ValuesFilePath *string `json:"valuesFilePath,omitempty"`

	// READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies []*BaseImageDependency `json:"baseImageDependencies,omitempty" azure:"ro"`
}

// GetTaskStepProperties implements the TaskStepPropertiesClassification interface for type FileTaskStep.
func (f *FileTaskStep) GetTaskStepProperties() *TaskStepProperties {
	return &TaskStepProperties{
		Type:                  f.Type,
		BaseImageDependencies: f.BaseImageDependencies,
		ContextPath:           f.ContextPath,
		ContextAccessToken:    f.ContextAccessToken,
	}
}

// FileTaskStepUpdateParameters - The properties of updating a task step.
type FileTaskStepUpdateParameters struct {
	// REQUIRED; The type of the step.
	Type *StepType `json:"type,omitempty"`

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`

	// The task template/definition file path relative to the source context.
	TaskFilePath *string `json:"taskFilePath,omitempty"`

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue `json:"values,omitempty"`

	// The values/parameters file path relative to the source context.
	ValuesFilePath *string `json:"valuesFilePath,omitempty"`
}

// GetTaskStepUpdateParameters implements the TaskStepUpdateParametersClassification interface for type FileTaskStepUpdateParameters.
func (f *FileTaskStepUpdateParameters) GetTaskStepUpdateParameters() *TaskStepUpdateParameters {
	return &TaskStepUpdateParameters{
		Type:               f.Type,
		ContextPath:        f.ContextPath,
		ContextAccessToken: f.ContextAccessToken,
	}
}

// GenerateCredentialsParameters - The parameters used to generate credentials for a specified token or user of a container
// registry.
type GenerateCredentialsParameters struct {
	// The expiry date of the generated credentials after which the credentials become invalid.
	Expiry *time.Time `json:"expiry,omitempty"`

	// Specifies name of the password which should be regenerated if any -- password1 or password2.
	Name *TokenPasswordName `json:"name,omitempty"`

	// The resource ID of the token for which credentials have to be generated.
	TokenID *string `json:"tokenId,omitempty"`
}

// GenerateCredentialsResult - The response from the GenerateCredentials operation.
type GenerateCredentialsResult struct {
	// The list of passwords for a container registry.
	Passwords []*TokenPassword `json:"passwords,omitempty"`

	// The username for a container registry.
	Username *string `json:"username,omitempty"`
}

// IPRule - IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// REQUIRED; Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string `json:"value,omitempty"`

	// The action of IP ACL rule.
	Action *Action `json:"action,omitempty"`
}

// IdentityProperties - Managed identity for the resource.
type IdentityProperties struct {
	// The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`

	// The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`

	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/ providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties `json:"userAssignedIdentities,omitempty"`
}

// ImageDescriptor - Properties for a registry image.
type ImageDescriptor struct {
	// The sha256-based digest of the image manifest.
	Digest *string `json:"digest,omitempty"`

	// The registry login server.
	Registry *string `json:"registry,omitempty"`

	// The repository name.
	Repository *string `json:"repository,omitempty"`

	// The tag name.
	Tag *string `json:"tag,omitempty"`
}

// ImageUpdateTrigger - The image update trigger that caused a build.
type ImageUpdateTrigger struct {
	// The unique ID of the trigger.
	ID *string `json:"id,omitempty"`

	// The list of image updates that caused the build.
	Images []*ImageDescriptor `json:"images,omitempty"`

	// The timestamp when the image update happened.
	Timestamp *time.Time `json:"timestamp,omitempty"`
}

type ImportImageParameters struct {
	// REQUIRED; The source of the image.
	Source *ImportSource `json:"source,omitempty"`

	// When Force, any existing target tags will be overwritten. When NoForce, any existing target tags will fail the operation
	// before any copying begins.
	Mode *ImportMode `json:"mode,omitempty"`

	// List of strings of the form repo[:tag]. When tag is omitted the source will be used (or 'latest' if source tag is also
	// omitted).
	TargetTags []*string `json:"targetTags,omitempty"`

	// List of strings of repository names to do a manifest only copy. No tag will be created.
	UntaggedTargetRepositories []*string `json:"untaggedTargetRepositories,omitempty"`
}

// ImportPipeline - An object that represents an import pipeline for a container registry.
type ImportPipeline struct {
	// The identity of the import pipeline.
	Identity *IdentityProperties `json:"identity,omitempty"`

	// The location of the import pipeline.
	Location *string `json:"location,omitempty"`

	// The properties of the import pipeline.
	Properties *ImportPipelineProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImportPipelineListResult - The result of a request to list import pipelines for a container registry.
type ImportPipelineListResult struct {
	// The URI that can be used to request the next list of pipeline runs.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of import pipelines. Since this list may be incomplete, the nextLink field should be used to request the next
	// list of import pipelines.
	Value []*ImportPipeline `json:"value,omitempty"`
}

// ImportPipelineProperties - The properties of an import pipeline.
type ImportPipelineProperties struct {
	// REQUIRED; The source properties of the import pipeline.
	Source *ImportPipelineSourceProperties `json:"source,omitempty"`

	// The list of all options configured for the pipeline.
	Options []*PipelineOptions `json:"options,omitempty"`

	// The properties that describe the trigger of the import pipeline.
	Trigger *PipelineTriggerProperties `json:"trigger,omitempty"`

	// READ-ONLY; The provisioning state of the pipeline at the time the operation was called.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ImportPipelineSourceProperties - The properties of the import pipeline source.
type ImportPipelineSourceProperties struct {
	// REQUIRED; They key vault secret uri to obtain the source storage SAS token.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// The type of source for the import pipeline.
	Type *PipelineSourceType `json:"type,omitempty"`

	// The source uri of the import pipeline. When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
	// When 'AzureStorageBlobContainer':
	// "https://accountName.blob.core.windows.net/containerName"
	URI *string `json:"uri,omitempty"`
}

// ImportPipelinesClientBeginCreateOptions contains the optional parameters for the ImportPipelinesClient.BeginCreate method.
type ImportPipelinesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ImportPipelinesClientBeginDeleteOptions contains the optional parameters for the ImportPipelinesClient.BeginDelete method.
type ImportPipelinesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ImportPipelinesClientGetOptions contains the optional parameters for the ImportPipelinesClient.Get method.
type ImportPipelinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ImportPipelinesClientListOptions contains the optional parameters for the ImportPipelinesClient.List method.
type ImportPipelinesClientListOptions struct {
	// placeholder for future optional parameters
}

type ImportSource struct {
	// REQUIRED; Repository name of the source image. Specify an image by repository ('hello-world'). This will use the 'latest'
	// tag. Specify an image by tag ('hello-world:latest'). Specify an image by sha256-based
	// manifest digest ('hello-world@sha256:abc123').
	SourceImage *string `json:"sourceImage,omitempty"`

	// Credentials used when importing from a registry uri.
	Credentials *ImportSourceCredentials `json:"credentials,omitempty"`

	// The address of the source registry (e.g. 'mcr.microsoft.com').
	RegistryURI *string `json:"registryUri,omitempty"`

	// The resource identifier of the source Azure Container Registry.
	ResourceID *string `json:"resourceId,omitempty"`
}

type ImportSourceCredentials struct {
	// REQUIRED; The password used to authenticate with the source registry.
	Password *string `json:"password,omitempty"`

	// The username to authenticate with the source registry.
	Username *string `json:"username,omitempty"`
}

// InnerErrorDescription - inner error.
type InnerErrorDescription struct {
	// REQUIRED; error code.
	Code *string `json:"code,omitempty"`

	// REQUIRED; error message.
	Message *string `json:"message,omitempty"`

	// target of the particular error.
	Target *string `json:"target,omitempty"`
}

type KeyVaultProperties struct {
	// The client id of the identity which will be used to access key vault.
	Identity *string `json:"identity,omitempty"`

	// Key vault uri to access the encryption key.
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`

	// READ-ONLY; Auto key rotation status for a CMK enabled registry.
	KeyRotationEnabled *bool `json:"keyRotationEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of the last successful key rotation.
	LastKeyRotationTimestamp *time.Time `json:"lastKeyRotationTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified key identifier that includes the version of the key that is actually used for encryption.
	VersionedKeyIdentifier *string `json:"versionedKeyIdentifier,omitempty" azure:"ro"`
}

// LoggingProperties - The logging properties of the connected registry.
type LoggingProperties struct {
	// Indicates whether audit logs are enabled on the connected registry.
	AuditLogStatus *AuditLogStatus `json:"auditLogStatus,omitempty"`

	// The verbosity of logs persisted on the connected registry.
	LogLevel *LogLevel `json:"logLevel,omitempty"`
}

// LoginServerProperties - The login server properties of the connected registry.
type LoginServerProperties struct {
	// READ-ONLY; The host of the connected registry. Can be FQDN or IP.
	Host *string `json:"host,omitempty" azure:"ro"`

	// READ-ONLY; The TLS properties of the connected registry login server.
	TLS *TLSProperties `json:"tls,omitempty" azure:"ro"`
}

// NetworkRuleSet - The network rule set for a container registry.
type NetworkRuleSet struct {
	// REQUIRED; The default action of allow or deny when no other rules match.
	DefaultAction *DefaultAction `json:"defaultAction,omitempty"`

	// The IP ACL rules.
	IPRules []*IPRule `json:"ipRules,omitempty"`
}

// OperationDefinition - The definition of a container registry operation.
type OperationDefinition struct {
	// The display information for the container registry operation.
	Display *OperationDisplayDefinition `json:"display,omitempty"`

	// This property indicates if the operation is an action or a data action ref: https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#management-and-data-operations
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// The origin information of the container registry operation.
	Origin *string `json:"origin,omitempty"`

	// The properties information for the container registry operation.
	Properties *OperationPropertiesDefinition `json:"properties,omitempty"`
}

// OperationDisplayDefinition - The display information for a container registry operation.
type OperationDisplayDefinition struct {
	// The description for the operation.
	Description *string `json:"description,omitempty"`

	// The operation that users can perform.
	Operation *string `json:"operation,omitempty"`

	// The resource provider name: Microsoft.ContainerRegistry.
	Provider *string `json:"provider,omitempty"`

	// The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - The result of a request to list container registry operations.
type OperationListResult struct {
	// The URI that can be used to request the next list of container registry operations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of container registry operations. Since this list may be incomplete, the nextLink field should be used to request
	// the next list of operations.
	Value []*OperationDefinition `json:"value,omitempty"`
}

// OperationLogSpecificationDefinition - The definition of Azure Monitoring log.
type OperationLogSpecificationDefinition struct {
	// Log blob duration.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Log display name.
	DisplayName *string `json:"displayName,omitempty"`

	// Log name.
	Name *string `json:"name,omitempty"`
}

// OperationMetricSpecificationDefinition - The definition of Azure Monitoring metric.
type OperationMetricSpecificationDefinition struct {
	// Metric aggregation type.
	AggregationType *string `json:"aggregationType,omitempty"`

	// Metric description.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Metric display name.
	DisplayName *string `json:"displayName,omitempty"`

	// Internal metric name.
	InternalMetricName *string `json:"internalMetricName,omitempty"`

	// Metric name.
	Name *string `json:"name,omitempty"`

	// Metric unit.
	Unit *string `json:"unit,omitempty"`
}

// OperationPropertiesDefinition - The definition of Azure Monitoring properties.
type OperationPropertiesDefinition struct {
	// The definition of Azure Monitoring service.
	ServiceSpecification *OperationServiceSpecificationDefinition `json:"serviceSpecification,omitempty"`
}

// OperationServiceSpecificationDefinition - The definition of Azure Monitoring list.
type OperationServiceSpecificationDefinition struct {
	// A list of Azure Monitoring log definitions.
	LogSpecifications []*OperationLogSpecificationDefinition `json:"logSpecifications,omitempty"`

	// A list of Azure Monitoring metrics definition.
	MetricSpecifications []*OperationMetricSpecificationDefinition `json:"metricSpecifications,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

type OverrideTaskStepProperties struct {
	// Gets or sets the collection of override arguments to be used when executing a build step.
	Arguments []*Argument `json:"arguments,omitempty"`

	// The source context against which run has to be queued.
	ContextPath *string `json:"contextPath,omitempty"`

	// The file against which run has to be queued.
	File *string `json:"file,omitempty"`

	// The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`

	// Base64 encoded update trigger token that will be attached with the base image trigger webhook.
	UpdateTriggerToken *string `json:"updateTriggerToken,omitempty"`

	// The collection of overridable values that can be passed when running a Task.
	Values []*SetValue `json:"values,omitempty"`
}

// PackageType - The properties of a package type.
type PackageType struct {
	// The name of the package type.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; The endpoint of the package type.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`
}

// ParentProperties - The properties of the connected registry parent.
type ParentProperties struct {
	// REQUIRED; The sync properties of the connected registry with its parent.
	SyncProperties *SyncProperties `json:"syncProperties,omitempty"`

	// The resource ID of the parent to which the connected registry will be associated.
	ID *string `json:"id,omitempty"`
}

// PipelineRun - An object that represents a pipeline run for a container registry.
type PipelineRun struct {
	// The properties of a pipeline run.
	Properties *PipelineRunProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PipelineRunListResult - The result of a request to list pipeline runs for a container registry.
type PipelineRunListResult struct {
	// The URI that can be used to request the next list of pipeline runs.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of pipeline runs. Since this list may be incomplete, the nextLink field should be used to request the next list
	// of pipeline runs.
	Value []*PipelineRun `json:"value,omitempty"`
}

// PipelineRunProperties - The properties of a pipeline run.
type PipelineRunProperties struct {
	// How the pipeline run should be forced to recreate even if the pipeline run configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The request parameters for a pipeline run.
	Request *PipelineRunRequest `json:"request,omitempty"`

	// READ-ONLY; The provisioning state of a pipeline run.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The response of a pipeline run.
	Response *PipelineRunResponse `json:"response,omitempty" azure:"ro"`
}

// PipelineRunRequest - The request properties provided for a pipeline run.
type PipelineRunRequest struct {
	// List of source artifacts to be transferred by the pipeline. Specify an image by repository ('hello-world'). This will use
	// the 'latest' tag. Specify an image by tag ('hello-world:latest'). Specify an
	// image by sha256-based manifest digest ('hello-world@sha256:abc123').
	Artifacts []*string `json:"artifacts,omitempty"`

	// The digest of the tar used to transfer the artifacts.
	CatalogDigest *string `json:"catalogDigest,omitempty"`

	// The resource ID of the pipeline to run.
	PipelineResourceID *string `json:"pipelineResourceId,omitempty"`

	// The source properties of the pipeline run.
	Source *PipelineRunSourceProperties `json:"source,omitempty"`

	// The target properties of the pipeline run.
	Target *PipelineRunTargetProperties `json:"target,omitempty"`
}

// PipelineRunResponse - The response properties returned for a pipeline run.
type PipelineRunResponse struct {
	// The digest of the tar used to transfer the artifacts.
	CatalogDigest *string `json:"catalogDigest,omitempty"`

	// The time the pipeline run finished.
	FinishTime *time.Time `json:"finishTime,omitempty"`

	// The artifacts imported in the pipeline run.
	ImportedArtifacts []*string `json:"importedArtifacts,omitempty"`

	// The detailed error message for the pipeline run in the case of failure.
	PipelineRunErrorMessage *string `json:"pipelineRunErrorMessage,omitempty"`

	// The current progress of the copy operation.
	Progress *ProgressProperties `json:"progress,omitempty"`

	// The source of the pipeline run.
	Source *ImportPipelineSourceProperties `json:"source,omitempty"`

	// The time the pipeline run started.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The current status of the pipeline run.
	Status *string `json:"status,omitempty"`

	// The target of the pipeline run.
	Target *ExportPipelineTargetProperties `json:"target,omitempty"`

	// The trigger that caused the pipeline run.
	Trigger *PipelineTriggerDescriptor `json:"trigger,omitempty"`
}

type PipelineRunSourceProperties struct {
	// The name of the source.
	Name *string `json:"name,omitempty"`

	// The type of the source.
	Type *PipelineRunSourceType `json:"type,omitempty"`
}

type PipelineRunTargetProperties struct {
	// The name of the target.
	Name *string `json:"name,omitempty"`

	// The type of the target.
	Type *PipelineRunTargetType `json:"type,omitempty"`
}

// PipelineRunsClientBeginCreateOptions contains the optional parameters for the PipelineRunsClient.BeginCreate method.
type PipelineRunsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PipelineRunsClientBeginDeleteOptions contains the optional parameters for the PipelineRunsClient.BeginDelete method.
type PipelineRunsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PipelineRunsClientGetOptions contains the optional parameters for the PipelineRunsClient.Get method.
type PipelineRunsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PipelineRunsClientListOptions contains the optional parameters for the PipelineRunsClient.List method.
type PipelineRunsClientListOptions struct {
	// placeholder for future optional parameters
}

type PipelineSourceTriggerDescriptor struct {
	// The timestamp when the source update happened.
	Timestamp *time.Time `json:"timestamp,omitempty"`
}

type PipelineSourceTriggerProperties struct {
	// REQUIRED; The current status of the source trigger.
	Status *TriggerStatus `json:"status,omitempty"`
}

type PipelineTriggerDescriptor struct {
	// The source trigger that caused the pipeline run.
	SourceTrigger *PipelineSourceTriggerDescriptor `json:"sourceTrigger,omitempty"`
}

type PipelineTriggerProperties struct {
	// The source trigger properties of the pipeline.
	SourceTrigger *PipelineSourceTriggerProperties `json:"sourceTrigger,omitempty"`
}

// PlatformProperties - The platform properties against which the run has to happen.
type PlatformProperties struct {
	// REQUIRED; The operating system type required for the run.
	OS *OS `json:"os,omitempty"`

	// The OS architecture.
	Architecture *Architecture `json:"architecture,omitempty"`

	// Variant of the CPU.
	Variant *Variant `json:"variant,omitempty"`
}

// PlatformUpdateParameters - The properties for updating the platform configuration.
type PlatformUpdateParameters struct {
	// The OS architecture.
	Architecture *Architecture `json:"architecture,omitempty"`

	// The operating system type required for the run.
	OS *OS `json:"os,omitempty"`

	// Variant of the CPU.
	Variant *Variant `json:"variant,omitempty"`
}

// Policies - The policies for a container registry.
type Policies struct {
	// The policy for using ARM audience token for a container registry.
	AzureADAuthenticationAsArmPolicy *AzureADAuthenticationAsArmPolicy `json:"azureADAuthenticationAsArmPolicy,omitempty"`

	// The export policy for a container registry.
	ExportPolicy *ExportPolicy `json:"exportPolicy,omitempty"`

	// The quarantine policy for a container registry.
	QuarantinePolicy *QuarantinePolicy `json:"quarantinePolicy,omitempty"`

	// The retention policy for a container registry.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`

	// The soft delete policy for a container registry.
	SoftDeletePolicy *SoftDeletePolicy `json:"softDeletePolicy,omitempty"`

	// The content trust policy for a container registry.
	TrustPolicy *TrustPolicy `json:"trustPolicy,omitempty"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// This is private endpoint resource created with Microsoft.Network resource provider.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - An object that represents a private endpoint connection for a container registry.
type PrivateEndpointConnection struct {
	// The properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - The result of a request to list private endpoint connections for a container registry.
type PrivateEndpointConnectionListResult struct {
	// The URI that can be used to request the next list of private endpoint connections.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of private endpoint connections. Since this list may be incomplete, the nextLink field should be used to request
	// the next list of private endpoint connections.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - The properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; The provisioning state of private endpoint connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A resource that supports private link capabilities.
type PrivateLinkResource struct {
	// The resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource.
	Name *string `json:"name,omitempty"`

	// A resource that supports private link capabilities.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource type is private link resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - The result of a request to list private link resources for a container registry.
type PrivateLinkResourceListResult struct {
	// The URI that can be used to request the next list of private link resources.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of private link resources. Since this list may be incomplete, the nextLink field should be used to request the
	// next list of private link resources.
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - The properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`

	// The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkServiceConnectionState - The state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *ActionsRequired `json:"actionsRequired,omitempty"`

	// The description for connection status. For example if connection is rejected it can indicate reason for rejection.
	Description *string `json:"description,omitempty"`

	// The private link service connection status.
	Status *ConnectionStatus `json:"status,omitempty"`
}

type ProgressProperties struct {
	// The percentage complete of the copy operation.
	Percentage *string `json:"percentage,omitempty"`
}

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags.
type ProxyResource struct {
	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QuarantinePolicy - The quarantine policy for a container registry.
type QuarantinePolicy struct {
	// The value that indicates whether the policy is enabled or not.
	Status *PolicyStatus `json:"status,omitempty"`
}

// RegenerateCredentialParameters - The parameters used to regenerate the login credential.
type RegenerateCredentialParameters struct {
	// REQUIRED; Specifies name of the password which should be regenerated -- password or password2.
	Name *PasswordName `json:"name,omitempty"`
}

// RegistriesClientBeginCreateOptions contains the optional parameters for the RegistriesClient.BeginCreate method.
type RegistriesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegistriesClientBeginDeleteOptions contains the optional parameters for the RegistriesClient.BeginDelete method.
type RegistriesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegistriesClientBeginGenerateCredentialsOptions contains the optional parameters for the RegistriesClient.BeginGenerateCredentials
// method.
type RegistriesClientBeginGenerateCredentialsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegistriesClientBeginImportImageOptions contains the optional parameters for the RegistriesClient.BeginImportImage method.
type RegistriesClientBeginImportImageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegistriesClientBeginScheduleRunOptions contains the optional parameters for the RegistriesClient.BeginScheduleRun method.
type RegistriesClientBeginScheduleRunOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegistriesClientBeginUpdateOptions contains the optional parameters for the RegistriesClient.BeginUpdate method.
type RegistriesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RegistriesClientCheckNameAvailabilityOptions contains the optional parameters for the RegistriesClient.CheckNameAvailability
// method.
type RegistriesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// RegistriesClientGetBuildSourceUploadURLOptions contains the optional parameters for the RegistriesClient.GetBuildSourceUploadURL
// method.
type RegistriesClientGetBuildSourceUploadURLOptions struct {
	// placeholder for future optional parameters
}

// RegistriesClientGetOptions contains the optional parameters for the RegistriesClient.Get method.
type RegistriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RegistriesClientGetPrivateLinkResourceOptions contains the optional parameters for the RegistriesClient.GetPrivateLinkResource
// method.
type RegistriesClientGetPrivateLinkResourceOptions struct {
	// placeholder for future optional parameters
}

// RegistriesClientListByResourceGroupOptions contains the optional parameters for the RegistriesClient.ListByResourceGroup
// method.
type RegistriesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// RegistriesClientListCredentialsOptions contains the optional parameters for the RegistriesClient.ListCredentials method.
type RegistriesClientListCredentialsOptions struct {
	// placeholder for future optional parameters
}

// RegistriesClientListOptions contains the optional parameters for the RegistriesClient.List method.
type RegistriesClientListOptions struct {
	// placeholder for future optional parameters
}

// RegistriesClientListPrivateLinkResourcesOptions contains the optional parameters for the RegistriesClient.ListPrivateLinkResources
// method.
type RegistriesClientListPrivateLinkResourcesOptions struct {
	// placeholder for future optional parameters
}

// RegistriesClientListUsagesOptions contains the optional parameters for the RegistriesClient.ListUsages method.
type RegistriesClientListUsagesOptions struct {
	// placeholder for future optional parameters
}

// RegistriesClientRegenerateCredentialOptions contains the optional parameters for the RegistriesClient.RegenerateCredential
// method.
type RegistriesClientRegenerateCredentialOptions struct {
	// placeholder for future optional parameters
}

// Registry - An object that represents a container registry.
type Registry struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU of the container registry.
	SKU *SKU `json:"sku,omitempty"`

	// The identity of the container registry.
	Identity *IdentityProperties `json:"identity,omitempty"`

	// The properties of the container registry.
	Properties *RegistryProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegistryListCredentialsResult - The response from the ListCredentials operation.
type RegistryListCredentialsResult struct {
	// The list of passwords for a container registry.
	Passwords []*RegistryPassword `json:"passwords,omitempty"`

	// The username for a container registry.
	Username *string `json:"username,omitempty"`
}

// RegistryListResult - The result of a request to list container registries.
type RegistryListResult struct {
	// The URI that can be used to request the next list of container registries.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of container registries. Since this list may be incomplete, the nextLink field should be used to request the next
	// list of container registries.
	Value []*Registry `json:"value,omitempty"`
}

// RegistryNameCheckRequest - A request to check whether a container registry name is available.
type RegistryNameCheckRequest struct {
	// REQUIRED; The name of the container registry.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'.
	Type *string `json:"type,omitempty"`
}

// RegistryNameStatus - The result of a request to check the availability of a container registry name.
type RegistryNameStatus struct {
	// If any, the error message that provides more detail for the reason that the name is not available.
	Message *string `json:"message,omitempty"`

	// The value that indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// If any, the reason that the name is not available.
	Reason *string `json:"reason,omitempty"`
}

// RegistryPassword - The login password for the container registry.
type RegistryPassword struct {
	// The password name.
	Name *PasswordName `json:"name,omitempty"`

	// The password value.
	Value *string `json:"value,omitempty"`
}

// RegistryProperties - The properties of a container registry.
type RegistryProperties struct {
	// The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`

	// Enables registry-wide pull from unauthenticated clients.
	AnonymousPullEnabled *bool `json:"anonymousPullEnabled,omitempty"`

	// Enable a single data endpoint per region for serving data.
	DataEndpointEnabled *bool `json:"dataEndpointEnabled,omitempty"`

	// The encryption settings of container registry.
	Encryption *EncryptionProperty `json:"encryption,omitempty"`

	// Whether to allow trusted Azure services to access a network restricted registry.
	NetworkRuleBypassOptions *NetworkRuleBypassOptions `json:"networkRuleBypassOptions,omitempty"`

	// The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet `json:"networkRuleSet,omitempty"`

	// The policies for a container registry.
	Policies *Policies `json:"policies,omitempty"`

	// Whether or not public network access is allowed for the container registry.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Whether or not zone redundancy is enabled for this container registry
	ZoneRedundancy *ZoneRedundancy `json:"zoneRedundancy,omitempty"`

	// READ-ONLY; The creation date of the container registry in ISO8601 format.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; List of host names that will serve data when dataEndpointEnabled is true.
	DataEndpointHostNames []*string `json:"dataEndpointHostNames,omitempty" azure:"ro"`

	// READ-ONLY; The URL that can be used to log into the container registry.
	LoginServer *string `json:"loginServer,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connections for a container registry.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the container registry at the time the operation was called.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The status of the container registry at the time the operation was called.
	Status *Status `json:"status,omitempty" azure:"ro"`
}

// RegistryPropertiesUpdateParameters - The parameters for updating the properties of a container registry.
type RegistryPropertiesUpdateParameters struct {
	// The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`

	// Enables registry-wide pull from unauthenticated clients.
	AnonymousPullEnabled *bool `json:"anonymousPullEnabled,omitempty"`

	// Enable a single data endpoint per region for serving data.
	DataEndpointEnabled *bool `json:"dataEndpointEnabled,omitempty"`

	// The encryption settings of container registry.
	Encryption *EncryptionProperty `json:"encryption,omitempty"`

	// Whether to allow trusted Azure services to access a network restricted registry.
	NetworkRuleBypassOptions *NetworkRuleBypassOptions `json:"networkRuleBypassOptions,omitempty"`

	// The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet `json:"networkRuleSet,omitempty"`

	// The policies for a container registry.
	Policies *Policies `json:"policies,omitempty"`

	// Whether or not public network access is allowed for the container registry.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// RegistryUpdateParameters - The parameters for updating a container registry.
type RegistryUpdateParameters struct {
	// The identity of the container registry.
	Identity *IdentityProperties `json:"identity,omitempty"`

	// The properties that the container registry will be updated with.
	Properties *RegistryPropertiesUpdateParameters `json:"properties,omitempty"`

	// The SKU of the container registry.
	SKU *SKU `json:"sku,omitempty"`

	// The tags for the container registry.
	Tags map[string]*string `json:"tags,omitempty"`
}

// RegistryUsage - The quota usage for a container registry.
type RegistryUsage struct {
	// The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// The limit of the usage.
	Limit *int64 `json:"limit,omitempty"`

	// The name of the usage.
	Name *string `json:"name,omitempty"`

	// The unit of measurement.
	Unit *RegistryUsageUnit `json:"unit,omitempty"`
}

// RegistryUsageListResult - The result of a request to get container registry quota usages.
type RegistryUsageListResult struct {
	// The list of container registry quota usages.
	Value []*RegistryUsage `json:"value,omitempty"`
}

// Replication - An object that represents a replication for a container registry.
type Replication struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`

	// The properties of the replication.
	Properties *ReplicationProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReplicationListResult - The result of a request to list replications for a container registry.
type ReplicationListResult struct {
	// The URI that can be used to request the next list of replications.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of replications. Since this list may be incomplete, the nextLink field should be used to request the next list
	// of replications.
	Value []*Replication `json:"value,omitempty"`
}

// ReplicationProperties - The properties of a replication.
type ReplicationProperties struct {
	// Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional
	// endpoint is disabled, however its data will continue to be synced with
	// other replications.
	RegionEndpointEnabled *bool `json:"regionEndpointEnabled,omitempty"`

	// Whether or not zone redundancy is enabled for this container registry replication
	ZoneRedundancy *ZoneRedundancy `json:"zoneRedundancy,omitempty"`

	// READ-ONLY; The provisioning state of the replication at the time the operation was called.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The status of the replication at the time the operation was called.
	Status *Status `json:"status,omitempty" azure:"ro"`
}

// ReplicationUpdateParameters - The parameters for updating a replication.
type ReplicationUpdateParameters struct {
	// The parameters for updating a replication's properties
	Properties *ReplicationUpdateParametersProperties `json:"properties,omitempty"`

	// The tags for the replication.
	Tags map[string]*string `json:"tags,omitempty"`
}

type ReplicationUpdateParametersProperties struct {
	// Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional
	// endpoint is disabled, however its data will continue to be synced with
	// other replications.
	RegionEndpointEnabled *bool `json:"regionEndpointEnabled,omitempty"`
}

// ReplicationsClientBeginCreateOptions contains the optional parameters for the ReplicationsClient.BeginCreate method.
type ReplicationsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationsClientBeginDeleteOptions contains the optional parameters for the ReplicationsClient.BeginDelete method.
type ReplicationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationsClientBeginUpdateOptions contains the optional parameters for the ReplicationsClient.BeginUpdate method.
type ReplicationsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationsClientGetOptions contains the optional parameters for the ReplicationsClient.Get method.
type ReplicationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationsClientListOptions contains the optional parameters for the ReplicationsClient.List method.
type ReplicationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Request - The request that generated the event.
type Request struct {
	// The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the
	// standard http request.
	Addr *string `json:"addr,omitempty"`

	// The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
	Host *string `json:"host,omitempty"`

	// The ID of the request that initiated the event.
	ID *string `json:"id,omitempty"`

	// The request method that generated the event.
	Method *string `json:"method,omitempty"`

	// The user agent header of the request.
	Useragent *string `json:"useragent,omitempty"`
}

// Resource - An Azure resource.
type Resource struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RetentionPolicy - The retention policy for a container registry.
type RetentionPolicy struct {
	// The number of days to retain an untagged manifest after which it gets purged.
	Days *int32 `json:"days,omitempty"`

	// The value that indicates whether the policy is enabled or not.
	Status *PolicyStatus `json:"status,omitempty"`

	// READ-ONLY; The timestamp when the policy was last updated.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`
}

// Run resource properties
type Run struct {
	// The properties of a run.
	Properties *RunProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RunFilter - Properties that are enabled for Odata querying on runs.
type RunFilter struct {
	// The name of the agent pool that the run corresponds to.
	AgentPoolName *string `json:"agentPoolName,omitempty"`

	// The create time for a run.
	CreateTime *time.Time `json:"createTime,omitempty"`

	// The time the run finished.
	FinishTime *time.Time `json:"finishTime,omitempty"`

	// The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// The list of comma-separated image manifests that were generated from the run. This is applicable if the run is of build
	// type.
	OutputImageManifests *string `json:"outputImageManifests,omitempty"`

	// The unique identifier for the run.
	RunID *string `json:"runId,omitempty"`

	// The type of run.
	RunType *RunType `json:"runType,omitempty"`

	// The current status of the run.
	Status *RunStatus `json:"status,omitempty"`

	// The name of the task that the run corresponds to.
	TaskName *string `json:"taskName,omitempty"`
}

// RunGetLogResult - The result of get log link operation.
type RunGetLogResult struct {
	// The link to logs in registry for a run on a azure container registry.
	LogArtifactLink *string `json:"logArtifactLink,omitempty"`

	// The link to logs for a run on a azure container registry.
	LogLink *string `json:"logLink,omitempty"`
}

// RunListResult - Collection of runs.
type RunListResult struct {
	// The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`

	// The collection value.
	Value []*Run `json:"value,omitempty"`
}

// RunProperties - The properties for a run.
type RunProperties struct {
	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`

	// The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`

	// The time the run was scheduled.
	CreateTime *time.Time `json:"createTime,omitempty"`

	// The list of custom registries that were logged in during this run.
	CustomRegistries []*string `json:"customRegistries,omitempty"`

	// The time the run finished.
	FinishTime *time.Time `json:"finishTime,omitempty"`

	// The image update trigger that caused the run. This is applicable if the task has base image trigger configured.
	ImageUpdateTrigger *ImageUpdateTrigger `json:"imageUpdateTrigger,omitempty"`

	// The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// The last updated time for the run.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty"`

	// The list of all images that were generated from the run. This is applicable if the run generates base image dependencies.
	OutputImages []*ImageDescriptor `json:"outputImages,omitempty"`

	// The platform properties against which the run will happen.
	Platform *PlatformProperties `json:"platform,omitempty"`

	// The provisioning state of a run.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// The unique identifier for the run.
	RunID *string `json:"runId,omitempty"`

	// The type of run.
	RunType *RunType `json:"runType,omitempty"`

	// The scope of the credentials that were used to login to the source registry during this run.
	SourceRegistryAuth *string `json:"sourceRegistryAuth,omitempty"`

	// The source trigger that caused the run.
	SourceTrigger *SourceTriggerDescriptor `json:"sourceTrigger,omitempty"`

	// The time the run started.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The current status of the run.
	Status *RunStatus `json:"status,omitempty"`

	// The task against which run was scheduled.
	Task *string `json:"task,omitempty"`

	// The timer trigger that caused the run.
	TimerTrigger *TimerTriggerDescriptor `json:"timerTrigger,omitempty"`

	// The update trigger token passed for the Run.
	UpdateTriggerToken *string `json:"updateTriggerToken,omitempty"`

	// READ-ONLY; The image description for the log artifact.
	LogArtifact *ImageDescriptor `json:"logArtifact,omitempty" azure:"ro"`

	// READ-ONLY; The error message received from backend systems after the run is scheduled.
	RunErrorMessage *string `json:"runErrorMessage,omitempty" azure:"ro"`
}

// RunRequestClassification provides polymorphic access to related types.
// Call the interface's GetRunRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DockerBuildRequest, *EncodedTaskRunRequest, *FileTaskRunRequest, *RunRequest, *TaskRunRequest
type RunRequestClassification interface {
	// GetRunRequest returns the RunRequest content of the underlying type.
	GetRunRequest() *RunRequest
}

// RunRequest - The request parameters for scheduling a run.
type RunRequest struct {
	// REQUIRED; The type of the run request.
	Type *string `json:"type,omitempty"`

	// The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`
}

// GetRunRequest implements the RunRequestClassification interface for type RunRequest.
func (r *RunRequest) GetRunRequest() *RunRequest { return r }

// RunUpdateParameters - The set of run properties that can be updated.
type RunUpdateParameters struct {
	// The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
}

// RunsClientBeginCancelOptions contains the optional parameters for the RunsClient.BeginCancel method.
type RunsClientBeginCancelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RunsClientBeginUpdateOptions contains the optional parameters for the RunsClient.BeginUpdate method.
type RunsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RunsClientGetLogSasURLOptions contains the optional parameters for the RunsClient.GetLogSasURL method.
type RunsClientGetLogSasURLOptions struct {
	// placeholder for future optional parameters
}

// RunsClientGetOptions contains the optional parameters for the RunsClient.Get method.
type RunsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RunsClientListOptions contains the optional parameters for the RunsClient.List method.
type RunsClientListOptions struct {
	// The runs filter to apply on the operation. Arithmetic operators are not supported. The allowed string function is 'contains'.
	// All logical operators except 'Not', 'Has', 'All' are allowed.
	Filter *string
	// $top is supported for get list of runs, which limits the maximum number of runs to return.
	Top *int32
}

// SKU - The SKU of a container registry.
type SKU struct {
	// REQUIRED; The SKU name of the container registry. Required for registry creation.
	Name *SKUName `json:"name,omitempty"`

	// READ-ONLY; The SKU tier based on the SKU name.
	Tier *SKUTier `json:"tier,omitempty" azure:"ro"`
}

// ScopeMap - An object that represents a scope map for a container registry.
type ScopeMap struct {
	// The properties of the scope map.
	Properties *ScopeMapProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScopeMapListResult - The result of a request to list scope maps for a container registry.
type ScopeMapListResult struct {
	// The URI that can be used to request the next list of scope maps.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of scope maps. Since this list may be incomplete, the nextLink field should be used to request the next list of
	// scope maps.
	Value []*ScopeMap `json:"value,omitempty"`
}

// ScopeMapProperties - The properties of a scope map.
type ScopeMapProperties struct {
	// REQUIRED; The list of scoped permissions for registry artifacts. E.g. repositories/repository-name/content/read, repositories/repository-name/metadata/write
	Actions []*string `json:"actions,omitempty"`

	// The user friendly description of the scope map.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The creation date of scope map.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The type of the scope map. E.g. BuildIn scope map.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScopeMapPropertiesUpdateParameters - The update parameters for scope map properties.
type ScopeMapPropertiesUpdateParameters struct {
	// The list of scope permissions for registry artifacts. E.g. repositories/repository-name/pull, repositories/repository-name/delete
	Actions []*string `json:"actions,omitempty"`

	// The user friendly description of the scope map.
	Description *string `json:"description,omitempty"`
}

// ScopeMapUpdateParameters - The properties for updating the scope map.
type ScopeMapUpdateParameters struct {
	// The update parameters for scope map properties.
	Properties *ScopeMapPropertiesUpdateParameters `json:"properties,omitempty"`
}

// ScopeMapsClientBeginCreateOptions contains the optional parameters for the ScopeMapsClient.BeginCreate method.
type ScopeMapsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ScopeMapsClientBeginDeleteOptions contains the optional parameters for the ScopeMapsClient.BeginDelete method.
type ScopeMapsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ScopeMapsClientBeginUpdateOptions contains the optional parameters for the ScopeMapsClient.BeginUpdate method.
type ScopeMapsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ScopeMapsClientGetOptions contains the optional parameters for the ScopeMapsClient.Get method.
type ScopeMapsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScopeMapsClientListOptions contains the optional parameters for the ScopeMapsClient.List method.
type ScopeMapsClientListOptions struct {
	// placeholder for future optional parameters
}

// SecretObject - Describes the properties of a secret object value.
type SecretObject struct {
	// The type of the secret object which determines how the value of the secret object has to be interpreted.
	Type *SecretObjectType `json:"type,omitempty"`

	// The value of the secret. The format of this value will be determined based on the type of the secret object. If the type
	// is Opaque, the value will be used as is without any modification.
	Value *string `json:"value,omitempty"`
}

// SetValue - The properties of a overridable value that can be passed to a task template.
type SetValue struct {
	// REQUIRED; The name of the overridable value.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The overridable value.
	Value *string `json:"value,omitempty"`

	// Flag to indicate whether the value represents a secret or not.
	IsSecret *bool `json:"isSecret,omitempty"`
}

// SoftDeletePolicy - The soft delete policy for a container registry
type SoftDeletePolicy struct {
	// The number of days after which a soft-deleted item is permanently deleted.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// The value that indicates whether the policy is enabled or not.
	Status *PolicyStatus `json:"status,omitempty"`

	// READ-ONLY; The timestamp when the policy was last updated.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`
}

// Source - The registry node that generated the event. Put differently, while the actor initiates the event, the source generates
// it.
type Source struct {
	// The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname()
	// along with the running port.
	Addr *string `json:"addr,omitempty"`

	// The running instance of an application. Changes after each restart.
	InstanceID *string `json:"instanceID,omitempty"`
}

// SourceProperties - The properties of the source code repository.
type SourceProperties struct {
	// REQUIRED; The full URL to the source code repository
	RepositoryURL *string `json:"repositoryUrl,omitempty"`

	// REQUIRED; The type of source control service.
	SourceControlType *SourceControlType `json:"sourceControlType,omitempty"`

	// The branch name of the source code.
	Branch *string `json:"branch,omitempty"`

	// The authorization properties for accessing the source code repository and to set up webhooks for notifications.
	SourceControlAuthProperties *AuthInfo `json:"sourceControlAuthProperties,omitempty"`
}

// SourceRegistryCredentials - Describes the credential parameters for accessing the source registry.
type SourceRegistryCredentials struct {
	// The authentication mode which determines the source registry login scope. The credentials for the source registry will
	// be generated using the given scope. These credentials will be used to login to
	// the source registry during the run.
	LoginMode *SourceRegistryLoginMode `json:"loginMode,omitempty"`
}

// SourceTrigger - The properties of a source based trigger.
type SourceTrigger struct {
	// REQUIRED; The name of the trigger.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The properties that describes the source(code) for the task.
	SourceRepository *SourceProperties `json:"sourceRepository,omitempty"`

	// REQUIRED; The source event corresponding to the trigger.
	SourceTriggerEvents []*SourceTriggerEvent `json:"sourceTriggerEvents,omitempty"`

	// The current status of trigger.
	Status *TriggerStatus `json:"status,omitempty"`
}

// SourceTriggerDescriptor - The source trigger that caused a run.
type SourceTriggerDescriptor struct {
	// The branch name in the repository.
	BranchName *string `json:"branchName,omitempty"`

	// The unique ID that identifies a commit.
	CommitID *string `json:"commitId,omitempty"`

	// The event type of the trigger.
	EventType *string `json:"eventType,omitempty"`

	// The unique ID of the trigger.
	ID *string `json:"id,omitempty"`

	// The source control provider type.
	ProviderType *string `json:"providerType,omitempty"`

	// The unique ID that identifies pull request.
	PullRequestID *string `json:"pullRequestId,omitempty"`

	// The repository URL.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
}

// SourceTriggerUpdateParameters - The properties for updating a source based trigger.
type SourceTriggerUpdateParameters struct {
	// REQUIRED; The name of the trigger.
	Name *string `json:"name,omitempty"`

	// The properties that describes the source(code) for the task.
	SourceRepository *SourceUpdateParameters `json:"sourceRepository,omitempty"`

	// The source event corresponding to the trigger.
	SourceTriggerEvents []*SourceTriggerEvent `json:"sourceTriggerEvents,omitempty"`

	// The current status of trigger.
	Status *TriggerStatus `json:"status,omitempty"`
}

// SourceUpdateParameters - The properties for updating the source code repository.
type SourceUpdateParameters struct {
	// The branch name of the source code.
	Branch *string `json:"branch,omitempty"`

	// The full URL to the source code repository
	RepositoryURL *string `json:"repositoryUrl,omitempty"`

	// The authorization properties for accessing the source code repository and to set up webhooks for notifications.
	SourceControlAuthProperties *AuthInfoUpdateParameters `json:"sourceControlAuthProperties,omitempty"`

	// The type of source control service.
	SourceControlType *SourceControlType `json:"sourceControlType,omitempty"`
}

// SourceUploadDefinition - The properties of a response to source upload request.
type SourceUploadDefinition struct {
	// The relative path to the source. This is used to submit the subsequent queue build request.
	RelativePath *string `json:"relativePath,omitempty"`

	// The URL where the client can upload the source.
	UploadURL *string `json:"uploadUrl,omitempty"`
}

// Status - The status of an Azure resource at the time the operation was called.
type Status struct {
	// READ-ONLY; The short label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty" azure:"ro"`

	// READ-ONLY; The detailed message for the status, including alerts and error messages.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp when the status was changed to the current value.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`
}

// StatusDetailProperties - The status detail properties of the connected registry.
type StatusDetailProperties struct {
	// READ-ONLY; The code of the status.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The correlation ID of the status.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; The description of the status.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of the status.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; The component of the connected registry corresponding to the status.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageAccountProperties - The properties of a storage account for a container registry. Only applicable to Classic SKU.
type StorageAccountProperties struct {
	// REQUIRED; The resource ID of the storage account.
	ID *string `json:"id,omitempty"`
}

// SyncProperties - The sync properties of the connected registry with its parent.
type SyncProperties struct {
	// REQUIRED; The period of time for which a message is available to sync before it is expired. Specify the duration using
	// the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
	MessageTTL *string `json:"messageTtl,omitempty"`

	// REQUIRED; The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
	TokenID *string `json:"tokenId,omitempty"`

	// The cron expression indicating the schedule that the connected registry will sync with its parent.
	Schedule *string `json:"schedule,omitempty"`

	// The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S
	// as per ISO8601.
	SyncWindow *string `json:"syncWindow,omitempty"`

	// READ-ONLY; The gateway endpoint used by the connected registry to communicate with its parent.
	GatewayEndpoint *string `json:"gatewayEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The last time a sync occurred between the connected registry and its parent.
	LastSyncTime *time.Time `json:"lastSyncTime,omitempty" azure:"ro"`
}

// SyncUpdateProperties - The parameters for updating the sync properties of the connected registry with its parent.
type SyncUpdateProperties struct {
	// The period of time for which a message is available to sync before it is expired. Specify the duration using the format
	// P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
	MessageTTL *string `json:"messageTtl,omitempty"`

	// The cron expression indicating the schedule that the connected registry will sync with its parent.
	Schedule *string `json:"schedule,omitempty"`

	// The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S
	// as per ISO8601.
	SyncWindow *string `json:"syncWindow,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource modification (UTC).
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *LastModifiedByType `json:"lastModifiedByType,omitempty"`
}

// TLSCertificateProperties - The TLS certificate properties of the connected registry login server.
type TLSCertificateProperties struct {
	// READ-ONLY; Indicates the location of the certificates.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The type of certificate location.
	Type *CertificateType `json:"type,omitempty" azure:"ro"`
}

// TLSProperties - The TLS properties of the connected registry login server.
type TLSProperties struct {
	// READ-ONLY; The certificate used to configure HTTPS for the login server.
	Certificate *TLSCertificateProperties `json:"certificate,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether HTTPS is enabled for the login server.
	Status *TLSStatus `json:"status,omitempty" azure:"ro"`
}

// Target - The target of the event.
type Target struct {
	// The digest of the content, as defined by the Registry V2 HTTP API Specification.
	Digest *string `json:"digest,omitempty"`

	// The number of bytes of the content. Same as Size field.
	Length *int64 `json:"length,omitempty"`

	// The MIME type of the referenced object.
	MediaType *string `json:"mediaType,omitempty"`

	// The name of the artifact.
	Name *string `json:"name,omitempty"`

	// The repository name.
	Repository *string `json:"repository,omitempty"`

	// The number of bytes of the content. Same as Length field.
	Size *int64 `json:"size,omitempty"`

	// The tag name.
	Tag *string `json:"tag,omitempty"`

	// The direct URL to the content.
	URL *string `json:"url,omitempty"`

	// The version of the artifact.
	Version *string `json:"version,omitempty"`
}

// Task - The task that has the ARM resource and task properties. The task will have all information to schedule a run against
// it.
type Task struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`

	// Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`

	// The properties of a task.
	Properties *TaskProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TaskListResult - The collection of tasks.
type TaskListResult struct {
	// The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`

	// The collection value.
	Value []*Task `json:"value,omitempty"`
}

// TaskProperties - The properties of a task.
type TaskProperties struct {
	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`

	// The dedicated agent pool for the task.
	AgentPoolName *string `json:"agentPoolName,omitempty"`

	// The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`

	// The value of this property indicates whether the task resource is system task or not.
	IsSystemTask *bool `json:"isSystemTask,omitempty"`

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`

	// The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`

	// The current status of task.
	Status *TaskStatus `json:"status,omitempty"`

	// The properties of a task step.
	Step TaskStepPropertiesClassification `json:"step,omitempty"`

	// Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`

	// The properties that describe all triggers for the task.
	Trigger *TriggerProperties `json:"trigger,omitempty"`

	// READ-ONLY; The creation date of task.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the task.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// TaskPropertiesUpdateParameters - The properties for updating a task.
type TaskPropertiesUpdateParameters struct {
	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`

	// The dedicated agent pool for the task.
	AgentPoolName *string `json:"agentPoolName,omitempty"`

	// The parameters that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`

	// The platform properties against which the run has to happen.
	Platform *PlatformUpdateParameters `json:"platform,omitempty"`

	// The current status of task.
	Status *TaskStatus `json:"status,omitempty"`

	// The properties for updating a task step.
	Step TaskStepUpdateParametersClassification `json:"step,omitempty"`

	// Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`

	// The properties for updating trigger properties.
	Trigger *TriggerUpdateParameters `json:"trigger,omitempty"`
}

// TaskRun - The task run that has the ARM resource and properties. The task run will have the information of request and
// result of a run.
type TaskRun struct {
	// Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`

	// The location of the resource
	Location *string `json:"location,omitempty"`

	// The properties associated with the task run, i.e., request and result of the run
	Properties *TaskRunProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TaskRunListResult - The collection of task runs.
type TaskRunListResult struct {
	// The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`

	// The collection value.
	Value []*TaskRun `json:"value,omitempty"`
}

// TaskRunProperties - The properties of task run.
type TaskRunProperties struct {
	// How the run should be forced to rerun even if the run request configuration has not changed
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The request (parameters) for the run
	RunRequest RunRequestClassification `json:"runRequest,omitempty"`

	// READ-ONLY; The provisioning state of this task run
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The result of this task run
	RunResult *Run `json:"runResult,omitempty" azure:"ro"`
}

// TaskRunPropertiesUpdateParameters - The properties of a task run update parameters.
type TaskRunPropertiesUpdateParameters struct {
	// How the run should be forced to rerun even if the run request configuration has not changed
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The request (parameters) for the new run
	RunRequest RunRequestClassification `json:"runRequest,omitempty"`
}

// TaskRunRequest - The parameters for a task run request.
type TaskRunRequest struct {
	// REQUIRED; The resource ID of task against which run has to be queued.
	TaskID *string `json:"taskId,omitempty"`

	// REQUIRED; The type of the run request.
	Type *string `json:"type,omitempty"`

	// The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`

	// Set of overridable parameters that can be passed when running a Task.
	OverrideTaskStepProperties *OverrideTaskStepProperties `json:"overrideTaskStepProperties,omitempty"`
}

// GetRunRequest implements the RunRequestClassification interface for type TaskRunRequest.
func (t *TaskRunRequest) GetRunRequest() *RunRequest {
	return &RunRequest{
		Type:             t.Type,
		IsArchiveEnabled: t.IsArchiveEnabled,
		AgentPoolName:    t.AgentPoolName,
		LogTemplate:      t.LogTemplate,
	}
}

// TaskRunUpdateParameters - The parameters for updating a task run.
type TaskRunUpdateParameters struct {
	// Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`

	// The location of the resource
	Location *string `json:"location,omitempty"`

	// The properties for updating a task run.
	Properties *TaskRunPropertiesUpdateParameters `json:"properties,omitempty"`

	// The ARM resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TaskRunsClientBeginCreateOptions contains the optional parameters for the TaskRunsClient.BeginCreate method.
type TaskRunsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TaskRunsClientBeginDeleteOptions contains the optional parameters for the TaskRunsClient.BeginDelete method.
type TaskRunsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TaskRunsClientBeginUpdateOptions contains the optional parameters for the TaskRunsClient.BeginUpdate method.
type TaskRunsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TaskRunsClientGetDetailsOptions contains the optional parameters for the TaskRunsClient.GetDetails method.
type TaskRunsClientGetDetailsOptions struct {
	// placeholder for future optional parameters
}

// TaskRunsClientGetOptions contains the optional parameters for the TaskRunsClient.Get method.
type TaskRunsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TaskRunsClientListOptions contains the optional parameters for the TaskRunsClient.List method.
type TaskRunsClientListOptions struct {
	// placeholder for future optional parameters
}

// TaskStepPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetTaskStepProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DockerBuildStep, *EncodedTaskStep, *FileTaskStep, *TaskStepProperties
type TaskStepPropertiesClassification interface {
	// GetTaskStepProperties returns the TaskStepProperties content of the underlying type.
	GetTaskStepProperties() *TaskStepProperties
}

// TaskStepProperties - Base properties for any task step.
type TaskStepProperties struct {
	// REQUIRED; The type of the step.
	Type *StepType `json:"type,omitempty"`

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`

	// READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies []*BaseImageDependency `json:"baseImageDependencies,omitempty" azure:"ro"`
}

// GetTaskStepProperties implements the TaskStepPropertiesClassification interface for type TaskStepProperties.
func (t *TaskStepProperties) GetTaskStepProperties() *TaskStepProperties { return t }

// TaskStepUpdateParametersClassification provides polymorphic access to related types.
// Call the interface's GetTaskStepUpdateParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DockerBuildStepUpdateParameters, *EncodedTaskStepUpdateParameters, *FileTaskStepUpdateParameters, *TaskStepUpdateParameters
type TaskStepUpdateParametersClassification interface {
	// GetTaskStepUpdateParameters returns the TaskStepUpdateParameters content of the underlying type.
	GetTaskStepUpdateParameters() *TaskStepUpdateParameters
}

// TaskStepUpdateParameters - Base properties for updating any task step.
type TaskStepUpdateParameters struct {
	// REQUIRED; The type of the step.
	Type *StepType `json:"type,omitempty"`

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
}

// GetTaskStepUpdateParameters implements the TaskStepUpdateParametersClassification interface for type TaskStepUpdateParameters.
func (t *TaskStepUpdateParameters) GetTaskStepUpdateParameters() *TaskStepUpdateParameters { return t }

// TaskUpdateParameters - The parameters for updating a task.
type TaskUpdateParameters struct {
	// Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`

	// The properties for updating a task.
	Properties *TaskPropertiesUpdateParameters `json:"properties,omitempty"`

	// The ARM resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TasksClientBeginCreateOptions contains the optional parameters for the TasksClient.BeginCreate method.
type TasksClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TasksClientBeginDeleteOptions contains the optional parameters for the TasksClient.BeginDelete method.
type TasksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TasksClientBeginUpdateOptions contains the optional parameters for the TasksClient.BeginUpdate method.
type TasksClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TasksClientGetDetailsOptions contains the optional parameters for the TasksClient.GetDetails method.
type TasksClientGetDetailsOptions struct {
	// placeholder for future optional parameters
}

// TasksClientGetOptions contains the optional parameters for the TasksClient.Get method.
type TasksClientGetOptions struct {
	// placeholder for future optional parameters
}

// TasksClientListOptions contains the optional parameters for the TasksClient.List method.
type TasksClientListOptions struct {
	// placeholder for future optional parameters
}

// TimerTrigger - The properties of a timer trigger.
type TimerTrigger struct {
	// REQUIRED; The name of the trigger.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The CRON expression for the task schedule
	Schedule *string `json:"schedule,omitempty"`

	// The current status of trigger.
	Status *TriggerStatus `json:"status,omitempty"`
}

type TimerTriggerDescriptor struct {
	// The occurrence that triggered the run.
	ScheduleOccurrence *string `json:"scheduleOccurrence,omitempty"`

	// The timer trigger name that caused the run.
	TimerTriggerName *string `json:"timerTriggerName,omitempty"`
}

// TimerTriggerUpdateParameters - The properties for updating a timer trigger.
type TimerTriggerUpdateParameters struct {
	// REQUIRED; The name of the trigger.
	Name *string `json:"name,omitempty"`

	// The CRON expression for the task schedule
	Schedule *string `json:"schedule,omitempty"`

	// The current status of trigger.
	Status *TriggerStatus `json:"status,omitempty"`
}

// Token - An object that represents a token for a container registry.
type Token struct {
	// The properties of the token.
	Properties *TokenProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TokenCertificate - The properties of a certificate used for authenticating a token.
type TokenCertificate struct {
	// Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
	EncodedPemCertificate *string `json:"encodedPemCertificate,omitempty"`

	// The expiry datetime of the certificate.
	Expiry *time.Time            `json:"expiry,omitempty"`
	Name   *TokenCertificateName `json:"name,omitempty"`

	// The thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// TokenCredentialsProperties - The properties of the credentials that can be used for authenticating the token.
type TokenCredentialsProperties struct {
	Certificates []*TokenCertificate `json:"certificates,omitempty"`
	Passwords    []*TokenPassword    `json:"passwords,omitempty"`
}

// TokenListResult - The result of a request to list tokens for a container registry.
type TokenListResult struct {
	// The URI that can be used to request the next list of tokens.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of tokens. Since this list may be incomplete, the nextLink field should be used to request the next list of tokens.
	Value []*Token `json:"value,omitempty"`
}

// TokenPassword - The password that will be used for authenticating the token of a container registry.
type TokenPassword struct {
	// The creation datetime of the password.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// The expiry datetime of the password.
	Expiry *time.Time `json:"expiry,omitempty"`

	// The password name "password1" or "password2"
	Name *TokenPasswordName `json:"name,omitempty"`

	// READ-ONLY; The password value.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// TokenProperties - The properties of a token.
type TokenProperties struct {
	// The credentials that can be used for authenticating the token.
	Credentials *TokenCredentialsProperties `json:"credentials,omitempty"`

	// The resource ID of the scope map to which the token will be associated with.
	ScopeMapID *string `json:"scopeMapId,omitempty"`

	// The status of the token example enabled or disabled.
	Status *TokenStatus `json:"status,omitempty"`

	// READ-ONLY; The creation date of scope map.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// TokenUpdateParameters - The parameters for updating a token.
type TokenUpdateParameters struct {
	// The properties of the token update parameters.
	Properties *TokenUpdateProperties `json:"properties,omitempty"`
}

// TokenUpdateProperties - The parameters for updating token properties.
type TokenUpdateProperties struct {
	// The credentials that can be used for authenticating the token.
	Credentials *TokenCredentialsProperties `json:"credentials,omitempty"`

	// The resource ID of the scope map to which the token will be associated with.
	ScopeMapID *string `json:"scopeMapId,omitempty"`

	// The status of the token example enabled or disabled.
	Status *TokenStatus `json:"status,omitempty"`
}

// TokensClientBeginCreateOptions contains the optional parameters for the TokensClient.BeginCreate method.
type TokensClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TokensClientBeginDeleteOptions contains the optional parameters for the TokensClient.BeginDelete method.
type TokensClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TokensClientBeginUpdateOptions contains the optional parameters for the TokensClient.BeginUpdate method.
type TokensClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TokensClientGetOptions contains the optional parameters for the TokensClient.Get method.
type TokensClientGetOptions struct {
	// placeholder for future optional parameters
}

// TokensClientListOptions contains the optional parameters for the TokensClient.List method.
type TokensClientListOptions struct {
	// placeholder for future optional parameters
}

// TriggerProperties - The properties of a trigger.
type TriggerProperties struct {
	// The trigger based on base image dependencies.
	BaseImageTrigger *BaseImageTrigger `json:"baseImageTrigger,omitempty"`

	// The collection of triggers based on source code repository.
	SourceTriggers []*SourceTrigger `json:"sourceTriggers,omitempty"`

	// The collection of timer triggers.
	TimerTriggers []*TimerTrigger `json:"timerTriggers,omitempty"`
}

// TriggerUpdateParameters - The properties for updating triggers.
type TriggerUpdateParameters struct {
	// The trigger based on base image dependencies.
	BaseImageTrigger *BaseImageTriggerUpdateParameters `json:"baseImageTrigger,omitempty"`

	// The collection of triggers based on source code repository.
	SourceTriggers []*SourceTriggerUpdateParameters `json:"sourceTriggers,omitempty"`

	// The collection of timer triggers.
	TimerTriggers []*TimerTriggerUpdateParameters `json:"timerTriggers,omitempty"`
}

// TrustPolicy - The content trust policy for a container registry.
type TrustPolicy struct {
	// The value that indicates whether the policy is enabled or not.
	Status *PolicyStatus `json:"status,omitempty"`

	// The type of trust policy.
	Type *TrustPolicyType `json:"type,omitempty"`
}

type UserIdentityProperties struct {
	// The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
}

// Webhook - An object that represents a webhook for a container registry.
type Webhook struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`

	// The properties of the webhook.
	Properties *WebhookProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebhookCreateParameters - The parameters for creating a webhook.
type WebhookCreateParameters struct {
	// REQUIRED; The location of the webhook. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`

	// The properties that the webhook will be created with.
	Properties *WebhookPropertiesCreateParameters `json:"properties,omitempty"`

	// The tags for the webhook.
	Tags map[string]*string `json:"tags,omitempty"`
}

// WebhookListResult - The result of a request to list webhooks for a container registry.
type WebhookListResult struct {
	// The URI that can be used to request the next list of webhooks.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of webhooks. Since this list may be incomplete, the nextLink field should be used to request the next list of
	// webhooks.
	Value []*Webhook `json:"value,omitempty"`
}

// WebhookProperties - The properties of a webhook.
type WebhookProperties struct {
	// REQUIRED; The list of actions that trigger the webhook to post notifications.
	Actions []*WebhookAction `json:"actions,omitempty"`

	// The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository
	// 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
	// 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`

	// The status of the webhook at the time the operation was called.
	Status *WebhookStatus `json:"status,omitempty"`

	// READ-ONLY; The provisioning state of the webhook at the time the operation was called.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// WebhookPropertiesCreateParameters - The parameters for creating the properties of a webhook.
type WebhookPropertiesCreateParameters struct {
	// REQUIRED; The list of actions that trigger the webhook to post notifications.
	Actions []*WebhookAction `json:"actions,omitempty"`

	// REQUIRED; The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`

	// Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders,omitempty"`

	// The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository
	// 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
	// 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`

	// The status of the webhook at the time the operation was called.
	Status *WebhookStatus `json:"status,omitempty"`
}

// WebhookPropertiesUpdateParameters - The parameters for updating the properties of a webhook.
type WebhookPropertiesUpdateParameters struct {
	// The list of actions that trigger the webhook to post notifications.
	Actions []*WebhookAction `json:"actions,omitempty"`

	// Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders,omitempty"`

	// The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository
	// 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
	// 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`

	// The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`

	// The status of the webhook at the time the operation was called.
	Status *WebhookStatus `json:"status,omitempty"`
}

// WebhookUpdateParameters - The parameters for updating a webhook.
type WebhookUpdateParameters struct {
	// The properties that the webhook will be updated with.
	Properties *WebhookPropertiesUpdateParameters `json:"properties,omitempty"`

	// The tags for the webhook.
	Tags map[string]*string `json:"tags,omitempty"`
}

// WebhooksClientBeginCreateOptions contains the optional parameters for the WebhooksClient.BeginCreate method.
type WebhooksClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebhooksClientBeginDeleteOptions contains the optional parameters for the WebhooksClient.BeginDelete method.
type WebhooksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebhooksClientBeginUpdateOptions contains the optional parameters for the WebhooksClient.BeginUpdate method.
type WebhooksClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebhooksClientGetCallbackConfigOptions contains the optional parameters for the WebhooksClient.GetCallbackConfig method.
type WebhooksClientGetCallbackConfigOptions struct {
	// placeholder for future optional parameters
}

// WebhooksClientGetOptions contains the optional parameters for the WebhooksClient.Get method.
type WebhooksClientGetOptions struct {
	// placeholder for future optional parameters
}

// WebhooksClientListEventsOptions contains the optional parameters for the WebhooksClient.ListEvents method.
type WebhooksClientListEventsOptions struct {
	// placeholder for future optional parameters
}

// WebhooksClientListOptions contains the optional parameters for the WebhooksClient.List method.
type WebhooksClientListOptions struct {
	// placeholder for future optional parameters
}

// WebhooksClientPingOptions contains the optional parameters for the WebhooksClient.Ping method.
type WebhooksClientPingOptions struct {
	// placeholder for future optional parameters
}
