//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataboxedge

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type AddonList.
func (a *AddonList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			a.Value, err = unmarshalAddonClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertProperties.
func (a AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertType", a.AlertType)
	populateTimeRFC3339(objectMap, "appearedAtDateTime", a.AppearedAtDateTime)
	populate(objectMap, "detailedInformation", a.DetailedInformation)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "recommendation", a.Recommendation)
	populate(objectMap, "severity", a.Severity)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertProperties.
func (a *AlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertType":
			err = unpopulate(val, "AlertType", &a.AlertType)
			delete(rawMsg, key)
		case "appearedAtDateTime":
			err = unpopulateTimeRFC3339(val, "AppearedAtDateTime", &a.AppearedAtDateTime)
			delete(rawMsg, key)
		case "detailedInformation":
			err = unpopulate(val, "DetailedInformation", &a.DetailedInformation)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "recommendation":
			err = unpopulate(val, "Recommendation", &a.Recommendation)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArcAddon.
func (a ArcAddon) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = AddonTypeArcForKubernetes
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArcAddon.
func (a *ArcAddon) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BandwidthScheduleProperties.
func (b BandwidthScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "days", b.Days)
	populate(objectMap, "rateInMbps", b.RateInMbps)
	populate(objectMap, "start", b.Start)
	populate(objectMap, "stop", b.Stop)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudEdgeManagementRole.
func (c CloudEdgeManagementRole) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	objectMap["kind"] = RoleTypesCloudEdgeManagement
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEdgeManagementRole.
func (c *CloudEdgeManagementRole) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterCapacityViewData.
func (c ClusterCapacityViewData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fqdn", c.Fqdn)
	populate(objectMap, "gpuCapacity", c.GpuCapacity)
	populateTimeRFC3339(objectMap, "lastRefreshedTime", c.LastRefreshedTime)
	populate(objectMap, "memoryCapacity", c.MemoryCapacity)
	populate(objectMap, "totalProvisionedNonHpnCores", c.TotalProvisionedNonHpnCores)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterCapacityViewData.
func (c *ClusterCapacityViewData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdn":
			err = unpopulate(val, "Fqdn", &c.Fqdn)
			delete(rawMsg, key)
		case "gpuCapacity":
			err = unpopulate(val, "GpuCapacity", &c.GpuCapacity)
			delete(rawMsg, key)
		case "lastRefreshedTime":
			err = unpopulateTimeRFC3339(val, "LastRefreshedTime", &c.LastRefreshedTime)
			delete(rawMsg, key)
		case "memoryCapacity":
			err = unpopulate(val, "MemoryCapacity", &c.MemoryCapacity)
			delete(rawMsg, key)
		case "totalProvisionedNonHpnCores":
			err = unpopulate(val, "TotalProvisionedNonHpnCores", &c.TotalProvisionedNonHpnCores)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactDetails.
func (c ContactDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "companyName", c.CompanyName)
	populate(objectMap, "contactPerson", c.ContactPerson)
	populate(objectMap, "emailList", c.EmailList)
	populate(objectMap, "phone", c.Phone)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ContainerProperties.
func (c ContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "containerStatus", c.ContainerStatus)
	populateTimeRFC3339(objectMap, "createdDateTime", c.CreatedDateTime)
	populate(objectMap, "dataFormat", c.DataFormat)
	populate(objectMap, "refreshDetails", c.RefreshDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerProperties.
func (c *ContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerStatus":
			err = unpopulate(val, "ContainerStatus", &c.ContainerStatus)
			delete(rawMsg, key)
		case "createdDateTime":
			err = unpopulateTimeRFC3339(val, "CreatedDateTime", &c.CreatedDateTime)
			delete(rawMsg, key)
		case "dataFormat":
			err = unpopulate(val, "DataFormat", &c.DataFormat)
			delete(rawMsg, key)
		case "refreshDetails":
			err = unpopulate(val, "RefreshDetails", &c.RefreshDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Device.
func (d Device) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DeviceCapacityInfoProperties.
func (d DeviceCapacityInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clusterComputeCapacityInfo", d.ClusterComputeCapacityInfo)
	populate(objectMap, "clusterStorageCapacityInfo", d.ClusterStorageCapacityInfo)
	populate(objectMap, "nodeCapacityInfos", d.NodeCapacityInfos)
	populateTimeRFC3339(objectMap, "timeStamp", d.TimeStamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceCapacityInfoProperties.
func (d *DeviceCapacityInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterComputeCapacityInfo":
			err = unpopulate(val, "ClusterComputeCapacityInfo", &d.ClusterComputeCapacityInfo)
			delete(rawMsg, key)
		case "clusterStorageCapacityInfo":
			err = unpopulate(val, "ClusterStorageCapacityInfo", &d.ClusterStorageCapacityInfo)
			delete(rawMsg, key)
		case "nodeCapacityInfos":
			err = unpopulate(val, "NodeCapacityInfos", &d.NodeCapacityInfos)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateTimeRFC3339(val, "TimeStamp", &d.TimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceCapacityRequestInfoProperties.
func (d DeviceCapacityRequestInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "vmPlacementQuery", d.VMPlacementQuery)
	populate(objectMap, "vmPlacementResults", d.VMPlacementResults)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DeviceExtendedInfoProperties.
func (d DeviceExtendedInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "channelIntegrityKeyName", d.ChannelIntegrityKeyName)
	populate(objectMap, "channelIntegrityKeyVersion", d.ChannelIntegrityKeyVersion)
	populate(objectMap, "clientSecretStoreId", d.ClientSecretStoreID)
	populate(objectMap, "clientSecretStoreUrl", d.ClientSecretStoreURL)
	populate(objectMap, "cloudWitnessContainerName", d.CloudWitnessContainerName)
	populate(objectMap, "cloudWitnessStorageAccountName", d.CloudWitnessStorageAccountName)
	populate(objectMap, "cloudWitnessStorageEndpoint", d.CloudWitnessStorageEndpoint)
	populate(objectMap, "clusterWitnessType", d.ClusterWitnessType)
	populate(objectMap, "deviceSecrets", d.DeviceSecrets)
	populate(objectMap, "encryptionKey", d.EncryptionKey)
	populate(objectMap, "encryptionKeyThumbprint", d.EncryptionKeyThumbprint)
	populate(objectMap, "fileShareWitnessLocation", d.FileShareWitnessLocation)
	populate(objectMap, "fileShareWitnessUsername", d.FileShareWitnessUsername)
	populate(objectMap, "keyVaultSyncStatus", d.KeyVaultSyncStatus)
	populate(objectMap, "resourceKey", d.ResourceKey)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DevicePatch.
func (d DevicePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DeviceProperties.
func (d DeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuredRoleTypes", d.ConfiguredRoleTypes)
	populate(objectMap, "culture", d.Culture)
	populate(objectMap, "dataBoxEdgeDeviceStatus", d.DataBoxEdgeDeviceStatus)
	populate(objectMap, "dataResidency", d.DataResidency)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "deviceHcsVersion", d.DeviceHcsVersion)
	populate(objectMap, "deviceLocalCapacity", d.DeviceLocalCapacity)
	populate(objectMap, "deviceModel", d.DeviceModel)
	populate(objectMap, "deviceSoftwareVersion", d.DeviceSoftwareVersion)
	populate(objectMap, "deviceType", d.DeviceType)
	populate(objectMap, "edgeProfile", d.EdgeProfile)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populate(objectMap, "modelDescription", d.ModelDescription)
	populate(objectMap, "nodeCount", d.NodeCount)
	populate(objectMap, "resourceMoveDetails", d.ResourceMoveDetails)
	populate(objectMap, "serialNumber", d.SerialNumber)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "timeZone", d.TimeZone)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticRemoteSupportSettingsProperties.
func (d DiagnosticRemoteSupportSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "remoteSupportSettingsList", d.RemoteSupportSettingsList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FileEventTrigger.
func (f FileEventTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", f.ID)
	objectMap["kind"] = TriggerEventTypeFileEvent
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileEventTrigger.
func (f *FileEventTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostCapacity.
func (h HostCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availableGpuCount", h.AvailableGpuCount)
	populate(objectMap, "effectiveAvailableMemoryMbOnHost", h.EffectiveAvailableMemoryMbOnHost)
	populate(objectMap, "gpuType", h.GpuType)
	populate(objectMap, "hostName", h.HostName)
	populate(objectMap, "numaNodesData", h.NumaNodesData)
	populate(objectMap, "vmUsedMemory", h.VMUsedMemory)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IoTAddon.
func (i IoTAddon) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	objectMap["kind"] = AddonTypeIotEdge
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTAddon.
func (i *IoTAddon) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTRole.
func (i IoTRole) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	objectMap["kind"] = RoleTypesIOT
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTRole.
func (i *IoTRole) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTRoleProperties.
func (i IoTRoleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "computeResource", i.ComputeResource)
	populate(objectMap, "hostPlatform", i.HostPlatform)
	populate(objectMap, "hostPlatformType", i.HostPlatformType)
	populate(objectMap, "ioTDeviceDetails", i.IoTDeviceDetails)
	populate(objectMap, "ioTEdgeAgentInfo", i.IoTEdgeAgentInfo)
	populate(objectMap, "ioTEdgeDeviceDetails", i.IoTEdgeDeviceDetails)
	populate(objectMap, "roleStatus", i.RoleStatus)
	populate(objectMap, "shareMappings", i.ShareMappings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &j.PercentComplete)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterInfo.
func (k KubernetesClusterInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etcdInfo", k.EtcdInfo)
	populate(objectMap, "nodes", k.Nodes)
	populate(objectMap, "version", k.Version)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesRole.
func (k KubernetesRole) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", k.ID)
	objectMap["kind"] = RoleTypesKubernetes
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "systemData", k.SystemData)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesRole.
func (k *KubernetesRole) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &k.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &k.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesRoleStorage.
func (k KubernetesRoleStorage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endpoints", k.Endpoints)
	populate(objectMap, "storageClasses", k.StorageClasses)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MECRole.
func (m MECRole) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = RoleTypesMEC
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MECRole.
func (m *MECRole) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricConfiguration.
func (m MetricConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "counterSets", m.CounterSets)
	populate(objectMap, "mdmAccount", m.MdmAccount)
	populate(objectMap, "metricNameSpace", m.MetricNameSpace)
	populate(objectMap, "resourceId", m.ResourceID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MetricCounter.
func (m MetricCounter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalDimensions", m.AdditionalDimensions)
	populate(objectMap, "dimensionFilter", m.DimensionFilter)
	populate(objectMap, "instance", m.Instance)
	populate(objectMap, "name", m.Name)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MetricCounterSet.
func (m MetricCounterSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "counters", m.Counters)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MonitoringMetricConfigurationProperties.
func (m MonitoringMetricConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "metricConfigurations", m.MetricConfigurations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkAdapter.
func (n NetworkAdapter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adapterId", n.AdapterID)
	populate(objectMap, "adapterPosition", n.AdapterPosition)
	populate(objectMap, "dnsServers", n.DNSServers)
	populate(objectMap, "dhcpStatus", n.DhcpStatus)
	populate(objectMap, "ipv4Configuration", n.IPv4Configuration)
	populate(objectMap, "ipv6Configuration", n.IPv6Configuration)
	populate(objectMap, "ipv6LinkLocalAddress", n.IPv6LinkLocalAddress)
	populate(objectMap, "index", n.Index)
	populate(objectMap, "label", n.Label)
	populate(objectMap, "linkSpeed", n.LinkSpeed)
	populate(objectMap, "macAddress", n.MacAddress)
	populate(objectMap, "networkAdapterName", n.NetworkAdapterName)
	populate(objectMap, "nodeId", n.NodeID)
	populate(objectMap, "rdmaStatus", n.RdmaStatus)
	populate(objectMap, "status", n.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkSettingsProperties.
func (n NetworkSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkAdapters", n.NetworkAdapters)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NodeInfo.
func (n NodeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ipConfiguration", n.IPConfiguration)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NumaNodeData.
func (n NumaNodeData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "effectiveAvailableMemoryInMb", n.EffectiveAvailableMemoryInMb)
	populate(objectMap, "freeVCpuIndexesForHpn", n.FreeVCPUIndexesForHpn)
	populate(objectMap, "logicalCoreCountPerCore", n.LogicalCoreCountPerCore)
	populate(objectMap, "numaNodeIndex", n.NumaNodeIndex)
	populate(objectMap, "totalMemoryInMb", n.TotalMemoryInMb)
	populate(objectMap, "vCpuIndexesForHpn", n.VCPUIndexesForHpn)
	populate(objectMap, "vCpuIndexesForRoot", n.VCPUIndexesForRoot)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OrderProperties.
func (o OrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contactInformation", o.ContactInformation)
	populate(objectMap, "currentStatus", o.CurrentStatus)
	populate(objectMap, "deliveryTrackingInfo", o.DeliveryTrackingInfo)
	populate(objectMap, "orderHistory", o.OrderHistory)
	populate(objectMap, "orderId", o.OrderID)
	populate(objectMap, "returnTrackingInfo", o.ReturnTrackingInfo)
	populate(objectMap, "serialNumber", o.SerialNumber)
	populate(objectMap, "shipmentType", o.ShipmentType)
	populate(objectMap, "shippingAddress", o.ShippingAddress)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OrderStatus.
func (o OrderStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalOrderDetails", o.AdditionalOrderDetails)
	populate(objectMap, "comments", o.Comments)
	populate(objectMap, "status", o.Status)
	populate(objectMap, "trackingInformation", o.TrackingInformation)
	populateTimeRFC3339(objectMap, "updateDateTime", o.UpdateDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderStatus.
func (o *OrderStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalOrderDetails":
			err = unpopulate(val, "AdditionalOrderDetails", &o.AdditionalOrderDetails)
			delete(rawMsg, key)
		case "comments":
			err = unpopulate(val, "Comments", &o.Comments)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		case "trackingInformation":
			err = unpopulate(val, "TrackingInformation", &o.TrackingInformation)
			delete(rawMsg, key)
		case "updateDateTime":
			err = unpopulateTimeRFC3339(val, "UpdateDateTime", &o.UpdateDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PeriodicTimerEventTrigger.
func (p PeriodicTimerEventTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	objectMap["kind"] = TriggerEventTypePeriodicTimerEvent
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PeriodicTimerEventTrigger.
func (p *PeriodicTimerEventTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PeriodicTimerSourceInfo.
func (p PeriodicTimerSourceInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "schedule", p.Schedule)
	populateTimeRFC3339(objectMap, "startTime", p.StartTime)
	populate(objectMap, "topic", p.Topic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PeriodicTimerSourceInfo.
func (p *PeriodicTimerSourceInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schedule":
			err = unpopulate(val, "Schedule", &p.Schedule)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "topic":
			err = unpopulate(val, "Topic", &p.Topic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefreshDetails.
func (r RefreshDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorManifestFile", r.ErrorManifestFile)
	populate(objectMap, "inProgressRefreshJobId", r.InProgressRefreshJobID)
	populateTimeRFC3339(objectMap, "lastCompletedRefreshJobTimeInUTC", r.LastCompletedRefreshJobTimeInUTC)
	populate(objectMap, "lastJob", r.LastJob)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefreshDetails.
func (r *RefreshDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorManifestFile":
			err = unpopulate(val, "ErrorManifestFile", &r.ErrorManifestFile)
			delete(rawMsg, key)
		case "inProgressRefreshJobId":
			err = unpopulate(val, "InProgressRefreshJobID", &r.InProgressRefreshJobID)
			delete(rawMsg, key)
		case "lastCompletedRefreshJobTimeInUTC":
			err = unpopulateTimeRFC3339(val, "LastCompletedRefreshJobTimeInUTC", &r.LastCompletedRefreshJobTimeInUTC)
			delete(rawMsg, key)
		case "lastJob":
			err = unpopulate(val, "LastJob", &r.LastJob)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoteSupportSettings.
func (r RemoteSupportSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessLevel", r.AccessLevel)
	populateTimeRFC3339(objectMap, "expirationTimeStampInUTC", r.ExpirationTimeStampInUTC)
	populate(objectMap, "remoteApplicationType", r.RemoteApplicationType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoteSupportSettings.
func (r *RemoteSupportSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessLevel":
			err = unpopulate(val, "AccessLevel", &r.AccessLevel)
			delete(rawMsg, key)
		case "expirationTimeStampInUTC":
			err = unpopulateTimeRFC3339(val, "ExpirationTimeStampInUTC", &r.ExpirationTimeStampInUTC)
			delete(rawMsg, key)
		case "remoteApplicationType":
			err = unpopulate(val, "RemoteApplicationType", &r.RemoteApplicationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMoveDetails.
func (r ResourceMoveDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operationInProgress", r.OperationInProgress)
	populateTimeRFC3339(objectMap, "operationInProgressLockTimeoutInUTC", r.OperationInProgressLockTimeoutInUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMoveDetails.
func (r *ResourceMoveDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationInProgress":
			err = unpopulate(val, "OperationInProgress", &r.OperationInProgress)
			delete(rawMsg, key)
		case "operationInProgressLockTimeoutInUTC":
			err = unpopulateTimeRFC3339(val, "OperationInProgressLockTimeoutInUTC", &r.OperationInProgressLockTimeoutInUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleList.
func (r *RoleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			r.Value, err = unmarshalRoleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShareProperties.
func (s ShareProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessProtocol", s.AccessProtocol)
	populate(objectMap, "azureContainerInfo", s.AzureContainerInfo)
	populate(objectMap, "clientAccessRights", s.ClientAccessRights)
	populate(objectMap, "dataPolicy", s.DataPolicy)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "monitoringStatus", s.MonitoringStatus)
	populate(objectMap, "refreshDetails", s.RefreshDetails)
	populate(objectMap, "shareMappings", s.ShareMappings)
	populate(objectMap, "shareStatus", s.ShareStatus)
	populate(objectMap, "userAccessRights", s.UserAccessRights)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionProperties.
func (s SubscriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "locationPlacementId", s.LocationPlacementID)
	populate(objectMap, "quotaId", s.QuotaID)
	populate(objectMap, "registeredFeatures", s.RegisteredFeatures)
	populate(objectMap, "serializedDetails", s.SerializedDetails)
	populate(objectMap, "tenantId", s.TenantID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SupportPackageRequestProperties.
func (s SupportPackageRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "include", s.Include)
	populateTimeRFC3339(objectMap, "maximumTimeStamp", s.MaximumTimeStamp)
	populateTimeRFC3339(objectMap, "minimumTimeStamp", s.MinimumTimeStamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportPackageRequestProperties.
func (s *SupportPackageRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "include":
			err = unpopulate(val, "Include", &s.Include)
			delete(rawMsg, key)
		case "maximumTimeStamp":
			err = unpopulateTimeRFC3339(val, "MaximumTimeStamp", &s.MaximumTimeStamp)
			delete(rawMsg, key)
		case "minimumTimeStamp":
			err = unpopulateTimeRFC3339(val, "MinimumTimeStamp", &s.MinimumTimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggerList.
func (t *TriggerList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			t.Value, err = unmarshalTriggerClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateSummaryProperties.
func (u UpdateSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "deviceLastScannedDateTime", u.DeviceLastScannedDateTime)
	populate(objectMap, "deviceVersionNumber", u.DeviceVersionNumber)
	populate(objectMap, "friendlyDeviceVersionName", u.FriendlyDeviceVersionName)
	populate(objectMap, "inProgressDownloadJobId", u.InProgressDownloadJobID)
	populateTimeRFC3339(objectMap, "inProgressDownloadJobStartedDateTime", u.InProgressDownloadJobStartedDateTime)
	populate(objectMap, "inProgressInstallJobId", u.InProgressInstallJobID)
	populateTimeRFC3339(objectMap, "inProgressInstallJobStartedDateTime", u.InProgressInstallJobStartedDateTime)
	populateTimeRFC3339(objectMap, "lastCompletedDownloadJobDateTime", u.LastCompletedDownloadJobDateTime)
	populate(objectMap, "lastCompletedDownloadJobId", u.LastCompletedDownloadJobID)
	populateTimeRFC3339(objectMap, "lastCompletedInstallJobDateTime", u.LastCompletedInstallJobDateTime)
	populate(objectMap, "lastCompletedInstallJobId", u.LastCompletedInstallJobID)
	populateTimeRFC3339(objectMap, "lastCompletedScanJobDateTime", u.LastCompletedScanJobDateTime)
	populate(objectMap, "lastDownloadJobStatus", u.LastDownloadJobStatus)
	populate(objectMap, "lastInstallJobStatus", u.LastInstallJobStatus)
	populateTimeRFC3339(objectMap, "lastSuccessfulInstallJobDateTime", u.LastSuccessfulInstallJobDateTime)
	populateTimeRFC3339(objectMap, "lastSuccessfulScanJobTime", u.LastSuccessfulScanJobTime)
	populate(objectMap, "ongoingUpdateOperation", u.OngoingUpdateOperation)
	populate(objectMap, "rebootBehavior", u.RebootBehavior)
	populate(objectMap, "totalNumberOfUpdatesAvailable", u.TotalNumberOfUpdatesAvailable)
	populate(objectMap, "totalNumberOfUpdatesPendingDownload", u.TotalNumberOfUpdatesPendingDownload)
	populate(objectMap, "totalNumberOfUpdatesPendingInstall", u.TotalNumberOfUpdatesPendingInstall)
	populate(objectMap, "totalTimeInMinutes", u.TotalTimeInMinutes)
	populate(objectMap, "totalUpdateSizeInBytes", u.TotalUpdateSizeInBytes)
	populate(objectMap, "updateTitles", u.UpdateTitles)
	populate(objectMap, "updates", u.Updates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateSummaryProperties.
func (u *UpdateSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceLastScannedDateTime":
			err = unpopulateTimeRFC3339(val, "DeviceLastScannedDateTime", &u.DeviceLastScannedDateTime)
			delete(rawMsg, key)
		case "deviceVersionNumber":
			err = unpopulate(val, "DeviceVersionNumber", &u.DeviceVersionNumber)
			delete(rawMsg, key)
		case "friendlyDeviceVersionName":
			err = unpopulate(val, "FriendlyDeviceVersionName", &u.FriendlyDeviceVersionName)
			delete(rawMsg, key)
		case "inProgressDownloadJobId":
			err = unpopulate(val, "InProgressDownloadJobID", &u.InProgressDownloadJobID)
			delete(rawMsg, key)
		case "inProgressDownloadJobStartedDateTime":
			err = unpopulateTimeRFC3339(val, "InProgressDownloadJobStartedDateTime", &u.InProgressDownloadJobStartedDateTime)
			delete(rawMsg, key)
		case "inProgressInstallJobId":
			err = unpopulate(val, "InProgressInstallJobID", &u.InProgressInstallJobID)
			delete(rawMsg, key)
		case "inProgressInstallJobStartedDateTime":
			err = unpopulateTimeRFC3339(val, "InProgressInstallJobStartedDateTime", &u.InProgressInstallJobStartedDateTime)
			delete(rawMsg, key)
		case "lastCompletedDownloadJobDateTime":
			err = unpopulateTimeRFC3339(val, "LastCompletedDownloadJobDateTime", &u.LastCompletedDownloadJobDateTime)
			delete(rawMsg, key)
		case "lastCompletedDownloadJobId":
			err = unpopulate(val, "LastCompletedDownloadJobID", &u.LastCompletedDownloadJobID)
			delete(rawMsg, key)
		case "lastCompletedInstallJobDateTime":
			err = unpopulateTimeRFC3339(val, "LastCompletedInstallJobDateTime", &u.LastCompletedInstallJobDateTime)
			delete(rawMsg, key)
		case "lastCompletedInstallJobId":
			err = unpopulate(val, "LastCompletedInstallJobID", &u.LastCompletedInstallJobID)
			delete(rawMsg, key)
		case "lastCompletedScanJobDateTime":
			err = unpopulateTimeRFC3339(val, "LastCompletedScanJobDateTime", &u.LastCompletedScanJobDateTime)
			delete(rawMsg, key)
		case "lastDownloadJobStatus":
			err = unpopulate(val, "LastDownloadJobStatus", &u.LastDownloadJobStatus)
			delete(rawMsg, key)
		case "lastInstallJobStatus":
			err = unpopulate(val, "LastInstallJobStatus", &u.LastInstallJobStatus)
			delete(rawMsg, key)
		case "lastSuccessfulInstallJobDateTime":
			err = unpopulateTimeRFC3339(val, "LastSuccessfulInstallJobDateTime", &u.LastSuccessfulInstallJobDateTime)
			delete(rawMsg, key)
		case "lastSuccessfulScanJobTime":
			err = unpopulateTimeRFC3339(val, "LastSuccessfulScanJobTime", &u.LastSuccessfulScanJobTime)
			delete(rawMsg, key)
		case "ongoingUpdateOperation":
			err = unpopulate(val, "OngoingUpdateOperation", &u.OngoingUpdateOperation)
			delete(rawMsg, key)
		case "rebootBehavior":
			err = unpopulate(val, "RebootBehavior", &u.RebootBehavior)
			delete(rawMsg, key)
		case "totalNumberOfUpdatesAvailable":
			err = unpopulate(val, "TotalNumberOfUpdatesAvailable", &u.TotalNumberOfUpdatesAvailable)
			delete(rawMsg, key)
		case "totalNumberOfUpdatesPendingDownload":
			err = unpopulate(val, "TotalNumberOfUpdatesPendingDownload", &u.TotalNumberOfUpdatesPendingDownload)
			delete(rawMsg, key)
		case "totalNumberOfUpdatesPendingInstall":
			err = unpopulate(val, "TotalNumberOfUpdatesPendingInstall", &u.TotalNumberOfUpdatesPendingInstall)
			delete(rawMsg, key)
		case "totalTimeInMinutes":
			err = unpopulate(val, "TotalTimeInMinutes", &u.TotalTimeInMinutes)
			delete(rawMsg, key)
		case "totalUpdateSizeInBytes":
			err = unpopulate(val, "TotalUpdateSizeInBytes", &u.TotalUpdateSizeInBytes)
			delete(rawMsg, key)
		case "updateTitles":
			err = unpopulate(val, "UpdateTitles", &u.UpdateTitles)
			delete(rawMsg, key)
		case "updates":
			err = unpopulate(val, "Updates", &u.Updates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserProperties.
func (u UserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryptedPassword", u.EncryptedPassword)
	populate(objectMap, "shareAccessRights", u.ShareAccessRights)
	populate(objectMap, "userType", u.UserType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VMPlacementRequestResult.
func (v VMPlacementRequestResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isFeasible", v.IsFeasible)
	populate(objectMap, "message", v.Message)
	populate(objectMap, "messageCode", v.MessageCode)
	populate(objectMap, "vmSize", v.VMSize)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
