//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetworkfunction

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AzureTrafficCollectorsBySubscriptionClient contains the methods for the AzureTrafficCollectorsBySubscription group.
// Don't use this type directly, use NewAzureTrafficCollectorsBySubscriptionClient() instead.
type AzureTrafficCollectorsBySubscriptionClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewAzureTrafficCollectorsBySubscriptionClient creates a new instance of AzureTrafficCollectorsBySubscriptionClient with the specified values.
// subscriptionID - Azure Subscription ID.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAzureTrafficCollectorsBySubscriptionClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AzureTrafficCollectorsBySubscriptionClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AzureTrafficCollectorsBySubscriptionClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// NewListPager - Return list of Azure Traffic Collectors in a subscription
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-05-01
// options - AzureTrafficCollectorsBySubscriptionClientListOptions contains the optional parameters for the AzureTrafficCollectorsBySubscriptionClient.List
// method.
func (client *AzureTrafficCollectorsBySubscriptionClient) NewListPager(options *AzureTrafficCollectorsBySubscriptionClientListOptions) *runtime.Pager[AzureTrafficCollectorsBySubscriptionClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureTrafficCollectorsBySubscriptionClientListResponse]{
		More: func(page AzureTrafficCollectorsBySubscriptionClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureTrafficCollectorsBySubscriptionClientListResponse) (AzureTrafficCollectorsBySubscriptionClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return AzureTrafficCollectorsBySubscriptionClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AzureTrafficCollectorsBySubscriptionClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AzureTrafficCollectorsBySubscriptionClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *AzureTrafficCollectorsBySubscriptionClient) listCreateRequest(ctx context.Context, options *AzureTrafficCollectorsBySubscriptionClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.NetworkFunction/azureTrafficCollectors"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *AzureTrafficCollectorsBySubscriptionClient) listHandleResponse(resp *http.Response) (AzureTrafficCollectorsBySubscriptionClientListResponse, error) {
	result := AzureTrafficCollectorsBySubscriptionClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureTrafficCollectorListResult); err != nil {
		return AzureTrafficCollectorsBySubscriptionClientListResponse{}, err
	}
	return result, nil
}
