//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicy

import "time"

// Alias - The alias type.
type Alias struct {
	// The default path for an alias.
	DefaultPath *string `json:"defaultPath,omitempty"`

	// The default pattern for an alias.
	DefaultPattern *AliasPattern `json:"defaultPattern,omitempty"`

	// The alias name.
	Name *string `json:"name,omitempty"`

	// The paths for an alias.
	Paths []*AliasPath `json:"paths,omitempty"`

	// The type of the alias.
	Type *AliasType `json:"type,omitempty"`

	// READ-ONLY; The default alias path metadata. Applies to the default path and to any alias path that doesn't have metadata
	DefaultMetadata *AliasPathMetadata `json:"defaultMetadata,omitempty" azure:"ro"`
}

// AliasPath - The type of the paths for alias.
type AliasPath struct {
	// The API versions.
	APIVersions []*string `json:"apiVersions,omitempty"`

	// The path of an alias.
	Path *string `json:"path,omitempty"`

	// The pattern for an alias path.
	Pattern *AliasPattern `json:"pattern,omitempty"`

	// READ-ONLY; The metadata of the alias path. If missing, fall back to the default metadata of the alias.
	Metadata *AliasPathMetadata `json:"metadata,omitempty" azure:"ro"`
}

type AliasPathMetadata struct {
	// READ-ONLY; The attributes of the token that the alias path is referring to.
	Attributes *AliasPathAttributes `json:"attributes,omitempty" azure:"ro"`

	// READ-ONLY; The type of the token that the alias path is referring to.
	Type *AliasPathTokenType `json:"type,omitempty" azure:"ro"`
}

// AliasPattern - The type of the pattern for an alias path.
type AliasPattern struct {
	// The alias pattern phrase.
	Phrase *string `json:"phrase,omitempty"`

	// The type of alias pattern
	Type *AliasPatternType `json:"type,omitempty"`

	// The alias pattern variable.
	Variable *string `json:"variable,omitempty"`
}

// Assignment - The policy assignment.
type Assignment struct {
	// The managed identity associated with the policy assignment.
	Identity *Identity `json:"identity,omitempty"`

	// The location of the policy assignment. Only required when utilizing managed identity.
	Location *string `json:"location,omitempty"`

	// Properties for the policy assignment.
	Properties *AssignmentProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the policy assignment.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the policy assignment.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the policy assignment.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AssignmentListResult - List of policy assignments.
type AssignmentListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of policy assignments.
	Value []*Assignment `json:"value,omitempty"`
}

// AssignmentProperties - The policy assignment properties.
type AssignmentProperties struct {
	// This message will be part of response in case of policy violation.
	Description *string `json:"description,omitempty"`

	// The display name of the policy assignment.
	DisplayName *string `json:"displayName,omitempty"`

	// The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
	EnforcementMode *EnforcementMode `json:"enforcementMode,omitempty"`

	// The policy assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
	Metadata interface{} `json:"metadata,omitempty"`

	// The messages that describe why a resource is non-compliant with the policy.
	NonComplianceMessages []*NonComplianceMessage `json:"nonComplianceMessages,omitempty"`

	// The policy's excluded scopes.
	NotScopes []*string `json:"notScopes,omitempty"`

	// The parameter values for the assigned policy rule. The keys are the parameter names.
	Parameters map[string]*ParameterValuesValue `json:"parameters,omitempty"`

	// The ID of the policy definition or policy set definition being assigned.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`

	// READ-ONLY; The scope for the policy assignment.
	Scope *string `json:"scope,omitempty" azure:"ro"`
}

type AssignmentUpdate struct {
	// The managed identity associated with the policy assignment.
	Identity *Identity `json:"identity,omitempty"`

	// The location of the policy assignment. Only required when utilizing managed identity.
	Location *string `json:"location,omitempty"`
}

// AssignmentsClientCreateByIDOptions contains the optional parameters for the AssignmentsClient.CreateByID method.
type AssignmentsClientCreateByIDOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientCreateOptions contains the optional parameters for the AssignmentsClient.Create method.
type AssignmentsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientDeleteByIDOptions contains the optional parameters for the AssignmentsClient.DeleteByID method.
type AssignmentsClientDeleteByIDOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientDeleteOptions contains the optional parameters for the AssignmentsClient.Delete method.
type AssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientGetByIDOptions contains the optional parameters for the AssignmentsClient.GetByID method.
type AssignmentsClientGetByIDOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientGetOptions contains the optional parameters for the AssignmentsClient.Get method.
type AssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientListForManagementGroupOptions contains the optional parameters for the AssignmentsClient.ListForManagementGroup
// method.
type AssignmentsClientListForManagementGroupOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()' or 'policyDefinitionId
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atScope() is provided, the returned list only includes all policy assignments that apply to the scope, which is
	// everything in the unfiltered list except those applied to sub scopes contained
	// within the given scope. If $filter=atExactScope() is provided, the returned list only includes all policy assignments that
	// at the given scope. If $filter=policyDefinitionId eq '{value}' is provided,
	// the returned list includes all policy assignments of the policy definition whose id is {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// AssignmentsClientListForResourceGroupOptions contains the optional parameters for the AssignmentsClient.ListForResourceGroup
// method.
type AssignmentsClientListForResourceGroupOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()' or 'policyDefinitionId
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atScope() is provided, the returned list only includes all policy assignments that apply to the scope, which is
	// everything in the unfiltered list except those applied to sub scopes contained
	// within the given scope. If $filter=atExactScope() is provided, the returned list only includes all policy assignments that
	// at the given scope. If $filter=policyDefinitionId eq '{value}' is provided,
	// the returned list includes all policy assignments of the policy definition whose id is {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// AssignmentsClientListForResourceOptions contains the optional parameters for the AssignmentsClient.ListForResource method.
type AssignmentsClientListForResourceOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()' or 'policyDefinitionId
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atScope() is provided, the returned list only includes all policy assignments that apply to the scope, which is
	// everything in the unfiltered list except those applied to sub scopes contained
	// within the given scope. If $filter=atExactScope() is provided, the returned list only includes all policy assignments that
	// at the given scope. If $filter=policyDefinitionId eq '{value}' is provided,
	// the returned list includes all policy assignments of the policy definition whose id is {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// AssignmentsClientListOptions contains the optional parameters for the AssignmentsClient.List method.
type AssignmentsClientListOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()' or 'policyDefinitionId
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atScope() is provided, the returned list only includes all policy assignments that apply to the scope, which is
	// everything in the unfiltered list except those applied to sub scopes contained
	// within the given scope. If $filter=atExactScope() is provided, the returned list only includes all policy assignments that
	// at the given scope. If $filter=policyDefinitionId eq '{value}' is provided,
	// the returned list includes all policy assignments of the policy definition whose id is {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// AssignmentsClientUpdateByIDOptions contains the optional parameters for the AssignmentsClient.UpdateByID method.
type AssignmentsClientUpdateByIDOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientUpdateOptions contains the optional parameters for the AssignmentsClient.Update method.
type AssignmentsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CloudError - An error response from a policy operation.
type CloudError struct {
	// Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows
	// the OData error response format.)
	Error *ErrorResponse `json:"error,omitempty"`
}

// DataEffect - The data effect definition.
type DataEffect struct {
	// The data effect details schema.
	DetailsSchema interface{} `json:"detailsSchema,omitempty"`

	// The data effect name.
	Name *string `json:"name,omitempty"`
}

// DataManifestCustomResourceFunctionDefinition - The custom resource function definition.
type DataManifestCustomResourceFunctionDefinition struct {
	// A value indicating whether the custom properties within the property bag are allowed. Needs api-version to be specified
	// in the policy rule eg - vault('2019-06-01').
	AllowCustomProperties *bool `json:"allowCustomProperties,omitempty"`

	// The top-level properties that can be selected on the function's output. eg - [ "name", "location" ] if vault().name and
	// vault().location are supported
	DefaultProperties []*string `json:"defaultProperties,omitempty"`

	// The fully qualified control plane resource type that this function represents. eg - 'Microsoft.KeyVault/vaults'.
	FullyQualifiedResourceType *string `json:"fullyQualifiedResourceType,omitempty"`

	// The function name as it will appear in the policy rule. eg - 'vault'.
	Name *string `json:"name,omitempty"`
}

// DataManifestResourceFunctionsDefinition - The resource functions supported by a manifest
type DataManifestResourceFunctionsDefinition struct {
	// An array of data manifest custom resource definition.
	Custom []*DataManifestCustomResourceFunctionDefinition `json:"custom,omitempty"`

	// The standard resource functions (subscription and/or resourceGroup).
	Standard []*string `json:"standard,omitempty"`
}

// DataPolicyManifest - The data policy manifest.
type DataPolicyManifest struct {
	// The data policy manifest properties.
	Properties *DataPolicyManifestProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the data policy manifest.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the data policy manifest (it's the same as the Policy Mode).
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource (Microsoft.Authorization/dataPolicyManifests).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataPolicyManifestListResult - List of data policy manifests.
type DataPolicyManifestListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of data policy manifests.
	Value []*DataPolicyManifest `json:"value,omitempty"`
}

// DataPolicyManifestProperties - The properties of the data policy manifest.
type DataPolicyManifestProperties struct {
	// The effect definition.
	Effects []*DataEffect `json:"effects,omitempty"`

	// The non-alias field accessor values that can be used in the policy rule.
	FieldValues []*string `json:"fieldValues,omitempty"`

	// A value indicating whether policy mode is allowed only in built-in definitions.
	IsBuiltInOnly *bool `json:"isBuiltInOnly,omitempty"`

	// The list of namespaces for the data policy manifest.
	Namespaces []*string `json:"namespaces,omitempty"`

	// The policy mode of the data policy manifest.
	PolicyMode *string `json:"policyMode,omitempty"`

	// The resource functions definition specified in the data manifest.
	ResourceFunctions *DataManifestResourceFunctionsDefinition `json:"resourceFunctions,omitempty"`

	// An array of resource type aliases.
	ResourceTypeAliases []*ResourceTypeAliases `json:"resourceTypeAliases,omitempty"`
}

// DataPolicyManifestsClientGetByPolicyModeOptions contains the optional parameters for the DataPolicyManifestsClient.GetByPolicyMode
// method.
type DataPolicyManifestsClientGetByPolicyModeOptions struct {
	// placeholder for future optional parameters
}

// DataPolicyManifestsClientListOptions contains the optional parameters for the DataPolicyManifestsClient.List method.
type DataPolicyManifestsClientListOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: "namespace eq '{value}'". If $filter is not provided,
	// no filtering is performed. If $filter=namespace eq '{value}' is provided, the
	// returned list only includes all data policy manifests that have a namespace matching the provided value.
	Filter *string
}

// Definition - The policy definition.
type Definition struct {
	// The policy definition properties.
	Properties *DefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the policy definition.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the policy definition.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource (Microsoft.Authorization/policyDefinitions).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DefinitionGroup - The policy definition group.
type DefinitionGroup struct {
	// REQUIRED; The name of the group.
	Name *string `json:"name,omitempty"`

	// A resource ID of a resource that contains additional metadata about the group.
	AdditionalMetadataID *string `json:"additionalMetadataId,omitempty"`

	// The group's category.
	Category *string `json:"category,omitempty"`

	// The group's description.
	Description *string `json:"description,omitempty"`

	// The group's display name.
	DisplayName *string `json:"displayName,omitempty"`
}

// DefinitionListResult - List of policy definitions.
type DefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of policy definitions.
	Value []*Definition `json:"value,omitempty"`
}

// DefinitionProperties - The policy definition properties.
type DefinitionProperties struct {
	// The policy definition description.
	Description *string `json:"description,omitempty"`

	// The display name of the policy definition.
	DisplayName *string `json:"displayName,omitempty"`

	// The policy definition metadata. Metadata is an open ended object and is typically a collection of key value pairs.
	Metadata interface{} `json:"metadata,omitempty"`

	// The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
	Mode *string `json:"mode,omitempty"`

	// The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
	Parameters map[string]*ParameterDefinitionsValue `json:"parameters,omitempty"`

	// The policy rule.
	PolicyRule interface{} `json:"policyRule,omitempty"`

	// The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
	PolicyType *PolicyType `json:"policyType,omitempty"`
}

// DefinitionReference - The policy definition reference.
type DefinitionReference struct {
	// REQUIRED; The ID of the policy definition or policy set definition.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`

	// The name of the groups that this policy definition reference belongs to.
	GroupNames []*string `json:"groupNames,omitempty"`

	// The parameter values for the referenced policy rule. The keys are the parameter names.
	Parameters map[string]*ParameterValuesValue `json:"parameters,omitempty"`

	// A unique id (within the policy set definition) for this policy definition reference.
	PolicyDefinitionReferenceID *string `json:"policyDefinitionReferenceId,omitempty"`
}

// DefinitionsClientCreateOrUpdateAtManagementGroupOptions contains the optional parameters for the DefinitionsClient.CreateOrUpdateAtManagementGroup
// method.
type DefinitionsClientCreateOrUpdateAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientCreateOrUpdateOptions contains the optional parameters for the DefinitionsClient.CreateOrUpdate method.
type DefinitionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientDeleteAtManagementGroupOptions contains the optional parameters for the DefinitionsClient.DeleteAtManagementGroup
// method.
type DefinitionsClientDeleteAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientDeleteOptions contains the optional parameters for the DefinitionsClient.Delete method.
type DefinitionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientGetAtManagementGroupOptions contains the optional parameters for the DefinitionsClient.GetAtManagementGroup
// method.
type DefinitionsClientGetAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientGetBuiltInOptions contains the optional parameters for the DefinitionsClient.GetBuiltIn method.
type DefinitionsClientGetBuiltInOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientGetOptions contains the optional parameters for the DefinitionsClient.Get method.
type DefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientListBuiltInOptions contains the optional parameters for the DefinitionsClient.ListBuiltIn method.
type DefinitionsClientListBuiltInOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atExactScope() is provided, the returned list only includes all policy definitions that at the given scope. If
	// $filter='policyType -eq {value}' is provided, the returned list only includes all
	// policy definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and Static.
	// If $filter='category -eq {value}' is provided, the returned list only
	// includes all policy definitions whose category match the {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// DefinitionsClientListByManagementGroupOptions contains the optional parameters for the DefinitionsClient.ListByManagementGroup
// method.
type DefinitionsClientListByManagementGroupOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atExactScope() is provided, the returned list only includes all policy definitions that at the given scope. If
	// $filter='policyType -eq {value}' is provided, the returned list only includes all
	// policy definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and Static.
	// If $filter='category -eq {value}' is provided, the returned list only
	// includes all policy definitions whose category match the {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// DefinitionsClientListOptions contains the optional parameters for the DefinitionsClient.List method.
type DefinitionsClientListOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atExactScope() is provided, the returned list only includes all policy definitions that at the given scope. If
	// $filter='policyType -eq {value}' is provided, the returned list only includes all
	// policy definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and Static.
	// If $filter='category -eq {value}' is provided, the returned list only
	// includes all policy definitions whose category match the {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponse `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// Exemption - The policy exemption.
type Exemption struct {
	// REQUIRED; Properties for the policy exemption.
	Properties *ExemptionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the policy exemption.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the policy exemption.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource (Microsoft.Authorization/policyExemptions).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExemptionListResult - List of policy exemptions.
type ExemptionListResult struct {
	// An array of policy exemptions.
	Value []*Exemption `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ExemptionProperties - The policy exemption properties.
type ExemptionProperties struct {
	// REQUIRED; The policy exemption category. Possible values are Waiver and Mitigated.
	ExemptionCategory *ExemptionCategory `json:"exemptionCategory,omitempty"`

	// REQUIRED; The ID of the policy assignment that is being exempted.
	PolicyAssignmentID *string `json:"policyAssignmentId,omitempty"`

	// The description of the policy exemption.
	Description *string `json:"description,omitempty"`

	// The display name of the policy exemption.
	DisplayName *string `json:"displayName,omitempty"`

	// The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of the policy exemption.
	ExpiresOn *time.Time `json:"expiresOn,omitempty"`

	// The policy exemption metadata. Metadata is an open ended object and is typically a collection of key value pairs.
	Metadata interface{} `json:"metadata,omitempty"`

	// The policy definition reference ID list when the associated policy assignment is an assignment of a policy set definition.
	PolicyDefinitionReferenceIDs []*string `json:"policyDefinitionReferenceIds,omitempty"`
}

// ExemptionsClientCreateOrUpdateOptions contains the optional parameters for the ExemptionsClient.CreateOrUpdate method.
type ExemptionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ExemptionsClientDeleteOptions contains the optional parameters for the ExemptionsClient.Delete method.
type ExemptionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ExemptionsClientGetOptions contains the optional parameters for the ExemptionsClient.Get method.
type ExemptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExemptionsClientListForManagementGroupOptions contains the optional parameters for the ExemptionsClient.ListForManagementGroup
// method.
type ExemptionsClientListForManagementGroupOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
	// 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is
	// performed. If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope, including
	// those that apply directly or apply from containing scopes. If
	// $filter=atScope() is provided, the returned list only includes all policy exemptions that apply to the scope, which is
	// everything in the unfiltered list except those applied to sub scopes contained
	// within the given scope. If $filter=atExactScope() is provided, the returned list only includes all policy exemptions that
	// at the given scope. If $filter=excludeExpired() is provided, the returned list
	// only includes all policy exemptions that either haven't expired or didn't set expiration date. If $filter=policyAssignmentId
	// eq '{value}' is provided. the returned list only includes all policy
	// exemptions that are associated with the give policyAssignmentId.
	Filter *string
}

// ExemptionsClientListForResourceGroupOptions contains the optional parameters for the ExemptionsClient.ListForResourceGroup
// method.
type ExemptionsClientListForResourceGroupOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
	// 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is
	// performed. If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope, including
	// those that apply directly or apply from containing scopes. If
	// $filter=atScope() is provided, the returned list only includes all policy exemptions that apply to the scope, which is
	// everything in the unfiltered list except those applied to sub scopes contained
	// within the given scope. If $filter=atExactScope() is provided, the returned list only includes all policy exemptions that
	// at the given scope. If $filter=excludeExpired() is provided, the returned list
	// only includes all policy exemptions that either haven't expired or didn't set expiration date. If $filter=policyAssignmentId
	// eq '{value}' is provided. the returned list only includes all policy
	// exemptions that are associated with the give policyAssignmentId.
	Filter *string
}

// ExemptionsClientListForResourceOptions contains the optional parameters for the ExemptionsClient.ListForResource method.
type ExemptionsClientListForResourceOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
	// 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is
	// performed. If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope, including
	// those that apply directly or apply from containing scopes. If
	// $filter=atScope() is provided, the returned list only includes all policy exemptions that apply to the scope, which is
	// everything in the unfiltered list except those applied to sub scopes contained
	// within the given scope. If $filter=atExactScope() is provided, the returned list only includes all policy exemptions that
	// at the given scope. If $filter=excludeExpired() is provided, the returned list
	// only includes all policy exemptions that either haven't expired or didn't set expiration date. If $filter=policyAssignmentId
	// eq '{value}' is provided. the returned list only includes all policy
	// exemptions that are associated with the give policyAssignmentId.
	Filter *string
}

// ExemptionsClientListOptions contains the optional parameters for the ExemptionsClient.List method.
type ExemptionsClientListOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
	// 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is
	// performed. If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope, including
	// those that apply directly or apply from containing scopes. If
	// $filter=atScope() is provided, the returned list only includes all policy exemptions that apply to the scope, which is
	// everything in the unfiltered list except those applied to sub scopes contained
	// within the given scope. If $filter=atExactScope() is provided, the returned list only includes all policy exemptions that
	// at the given scope. If $filter=excludeExpired() is provided, the returned list
	// only includes all policy exemptions that either haven't expired or didn't set expiration date. If $filter=policyAssignmentId
	// eq '{value}' is provided. the returned list only includes all policy
	// exemptions that are associated with the give policyAssignmentId.
	Filter *string
}

// Identity for the resource. Policy assignments support a maximum of one identity. That is either a system assigned identity
// or a single user assigned identity.
type Identity struct {
	// The identity type. This is the only required field when adding a system or user assigned identity to a resource.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The user identity associated with the policy. The user identity dictionary key references will be ARM resource ids in the
	// form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of the resource identity. This property will only be provided for a system assigned identity
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the resource identity. This property will only be provided for a system assigned identity
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// NonComplianceMessage - A message that describes why a resource is non-compliant with the policy. This is shown in 'deny'
// error messages and on resource's non-compliant compliance results.
type NonComplianceMessage struct {
	// REQUIRED; A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages
	// and on resource's non-compliant compliance results.
	Message *string `json:"message,omitempty"`

	// The policy definition reference ID within a policy set definition the message is intended for. This is only applicable
	// if the policy assignment assigns a policy set definition. If this is not provided
	// the message applies to all policies assigned by this policy assignment.
	PolicyDefinitionReferenceID *string `json:"policyDefinitionReferenceId,omitempty"`
}

// ParameterDefinitionsValue - The definition of a parameter that can be provided to the policy.
type ParameterDefinitionsValue struct {
	// The allowed values for the parameter.
	AllowedValues []interface{} `json:"allowedValues,omitempty"`

	// The default value for the parameter if no value is provided.
	DefaultValue interface{} `json:"defaultValue,omitempty"`

	// General metadata for the parameter.
	Metadata *ParameterDefinitionsValueMetadata `json:"metadata,omitempty"`

	// The data type of the parameter.
	Type *ParameterType `json:"type,omitempty"`
}

// ParameterDefinitionsValueMetadata - General metadata for the parameter.
type ParameterDefinitionsValueMetadata struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this parameter during
	// policy assignment. This property is useful in case you wish to assign
	// permissions outside the assignment scope.
	AssignPermissions *bool `json:"assignPermissions,omitempty"`

	// The description of the parameter.
	Description *string `json:"description,omitempty"`

	// The display name for the parameter.
	DisplayName *string `json:"displayName,omitempty"`

	// Used when assigning the policy definition through the portal. Provides a context aware list of values for the user to choose
	// from.
	StrongType *string `json:"strongType,omitempty"`
}

// ParameterValuesValue - The value of a parameter.
type ParameterValuesValue struct {
	// The value of the parameter.
	Value interface{} `json:"value,omitempty"`
}

// ResourceTypeAliases - The resource type aliases definition.
type ResourceTypeAliases struct {
	// The aliases for property names.
	Aliases []*Alias `json:"aliases,omitempty"`

	// The resource type name.
	ResourceType *string `json:"resourceType,omitempty"`
}

// SetDefinition - The policy set definition.
type SetDefinition struct {
	// The policy definition properties.
	Properties *SetDefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the policy set definition.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the policy set definition.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource (Microsoft.Authorization/policySetDefinitions).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SetDefinitionListResult - List of policy set definitions.
type SetDefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of policy set definitions.
	Value []*SetDefinition `json:"value,omitempty"`
}

// SetDefinitionProperties - The policy set definition properties.
type SetDefinitionProperties struct {
	// REQUIRED; An array of policy definition references.
	PolicyDefinitions []*DefinitionReference `json:"policyDefinitions,omitempty"`

	// The policy set definition description.
	Description *string `json:"description,omitempty"`

	// The display name of the policy set definition.
	DisplayName *string `json:"displayName,omitempty"`

	// The policy set definition metadata. Metadata is an open ended object and is typically a collection of key value pairs.
	Metadata interface{} `json:"metadata,omitempty"`

	// The policy set definition parameters that can be used in policy definition references.
	Parameters map[string]*ParameterDefinitionsValue `json:"parameters,omitempty"`

	// The metadata describing groups of policy definition references within the policy set definition.
	PolicyDefinitionGroups []*DefinitionGroup `json:"policyDefinitionGroups,omitempty"`

	// The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
	PolicyType *PolicyType `json:"policyType,omitempty"`
}

// SetDefinitionsClientCreateOrUpdateAtManagementGroupOptions contains the optional parameters for the SetDefinitionsClient.CreateOrUpdateAtManagementGroup
// method.
type SetDefinitionsClientCreateOrUpdateAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// SetDefinitionsClientCreateOrUpdateOptions contains the optional parameters for the SetDefinitionsClient.CreateOrUpdate
// method.
type SetDefinitionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SetDefinitionsClientDeleteAtManagementGroupOptions contains the optional parameters for the SetDefinitionsClient.DeleteAtManagementGroup
// method.
type SetDefinitionsClientDeleteAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// SetDefinitionsClientDeleteOptions contains the optional parameters for the SetDefinitionsClient.Delete method.
type SetDefinitionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SetDefinitionsClientGetAtManagementGroupOptions contains the optional parameters for the SetDefinitionsClient.GetAtManagementGroup
// method.
type SetDefinitionsClientGetAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// SetDefinitionsClientGetBuiltInOptions contains the optional parameters for the SetDefinitionsClient.GetBuiltIn method.
type SetDefinitionsClientGetBuiltInOptions struct {
	// placeholder for future optional parameters
}

// SetDefinitionsClientGetOptions contains the optional parameters for the SetDefinitionsClient.Get method.
type SetDefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SetDefinitionsClientListBuiltInOptions contains the optional parameters for the SetDefinitionsClient.ListBuiltIn method.
type SetDefinitionsClientListBuiltInOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the given scope.
	// If $filter='policyType -eq {value}' is provided, the returned list only includes
	// all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom,
	// and Static. If $filter='category -eq {value}' is provided, the returned list only
	// includes all policy set definitions whose category match the {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// SetDefinitionsClientListByManagementGroupOptions contains the optional parameters for the SetDefinitionsClient.ListByManagementGroup
// method.
type SetDefinitionsClientListByManagementGroupOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the given scope.
	// If $filter='policyType -eq {value}' is provided, the returned list only includes
	// all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom,
	// and Static. If $filter='category -eq {value}' is provided, the returned list only
	// includes all policy set definitions whose category match the {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// SetDefinitionsClientListOptions contains the optional parameters for the SetDefinitionsClient.List method.
type SetDefinitionsClientListOptions struct {
	// The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category
	// eq '{value}''. If $filter is not provided, no filtering is performed. If
	// $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the given scope.
	// If $filter='policyType -eq {value}' is provided, the returned list only includes
	// all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom,
	// and Static. If $filter='category -eq {value}' is provided, the returned list only
	// includes all policy set definitions whose category match the {value}.
	Filter *string
	// Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
	Top *int32
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

type UserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}
