//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagedapplications

import "time"

// Application - Information about managed application.
type Application struct {
	// REQUIRED; The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string `json:"kind,omitempty"`

	// REQUIRED; The managed application properties.
	Properties *ApplicationProperties `json:"properties,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The plan information.
	Plan *Plan `json:"plan,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationArtifact - Managed application artifact.
type ApplicationArtifact struct {
	// REQUIRED; The managed application artifact name.
	Name *ApplicationArtifactName `json:"name,omitempty"`

	// REQUIRED; The managed application artifact type.
	Type *ApplicationArtifactType `json:"type,omitempty"`

	// REQUIRED; The managed application artifact blob uri.
	URI *string `json:"uri,omitempty"`
}

// ApplicationAuthorization - The managed application provider authorization.
type ApplicationAuthorization struct {
	// REQUIRED; The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the
	// managed application resources.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; The provider's role definition identifier. This role will define all the permissions that the provider must have
	// on the managed application's container resource group. This role definition cannot have
	// permission to delete the resource group.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// ApplicationBillingDetailsDefinition - Managed application billing details definition.
type ApplicationBillingDetailsDefinition struct {
	// The managed application resource usage Id.
	ResourceUsageID *string `json:"resourceUsageId,omitempty"`
}

// ApplicationClientDetails - The application client details to track the entity creating/updating the managed app resource.
type ApplicationClientDetails struct {
	// The client application Id.
	ApplicationID *string `json:"applicationId,omitempty"`

	// The client Oid.
	Oid *string `json:"oid,omitempty"`

	// The client Puid
	Puid *string `json:"puid,omitempty"`
}

// ApplicationClientListOperationsOptions contains the optional parameters for the ApplicationClient.ListOperations method.
type ApplicationClientListOperationsOptions struct {
	// placeholder for future optional parameters
}

// ApplicationDefinition - Information about managed application definition.
type ApplicationDefinition struct {
	// REQUIRED; The managed application definition properties.
	Properties *ApplicationDefinitionProperties `json:"properties,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationDefinitionArtifact - Application definition artifact.
type ApplicationDefinitionArtifact struct {
	// REQUIRED; The managed application definition artifact name.
	Name *ApplicationDefinitionArtifactName `json:"name,omitempty"`

	// REQUIRED; The managed application definition artifact type.
	Type *ApplicationArtifactType `json:"type,omitempty"`

	// REQUIRED; The managed application definition artifact blob uri.
	URI *string `json:"uri,omitempty"`
}

// ApplicationDefinitionListResult - List of managed application definitions.
type ApplicationDefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The array of managed application definitions.
	Value []*ApplicationDefinition `json:"value,omitempty"`
}

// ApplicationDefinitionPatchable - Information about an application definition request.
type ApplicationDefinitionPatchable struct {
	// Application definition tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ApplicationDefinitionProperties - The managed application definition properties.
type ApplicationDefinitionProperties struct {
	// REQUIRED; The managed application lock level.
	LockLevel *ApplicationLockLevel `json:"lockLevel,omitempty"`

	// The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the
	// user experience of creating a managed application from a managed application
	// definition.
	Artifacts []*ApplicationDefinitionArtifact `json:"artifacts,omitempty"`

	// The managed application provider authorizations.
	Authorizations []*ApplicationAuthorization `json:"authorizations,omitempty"`

	// The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject
	// or well-formed JSON string.
	CreateUIDefinition interface{} `json:"createUiDefinition,omitempty"`

	// The managed application deployment policy.
	DeploymentPolicy *ApplicationDeploymentPolicy `json:"deploymentPolicy,omitempty"`

	// The managed application definition description.
	Description *string `json:"description,omitempty"`

	// The managed application definition display name.
	DisplayName *string `json:"displayName,omitempty"`

	// A value indicating whether the package is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// The managed application locking policy.
	LockingPolicy *ApplicationPackageLockingPolicyDefinition `json:"lockingPolicy,omitempty"`

	// The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
	MainTemplate interface{} `json:"mainTemplate,omitempty"`

	// The managed application management policy that determines publisher's access to the managed resource group.
	ManagementPolicy *ApplicationManagementPolicy `json:"managementPolicy,omitempty"`

	// The managed application notification policy.
	NotificationPolicy *ApplicationNotificationPolicy `json:"notificationPolicy,omitempty"`

	// The managed application definition package file Uri. Use this element
	PackageFileURI *string `json:"packageFileUri,omitempty"`

	// The managed application provider policies.
	Policies []*ApplicationPolicy `json:"policies,omitempty"`

	// The storage account id for bring your own storage scenario.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationDefinitionsClientBeginCreateOrUpdateOptions contains the optional parameters for the ApplicationDefinitionsClient.BeginCreateOrUpdate
// method.
type ApplicationDefinitionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationDefinitionsClientBeginDeleteOptions contains the optional parameters for the ApplicationDefinitionsClient.BeginDelete
// method.
type ApplicationDefinitionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationDefinitionsClientGetOptions contains the optional parameters for the ApplicationDefinitionsClient.Get method.
type ApplicationDefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationDefinitionsClientListByResourceGroupOptions contains the optional parameters for the ApplicationDefinitionsClient.ListByResourceGroup
// method.
type ApplicationDefinitionsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ApplicationDefinitionsClientListBySubscriptionOptions contains the optional parameters for the ApplicationDefinitionsClient.ListBySubscription
// method.
type ApplicationDefinitionsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ApplicationDefinitionsClientUpdateOptions contains the optional parameters for the ApplicationDefinitionsClient.Update
// method.
type ApplicationDefinitionsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ApplicationDeploymentPolicy - Managed application deployment policy.
type ApplicationDeploymentPolicy struct {
	// REQUIRED; The managed application deployment mode.
	DeploymentMode *DeploymentMode `json:"deploymentMode,omitempty"`
}

// ApplicationJitAccessPolicy - Managed application Jit access policy.
type ApplicationJitAccessPolicy struct {
	// REQUIRED; Whether the JIT access is enabled.
	JitAccessEnabled *bool `json:"jitAccessEnabled,omitempty"`

	// JIT approval mode.
	JitApprovalMode *JitApprovalMode `json:"jitApprovalMode,omitempty"`

	// The JIT approvers
	JitApprovers []*JitApproverDefinition `json:"jitApprovers,omitempty"`

	// The maximum duration JIT access is granted. This is an ISO8601 time period value.
	MaximumJitAccessDuration *string `json:"maximumJitAccessDuration,omitempty"`
}

// ApplicationListResult - List of managed applications.
type ApplicationListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The array of managed applications.
	Value []*Application `json:"value,omitempty"`
}

// ApplicationManagementPolicy - Managed application management policy.
type ApplicationManagementPolicy struct {
	// The managed application management mode.
	Mode *ApplicationManagementMode `json:"mode,omitempty"`
}

// ApplicationNotificationEndpoint - Managed application notification endpoint.
type ApplicationNotificationEndpoint struct {
	// REQUIRED; The managed application notification endpoint uri.
	URI *string `json:"uri,omitempty"`
}

// ApplicationNotificationPolicy - Managed application notification policy.
type ApplicationNotificationPolicy struct {
	// REQUIRED; The managed application notification endpoint.
	NotificationEndpoints []*ApplicationNotificationEndpoint `json:"notificationEndpoints,omitempty"`
}

// ApplicationPackageContact - The application package contact information.
type ApplicationPackageContact struct {
	// REQUIRED; The contact email.
	Email *string `json:"email,omitempty"`

	// REQUIRED; The contact phone number.
	Phone *string `json:"phone,omitempty"`

	// The contact name.
	ContactName *string `json:"contactName,omitempty"`
}

// ApplicationPackageLockingPolicyDefinition - Managed application locking policy.
type ApplicationPackageLockingPolicyDefinition struct {
	// The deny assignment excluded actions.
	AllowedActions []*string `json:"allowedActions,omitempty"`

	// The deny assignment excluded data actions.
	AllowedDataActions []*string `json:"allowedDataActions,omitempty"`
}

// ApplicationPackageSupportUrls - The appliance package support URLs.
type ApplicationPackageSupportUrls struct {
	// The government cloud support URL.
	GovernmentCloud *string `json:"governmentCloud,omitempty"`

	// The public azure support URL.
	PublicAzure *string `json:"publicAzure,omitempty"`
}

// ApplicationPatchable - Information about managed application.
type ApplicationPatchable struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string `json:"kind,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The plan information.
	Plan *PlanPatchable `json:"plan,omitempty"`

	// The managed application properties.
	Properties *ApplicationProperties `json:"properties,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationPolicy - Managed application policy.
type ApplicationPolicy struct {
	// The policy name
	Name *string `json:"name,omitempty"`

	// The policy parameters.
	Parameters *string `json:"parameters,omitempty"`

	// The policy definition Id.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`
}

// ApplicationProperties - The managed application properties.
type ApplicationProperties struct {
	// The fully qualified path of managed application definition Id.
	ApplicationDefinitionID *string `json:"applicationDefinitionId,omitempty"`

	// The managed application Jit access policy.
	JitAccessPolicy *ApplicationJitAccessPolicy `json:"jitAccessPolicy,omitempty"`

	// The managed resource group Id.
	ManagedResourceGroupID *string `json:"managedResourceGroupId,omitempty"`

	// Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`

	// READ-ONLY; The collection of managed application artifacts.
	Artifacts []*ApplicationArtifact `json:"artifacts,omitempty" azure:"ro"`

	// READ-ONLY; The read-only authorizations property that is retrieved from the application package.
	Authorizations []*ApplicationAuthorization `json:"authorizations,omitempty" azure:"ro"`

	// READ-ONLY; The managed application billing details.
	BillingDetails *ApplicationBillingDetailsDefinition `json:"billingDetails,omitempty" azure:"ro"`

	// READ-ONLY; The client entity that created the JIT request.
	CreatedBy *ApplicationClientDetails `json:"createdBy,omitempty" azure:"ro"`

	// READ-ONLY; The read-only customer support property that is retrieved from the application package.
	CustomerSupport *ApplicationPackageContact `json:"customerSupport,omitempty" azure:"ro"`

	// READ-ONLY; The managed application management mode.
	ManagementMode *ApplicationManagementMode `json:"managementMode,omitempty" azure:"ro"`

	// READ-ONLY; Name and value pairs that define the managed application outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; The managed application provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The publisher tenant Id.
	PublisherTenantID *string `json:"publisherTenantId,omitempty" azure:"ro"`

	// READ-ONLY; The read-only support URLs property that is retrieved from the application package.
	SupportUrls *ApplicationPackageSupportUrls `json:"supportUrls,omitempty" azure:"ro"`

	// READ-ONLY; The client entity that last updated the JIT request.
	UpdatedBy *ApplicationClientDetails `json:"updatedBy,omitempty" azure:"ro"`
}

// ApplicationPropertiesPatchable - The managed application properties.
type ApplicationPropertiesPatchable struct {
	// The fully qualified path of managed application definition Id.
	ApplicationDefinitionID *string `json:"applicationDefinitionId,omitempty"`

	// The managed resource group Id.
	ManagedResourceGroupID *string `json:"managedResourceGroupId,omitempty"`

	// Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`

	// READ-ONLY; Name and value pairs that define the managed application outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; The managed application provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationsClientBeginCreateOrUpdateOptions contains the optional parameters for the ApplicationsClient.BeginCreateOrUpdate
// method.
type ApplicationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationsClientBeginDeleteOptions contains the optional parameters for the ApplicationsClient.BeginDelete method.
type ApplicationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationsClientBeginRefreshPermissionsOptions contains the optional parameters for the ApplicationsClient.BeginRefreshPermissions
// method.
type ApplicationsClientBeginRefreshPermissionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationsClientGetOptions contains the optional parameters for the ApplicationsClient.Get method.
type ApplicationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientListAllowedUpgradePlansOptions contains the optional parameters for the ApplicationsClient.ListAllowedUpgradePlans
// method.
type ApplicationsClientListAllowedUpgradePlansOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientListByResourceGroupOptions contains the optional parameters for the ApplicationsClient.ListByResourceGroup
// method.
type ApplicationsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientListBySubscriptionOptions contains the optional parameters for the ApplicationsClient.ListBySubscription
// method.
type ApplicationsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientUpdateOptions contains the optional parameters for the ApplicationsClient.Update method.
type ApplicationsClientUpdateOptions struct {
	// Parameters supplied to update an existing managed application.
	Parameters *ApplicationPatchable
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GenericResource - Resource information.
type GenericResource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource. The user identity dictionary key references will be resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedResourceIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// JitApproverDefinition - JIT approver definition.
type JitApproverDefinition struct {
	// REQUIRED; The approver service principal Id.
	ID *string `json:"id,omitempty"`

	// The approver display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The approver type.
	Type *JitApproverType `json:"type,omitempty"`
}

// JitAuthorizationPolicies - The JIT authorization policies.
type JitAuthorizationPolicies struct {
	// REQUIRED; The the principal id that will be granted JIT access.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; The role definition id that will be granted to the Principal.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// JitRequestDefinition - Information about JIT request definition.
type JitRequestDefinition struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// The JIT request properties.
	Properties *JitRequestProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JitRequestDefinitionListResult - List of JIT requests.
type JitRequestDefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The array of Jit request definition.
	Value []*JitRequestDefinition `json:"value,omitempty"`
}

// JitRequestPatchable - Information about JIT request.
type JitRequestPatchable struct {
	// Jit request tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// JitRequestProperties - Information about JIT request properties
type JitRequestProperties struct {
	// REQUIRED; The parent application id.
	ApplicationResourceID *string `json:"applicationResourceId,omitempty"`

	// REQUIRED; The JIT authorization policies.
	JitAuthorizationPolicies []*JitAuthorizationPolicies `json:"jitAuthorizationPolicies,omitempty"`

	// REQUIRED; The JIT request properties.
	JitSchedulingPolicy *JitSchedulingPolicy `json:"jitSchedulingPolicy,omitempty"`

	// READ-ONLY; The client entity that created the JIT request.
	CreatedBy *ApplicationClientDetails `json:"createdBy,omitempty" azure:"ro"`

	// READ-ONLY; The JIT request state.
	JitRequestState *JitRequestState `json:"jitRequestState,omitempty" azure:"ro"`

	// READ-ONLY; The JIT request provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The publisher tenant id.
	PublisherTenantID *string `json:"publisherTenantId,omitempty" azure:"ro"`

	// READ-ONLY; The client entity that last updated the JIT request.
	UpdatedBy *ApplicationClientDetails `json:"updatedBy,omitempty" azure:"ro"`
}

// JitRequestsClientBeginCreateOrUpdateOptions contains the optional parameters for the JitRequestsClient.BeginCreateOrUpdate
// method.
type JitRequestsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JitRequestsClientDeleteOptions contains the optional parameters for the JitRequestsClient.Delete method.
type JitRequestsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JitRequestsClientGetOptions contains the optional parameters for the JitRequestsClient.Get method.
type JitRequestsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JitRequestsClientListByResourceGroupOptions contains the optional parameters for the JitRequestsClient.ListByResourceGroup
// method.
type JitRequestsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// JitRequestsClientListBySubscriptionOptions contains the optional parameters for the JitRequestsClient.ListBySubscription
// method.
type JitRequestsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// JitRequestsClientUpdateOptions contains the optional parameters for the JitRequestsClient.Update method.
type JitRequestsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// JitSchedulingPolicy - The JIT scheduling policies.
type JitSchedulingPolicy struct {
	// REQUIRED; The required duration of the JIT request.
	Duration *string `json:"duration,omitempty"`

	// REQUIRED; The start time of the request.
	StartTime *time.Time `json:"startTime,omitempty"`

	// REQUIRED; The type of JIT schedule.
	Type *JitSchedulingType `json:"type,omitempty"`
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// Plan for the managed application.
type Plan struct {
	// REQUIRED; The plan name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The product code.
	Product *string `json:"product,omitempty"`

	// REQUIRED; The publisher ID.
	Publisher *string `json:"publisher,omitempty"`

	// REQUIRED; The plan's version.
	Version *string `json:"version,omitempty"`

	// The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
}

// PlanPatchable - Plan for the managed application.
type PlanPatchable struct {
	// The plan name.
	Name *string `json:"name,omitempty"`

	// The product code.
	Product *string `json:"product,omitempty"`

	// The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`

	// The publisher ID.
	Publisher *string `json:"publisher,omitempty"`

	// The plan's version.
	Version *string `json:"version,omitempty"`
}

// Resource information.
type Resource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKU for the resource.
type SKU struct {
	// REQUIRED; The SKU name.
	Name *string `json:"name,omitempty"`

	// The SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`

	// The SKU family.
	Family *string `json:"family,omitempty"`

	// The SKU model.
	Model *string `json:"model,omitempty"`

	// The SKU size.
	Size *string `json:"size,omitempty"`

	// The SKU tier.
	Tier *string `json:"tier,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// UserAssignedResourceIdentity - Represents the user assigned identity that is contained within the UserAssignedIdentities
// dictionary on ResourceIdentity
type UserAssignedResourceIdentity struct {
	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of user assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}
