# frozen_string_literal: true

class QueueBackfillVulnerabilityMergeRequestLinksProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.1'
  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  MIGRATION = "BackfillVulnerabilityMergeRequestLinksProjectId"
  DELAY_INTERVAL = 2.minutes
  BATCH_SIZE = 1000
  SUB_BATCH_SIZE = 100

  def up
    queue_batched_background_migration(
      MIGRATION,
      :vulnerability_merge_request_links,
      :id,
      :project_id,
      :vulnerabilities,
      :project_id,
      :vulnerability_id,
      job_interval: DELAY_INTERVAL,
      batch_size: BATCH_SIZE,
      sub_batch_size: SUB_BATCH_SIZE
    )
  end

  def down
    delete_batched_background_migration(
      MIGRATION,
      :vulnerability_merge_request_links,
      :id,
      [
        :project_id,
        :vulnerabilities,
        :project_id,
        :vulnerability_id
      ]
    )
  end
end
