<!--
SPDX-FileCopyrightText: 2011 Giovanni Campagna <gcampagna@src.gnome.org>
SPDX-FileCopyrightText: 2017 Florian Müllner <fmuellner@gnome.org>"""
SPDX-License-Identifier: CC-BY-SA-4.0
-->

## Creating a New Extension

To create a new extension, add a subdirectory in extensions. Then create
a meson.build from the provided [template](extensions/meson.build.template).
If you need additional sources, add them to extension_sources. Similarily add
GSettings schemas to extension_schemas and other files to extension_data.

Then modify the [toplevel Meson file](meson.build) to add the new
extension name in the appropriate set (that is one of classic_extensions,
default_extensions or all_extensions).

Don't forget to add any translatable file to po/POTFILES.in, and
then you're done.
The Gettext domain you should choose is gnome-shell-extensions,
not gnome-shell, unless you're sure there is the string you
need in gnome-shell.

## Coding Style

Generally, we follow [GJS coding style][coding-style], which in short is:
indent 4 spaces, no tabs, space after comma, no space after function call.

Imports should be at the top, in two groups, one for standard
imports (like imports.lang or imports.dbus) and introspection,
the other for Shell API. Within the same group, put everything
in alphabetic order.

[coding-style]: https://gitlab.gnome.org/GNOME/gjs/blob/HEAD/doc/Style_Guide.md
