/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.items;

import java.util.ArrayList;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.editors.LisaacCompletionProposal;
import org.lisaac.ldt.model.LisaacParser;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.IArgument;
import org.lisaac.ldt.model.items.ICode;
import org.lisaac.ldt.model.items.ITMBlock;
import org.lisaac.ldt.model.items.ITMList;
import org.lisaac.ldt.model.items.ITMLocal;
import org.lisaac.ldt.model.items.IVariable;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Section;
import org.lisaac.ldt.model.types.IType;
import org.lisaac.ldt.outline.OutlineSlot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slot {
    protected Section sectionId;
    protected Position position;
    protected String name;
    protected char style;
    protected char affect;
    protected IArgument[] argumentList;
    protected IType resultType;
    protected String[] keywordList;
    protected ICode value;
    protected ArrayList<ICode> subLists;
    protected String comment;
    protected Position body;
    protected int priorityAndLevel;

    public Slot(Position position, String name, Section sectionId) {
        this.name = name;
        this.position = position;
        this.sectionId = sectionId;
    }

    public String getName() {
        return this.name;
    }

    public char getStyle() {
        return this.style;
    }

    public char getAffect() {
        return this.affect;
    }

    public IArgument getArgument(int i) {
        return this.argumentList[i];
    }

    public Section getSectionId() {
        return this.sectionId;
    }

    public IType getResultType() {
        return this.resultType;
    }

    public void setArgumentList(IArgument[] argumentList) {
        this.argumentList = argumentList;
    }

    public void setResultType(IType resultType) {
        this.resultType = resultType;
    }

    public void setKeywordList(String[] keywordList) {
        this.keywordList = keywordList;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setAffect(char affect) {
        this.affect = affect;
    }

    public Position getPosition() {
        return this.position;
    }

    public Position getPositionBody() {
        return this.body;
    }

    public void setBody(Position p) {
        this.body = p;
    }

    public int keywordCount() {
        if (this.keywordList == null) {
            return 0;
        }
        return this.keywordList.length;
    }

    public void setValue(ICode v) {
        if (this.affect == '<') {
            this.value = v;
        }
    }

    public ICode getValue() {
        return this.value;
    }

    public void addSubList(ICode list) {
        if (this.subLists == null) {
            this.subLists = new ArrayList();
        }
        this.subLists.add(list);
    }

    public void setAssociativity(String p, int l) {
        this.priorityAndLevel = p == null || p.equals("Left") ? l : -l;
    }

    public String getAssociativity() {
        String result = this.priorityAndLevel >= 0 ? "Left" : "Right";
        return result;
    }

    public int getPriority() {
        if (this.priorityAndLevel < 0) {
            return -this.priorityAndLevel;
        }
        return this.priorityAndLevel;
    }

    public void setStyle(char style) {
        this.style = style;
    }

    public boolean hasArgument(String word) {
        return this.getArgument(word) != null;
    }

    public IArgument getArgument(String word) {
        if (this.argumentList != null) {
            int i = 0;
            while (i < this.argumentList.length) {
                if (this.argumentList[i].hasName(word)) {
                    return this.argumentList[i];
                }
                ++i;
            }
        }
        return null;
    }

    public boolean hasVariableDefinition(String word, int offset) {
        return this.getVariableDefinition(word, offset) != null;
    }

    public IVariable getVariableDefinition(String word, int offset) {
        if (this.subLists != null) {
            int i = 0;
            while (i < this.subLists.size()) {
                ITMList list;
                ICode c = this.subLists.get(i);
                if (c instanceof ITMList) {
                    ITMLocal var;
                    list = (ITMList)c;
                    if (list != null && list.isInside(offset) && (var = list.getLocal(word)) != null) {
                        return var;
                    }
                } else if (c instanceof ITMBlock) {
                    list = ((ITMBlock)c).list;
                    IArgument arg = ((ITMBlock)c).argument;
                    if (list != null && arg != null && list.isInside(offset) && arg.hasName(word)) {
                        return arg;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public IVariable getVariable(String word, int offset) {
        IVariable result = this.getArgument(word);
        if (result == null) {
            result = this.getVariableDefinition(word, offset);
        }
        return result;
    }

    public Prototype getPrototype() {
        return this.sectionId.getPrototype();
    }

    private String getOperatorName() {
        int index;
        String s = this.name.substring(2);
        StringBuffer result = new StringBuffer("'");
        do {
            index = s.indexOf("_");
            s = s.substring(index + 1);
            if (index == -1) continue;
            if (s.startsWith("add")) {
                result.append('+');
                continue;
            }
            if (s.startsWith("sub")) {
                result.append('-');
                continue;
            }
            if (s.startsWith("logicnot")) {
                result.append('~');
                continue;
            }
            if (s.startsWith("not")) {
                result.append('!');
                continue;
            }
            if (s.startsWith("div")) {
                result.append('/');
                continue;
            }
            if (s.startsWith("mul")) {
                result.append('*');
                continue;
            }
            if (s.startsWith("xor")) {
                result.append('^');
                continue;
            }
            if (s.startsWith("mod")) {
                result.append('%');
                continue;
            }
            if (s.startsWith("greater")) {
                result.append('>');
                continue;
            }
            if (s.startsWith("less")) {
                result.append('<');
                continue;
            }
            if (s.startsWith("equal")) {
                result.append('=');
                continue;
            }
            if (s.startsWith("notdiv")) {
                result.append('\\');
                continue;
            }
            if (s.startsWith("or")) {
                result.append('|');
                continue;
            }
            if (s.startsWith("and")) {
                result.append('&');
                continue;
            }
            if (s.startsWith("dollar")) {
                result.append('$');
                continue;
            }
            if (s.startsWith("diese")) {
                result.append('#');
                continue;
            }
            if (s.startsWith("at")) {
                result.append('@');
                continue;
            }
            if (!s.startsWith("ask")) continue;
            result.append('?');
        } while (index != -1);
        result.append('\'');
        return result.toString();
    }

    public String getSignature(boolean isCall) {
        if (this.name.startsWith("__")) {
            return this.getOperatorName();
        }
        if (this.keywordList == null || this.keywordList.length < 1) {
            return this.name;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.keywordList[0]);
        buffer.append(" ");
        int keywordIndex = 1;
        int argIndex = 0;
        while (argIndex < this.argumentList.length) {
            if (isCall) {
                buffer.append(this.argumentList[argIndex].getName());
            } else {
                this.argumentList[argIndex].printIn(buffer);
            }
            buffer.append(" ");
            if (keywordIndex < this.keywordList.length) {
                buffer.append(this.keywordList[keywordIndex]);
                buffer.append(" ");
                ++keywordIndex;
            }
            ++argIndex;
        }
        if (!isCall && this.resultType.toString() != null) {
            buffer.append(" : " + this.resultType);
        }
        return buffer.toString();
    }

    public StyledString getStyledSignature(boolean isCall, boolean showProto) {
        ColorManager colors = ColorManager.getDefault();
        StyledString result = new StyledString();
        if (this.name.startsWith("__")) {
            result.append(this.getOperatorName(), colors.getOperatorStyler());
            return result;
        }
        if (this.keywordList == null || this.keywordList.length < 1) {
            result.append(this.name, colors.getSlotStyler());
            return result;
        }
        result.append(this.keywordList[0], colors.getSlotStyler());
        result.append(" ");
        int keywordIndex = 1;
        int argIndex = 0;
        while (argIndex < this.argumentList.length) {
            if (isCall) {
                result.append(this.argumentList[argIndex].getName(), colors.getVariableStyler());
            } else {
                this.argumentList[argIndex].styledPrintIn(result);
            }
            result.append(" ");
            if (keywordIndex < this.keywordList.length) {
                result.append(this.keywordList[keywordIndex], colors.getSlotStyler());
                result.append(" ");
                ++keywordIndex;
            }
            ++argIndex;
        }
        if (!isCall && this.resultType.toString() != null) {
            result.append(" : ");
            result.append(this.resultType.toString(), colors.getPrototypeStyler());
        }
        if (showProto) {
            result.append("  - ", StyledString.QUALIFIER_STYLER);
            result.append(this.getPrototype().getName(), StyledString.QUALIFIER_STYLER);
        }
        return result;
    }

    public void getSlotProposals(ArrayList<ICompletionProposal> proposals, int offset, int length) {
        if (this.name.startsWith("__")) {
            return;
        }
        Image image = new OutlineSlot(this).getImage();
        String displayString = this.getSignature(true);
        StyledString styledString = this.getStyledSignature(false, true);
        if (Slot.checkUnicity(proposals, styledString.getString())) {
            proposals.add(new LisaacCompletionProposal(displayString, offset, length, displayString.length() - 1, image, styledString));
        }
    }

    public void getSlotMatchProposals(ArrayList<ICompletionProposal> proposals, int offset, int length, int matchLength) {
        Image image = new OutlineSlot(this).getImage();
        String displayString = this.getSignature(true);
        StyledString styledString = this.getStyledSignature(false, true);
        if (Slot.checkUnicity(proposals, styledString.getString())) {
            displayString = displayString.substring(matchLength);
            proposals.add(new LisaacCompletionProposal(displayString, offset, length, displayString.length(), image, styledString));
        }
    }

    public void getArgumentMatchProposals(String n, ArrayList<ICompletionProposal> matchList, int offset, int length) {
        if (this.argumentList != null) {
            int i = 0;
            while (i < this.argumentList.length) {
                this.argumentList[i].getMatchProposals(n, matchList, offset, length);
                ++i;
            }
        }
    }

    public void getLocalMatchProposals(String n, ArrayList<ICompletionProposal> matchList, int offset, int length) {
        if (this.subLists != null) {
            int i = 0;
            while (i < this.subLists.size()) {
                ITMList list;
                ICode c = this.subLists.get(i);
                if (c instanceof ITMList) {
                    list = (ITMList)c;
                    if (list != null && list.isInside(offset)) {
                        list.getMatchProposals(n, matchList, offset, length);
                    }
                } else if (c instanceof ITMBlock) {
                    list = ((ITMBlock)c).list;
                    IArgument arg = ((ITMBlock)c).argument;
                    if (list != null && arg != null && list.isInside(offset)) {
                        arg.getMatchProposals(n, matchList, offset, length);
                    }
                }
                ++i;
            }
        }
    }

    public static boolean checkUnicity(ArrayList<ICompletionProposal> proposals, String str) {
        int i = 0;
        while (i < proposals.size()) {
            if (proposals.get(i).getDisplayString().compareTo(str) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean match(String n) {
        return this.name.startsWith(n);
    }

    public String getHoverInformation() {
        StringBuffer buffer = new StringBuffer("<b>");
        buffer.append(this.getSignature(false));
        buffer.append("</b> <I>- ");
        buffer.append(this.getPrototype().getName());
        buffer.append("</I>");
        if (this.comment != null) {
            buffer.append("\n\n<g>");
            buffer.append(this.comment);
            buffer.append("</g>");
        }
        return buffer.toString();
    }

    public TextEdit[] refactorRenamePrototype(String oldName, String newName) {
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        int i = 0;
        while (i < this.argumentList.length) {
            IType type = this.argumentList[i].getType();
            Position p = this.argumentList[i].getPosition();
            if (p != null && type.toString().compareTo(oldName) == 0) {
                LisaacParser parser = this.getPrototype().openParser();
                parser.setPosition(p.offset + p.length);
                parser.readCharacter(':');
                parser.readSpace();
                int startOffset = parser.getOffset();
                result.add((TextEdit)new DeleteEdit(startOffset, oldName.length()));
                result.add((TextEdit)new InsertEdit(startOffset, newName));
            }
            ++i;
        }
        if (this.resultType != null && this.resultType.toString() != null && this.resultType.toString().compareTo(oldName) == 0) {
            LisaacParser parser = this.getPrototype().openParser();
            parser.setPosition(this.position.offset);
            parser.readSlotNameFromOffset(this.position.offset, true);
            parser.readCharacter(':');
            parser.readSpace();
            int startOffset = parser.getOffset();
            result.add((TextEdit)new DeleteEdit(startOffset, oldName.length()));
            result.add((TextEdit)new InsertEdit(startOffset, newName));
        }
        if (this.value != null) {
            this.value.refactorRenamePrototype(oldName, newName, result);
        }
        if (result.size() > 0) {
            return result.toArray(new TextEdit[result.size()]);
        }
        return null;
    }
}

