/* iso_15924.c generated by valac 0.48.13, the Vala compiler
 * generated from iso_15924.vala, do not modify */

/* Copyright © 2012-2013 Tobias Quathamer
 *
 * This file is part of libisocodes.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libxml/parser.h>
#include <gee.h>

#define LIBISOCODES_TYPE_ISO_CODES (libisocodes_iso_codes_get_type ())
#define LIBISOCODES_ISO_CODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes))
#define LIBISOCODES_ISO_CODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_CodesClass))
#define LIBISOCODES_IS_ISO_CODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBISOCODES_TYPE_ISO_CODES))
#define LIBISOCODES_IS_ISO_CODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBISOCODES_TYPE_ISO_CODES))
#define LIBISOCODES_ISO_CODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_CodesClass))

typedef struct _libisocodesISO_Codes libisocodesISO_Codes;
typedef struct _libisocodesISO_CodesClass libisocodesISO_CodesClass;
typedef struct _libisocodesISO_CodesPrivate libisocodesISO_CodesPrivate;

#define LIBISOCODES_TYPE_ISO_15924 (libisocodes_iso_15924_get_type ())
#define LIBISOCODES_ISO_15924(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBISOCODES_TYPE_ISO_15924, libisocodesISO_15924))
#define LIBISOCODES_ISO_15924_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBISOCODES_TYPE_ISO_15924, libisocodesISO_15924Class))
#define LIBISOCODES_IS_ISO_15924(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBISOCODES_TYPE_ISO_15924))
#define LIBISOCODES_IS_ISO_15924_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBISOCODES_TYPE_ISO_15924))
#define LIBISOCODES_ISO_15924_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBISOCODES_TYPE_ISO_15924, libisocodesISO_15924Class))

typedef struct _libisocodesISO_15924 libisocodesISO_15924;
typedef struct _libisocodesISO_15924Class libisocodesISO_15924Class;
typedef struct _libisocodesISO_15924Private libisocodesISO_15924Private;
enum  {
	LIBISOCODES_ISO_15924_0_PROPERTY,
	LIBISOCODES_ISO_15924_NUM_PROPERTIES
};
static GParamSpec* libisocodes_iso_15924_properties[LIBISOCODES_ISO_15924_NUM_PROPERTIES];

#define LIBISOCODES_TYPE_ISO_15924_ITEM (libisocodes_iso_15924_item_get_type ())
#define LIBISOCODES_ISO_15924_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBISOCODES_TYPE_ISO_15924_ITEM, libisocodesISO_15924_Item))
#define LIBISOCODES_ISO_15924_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBISOCODES_TYPE_ISO_15924_ITEM, libisocodesISO_15924_ItemClass))
#define LIBISOCODES_IS_ISO_15924_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBISOCODES_TYPE_ISO_15924_ITEM))
#define LIBISOCODES_IS_ISO_15924_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBISOCODES_TYPE_ISO_15924_ITEM))
#define LIBISOCODES_ISO_15924_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBISOCODES_TYPE_ISO_15924_ITEM, libisocodesISO_15924_ItemClass))

typedef struct _libisocodesISO_15924_Item libisocodesISO_15924_Item;
typedef struct _libisocodesISO_15924_ItemClass libisocodesISO_15924_ItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _libisocodesISO_Codes {
	GObject parent_instance;
	libisocodesISO_CodesPrivate * priv;
};

struct _libisocodesISO_CodesClass {
	GObjectClass parent_class;
	gchar** (*_get_xpaths) (libisocodesISO_Codes* self, const gchar* code, gint* result_length1);
	gchar** (*_get_fields) (libisocodesISO_Codes* self, gint* result_length1);
};

struct _libisocodesISO_15924 {
	libisocodesISO_Codes parent_instance;
	libisocodesISO_15924Private * priv;
};

struct _libisocodesISO_15924Class {
	libisocodesISO_CodesClass parent_class;
};

typedef enum  {
	LIBISOCODES_ISO_CODES_ERROR_CANNOT_OPEN_FILE,
	LIBISOCODES_ISO_CODES_ERROR_CANNOT_CREATE_LIBXML_STRUCTURE,
	LIBISOCODES_ISO_CODES_ERROR_CANNOT_PARSE_FILE,
	LIBISOCODES_ISO_CODES_ERROR_FILE_DOES_NOT_CONTAIN_ISO_DATA,
	LIBISOCODES_ISO_CODES_ERROR_CODE_NOT_DEFINED
} libisocodesISOCodesError;
#define LIBISOCODES_ISO_CODES_ERROR libisocodes_iso_codes_error_quark ()

static gpointer libisocodes_iso_15924_parent_class = NULL;

GType libisocodes_iso_codes_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (libisocodesISO_Codes, g_object_unref)
GType libisocodes_iso_15924_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (libisocodesISO_15924, g_object_unref)
gchar** _libisocodes_iso_codes_get_xpaths (libisocodesISO_Codes* self,
                                           const gchar* code,
                                           gint* result_length1);
gchar** _libisocodes_iso_codes_get_fields (libisocodesISO_Codes* self,
                                           gint* result_length1);
libisocodesISO_15924* libisocodes_iso_15924_new (void);
libisocodesISO_15924* libisocodes_iso_15924_construct (GType object_type);
libisocodesISO_Codes* libisocodes_iso_codes_construct (GType object_type);
void libisocodes_iso_15924_setup (libisocodesISO_15924* self);
void _libisocodes_iso_codes_setup_i18n (libisocodesISO_Codes* self);
void libisocodes_iso_codes_set_standard (libisocodesISO_Codes* self,
                                         const gchar* value);
void libisocodes_iso_codes_set_filepath (libisocodesISO_Codes* self,
                                         const gchar* path);
GType libisocodes_iso_15924_item_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (libisocodesISO_15924_Item, g_object_unref)
GQuark libisocodes_iso_codes_error_quark (void);
libisocodesISO_15924_Item** libisocodes_iso_15924_find_all (libisocodesISO_15924* self,
                                                            gint* result_length1,
                                                            GError** error);
GeeArrayList* _libisocodes_iso_codes_find_all (libisocodesISO_Codes* self,
                                               GError** error);
libisocodesISO_15924_Item* libisocodes_iso_15924_item_new (GeeHashMap* item);
libisocodesISO_15924_Item* libisocodes_iso_15924_item_construct (GType object_type,
                                                                 GeeHashMap* item);
static void _vala_array_add20 (libisocodesISO_15924_Item** * array,
                        gint* length,
                        gint* size,
                        libisocodesISO_15924_Item* value);
libisocodesISO_15924_Item* libisocodes_iso_15924_find_code (libisocodesISO_15924* self,
                                                            const gchar* code,
                                                            GError** error);
GeeHashMap* _libisocodes_iso_codes_find_code (libisocodesISO_Codes* self,
                                              const gchar* code,
                                              GError** error);
static gchar** libisocodes_iso_15924_real__get_xpaths (libisocodesISO_Codes* base,
                                                const gchar* code,
                                                gint* result_length1);
gboolean _libisocodes_iso_codes_is_number (libisocodesISO_Codes* self,
                                           const gchar* text);
static void _vala_array_add21 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add22 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** libisocodes_iso_15924_real__get_fields (libisocodesISO_Codes* base,
                                                gint* result_length1);
static void libisocodes_iso_15924_finalize (GObject * obj);
static GType libisocodes_iso_15924_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

/**
         * Constructor of class.
         * 
         * Call the setup() method, see there for reasoning.
         */
libisocodesISO_15924*
libisocodes_iso_15924_construct (GType object_type)
{
	libisocodesISO_15924 * self = NULL;
	self = (libisocodesISO_15924*) libisocodes_iso_codes_construct (object_type);
	libisocodes_iso_15924_setup (self);
	return self;
}

libisocodesISO_15924*
libisocodes_iso_15924_new (void)
{
	return libisocodes_iso_15924_construct (LIBISOCODES_TYPE_ISO_15924);
}

/**
         * Setup of the class.
         * 
         * Due to a bug somewhere in the GObject introspection routines
         * with vala, the constructor of a class is not called when
         * the class is instanciated. Therefore, we use a separate
         * setup method which can be called, if necessary.
         * 
         * For LibXML, it is needed to initialize the parser here.
         */
void
libisocodes_iso_15924_setup (libisocodesISO_15924* self)
{
	g_return_if_fail (self != NULL);
	_libisocodes_iso_codes_setup_i18n ((libisocodesISO_Codes*) self);
	xmlInitParser ();
	libisocodes_iso_codes_set_standard ((libisocodesISO_Codes*) self, "15924");
	libisocodes_iso_codes_set_filepath ((libisocodesISO_Codes*) self, "/usr/share/xml/iso-codes/iso_15924.xml");
}

/**
         * Return an array of all items in the ISO standard.
         * 
         * @return array All ISO 15924 items.
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add20 (libisocodesISO_15924_Item** * array,
                   gint* length,
                   gint* size,
                   libisocodesISO_15924_Item* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (libisocodesISO_15924_Item*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

libisocodesISO_15924_Item**
libisocodes_iso_15924_find_all (libisocodesISO_15924* self,
                                gint* result_length1,
                                GError** error)
{
	libisocodesISO_15924_Item** _result_ = NULL;
	gint _result__length1;
	gint __result__size_;
	GeeArrayList* items = NULL;
	GeeArrayList* _tmp0_;
	libisocodesISO_15924_Item** _tmp11_;
	gint _tmp11__length1;
	GError* _inner_error0_ = NULL;
	libisocodesISO_15924_Item** result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp0_ = _libisocodes_iso_codes_find_all ((libisocodesISO_Codes*) self, &_inner_error0_);
	items = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_object_unref), NULL);
			return NULL;
		} else {
			_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_object_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp1_;
		gint _item_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _item_index = 0;
		_tmp1_ = _g_object_ref0 (items);
		_item_list = _tmp1_;
		_tmp2_ = _item_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_item_size = _tmp4_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GeeHashMap* item = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			GeeHashMap* _tmp9_;
			libisocodesISO_15924_Item* _tmp10_;
			_item_index = _item_index + 1;
			_tmp5_ = _item_index;
			_tmp6_ = _item_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _item_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _item_index);
			item = (GeeHashMap*) _tmp8_;
			_tmp9_ = item;
			_tmp10_ = libisocodes_iso_15924_item_new (_tmp9_);
			_vala_array_add20 (&_result_, &_result__length1, &__result__size_, _tmp10_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_list);
	}
	_tmp11_ = _result_;
	_tmp11__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	_g_object_unref0 (items);
	return result;
}

/**
         * Try to locate the given code in the XML file.
         * 
         * @param string Code to search for.
         * 
         * @return struct A matching ISO 15924 item, if found.
         */
libisocodesISO_15924_Item*
libisocodes_iso_15924_find_code (libisocodesISO_15924* self,
                                 const gchar* code,
                                 GError** error)
{
	GeeHashMap* res = NULL;
	GeeHashMap* _tmp0_;
	libisocodesISO_15924_Item* _tmp1_;
	GError* _inner_error0_ = NULL;
	libisocodesISO_15924_Item* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (code != NULL, NULL);
	_tmp0_ = _libisocodes_iso_codes_find_code ((libisocodesISO_Codes*) self, code, &_inner_error0_);
	res = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = libisocodes_iso_15924_item_new (res);
	result = _tmp1_;
	_g_object_unref0 (res);
	return result;
}

/**
         * Set up the XPaths to try.
         * 
         * @param string Code to search for.
         */
static void
_vala_array_add21 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
_vala_array_add22 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
libisocodes_iso_15924_real__get_xpaths (libisocodesISO_Codes* base,
                                        const gchar* code,
                                        gint* result_length1)
{
	libisocodesISO_15924 * self;
	gchar** xpaths = NULL;
	gchar** _tmp0_;
	gint xpaths_length1;
	gint _xpaths_size_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** result = NULL;
	self = (libisocodesISO_15924*) base;
	g_return_val_if_fail (code != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	xpaths = _tmp0_;
	xpaths_length1 = 0;
	_xpaths_size_ = xpaths_length1;
	if (_libisocodes_iso_codes_is_number ((libisocodesISO_Codes*) self, code)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = g_utf8_strup (code, (gssize) -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("//iso_15924_entry[@numeric_code='", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "']", NULL);
		_vala_array_add21 (&xpaths, &xpaths_length1, &_xpaths_size_, _tmp5_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		gchar* normalized_code = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp6_ = string_slice (code, (glong) 0, (glong) 1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_utf8_strup (_tmp7_, (gssize) -1);
		_tmp9_ = _tmp8_;
		_tmp10_ = strlen (code);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_slice (code, (glong) 1, (glong) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp9_, _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		normalized_code = _tmp17_;
		_tmp18_ = normalized_code;
		_tmp19_ = g_strconcat ("//iso_15924_entry[@alpha_4_code='", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, "']", NULL);
		_vala_array_add22 (&xpaths, &xpaths_length1, &_xpaths_size_, _tmp21_);
		_g_free0 (_tmp20_);
		_g_free0 (normalized_code);
	}
	_tmp22_ = xpaths;
	_tmp22__length1 = xpaths_length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	return result;
}

/**
         * @inheritDoc
         */
static gchar**
libisocodes_iso_15924_real__get_fields (libisocodesISO_Codes* base,
                                        gint* result_length1)
{
	libisocodesISO_15924 * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** result = NULL;
	self = (libisocodesISO_15924*) base;
	_tmp0_ = g_strdup ("alpha_4_code");
	_tmp1_ = g_strdup ("numeric_code");
	_tmp2_ = g_strdup ("name");
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static void
libisocodes_iso_15924_class_init (libisocodesISO_15924Class * klass,
                                  gpointer klass_data)
{
	libisocodes_iso_15924_parent_class = g_type_class_peek_parent (klass);
	((libisocodesISO_CodesClass *) klass)->_get_xpaths = (gchar** (*) (libisocodesISO_Codes*, const gchar*, gint*)) libisocodes_iso_15924_real__get_xpaths;
	((libisocodesISO_CodesClass *) klass)->_get_fields = (gchar** (*) (libisocodesISO_Codes*, gint*)) libisocodes_iso_15924_real__get_fields;
	G_OBJECT_CLASS (klass)->finalize = libisocodes_iso_15924_finalize;
}

static void
libisocodes_iso_15924_instance_init (libisocodesISO_15924 * self,
                                     gpointer klass)
{
}

static void
libisocodes_iso_15924_finalize (GObject * obj)
{
	libisocodesISO_15924 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBISOCODES_TYPE_ISO_15924, libisocodesISO_15924);
	xmlCleanupParser ();
	G_OBJECT_CLASS (libisocodes_iso_15924_parent_class)->finalize (obj);
}

static GType
libisocodes_iso_15924_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (libisocodesISO_15924Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) libisocodes_iso_15924_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (libisocodesISO_15924), 0, (GInstanceInitFunc) libisocodes_iso_15924_instance_init, NULL };
	GType libisocodes_iso_15924_type_id;
	libisocodes_iso_15924_type_id = g_type_register_static (LIBISOCODES_TYPE_ISO_CODES, "libisocodesISO_15924", &g_define_type_info, 0);
	return libisocodes_iso_15924_type_id;
}

GType
libisocodes_iso_15924_get_type (void)
{
	static volatile gsize libisocodes_iso_15924_type_id__volatile = 0;
	if (g_once_init_enter (&libisocodes_iso_15924_type_id__volatile)) {
		GType libisocodes_iso_15924_type_id;
		libisocodes_iso_15924_type_id = libisocodes_iso_15924_get_type_once ();
		g_once_init_leave (&libisocodes_iso_15924_type_id__volatile, libisocodes_iso_15924_type_id);
	}
	return libisocodes_iso_15924_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

