/* ----- decode/653xint32, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_653xint32_checksums[] = {
  "34b2ca8a50458bcb0807cec51d8532fbe6757c16134cdffc358383de4e1a148c",
  "57b3c59fc493ad09401c0b98870b52d4c0f37472e636dbff071e3ae4e29ca59d",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_653xint32_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_653xint32_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_653xint32_ITEMBYTES

static void *storage_decode_653xint32_x;
static unsigned char *test_decode_653xint32_x;
static void *storage_decode_653xint32_s;
static unsigned char *test_decode_653xint32_s;
static void *storage_decode_653xint32_x2;
static unsigned char *test_decode_653xint32_x2;
static void *storage_decode_653xint32_s2;
static unsigned char *test_decode_653xint32_s2;

#define precomputed_decode_653xint32_NUM 4

static const uint32_t precomputed_decode_653xint32_x[precomputed_decode_653xint32_NUM][crypto_decode_ITEMS] = {
  {3810207912,3943900755,1670057613,4057773587,2644115003,3150129286,303486790,1776657552,1893228624,996822905,4237290586,3387645418,3418477528,3110661108,1400243206,958476288,2098280938,2662915397,2468285571,4183075362,3295671868,343779808,2852208237,2143457990,209838621,1746914301,2237587492,1027651829,2881138815,2808489974,358056104,3747724217,2658135608,1718094735,67964650,1664903262,3457804470,1952331956,2007535051,917760869,2312922761,4087286107,358022119,3481903012,645703777,30572508,3062160578,1424702034,957049903,4212427121,403279352,523332448,341699413,3774829884,1263766688,4028891021,3693971059,3656920063,4255881321,3818309398,520962623,772455291,3911952260,2357493859,1532977716,1296798131,345302639,686597384,1618231394,3173239811,1293869224,3087968556,2037790729,75540982,2636461275,2061763079,2735670443,2030215496,2116789483,4048031653,793273492,4190716252,4290057699,3662581540,4270479878,3993657102,1110111845,801130551,682386125,2113654329,3334342328,3704388475,2122274783,2755064493,1976461593,3176031156,3878588370,3598848276,3365761313,3540375200,690665004,823298889,4221609110,2694242998,3428248127,4031736499,2112414756,2124111508,3989941868,136047243,2785690961,195786736,1230438613,2868367939,1344206463,403795910,2768223875,2387956381,2032138454,2900630803,1171895822,2183185527,1995306567,1211387105,678199389,1823133672,1804643886,3641522444,797822327,1998704872,1661471389,170243675,1194946016,605093355,4109770067,1380444470,1672410259,3284681545,161955131,554434735,1101050575,144336189,1130506727,1799883276,1726514920,3056074072,3921933918,4039194328,2737615675,1502315147,1518103755,2441736739,3471991265,2869541977,3266307145,2238572564,3066201634,3996153951,1903853772,840614181,3446620095,4082555432,3168500850,4134625435,16379055,2438172398,2216326598,1588243025,2171400821,2425483512,3533198457,2228995852,428127447,3261908229,1407041676,711269935,1632203558,4095712461,2879507417,3948234278,2291108799,735675808,3202419690,2628930740,554777298,810821578,3448822022,4108932594,2629335679,54948074,3266686644,1917754704,4072670692,756272495,670814776,718610009,3481521333,2677150435,2525653048,2256162512,4213457139,3064833910,3811153766,3825573768,3840190038,2263769543,4230322215,691586948,2581333960,2477904138,2425386379,2962397543,543486117,2734971266,3178452125,66273410,3351312381,1882613132,2941925856,2113286607,3747173117,2385493071,3508097393,293546739,3810034453,3897853759,3193530873,1115149259,2476974106,2510631465,2969310489,4126698758,2471011031,883118268,3259639886,3355955404,1018925061,916624008,2327384203,1768995772,1963093993,1595463031,2268727348,1335170522,1482005248,3333768552,4069968991,4117878274,3398706073,2628912948,2822578801,3092795403,2683353966,1115915184,1110329563,4210783420,1014523095,4194016943,4240878671,2658671893,1908954057,2232060549,3741201186,2343484564,4235310856,2843450377,3755850354,1298968437,2217191895,1618125098,618793562,2289736626,1060045758,4292480760,3104220639,2659930375,3577866697,1946625082,4025025521,154998115,1032453481,910409055,317349003,2604244093,1785425057,625073030,3410222712,3009079414,98757435,890325764,891946499,4188375987,2269045234,3940958497,358369970,3744623833,3828721204,2594648435,622935347,3397256885,1749732110,569349323,1946233020,101520386,3959698239,86492000,2992325484,199660794,1531740396,3158217237,2646742566,2622460434,1718198789,1352964149,4088875208,2643999676,429913212,655382466,503133479,626394264,3433379519,3966436972,619799452,3219526538,1578893257,1606785756,1599609027,4121361321,1821362344,375715917,3960596384,2210574792,3480536981,2136058357,642196044,2712940191,749875793,114006606,1198167945,3636267759,2551854755,2177724350,2356553070,1819476729,3763000667,979269762,124584459,2500951878,3715859539,463439895,1443509743,4039018640,828741361,2042666941,216478475,1468242257,573325541,1457780480,3792606393,4204882913,230364713,1107294038,2954418223,144004627,4044058786,145350709,1230077898,4113110215,1168263660,529160722,652174858,2070934123,945859948,674827626,725906873,556763097,1415463552,1924983096,639852202,3311543119,2518751597,2244530430,566898659,3079840828,70390290,2344578868,647433190,3017913437,1384723414,4274683974,1382807215,2117702307,1562008535,2915247663,1504325198,348759728,986122104,3717003762,4096220436,1359859237,4175192415,1973058554,1581235202,1321621699,152626609,923831310,1100935474,2465151994,1534743547,1145303512,753400656,1551547920,3868194252,1690710934,3272997108,3017127833,2074023810,3621213985,1657964356,92764251,4244757522,2330471082,2370766654,3196572026,864704137,1778635497,2472276698,2609081899,786156752,2389818251,4201931218,2693434305,2975857523,2669995116,3354004190,671350462,901572550,1008698811,2954702571,1631450935,2818452042,213376585,1261119747,3209192371,3307694070,3319202473,517586427,1615130638,1084733659,3682972633,679966383,3168277865,3409582414,3417351666,2215126147,2418447248,2791390386,1350786027,15102806,3951359538,2574587516,2523805476,1025643667,1622234630,480662498,2021067082,281394381,286897264,1406002057,2879895750,3573880817,253978922,2521436610,1923298251,3759213281,1108928806,3784082761,1597798271,3376767638,1320804124,4218393443,111336921,3833238710,1538478975,3335134782,3565448640,2662439349,3673304372,2021213939,2055114268,335132684,2052658698,3205957229,4253354580,2841960641,2778199293,3433345908,920222177,2342164464,1321309627,1828306639,407891852,1341735283,2991429442,3211786750,3173999721,3443363970,2622619953,2288600317,2138549005,3688237234,1481004045,2745756031,3379277885,642549770,1985551693,1227576018,1884291637,2602215378,1688280312,3902961665,123884830,20048549,3550802502,3986691014,2148188151,65679966,1705286260,1418959772,2215085293,2799703869,4087684314,4089601316,3812504194,1658316900,3773201936,2654877356,1185964831,2684927724,4280177605,921921012,3296048383,321005557,1914731866,4082460516,4285497802,1251762524,3797057147,1634740945,691719561,3095052972,2710320070,1964979328,2363471200,3079974704,2034235988,3531731989,3058587545,1675281698,1910214867,1419564272,3510170235,2383622104,1803789714,1198231786,3910869974,865706339,3568478391,994163853,3384885670,2662469161,1710557718,1520178528,3359912510,1022687519,1645138974,543272655,564011910,421771523,4204098334,1254172982,1776421616,4089200404,1299809365,504364064,1090513427,3806689982,3231527101,232446871,1265833034,102712307,2194541393,1262419490,2415605050,2846792851,1752364515,1401782357,1178416425,3361726793,1663160417,134279268,433114227,3589440727,843624470,3568829177,1237880957,389515679,2445796405,3514436196,2027235806,4020187017,2317284487,2008133359,4213940295,1171462266,3215848577,450991251,1344308874,2225530065,1078519843,267918090,3892742014,998330928,4007899304,3865774882,711524336,1225499527,1443784353,2412116353,2701129676,2282050427,3568372370,1543174000,3352653747,987871172,752506431,2664998021,1769638530,2030447848,107930345,3626147140,1517289394,1584873703,267886993,3891203059,1778910378,4224900610,948655352,3167631050,667062172,3275138785,4078612176,2700690346},
  {1262688387,868344123,302997634,416573603,831915015,168809664,3020644227,2908714691,2082019299,4097629800,918018933,3863811242,2039569382,3353842091,2946864245,923954824,1909318579,3799052708,1381903073,2603447055,3281627856,1801164217,4203535594,1603498864,2693110643,1867450616,4286509736,3151362554,192542136,3236355733,799457779,3853557654,3216955543,928905039,2019488772,1135049440,3209362823,1370543093,2149401160,713967888,265133634,2948664453,2328976096,2265180305,3091386098,2190824377,73221260,447477412,3412550779,4078499492,1148562241,1684568870,3020506360,3361118220,2249306538,1561301386,721554957,2476209661,3360397706,1644413385,1623022247,2118997943,973620295,3075246246,3831130104,1342771077,3428692372,65058617,4111940038,343413209,14337341,234345090,2305960653,1280103730,1827304453,1571675394,3590210054,1372639339,2487448639,550127620,3694567454,2944723719,236487628,3943277030,3578052272,2689947505,1432066773,619817393,1331781775,1313294088,2912184989,3596384667,1271773123,136326176,345847238,1869665494,2466695479,1158093120,1829064094,2948568428,3521302767,3433334766,2240354074,3087246742,701298784,1332226401,738145987,4027188847,2868563791,4269364130,3392926283,3866123806,671493245,142227120,1415098063,2980311604,1775774538,2296389275,3626887548,2392522741,3790595656,3400619037,1363361746,4040037114,1191013857,1591509069,2501288517,3584412907,591392121,3241938862,841822643,1434163154,3447023118,4282367542,1068599653,3823861422,2164554234,3583851599,504806238,856306110,1323539870,680455693,1643136672,3040386071,3186865873,1602960391,882681733,4110377031,2317968049,3072474855,457990262,2202033361,3098312709,971867395,3578484252,224274044,543796090,3904715345,1458155875,2701251406,3579350156,1960246173,2939810019,2301946639,2739058855,3080352152,2501060472,2860179726,4169943892,4165348908,1627869315,1560777575,913778255,10222063,371403457,3461777639,307260695,1211273356,1886845234,3328966836,3526842511,2059117424,2681896423,3317940904,1512822457,965979796,1381632547,761064709,2894770132,1852788762,925390183,3531313922,3802646347,190497622,4156322321,3093678116,458990511,10522047,1270076012,1966538904,351609133,1667115480,646330176,2880078846,3024590933,2763981283,351672229,735677487,1485414492,3565164258,2216060666,1679372270,2026998032,173553834,713536121,1755782673,2815105218,2287048120,1093692014,2131767341,1759520155,2267099197,979527082,3986731260,3905354860,3170713178,3413786722,2033837750,2130628904,3448863854,3271022490,3573267148,3051986509,505736488,1610588312,4160395379,1045676322,3354047099,364744860,692973779,2473177542,760185867,340853473,1561764226,1247802877,623203345,1756731210,1881583650,2700499430,2944322463,3857018699,4226146577,17806166,1920630409,1362736660,210710404,1805460652,4136803774,3686259788,871213122,994683182,2958868893,4276867948,3951526444,4030519464,262190699,173616563,545256939,137978334,3116479540,619105126,821406394,1984399809,891350447,4030140208,2545152616,2804754350,3417075990,3589145462,1370947447,3701110332,2337838532,253329943,1385369817,890815732,2588445234,1730231070,1372173116,134577365,1604671045,1820305460,548722487,1211643146,1764644949,2879545039,2728504976,2322407850,2208818820,1058799936,2434027693,3037971496,2137116576,547595075,11048187,3337076173,2304143447,3321145583,1785266544,1970709738,3833792817,3450242329,2160061743,1628897693,1273590942,2160543703,1921724434,1678517498,1107700654,1276160024,1840574681,368077243,132525445,565915598,948487919,1452952665,3036814394,364775955,1065193558,1695417033,2333500112,2651830495,3647615364,3495885971,362505725,1047602121,2899492030,1122060262,1424031226,1894268627,1742758394,1948902853,146523366,598612856,331888985,1248462122,3085465848,2245934206,2934322038,1868095102,574277392,1218596429,1040851159,3502498699,2802646575,1498192417,2077666324,3505056697,975383910,4248348332,2939449316,3251420868,2193372790,2912235018,723599214,3733734845,1199638494,1317861124,1566030136,1421739087,760158544,2882179015,616332248,4135190644,1160395065,278554926,1232127070,15396140,593406824,2623109875,2926873573,1357637645,3115260452,2922382539,163854971,590699266,4156478889,998030718,893575515,100219415,825643336,2279992950,739677113,3571688040,2463749740,862905670,3081798030,4266981390,2920763415,2235939863,2172605340,3926514637,3197337394,58773096,1490259488,104332179,637958871,428445663,1578807154,278445850,2728381348,2956651167,1235952207,40293978,4178846961,1931602099,4094109075,1467829989,3081075206,712380420,974617650,2104696295,54064598,2880572673,2360708434,3178221898,838442195,2810193786,2463499739,617456330,922520862,2264041520,2202091806,1743593059,605004855,3770888178,1058484551,852703127,3725381538,2118548895,3200655189,1478866793,2766189336,3710575940,2193483923,1958634499,1766058652,3159826976,1430011236,1537625196,717154786,253413939,1020864360,3168387311,1436763364,13884805,2752803897,4131031148,3066293868,1450270275,4183180145,1939485325,7799725,4064526172,1597173239,562869042,4197971774,445490432,58126198,3072854321,3341898442,2784758334,1054473370,4031461185,1391185824,155597166,3074815888,1567448421,4185526260,3738692530,1473556987,324367939,518607971,571257457,1612306722,3624219640,3558781331,1516442854,530918392,3189768245,1201981878,1549541317,2678425635,1423101278,2647419124,46619890,1735828337,728323669,3872393845,3684990839,2067229068,1826978312,594889601,80044664,1716695168,1668081728,958298819,3455224127,48545153,1118014782,1062878417,2294494674,1412858900,83349539,1363012022,846837646,317990555,3407261902,640483207,4098324169,1625552993,1546625431,1068687425,640565304,2375066896,4177204799,67311965,1809790416,742214002,2753667729,690824765,3245238686,3648815999,666526580,383112899,1900356526,1713591112,3574225246,3407156158,3944962732,3281017817,2882937927,3550507569,3219869321,2831589387,349118817,3126818042,4207379568,3498396183,198307022,4253526789,3047053982,2053193607,4074406432,876618225,3261957403,2861262469,2408614949,2601161387,3036837020,4193009295,3230369472,2485429267,261675016,339918378,2385810764,3387406273,2174105353,967290710,1316706495,3273002167,4205898725,2380019465,2336346431,1202539322,4257468652,411892080,611478482,926851837,445311703,1634980274,2051812022,339121092,2379587953,1144706572,1728812373,288765102,267916030,751845288,2327698335,3355185812,3916681944,1912477386,2502281693,734745813,2518158892,2576715724,3919720985,1490134233,3309236208,3246178417,47568470,2642145565,4110031902,3230466716,4123196148,550809389,3331083316,991970434,1084374348,1809951175,133002034,1107679498,2322149912,2995605328,4038962256,480557281,4041470140,3624745460,890788706,3479235678,3179572966,509860402,3300801322,3858176703,1801686866,1008574415,2082694490,905860424,685819996,502294761,3654071562,3767055654,1871916909,1600755407,3442430967,306716519,1251220192,4275387481,1523217340,1447591923,627780515,3654784889,4281374123,1150078111,1720096130,1527274772,889235653,1994612146,604803706,293403083,2666049271,2112378744,2487465850},
  {1579325394,1889431874,2815240770,1533076325,1675601278,3073919757,3504594026,249972878,758491779,2377929184,3332314185,919716298,214697438,1897586810,3620971413,3647076804,1172070134,363657285,795209050,1639401067,3090850014,1306701528,1495401084,4181114028,4237151417,2173042989,902366061,575425518,1204529026,366003451,158492684,2971608165,1584899585,1609743891,2049442074,3507775888,1238453377,117577966,985893759,3110804408,4058973562,2599774575,1330518010,4169053529,2886704204,3457832114,1529115948,3006424767,2747650563,3128304801,4006336518,2174176968,260844168,1403896739,2381523190,285653512,1743314530,1421620042,3061451921,3645028389,3072066009,3242194262,901452023,1209957755,691336156,1316711595,365841496,2365078861,1530785363,1678622577,2612384477,3764537298,3757047485,2676024758,3783335230,1918202820,1847023919,373257844,180501388,2287923550,1704406421,3942836521,253989494,3008832411,2334289436,739144714,577306145,3044450262,1440618356,3660900394,314648487,683095642,912579142,3147741756,232479456,1171787365,431777565,2343246030,1019829798,3199865556,2656528499,1661550448,589343069,2781274256,3070720359,2445942557,279077960,3558538007,3826572609,2314900193,3395306485,455741092,3425076353,1637729701,1289663321,80378784,3760731501,169999281,1612249310,1163393845,2626910518,4199197297,1077028048,374751963,601538642,1508989684,1455766205,333067820,1846789954,3202962303,2500880305,2586085248,2793996241,895183366,2473447817,1826709455,1783382539,2783797901,3105004494,4245365288,2913279616,2436375385,3894496454,696352132,3575805703,3612144531,3182001841,3056214337,460103750,1997171077,1777810187,3328276020,1728961297,27968311,202669836,1409392771,3485315634,3715318605,743602024,2988520561,1287949209,2979981155,3504538796,3225800136,3483122595,852539525,893567771,3985210578,3406275131,1976959908,1022369530,4072299480,1047276954,17785928,1929940932,3792637310,2574431392,327246888,3748849286,1434166819,242212485,3840543386,3788307251,148099637,2327261655,2780649563,1152074014,1501014656,2443121627,223573591,4028201903,3285379931,3493978773,3800776690,4254877275,4241010014,852722712,4009741250,328366924,3765796616,2127683858,1605941640,4273350783,588761321,3695714700,712346592,4175433864,2276518300,3350148080,3052955142,1978900130,2036255990,2014061952,2307520928,206853920,3582857411,2186055557,126218236,4283026388,901873828,2379250137,735354910,3167105723,4142784688,4089520944,4165742140,2929683344,3034095560,1199487403,2935945544,2857294173,2571136184,2998865439,1199076834,2209613467,1439073951,170526092,3761423196,3074121720,4139757964,522941728,198366719,1148270670,3762074788,1573290530,813866167,1230694840,174042111,344065931,3501752523,1939377144,269821860,3360959437,2595191126,805792672,2041664185,2534800504,2918108342,692780289,4127825983,4228004364,3965034625,3481281089,1193961512,1347021436,155123194,2124563149,2765454942,1470306345,4167773808,3914526002,573504029,3726884688,3054926263,285626546,1745077127,1639493062,688358505,2075444902,2739543058,2928118210,4123457289,3100493364,3908099427,15919864,1782075252,4074686030,1384609646,3371948679,424929723,1525388783,1473848758,241934079,912330564,2928371174,564658127,1460080751,3917107384,1964149044,4270063829,2752358541,628543714,220248945,1027397769,2093407045,335628076,2783194927,1684101162,1523974873,1036520542,3124518323,200439447,3796725067,2910022591,2095677175,219109337,1288058577,2633296369,2011672428,1512358782,1272821429,2862540532,349564691,720014954,2549390442,273228671,2392363843,3088322107,1355932218,329240213,876944203,2445109695,1857998234,842961820,3294131851,1388959341,206855047,2947172203,2325974610,2816438111,470020093,2790826465,2701301540,3007572680,129249303,2874167851,1142172945,2744285822,3627537452,443891116,109014842,1029900120,1839623525,332759330,1309892052,1628323960,1959153749,2963901719,2618267923,4273591022,1042130332,4033993947,1639888541,1409143749,1951181315,97030397,1022860101,2138037017,2289594937,266998736,2763946395,2457663445,6247622,4211916295,751740707,214650711,1918751339,3238536484,2991258641,3953583602,3111177923,3016732372,81158010,1428521864,2315831226,1219035384,598632426,3113898523,1203778746,2161648922,3977472329,1968858003,3842117340,1709187605,2891997854,3655525983,8093370,3455361473,2823019921,2893512876,3725958649,4220572376,2915772941,3270191049,4045115886,3512288186,3280365959,3694683953,1205243887,732717970,4200964190,918328919,1867738123,2907408575,1015310189,72094213,1326296921,488362859,1135586627,3912526062,907399791,99963748,3861649112,995446047,2795063471,3338806565,2541402581,4210268785,2671098146,1125911663,561555362,118324633,1112828606,4206805022,3483232545,730342642,4186063791,478623122,1601876813,188726398,3362632124,649890500,1208760503,1179308559,3527838044,1934991604,2503841342,1797673619,2593969793,3033546152,3265210158,2697235735,1679938520,3706289070,875012701,3191964483,2340721400,93191775,72908523,2772694034,4231092374,530171543,1969824668,1191084021,865103672,3349032650,428107233,260876734,3076012927,3539053103,3178745654,521418091,3715368803,872430550,3796316044,124658260,1002671047,2350623364,201291583,466883982,1639663181,2155932570,2598624223,1664470177,117032682,1525018124,2071083602,785302771,2787167120,3239720098,570847791,4233824788,795904179,177508342,2676826021,699361121,2792866257,2708939764,1976539781,1685834385,438725818,2502780308,1679742401,2030448988,3913114178,1987185767,1641385063,1894877492,2583139833,2345368074,2553101778,2292450437,2349251913,2132059518,1522443776,2931907418,690848869,715744013,3373967222,1411465065,3132538484,31904256,1132549995,3174394811,1081760502,2576656054,1770265489,2037551241,446366561,591225663,3567761161,1558714378,731230029,3740728731,1302075422,1432101949,2875713403,3697281239,1887950340,1472648640,1608468257,1128925070,1348243682,313175312,2538221218,1163598630,3489469305,1396877329,304772137,1615494565,2162528186,1043796133,464523330,1212132298,4031168892,140121130,3891144889,3451993374,1011635342,362393016,4244791051,4002297364,1606981934,2833621929,3594281099,4110376078,2561057248,1505785866,2793966807,428503650,1769747283,1417895050,2985349051,485589424,617807483,1103574942,3906356589,2597071911,2540350238,3211714475,4010674887,3800471932,1589085056,2729531021,2205758364,235037603,2542305383,2639086451,3524536061,2034250634,2970638562,2477473421,362533538,3562388127,585982470,851083578,954581602,3853388824,4132945562,233348908,158159284,426527287,973697760,3486532596,2358749826,2530318733,691573164,1793545885,3308370821,3040707083,622991086,3112060566,4274689368,3412842218,87486933,1828436985,584548108,739866581,535569745,519005876,97500475,3043700524,1510164014,1406334749,1797500407,4076041087,1391008103,4149750910,217898950,2220030256,810059478,3001120575,336170245,3594166950,3400673706,3007297935,275678704,3686911866,1668369985,2112358797,3916862292,1570005012,4195208318,16402313,753706732,3536891891,1160008775,3512844538,199469100,2192633888,1477526764,3474735138,1514390402},
  {2250674169,3994504747,1156126483,3913602952,3676364156,371599263,2833003111,2000245031,3011048292,2662979097,3674228436,90449174,3279773629,1423516865,2041671543,3623426310,985461430,494442544,3918664906,1632711288,3994436830,382853826,2568270485,1021810070,2083587194,1016966869,1174884687,2669722978,1652423043,2313506733,1785228214,2449500415,177196046,1878177772,2918664087,726086185,1586010938,3039787245,3742163940,4100088145,3605782609,211765236,1788567563,3970889871,2945113059,1523932839,688684673,3214048637,3143590224,619356868,3725518103,1958434404,2346217168,1803060119,1532233450,355776246,3497765146,3515574561,3576944701,179841322,3771372008,452243513,1625878018,867865382,1546472908,1964241811,2239971297,2022073484,3834356319,4138108299,3232933269,1932502330,1639380315,2299288822,3026837011,2690998641,72041093,3699128250,245452163,652817453,3868822403,5619703,1336836812,2390460405,2641783530,3958689154,2034625377,168461652,1612001119,4072815853,2459581986,3712845262,2243377195,2742234931,1903115999,1283512040,3790283446,1272711330,1055214675,4222346592,3056337145,2891616238,15748426,3671931299,3950678452,1383700490,3964187129,2152328682,3569259327,1989270724,2950509394,628551247,1860158826,1224216743,3680299231,1913866915,3971402855,3965435659,178874555,2289915349,2890775243,3055775711,3715668371,870837129,242130245,3098889202,3435993445,3943257318,1343806125,4155936355,3209187359,1525525373,648533944,3379228569,3000223371,1529263057,241011397,662437397,4184281207,1970809101,3625931978,1438179828,2574553565,1771493123,1495926830,1671420845,791779328,971528098,565148871,320582746,664298556,3996634877,2970655838,1349153231,2303450010,1441356232,384394679,8992960,1308411053,2226578915,927459585,3512961410,2965307138,2732789268,1721384834,3475413024,2016914496,4155568048,3403147514,1252572558,1180613718,1942233293,482859912,2937526868,433094150,2610870291,2184268879,1631632637,1756419410,2612969869,2672695411,4146073711,2783115478,277407138,812144080,2518813200,4117418928,523452044,490834317,747585170,147585573,1774342871,1879654338,2823790725,522804338,2798147720,755584318,337135411,3923675048,494137698,4131263972,865562432,3264429888,1347575920,4112170104,1871643289,739921061,302258379,2237566071,225528806,3876311775,3290767793,1175481592,413390569,1775394551,2164062264,42437508,3490692035,3045868423,3883961091,2339920153,3409374643,724539226,3629188245,405684110,3132781814,2185743264,903718663,1520362085,2260306826,1545882524,4280222790,1493902109,2868793471,578455094,3048294516,1146350783,344449693,2437567480,2546101122,41327371,2157382014,212331623,2567186242,3595447663,2929344897,39367355,4246670194,3216790123,4097738365,835594546,1108177369,2058367461,1425064248,560192734,4202296154,2232023261,366379739,1565010083,239339824,1961034757,1804058531,2640637592,2243760513,1743856806,385274495,4195602787,357488712,1137831082,208261943,1635277032,117321314,430492549,517876409,1633270251,1446827342,3855129806,1030824791,1272767748,170893481,2903035048,3005542539,2389617636,371376744,3036139848,1554707009,2258938150,4241781948,3676948014,3930862606,1415564915,1296838475,3750407846,2293526428,2451453942,2370905901,3069528558,1736881093,3890941513,3724859091,538662635,3128588107,3135962600,1207246702,3321156965,1854136549,1566239281,154084690,3318688785,1889151151,51854218,692170467,1371023770,3675629073,1085124369,3508747388,3999548263,2965174183,1468078021,2486822637,4092913178,4078825516,4134332826,2064785561,806765726,3403554245,1681946859,790000118,3507507045,3730784125,1184113958,1576003825,2333304221,653696951,1740079166,3702140927,2079904096,1230684559,1276406632,1911165776,3563030351,2089681564,144317449,2701609094,1201202140,2990363547,4253079025,1448463658,2229407536,3690704380,3191599661,1562204677,3888002616,197326304,1691265401,3355900836,187164263,2526676217,1003034413,317008418,2080763526,319073822,3945572041,3020973328,3975343429,1088440966,2973246497,2762690701,2712153628,2702655468,4257060127,120075225,292275383,4016887660,2193070232,3960944514,2671300028,2907884921,3597020862,1061265183,1766049501,4289120599,2728799300,3107236939,2503971390,785788063,3081486085,1371922931,3419173359,3087965108,3213844960,2419250886,400243156,2000677496,1831519743,2701616542,560608375,1947999315,232018703,748813533,3206579502,1021089668,2633149648,4134212638,3987551946,3307123818,1585963282,4290776990,2823131137,2061818656,3396100225,3574426632,2028044008,3122017036,2782106758,1732704710,483135034,2448194254,2827746259,1896932644,3608258897,1530074182,2807567702,2846507279,742942472,3578204355,3511574700,1010008018,1197710884,271341913,537077839,2757273885,1201920792,1722774854,1209521644,1255467439,37338378,3913034561,2938942270,3520338224,1707381377,676215045,2860027871,1859419499,503507519,68709958,3700284769,2043142008,1856556055,3071565455,528950930,2737583959,944200171,3205501454,837655924,607686520,475178351,1064886510,1629025855,2859109603,2512930776,1202811045,3843925575,144390663,2420144483,1828286274,1886459210,929707757,1957067070,2672350218,2618550872,185072933,1665697893,2322041829,935744942,1541678928,1109851526,875525977,3137286054,3054131483,1545767872,687053309,2926903559,1949303729,153148525,3289260137,2912973927,2282915709,1458012772,3868689503,3508412192,1637440215,2902584897,2333829149,3545456768,968573544,89592561,3257609558,3072947754,4279579796,82654246,3217718803,3311074172,1710035769,3374367971,2441504157,4099720736,3314432581,2186464477,3314455091,488510707,1656060568,1182670292,1010565248,1135459656,1816174402,1221646696,601630562,3875208176,872729093,100210314,3018346504,2878018128,2221436549,2239060576,3174618972,1159900086,3997075994,3596087430,3612822963,906769510,1713749000,105277339,501740541,385493594,3342389804,1526459834,926972522,1430831052,2160312157,3762555740,576505754,1698966111,3302748953,2767545040,2447135458,2845272387,3232403308,310457643,963319976,2693527039,245813161,3194008007,801370766,1542141765,1596125657,867467139,4284441909,3906497402,3028449498,1091108085,230904603,159648941,3291053161,3157936332,2989592185,3293556409,2969666911,3044081295,1624610077,4216741980,4264576966,438656916,1855218994,629486629,3031620938,1924299150,727404667,858456238,2479156596,3951612133,1718880209,3640991651,3758030645,3768090926,429290970,256718813,2023956268,3981702321,3730865299,221352202,372459688,3387172713,4035033014,610042093,47622431,4237697038,313536911,3851882049,4110765943,1298069131,3184569332,3867188598,2791598608,1964977917,2368955295,39025045,380121479,2535042276,4261775200,36984362,645239506,111036174,4234126852,3228035115,587163431,901443640,2673985197,1322185940,4232709808,4053924383,1760984600,3528184874,2410203244,2258883299,3604544065,3471964193,2212395562,2193718398,3859632340,1429290025,724476345,3047287205,1611733996,707164052,3697091169,513892779,3716368479,3534917339,811803975,4151373731,4227272565,3540240156,1733039235,3796417444,388374059,2521929519,4160084961,1233796082,3828727057,3359066035,1254854001,3377206905},
} ;

static const unsigned char precomputed_decode_653xint32_s[precomputed_decode_653xint32_NUM][crypto_decode_STRBYTES] = {
  {168,40,27,227,83,38,19,235,141,14,139,99,19,182,220,241,59,254,153,157,134,40,195,187,70,215,22,18,144,164,229,105,80,96,216,112,121,79,106,59,90,236,143,252,234,93,235,201,216,211,193,203,244,235,104,185,6,4,118,83,0,48,33,57,234,57,17,125,69,221,184,158,131,12,31,147,34,170,84,249,60,246,111,196,224,169,125,20,109,62,1,170,198,146,194,127,29,226,129,12,253,203,31,104,36,224,94,133,245,184,64,61,127,176,186,171,246,39,102,167,168,128,87,21,185,187,97,223,56,238,111,158,143,11,104,102,234,14,13,4,94,104,60,99,182,232,25,206,180,56,94,116,203,141,168,119,101,235,179,54,137,102,220,137,91,9,159,243,231,251,86,21,164,159,137,207,97,168,124,38,220,127,210,1,194,220,132,182,82,58,235,84,47,108,11,57,113,137,20,251,248,141,9,24,96,107,49,31,85,235,93,20,60,85,255,224,160,140,83,75,141,255,35,240,115,134,45,220,255,43,248,217,105,152,171,253,22,199,150,227,63,66,13,31,123,187,10,46,132,167,43,233,99,128,132,140,52,98,95,91,179,145,75,77,111,230,148,20,8,165,236,40,98,64,116,96,3,204,35,189,168,224,30,77,44,169,14,184,9,56,118,121,246,169,128,4,219,52,37,157,7,2,228,122,171,4,15,163,72,161,2,121,235,164,43,126,165,15,72,241,148,100,72,47,92,65,201,249,227,21,181,255,36,143,78,218,6,90,138,254,14,95,10,238,101,246,42,66,55,72,192,47,205,98,172,40,57,206,251,125,184,6,190,198,123,123,204,220,223,87,127,126,173,242,54,164,25,105,206,117,180,99,78,189,210,143,46,231,20,17,130,214,33,113,157,200,160,214,5,211,44,182,42,41,73,139,18,49,150,164,160,251,182,226,150,160,63,234,86,204,179,106,79,240,36,228,232,125,148,94,155,126,108,174,209,237,139,234,27,8,81,69,10,166,240,119,171,11,213,0,87,73,67,210,247,170,127,246,30,80,198,111,17,24,131,190,255,164,157,82,85,142,214,248,31,121,19,29,228,172,14,182,217,69,119,196,32,130,71,246,237,118,225,76,52,72,93,128,108,40,232,207,170,108,46,174,144,107,12,57,13,217,119,205,141,47,232,208,33,119,157,10,8,99,91,182,37,10,224,109,57,71,235,253,16,36,83,29,246,244,54,233,71,82,147,244,174,99,73,67,200,195,59,61,167,9,175,0,12,33,207,178,160,65,61,101,154,8,231,41,98,67,12,10,72,107,232,134,232,102,88,253,39,182,94,246,195,233,216,54,193,240,59,179,44,163,139,130,139,89,203,108,124,90,35,242,137,145,225,97,242,206,89,188,9,171,73,228,175,194,20,232,109,133,34,134,194,182,95,120,48,238,204,128,122,113,37,193,26,50,191,63,111,205,40,218,86,243,114,124,219,188,155,96,113,246,175,236,249,0,238,142,83,145,198,117,26,132,81,170,170,94,117,242,108,129,248,240,145,144,121,84,152,210,12,199,219,132,215,180,132,25,5,197,108,194,140,192,221,83,47,30,101,42,38,115,73,97,205,156,31,244,217,203,161,171,38,70,85,235,191,139,143,136,160,133,217,43,234,11,225,190,180,76,178,156,210,58,17,33,202,39,84,48,6,217,144,205,242,85,233,244,127,122,184,156,234,112,70,3,180,174,181,194,80,157,78,114,228,5,192,242,111,205,19,45,56,210,251,39,89,30,213,42,181,204,131,207,227,18,146,159,56,104,138,150,208,78,122,134,243,64,36,251,118,167,173,182,102,151,41,227,136,159,5,228,86,166,228,228,199,97,238,134,39,152,37,252,132,199,56,41,200,7,220,153,10,209,177,147,139,117,144,144,103,153,146,176,165,240,100,32,130,89,4,163,157,84,115,189,130,64,243,3,253,247,192,199,140,101,54,112,224,57,90,175,207,49,246,125,253,82,89,223,79,188,47,142,113,81,25,209,243,42,127,17,21,131,24,227,63,135,84,232,249,105,89,190,203,211,119,66,26,160,163,147,41,50,165,149,25,21,252,176,6,109,248,245,215,162,72,147,188,80,163,52,78,40,74,194,204,208,7,200,5,144,187,60,136,146,162,54,139,16,185,138,188,187,112,105,233,111,2,117,119,213,24,95,52,8,58,135,218,21,149,79,0,155,85,88,104,69,181,198,95,204,150,242,2,214,113,245,153,35,148,202,52,7,178,156,113,34,61,168,11,80,88,184,110,187,240,159,176,131,131,66,219,72,46,66,188,116,251,250,215,100,120,60,175,158,251,249,79,172,198,252,21,29,120,158,201,83,200,113,133,138,10,133,34,51,254,222,148,188,174,139,8,183,113,252,9,156,123,169,114,186,221,223,117,175,108,77,215,169,39,132,42,161,114,96,90,10,226,36,178,155,122,136,190,3,47,63,248,14,218,255,223,165,6,185,7,81,139,158,201,233,65,213,58,36,7,116,241,3,233,239,99,21,61,9,105,253,137,61,95,189,67,54,139,92,234,18,125,156,57,155,161,108,107,106,134,219,65,37,120,222,67,203,118,232,90,179,59,235,226,5,4,75,17,53,3,6,42,53,179,139,165,249,242,225,62,135,33,65,230,234,178,74,92,21,217,108,50,223,52,166,53,228,115,49,167,154,51,61,33,37,181,6,126,202,14,203,74,104,203,148,239,33,188,40,1,116,2,20,13,6,63,51,4,236,96,195,39,5,108,67,91,178,250,148,230,11,236,128,76,91,21,146,62,188,38,22,194,157,18,146,79,156,5,162,105,102,53,152,164,80,200,72,183,243,188,59,152,157,124,244,159,25,194,87,16,39,39,53,253,29,152,4,86,37,191,54,165,204,108,6,107,236,156,99,241,36,138,19,230,191,201,255,27,94,220,154,197,95,195,24,88,95,169,251,166,245,168,200,143,108,77,248,100,22,160,231,17,236,200,177,194,131,149,199,116,207,245,169,81,127,76,34,71,38,159,46,180,161,81,50,178,44,78,154,203,6,137,151,106,71,239,10,189,216,163,54,26,152,190,111,205,129,110,37,118,140,249,2,115,108,91,213,74,224,130,120,94,58,11,2,109,7,70,127,17,149,83,132,123,221,23,136,159,27,239,53,10,86,144,136,190,240,241,150,101,49,189,159,192,121,11,51,231,12,81,153,131,87,229,64,44,34,0,247,227,86,185,148,14,226,225,107,161,250,41,22,187,13,86,247,255,65,47,216,24,176,19,86,149,8,162,112,11,241,53,224,169,8,202,127,81,73,199,20,41,245,236,73,162,69,18,90,138,31,10,102,223,38,107,242,111,123,108,173,96,56,106,13,57,40,185,117,68,43,217,135,47,33,128,66,94,84,56,233,188,114,170,94,35,38,79,35,98,197,109,25,33,150,254,208,200,133,227,47,202,33,60,164,146,183,18,18,50,4,52,111,191,139,230,11,151,38,93,180,225,179,214,51,137,82,70,128,202,254,175,246,107,82,163,146,57,126,215,91,26,93,47,38,195,173,78,46,170,89,176,166,201,20,120,7,199,58,242,249,140,221,20,93,39,244,37,206,13,81,95,97,220,248,250,123,154,117,2,188,63,94,195,88,198,78,177,229,24,9,14,140,16,55,50,241,158,65,250,59,239,146,251,83,122,91,216,241,67,68,80,251,231,44,16,190,122,92,204,245,143,230,150,51,198,100,244,248,21,195,153,183,213,179,130,23,159,123,33,87,215,215,68,135,210,98,91,120,135,5,18,220,1,253,170,42,232,138,62,7,79,141,122,209,135,190,137,86,138,51,233,210,3,106,218,242,91,147,43,110,131,155,208,204,219,46,139,187,113,142,210,97,116,250,193,139,138,160,115,251,95,177,108,228,36,159,222,10,234,199,190,254,3,40,198,231,188,53,187,133,31,60,235,46,29,176,55,247,61,97,74,42,254,167,73,222,183,12,3,41,43,75,179,99,72,191,246,103,39,197,169,2,215,197,251,189,217,30,14,240,68,96,219,184,167,64,217,179,133,219,175,118,135,40,105,21,216,188,78,25,58,203,242,165,176,203,131,36,8,132,144,147,38,144,178,60,97,166,235,91,131,80,86,115,230,0,50,246,132,235,124,22,117,153,36,55,110,150,147,20,34,61,6,86,177,96,226,83,166,28,74,9,119,120,205,188,197,16,112,180,25,17,137,227,205,83,198,184,167,171,241,23,5,213,42,105,35,15,194,17,74,150,203,51,163,114,225,10,17,224,38,233,24,66,73,133,140,225,127,119,60,95,150,98,69,201,28,223,185,78,99,147,111,251,217,221,162,6,182,148,122,228,127,83,179,91,62,30,202,198,192,109,132,212,181,153,177,158,52,45,242,218,243,70,121,120,28,142,126,122,12,184,249,19,10,22,89,122,109,6,23,191,84,10,133,253,193,224,100,169,253,244,151,165,116,179,164,204,225,121,217,54,240,151,154,139,187,149,193,78,207,190,249,108,140,239,79,24,115,65,249,79,66,151,77,178,254,249,111,191,105,100,47,189,130,144,61,205,49,1,82,156,253,68,105,136,13,171,119,127,178,8,214,219,13,84,70,88,127,233,168,163,61,176,107,201,10,136,76,38,77,29,89,118,210,82,43,73,53,2,80,112,210,167,26,155,248,28,161,100,1,120,162,232,30,85,98,7,165,234,49,1,70,242,164,211,198,19,160,237,247,191,10,128,94,50,234,3,116,154,164,101,156,155,147,84,237,132,7,132,61,23,224,166,218,28,165,243,36,93,194,243,130,50,62,227,100,232,215,98,16,126,230,224,172,54,62,158,31,99,176,70,236,190,8,160,197,83,30,255,244,101,243,54,255,180,117,196,245,39,34,19,90,125,32,114,100,103,85,243,202,129,111,255,92,97,156,74,123,126,82,226,209,42,112,97,137,205,58,41,172,194,122,184,198,51,140,161,128,52,31,117,96,181,223,140,48,175,148,183,84,250,63,121,21,244,129,210,153,87,78,182,34,197,218,99,211,144,219,113,240,212,156,84,123,242,56,209,216,47,19,142,146,165,131,107,234,144,107,71,214,35,27,233,99,161,153,51,183,168,178,212,141,188,65,59,166,65,193,201,41,14,178,158,22,10,245,101,96,21,156,90,62,50,68,200,31,249,244,60,30,212,14,98,207,174,97,32,134,35,158,33,3,185,35,25,30,115,149,250,54,41,193,74,240,10,226,105,20,63,188,243,85,132,121,77,32,252,15,30,19,234,255,64,190,122,229,226,189,48,157,192,151,219,218,13,74,20,115,75,243,67,31,6,81,11,206,130,34,254,62,75,58,53,251,143,147,156,174,169,227,245,114,104,85,128,141,83,41,53,61,70,73,225,95,200,97,208,33,99,100,240,0,8,115,204,208,25,215,132,242,213,22,176,72,50,249,2,184,212,125,144,200,73,159,137,55,23,53,228,199,145,100,10,122,209,222,41,213,120,137,47,159,239,135,244,30,138,239,174,177,119,71,160,43,251,122,24,211,69,129,244,173,191,147,148,225,26,138,134,32,80,209,228,166,132,35,232,72,64,10,27,248,15,126,135,6,232,48,82,129,59,168,176,227,238,34,11,107,230,240,255,104,42,135,163,11,73,161,102,14,86,129,249,197,143,204,247,255,160,123,83,5,136,146,10,177,212,112,247,250,91,179,111,213,199,196,183,225,58,63,86,218,44,133,164,216,158,130,138,122,105,232,44,6,121,233,226,110,6,68,157,34,216,178,255,111,90,231,64,119,94,145,161,247,15,243,11,239,231,170,4,8,106,2,222,210,251,248,84,139,56,202,54,206,188,156,143,194,39,225,166,54,195,208,174,26,243,170,67,249,160},
  {131,24,67,75,59,225,193,51,130,96,15,18,163,104,212,24,7,4,150,49,192,212,15,10,131,95,11,180,195,118,95,173,227,23,25,124,104,222,60,244,117,219,183,54,170,20,77,230,230,91,145,121,171,145,231,199,117,148,165,175,136,110,18,55,179,227,205,113,164,241,112,226,225,42,94,82,15,115,45,155,208,170,153,195,185,149,91,107,234,220,140,250,112,115,147,95,115,155,133,160,248,8,79,111,168,242,126,255,250,249,213,187,184,245,121,11,149,222,230,192,243,193,166,47,150,159,176,229,151,216,190,191,79,247,93,55,4,244,94,120,224,122,167,67,135,253,74,191,245,211,176,81,72,66,29,128,16,73,142,42,66,158,205,15,133,12,193,175,224,90,209,138,145,232,3,135,242,206,66,184,185,83,149,130,140,68,93,4,164,246,171,26,123,100,103,203,164,246,24,243,65,171,117,68,38,123,104,100,248,68,9,180,12,152,86,200,170,177,17,134,138,145,15,93,13,14,2,43,253,245,151,147,138,153,75,200,201,193,3,98,167,90,189,96,183,87,77,126,71,68,8,58,166,136,76,183,248,103,90,228,133,15,9,80,148,177,93,204,57,183,224,3,198,57,23,245,217,17,120,20,61,197,218,0,130,210,247,13,205,42,114,137,50,213,76,76,5,116,234,108,2,221,173,93,6,66,254,213,107,208,208,81,63,116,67,148,4,72,202,32,30,160,54,220,7,235,132,175,204,131,24,14,230,161,9,235,176,190,68,213,113,87,85,160,213,154,91,85,177,169,241,36,143,96,97,79,8,71,71,78,157,106,148,173,155,121,92,214,195,183,205,75,32,44,32,8,198,53,157,20,214,212,112,111,55,201,6,147,64,25,7,69,158,77,5,109,108,149,191,175,239,208,226,209,238,135,164,204,26,23,137,133,150,165,3,184,96,248,204,41,97,41,104,79,195,54,255,43,111,6,10,240,79,207,250,170,162,83,121,254,75,242,59,202,30,94,112,230,125,44,6,40,176,54,122,8,207,174,88,84,52,242,163,177,74,43,216,105,155,30,224,136,124,233,45,216,245,255,154,142,72,230,239,225,29,84,177,202,210,63,67,81,250,18,206,240,225,109,253,70,77,128,220,94,69,162,22,149,235,204,165,213,121,237,63,35,174,15,60,193,179,49,45,50,210,151,123,85,14,102,117,205,54,190,63,255,101,137,177,63,174,126,235,227,250,121,4,129,79,60,157,213,94,187,22,30,190,49,10,51,158,157,227,78,13,238,142,40,160,70,240,97,23,156,56,181,209,182,243,189,7,60,139,95,133,167,156,52,71,96,255,244,177,98,41,138,231,62,34,183,118,96,76,27,209,92,64,131,5,128,172,184,3,133,237,57,28,86,75,213,124,38,94,13,122,171,105,32,81,58,189,232,99,177,233,86,78,211,1,161,140,140,88,213,157,251,214,116,227,240,57,175,15,235,52,137,167,184,66,163,152,113,154,183,120,39,19,149,14,225,122,170,84,75,140,248,44,46,70,248,131,80,7,97,103,147,7,93,79,38,119,54,239,249,155,0,193,42,35,22,231,136,86,206,23,109,80,18,140,144,50,72,50,249,118,112,180,0,108,198,143,88,55,210,112,163,187,122,231,125,218,159,168,194,195,197,185,214,43,90,148,174,147,57,35,10,90,82,5,237,92,45,212,175,138,172,26,80,111,110,103,85,40,55,2,147,123,210,75,199,167,226,86,195,90,11,17,114,188,247,36,200,101,184,175,163,91,27,191,141,160,0,108,210,179,75,152,0,55,117,45,33,245,20,216,41,94,99,64,55,134,38,254,131,170,171,85,152,71,180,227,1,191,164,165,23,246,20,47,140,217,43,92,160,137,88,226,22,128,212,250,102,22,132,238,47,25,100,16,137,209,120,170,56,88,10,121,178,135,42,17,30,167,104,194,24,203,167,184,149,81,136,110,106,48,65,45,48,16,127,155,37,224,104,61,48,33,135,170,101,98,58,252,176,160,237,108,252,198,232,90,62,253,188,98,64,122,203,182,230,57,121,40,209,254,126,110,124,145,205,154,215,247,194,204,186,251,212,77,158,233,181,40,237,36,30,152,160,255,95,115,152,250,247,34,193,83,62,123,178,234,199,156,144,189,21,211,240,77,41,198,177,105,147,11,132,79,45,225,2,81,20,130,161,22,93,253,245,95,74,17,84,37,37,74,151,181,104,34,176,38,112,230,89,246,160,159,203,126,175,75,111,229,229,17,225,229,251,86,179,15,1,137,126,122,114,20,182,57,81,132,47,143,12,172,36,157,107,190,157,146,246,76,220,183,219,66,168,237,51,46,169,73,59,157,193,92,176,108,211,235,254,44,130,135,235,168,216,60,240,107,182,160,15,179,45,89,10,235,245,127,32,222,97,57,8,52,180,193,185,102,203,230,36,186,170,245,48,193,137,71,118,175,237,32,53,48,15,55,240,104,242,179,151,174,39,45,167,22,113,172,203,118,3,238,213,119,255,182,81,60,118,154,220,196,149,88,139,23,130,25,15,217,16,147,82,244,196,24,53,50,138,72,154,30,59,33,103,60,179,201,81,213,124,5,8,69,86,165,95,52,168,127,108,55,215,180,32,10,53,56,72,85,88,46,105,207,94,162,171,144,174,161,162,170,33,109,138,132,230,167,131,64,1,28,63,173,80,20,145,40,196,19,181,160,207,97,127,67,163,163,32,251,148,168,0,205,189,231,198,87,112,86,137,239,168,244,197,112,1,105,106,234,164,118,117,49,9,131,228,25,133,166,205,47,237,191,128,157,1,23,97,158,116,233,75,215,71,199,128,18,48,139,114,250,36,12,100,174,43,6,66,24,168,16,76,217,240,180,109,187,105,240,21,133,45,230,7,206,47,187,33,239,198,136,56,89,76,154,86,58,28,2,181,19,10,190,21,86,144,125,63,201,2,14,101,208,98,22,139,223,184,15,158,132,49,106,217,147,252,94,208,253,101,155,21,201,35,113,62,190,188,210,172,230,71,225,66,250,253,224,84,211,62,232,112,250,97,224,103,197,229,41,116,230,196,187,8,120,27,174,35,89,57,200,19,42,5,106,74,248,120,232,183,126,60,222,133,118,51,230,174,126,222,88,111,16,199,58,34,77,78,162,72,215,32,10,62,139,227,195,208,47,254,12,167,33,154,76,89,20,172,214,123,185,235,234,208,102,45,35,58,172,166,56,253,228,111,52,175,196,190,204,193,118,54,188,130,10,46,149,173,110,63,33,43,189,69,140,222,222,7,129,71,4,247,140,78,56,185,87,93,79,4,190,84,80,25,79,45,199,143,202,171,216,123,188,36,116,0,122,246,57,57,42,69,46,105,154,16,94,196,112,73,44,237,234,0,104,171,94,35,243,122,89,156,229,139,116,174,13,232,235,80,36,26,175,185,203,4,48,174,123,58,196,9,2,91,53,35,169,213,190,247,126,189,124,59,91,225,66,53,23,58,249,5,72,81,54,49,118,238,229,135,185,147,22,44,104,162,227,212,108,214,217,146,70,229,110,51,142,129,176,183,14,248,84,254,23,80,23,174,23,188,69,133,156,83,127,129,205,219,9,234,50,127,147,190,104,206,128,3,32,142,211,88,147,251,55,6,215,122,6,38,223,143,137,25,114,175,26,94,26,191,152,16,164,203,159,162,159,234,58,176,79,34,171,73,90,214,102,2,241,36,20,249,179,232,33,115,147,37,7,244,229,78,125,87,6,122,165,183,4,16,118,42,50,124,23,58,231,29,115,125,214,245,56,3,1,13,178,171,82,141,181,140,74,209,111,189,211,156,249,49,122,39,128,167,219,5,214,146,202,162,205,36,30,141,252,54,48,136,242,134,30,65,65,131,99,30,237,103,55,164,15,36,242,47,195,224,71,49,23,63,151,55,211,50,162,207,12,222,159,125,70,126,85,31,198,190,105,183,37,88,24,179,224,164,68,229,42,221,147,232,189,130,3,100,190,116,156,234,67,105,32,34,87,188,100,61,60,85,108,76,166,91,226,233,190,42,51,202,26,15,104,39,217,60,239,192,217,188,228,68,163,85,133,221,211,0,57,116,20,164,108,136,58,246,108,238,195,182,67,94,113,86,113,67,86,249,141,50,154,115,173,3,119,0,92,191,67,242,247,237,50,95,50,179,140,33,62,247,55,250,0,165,141,26,118,239,118,3,49,9,40,183,202,82,49,199,62,10,252,165,154,252,217,62,65,55,75,240,160,207,235,82,110,57,70,9,144,247,69,183,101,93,109,93,244,15,122,249,178,235,215,222,251,177,212,87,67,118,85,19,99,84,233,30,113,178,12,34,34,217,25,96,248,51,5,216,147,177,30,212,230,20,99,90,248,43,165,31,53,0,32,190,182,201,164,71,197,31,92,92,35,136,165,159,94,205,210,84,244,104,204,157,242,92,199,2,113,163,118,103,85,86,105,43,117,10,208,230,119,127,164,219,140,105,55,123,8,122,229,108,129,75,117,35,120,98,197,4,128,176,82,102,64,232,108,99,195,122,30,57,63,137,242,205,129,189,228,2,62,141,163,66,209,60,90,63,210,53,195,136,20,132,54,84,35,208,247,4,182,233,61,81,142,183,121,50,155,38,244,18,206,176,22,203,135,255,44,38,201,118,71,244,97,248,227,96,151,161,47,92,65,224,178,63,56,64,46,38,16,165,144,141,63,22,251,248,93,25,3,4,208,53,223,107,114,73,61,44,145,162,33,164,61,38,45,41,158,105,110,193,127,131,124,217,116,99,186,39,195,214,213,22,174,35,69,113,72,83,35,102,94,89,10,213,190,19,21,203,172,90,35,235,217,91,144,195,71,36,214,171,49,114,160,211,137,78,235,191,11,160,198,168,97,33,207,20,250,116,95,186,112,132,199,250,23,74,133,208,206,236,209,11,5,171,135,253,158,90,158,181,135,63,97,122,32,130,218,242,241,33,64,52,27,133,109,194,133,102,139,170,37,140,144,143,171,146,10,155,156,116,2,181,143,62,236,249,192,134,139,192,19,164,36,148,8,216,152,15,42,190,66,20,76,149,52,142,193,183,231,201,9,55,150,129,86,175,167,57,191,88,123,78,183,12,22,195,229,235,176,250,9,55,220,141,63,209,65,139,58,75,173,71,236,208,195,253,112,249,140,24,210,107,114,36,253,162,62,55,215,234,138,26,178,209,115,97,182,42,76,122,196,147,54,20,113,161,213,141,12,214,58,68,85,149,11,103,174,52,54,17,254,18,248,15,168,63,208,44,159,219,189,138,148,18,252,199,216,210,115,233,202,22,254,113,221,201,37,149,213,84,203,43,44,14,24,150,204,143,149,153,25,50,162,233,217,164,209,88,240,239,62,197,113,192,124,193,86,214,213,2,29,241,123,157,30,28,250,244,156,2,141,192,244,250,194,245,45,175,212,32,52,76,140,198,130,68,32,59,76,61,162,64,199,169,225,107,50,115,237,7,10,217,5,66,24,50,105,138,80,79,141,178,80,172,189,240,225,184,164,28,188,240,227,240,244,57,13,216,98,91,24,53,94,236,96,207,230,110,132,189,50,218,99,30,42,59,190,196,191,26,247,229,82,143,99,107,207,159,29,60,90,101,35,124,72,85,254,53,92,200,224,40,233,104,240,29,10,181,204,217,38,181,136,224,109,47,147,111,207,150,105,95,247,83,47,205,103,31,72,18,224,26,148,74,89,60,213,254,188,115,202,90,243,127,72,86,163,43,107,37,121,151,215,217,171,149,48,255,159,204,140,68,130,149,134,102,20,93,8,91,197,168,0,53,178,93,227,118,122,146,12,36,203,249,124,17,247,174,232,158,120,87,232,125,122,183,67,148},
  {210,151,34,94,66,113,158,112,66,42,205,167,101,227,96,91,126,165,223,99,13,75,56,183,106,220,227,208,142,72,230,14,131,170,53,45,224,81,188,141,73,20,159,198,202,193,209,54,222,5,204,12,122,224,26,113,149,163,211,215,196,249,97,217,246,94,220,69,69,248,172,21,90,237,101,47,107,70,183,97,222,160,58,184,216,174,226,77,124,2,34,89,172,188,54,249,185,204,141,252,45,1,134,129,109,3,201,53,238,75,76,34,130,167,203,71,251,196,208,21,12,104,114,9,101,36,31,177,1,166,119,94,19,190,242,95,26,1,40,122,144,105,20,209,129,76,209,73,238,24,2,7,127,139,195,58,184,27,107,185,122,5,239,241,111,105,245,154,250,23,78,79,89,181,126,248,76,156,15,172,178,84,26,206,44,117,36,91,191,102,50,179,3,210,197,163,161,36,118,186,6,216,203,238,200,78,151,129,136,42,140,15,163,195,173,83,246,40,243,141,8,186,6,17,98,222,232,103,74,51,188,84,145,12,122,182,37,184,66,217,217,1,28,183,86,245,63,193,247,16,187,53,123,125,30,72,220,243,52,41,171,108,123,78,88,76,206,21,77,61,248,140,83,238,61,91,113,191,13,100,221,210,181,155,210,71,98,224,189,254,239,223,182,229,128,159,62,29,129,225,196,115,85,114,47,89,23,110,116,118,63,22,140,59,194,10,94,241,94,136,149,45,151,101,41,233,2,235,118,146,35,15,155,35,87,179,28,110,34,139,10,116,14,44,33,254,104,34,214,159,118,181,116,23,222,85,42,232,52,218,167,39,193,18,90,54,183,40,70,218,100,54,60,186,158,187,224,90,219,13,101,14,216,69,29,103,188,25,206,24,171,139,38,94,201,60,212,18,186,190,115,104,87,158,112,63,9,99,93,169,32,35,144,224,198,165,103,121,7,183,29,31,202,145,72,100,162,16,23,251,26,212,65,221,20,228,225,146,250,137,245,67,96,202,164,14,42,27,129,132,38,204,165,197,157,97,89,179,222,76,160,123,202,4,109,53,40,224,177,251,33,10,222,248,24,96,53,251,87,69,54,121,147,156,113,170,74,250,208,36,50,64,219,66,86,22,82,192,218,35,244,90,241,89,189,58,197,86,44,54,218,19,66,199,19,110,127,83,233,190,177,103,16,149,128,135,36,154,209,255,136,166,6,106,91,53,137,209,109,147,207,95,225,108,11,66,76,106,141,98,237,165,206,155,18,185,40,34,11,253,128,30,165,173,89,35,56,145,198,76,33,232,132,125,129,41,7,119,34,213,147,243,76,215,177,126,169,189,65,33,42,182,70,160,108,27,133,105,10,119,11,59,247,105,52,118,97,198,17,219,13,103,55,195,170,1,12,127,20,12,131,160,1,84,50,178,189,207,77,67,115,221,104,119,82,44,113,52,33,178,153,139,196,76,99,231,158,177,172,4,227,208,200,205,69,192,163,59,156,207,133,184,208,50,27,195,66,53,210,124,137,237,59,162,7,203,164,3,214,117,250,30,240,60,216,91,186,242,154,45,108,62,72,100,15,1,196,143,8,115,126,13,15,226,160,180,114,153,40,100,129,19,134,230,114,223,35,166,123,85,133,222,111,14,154,10,234,228,51,251,204,225,53,210,211,8,215,49,183,138,91,88,189,165,30,65,171,68,128,170,119,89,219,19,159,145,87,118,83,13,175,123,25,240,91,235,210,195,149,226,65,208,242,63,139,226,91,70,156,253,94,173,200,252,24,132,211,50,194,203,255,238,76,123,146,19,8,127,117,224,18,225,209,126,136,185,184,95,127,40,182,254,233,200,23,35,140,33,72,220,224,139,117,42,136,16,224,248,156,233,176,135,240,51,175,199,6,102,248,181,162,158,243,117,246,204,94,121,128,37,12,120,160,249,137,137,32,87,84,12,195,16,142,213,133,143,76,130,252,239,133,7,212,203,73,255,164,128,193,53,217,121,208,141,30,160,212,43,187,50,198,188,176,224,237,246,48,35,193,243,60,46,76,248,144,107,159,174,200,159,216,180,171,185,126,71,72,249,254,174,93,217,78,170,184,108,64,153,31,14,191,178,226,117,120,71,155,6,180,131,159,134,198,85,140,5,42,10,92,195,50,224,248,95,59,183,140,177,191,246,32,117,43,31,255,213,210,11,78,56,113,68,164,180,60,224,34,130,198,93,183,156,130,48,184,233,90,73,255,171,95,10,139,7,130,20,203,128,184,208,248,139,152,115,164,39,21,16,205,43,84,200,86,121,175,154,160,107,7,48,185,82,177,121,120,252,21,151,182,204,238,173,1,253,74,41,63,160,9,246,12,58,2,252,129,160,85,236,65,34,128,207,40,104,42,71,124,234,73,80,250,253,62,9,205,66,162,126,94,126,213,164,41,24,163,87,112,46,107,248,50,237,82,233,29,250,46,34,80,191,35,222,183,121,22,182,178,80,6,17,135,195,3,104,198,173,184,97,105,132,7,41,166,198,180,123,18,28,74,163,194,137,135,174,9,247,198,245,52,198,205,184,99,221,240,232,248,234,242,0,116,79,56,106,78,198,222,242,110,119,135,82,135,218,251,200,187,233,83,25,239,149,235,90,182,37,217,87,255,158,107,14,68,15,97,54,230,101,139,174,207,255,167,33,111,16,7,87,184,80,122,233,52,137,18,117,213,0,132,254,141,168,13,164,226,208,118,37,113,187,32,13,137,216,60,61,69,219,198,124,44,71,1,20,47,47,228,165,42,88,97,100,217,2,214,90,94,12,200,61,179,93,60,186,151,118,242,11,75,109,77,226,191,107,115,173,247,126,233,124,217,87,15,13,209,54,198,76,241,233,244,156,108,175,231,119,126,195,36,90,181,182,221,75,244,230,158,170,19,239,213,20,106,142,234,42,106,156,244,151,127,35,73,16,67,147,152,142,59,14,20,184,58,226,209,80,149,206,159,19,75,27,69,52,191,105,189,145,154,205,190,110,156,147,62,50,139,118,88,196,109,214,201,82,135,91,84,12,107,71,170,175,82,142,163,138,95,111,223,167,253,239,3,28,225,161,88,166,36,151,2,161,200,234,67,179,23,48,180,7,43,82,80,171,17,45,20,68,126,122,146,163,44,212,55,216,172,61,117,26,58,111,127,6,88,7,99,61,101,109,166,109,34,129,213,19,212,93,19,78,120,64,14,97,85,80,198,116,23,141,169,176,19,153,15,156,238,210,185,254,156,165,29,62,219,220,113,240,157,182,190,97,197,211,253,83,3,170,76,116,253,144,200,5,69,155,247,60,25,219,111,127,57,114,120,136,208,19,234,15,155,121,190,164,213,247,124,146,198,84,95,0,7,190,12,251,35,167,206,44,87,79,203,12,107,210,93,114,36,37,8,193,17,252,74,178,242,229,166,235,195,206,112,185,212,174,207,179,122,95,214,4,136,131,37,85,186,199,8,138,248,0,169,72,234,103,174,35,27,82,154,185,186,52,192,71,26,37,216,128,73,105,19,237,147,99,90,117,220,14,2,229,21,34,224,101,158,98,96,172,95,230,226,217,186,126,123,0,193,161,244,205,145,221,67,168,172,128,119,172,249,157,21,222,216,210,144,251,13,42,203,173,201,39,235,194,238,145,27,241,186,67,89,209,135,105,134,195,49,103,56,220,239,143,214,71,146,99,172,43,94,160,101,250,87,150,188,54,11,108,83,111,191,136,75,173,109,103,132,60,5,18,76,4,89,175,13,79,107,211,27,29,67,173,175,67,238,104,52,233,111,210,21,54,100,83,245,5,216,22,44,230,31,77,85,59,175,72,153,166,37,37,2,199,213,185,122,151,113,154,243,250,34,185,53,159,111,12,28,67,162,167,120,33,153,125,13,7,190,106,84,66,30,192,190,250,33,233,157,207,242,36,136,43,175,67,130,249,146,53,135,28,77,179,122,95,126,188,63,11,188,177,109,200,196,138,188,38,183,56,12,72,15,210,74,70,92,137,70,210,244,160,85,115,62,150,61,149,147,82,38,107,129,214,156,154,168,61,208,180,46,39,159,194,23,141,196,160,216,211,33,100,174,123,233,220,93,162,39,52,67,131,65,190,248,146,132,139,95,254,141,5,235,126,88,4,18,244,67,165,150,88,49,252,151,198,153,31,156,35,105,117,245,127,254,70,56,111,144,51,202,46,158,199,225,101,132,25,190,169,140,15,127,59,88,183,47,170,241,210,54,207,119,189,107,53,20,31,99,7,116,221,214,59,0,52,140,47,71,226,84,34,110,7,199,139,195,59,132,170,27,140,63,119,255,11,142,21,212,27,77,70,187,97,154,235,128,128,223,219,227,154,161,204,53,99,234,198,249,6,12,238,229,90,82,58,114,123,243,196,206,46,144,203,32,166,162,52,26,193,47,114,6,34,20,10,91,252,179,136,112,47,246,143,148,10,165,31,141,159,97,103,175,41,209,193,119,166,244,35,119,161,133,154,207,117,145,202,123,100,186,108,38,26,148,101,45,149,193,213,30,100,92,49,6,121,66,98,61,233,103,12,114,118,103,140,213,97,52,137,241,112,249,149,247,153,10,122,203,139,210,61,45,152,133,4,164,136,73,189,6,140,126,165,20,127,0,166,190,90,90,91,193,174,101,132,45,41,13,99,169,42,118,167,26,201,105,63,33,84,116,190,182,186,0,210,230,1,107,87,129,67,187,107,53,189,246,90,122,64,182,166,148,153,145,27,132,105,137,144,114,121,97,3,155,26,63,99,61,35,9,183,167,212,10,24,232,92,77,175,149,43,155,253,246,222,30,24,156,77,61,36,92,85,123,231,103,171,215,8,96,220,4,214,135,112,192,213,198,87,33,71,223,95,142,7,74,67,226,144,92,80,16,173,170,18,162,46,74,151,38,27,91,69,121,19,253,207,17,168,66,83,41,116,42,18,165,125,74,96,186,143,229,128,165,16,55,62,66,16,176,27,202,171,63,72,124,193,70,240,42,20,90,8,185,40,238,231,30,61,193,205,142,84,76,60,184,173,153,21,11,95,2,253,20,54,142,238,46,153,200,95,169,163,229,168,139,96,60,214,142,92,255,244,224,161,166,152,10,120,192,89,215,140,136,166,98,114,138,25,83,51,124,105,138,92,131,84,187,207,240,177,176,129,241,28,123,254,210,36,158,55,199,65,109,69,214,232,39,44,204,154,30,171,106,151,171,223,110,191,199,10,14,239,124,153,134,226,128,131,183,94,141,86,177,162,156,51,121,131,163,99,2,14,103,128,136,151,115,67,77,157,253,38,20,210,138,51,64,121,226,88,16,177,141,62,171,147,162,210,155,21,159,186,85,212,6,98,237,34,58,129,186,50,98,194,229,56,24,12,174,229,154,190,87,246,44,159,232,13,180,81,109,9,55,74,108,25,224,114,9,58,244,67,208,207,130,170,151,140,141,153,209,150,172,145,56,41,157,86,231,106,133,187,49,197,11,130,61,181,238,22,34,37,150,70,126,185,88,149,202,254,234,214,107,203,213,241,54,5,249,187,251,108,12,127,215,34,213,119,25,44,81,37,236,31,180,102,239,30,59,189,207,5,44,47,107,181,46,70,3,90,29,247,210,83,247,173,35,107,127,115,243,242,103,25,233,82,126,44,88,247,198,223,252,12,48,249,82,132,214,134,72,48,63,119,225,178,5,141,9,20,166,162,58,214,170,41,178,202,143,185,63,179,240,133,110,16,122,207,193,219,65,78,113,99,141,9,232,125,84,147,118,233,20,96,148,93,126,204,13,250,137,71,250,0,236,166,236,44,243,175,208,210,71,84,36,69,250,192,97,209,44,168,227,11,32,240,176,130,236,68,17,88,34,64,28,207,130,195,67,90},
  {249,143,38,134,43,78,23,238,19,23,233,68,136,215,68,233,124,221,32,219,159,39,38,22,103,50,220,168,39,81,57,119,100,243,120,179,25,214,185,158,212,70,0,219,22,37,100,5,189,95,125,195,193,36,217,84,119,111,177,121,6,25,249,215,182,242,188,58,48,152,120,29,202,20,146,233,120,50,81,97,222,68,22,238,194,226,209,22,149,178,20,153,150,149,231,60,122,4,49,124,213,174,157,60,79,81,7,70,98,189,32,159,131,249,125,98,173,79,229,137,182,107,104,106,255,104,0,146,14,204,143,10,236,183,242,111,151,71,247,173,41,50,71,43,58,155,136,94,237,120,47,181,228,227,12,223,81,97,98,244,81,224,235,214,244,71,159,12,11,96,155,106,143,248,174,236,227,219,138,175,167,94,213,90,129,126,12,41,125,125,146,191,80,97,95,187,196,162,234,36,23,229,14,222,100,86,187,116,208,110,216,139,151,131,120,107,234,6,84,91,246,182,52,21,26,169,123,208,33,105,139,209,61,216,51,213,42,41,184,10,232,145,202,224,57,176,244,26,2,238,232,96,38,147,186,51,204,77,45,92,147,243,19,117,225,63,131,133,140,100,134,120,95,162,139,228,139,133,166,246,149,165,178,192,58,165,47,115,91,245,182,97,246,92,12,137,19,222,105,180,113,97,101,160,133,66,75,4,186,55,124,220,131,77,161,14,45,52,233,38,131,139,153,230,247,191,85,0,204,130,174,79,245,135,123,142,234,106,118,157,130,205,244,235,97,235,69,121,84,133,10,10,95,47,21,96,237,60,194,242,34,62,154,146,206,133,77,221,43,56,183,133,51,47,115,163,223,62,111,113,232,214,128,76,182,34,235,225,162,8,220,75,83,76,229,62,96,229,171,251,249,0,44,182,238,143,90,172,74,77,240,0,163,57,221,218,180,145,122,235,10,152,121,82,249,177,72,236,234,237,73,128,63,147,190,212,196,220,145,118,82,51,221,175,79,238,118,37,106,197,223,110,167,16,248,72,223,232,92,219,163,74,19,114,103,204,182,236,11,191,91,236,187,104,169,10,213,85,125,136,203,186,77,172,223,111,35,182,147,153,120,221,137,235,231,51,69,157,110,14,242,75,181,184,101,25,205,204,230,84,9,235,173,218,24,80,99,142,182,247,31,80,72,191,125,171,237,90,184,215,167,38,153,239,106,201,139,198,211,178,209,179,38,91,197,138,93,14,21,254,123,39,119,16,103,249,13,41,120,117,202,84,31,216,244,225,184,85,221,145,116,153,3,215,150,105,46,8,42,89,173,219,159,99,0,152,49,47,162,87,232,57,199,124,175,33,90,180,27,19,60,100,152,39,253,206,55,238,94,156,16,177,207,113,106,80,154,219,75,137,200,89,233,85,183,101,233,22,192,56,137,0,173,196,252,77,227,229,182,132,1,233,71,55,130,137,99,209,2,255,190,176,20,14,227,162,130,63,154,102,32,152,38,207,64,172,55,120,176,239,176,247,250,232,215,202,142,189,168,74,86,188,94,70,205,32,196,115,136,219,199,28,84,26,23,175,6,126,208,25,19,184,158,155,79,76,49,130,253,188,64,97,82,213,176,104,141,193,190,155,115,24,78,159,111,16,32,247,214,248,226,165,162,229,136,16,208,85,104,48,16,10,34,150,176,211,106,245,140,62,51,31,141,137,65,29,146,62,143,44,37,250,203,8,215,82,194,105,194,63,9,112,133,160,79,168,114,92,41,31,136,88,200,166,62,77,9,45,51,71,24,20,168,135,222,233,98,241,115,29,228,21,62,246,64,111,151,51,64,63,147,194,112,96,82,80,120,188,26,245,153,2,143,111,165,76,26,44,203,24,4,18,119,140,94,133,230,75,113,13,223,210,11,231,177,33,37,196,248,108,16,70,233,214,163,24,247,94,210,105,56,248,252,128,132,139,135,2,195,187,15,208,135,67,140,181,3,139,128,231,25,89,120,139,179,237,54,203,90,151,47,43,149,4,81,216,142,63,46,24,246,116,186,186,160,203,71,130,7,167,221,53,101,226,158,90,138,139,185,134,156,75,36,92,70,4,31,255,29,35,11,89,127,80,254,170,54,134,122,34,116,72,177,181,191,236,83,68,157,226,135,20,248,83,74,145,130,107,194,151,11,155,118,2,126,9,151,128,103,236,167,12,66,39,4,153,111,45,78,214,129,65,154,174,187,178,88,2,114,11,31,253,107,82,188,191,125,134,62,244,50,41,206,49,217,113,13,66,229,49,176,122,56,193,240,84,222,220,99,33,90,243,121,250,221,248,9,133,219,130,214,21,163,40,72,93,48,9,68,14,5,4,227,116,163,191,135,107,152,238,100,157,129,17,189,133,166,36,241,103,127,210,246,22,99,209,19,250,72,216,78,21,170,236,209,67,55,211,105,12,232,88,120,97,98,46,254,6,133,203,168,25,185,42,222,30,235,185,89,97,78,213,60,86,206,156,200,229,87,35,113,61,4,229,220,75,169,160,47,10,168,204,8,173,139,240,36,179,228,171,110,142,104,194,34,22,72,209,247,180,65,242,170,92,38,169,164,134,188,116,212,252,46,198,41,219,14,52,76,234,115,206,95,84,75,47,76,77,166,174,138,223,156,111,180,136,246,55,30,146,45,39,81,141,238,73,245,182,197,179,134,103,73,14,235,231,211,214,4,222,235,86,27,32,75,119,122,186,232,253,234,186,110,31,245,71,101,213,244,197,229,224,131,110,49,234,90,93,82,37,47,9,17,44,207,197,175,40,154,112,138,59,23,3,227,174,65,41,154,41,184,81,17,166,21,219,17,175,173,64,124,60,35,209,103,67,100,238,167,247,188,176,197,23,129,87,237,230,57,148,26,230,244,243,44,240,29,243,154,233,108,246,153,32,18,123,158,68,22,48,197,29,222,202,235,120,64,100,246,113,22,47,101,79,16,209,125,63,95,222,38,37,148,70,241,232,239,93,157,101,19,139,183,159,246,38,62,128,183,103,255,47,170,220,96,209,248,123,143,193,90,73,104,107,20,76,80,19,234,113,79,135,95,212,156,2,142,124,9,28,154,8,134,72,7,161,220,227,152,71,155,83,61,178,241,213,128,253,42,205,85,86,48,15,226,132,252,173,251,219,45,242,59,190,5,90,29,93,56,54,190,231,224,245,194,11,121,169,206,100,164,251,6,200,103,230,39,11,249,4,154,150,45,23,201,59,34,42,229,18,134,238,5,124,30,174,4,19,201,166,44,235,16,101,16,180,69,237,242,236,134,74,224,64,33,36,56,177,141,80,171,164,28,46,168,161,236,63,23,161,31,149,189,253,217,51,40,7,183,196,107,17,108,215,108,239,152,152,183,130,130,55,23,236,188,205,56,159,121,205,82,173,190,46,102,214,31,159,65,63,221,198,67,105,87,201,166,255,68,44,166,162,75,172,52,185,62,146,63,149,159,44,214,46,5,191,171,183,243,225,197,81,239,113,204,203,180,155,14,184,224,97,143,191,198,214,50,144,212,57,219,23,120,234,63,119,255,197,42,109,158,101,7,161,119,52,106,33,83,28,28,116,15,83,212,13,221,252,161,44,46,133,32,191,132,151,220,60,208,172,242,156,30,20,107,246,202,54,173,237,106,180,30,197,18,225,135,94,158,15,192,255,1,144,69,168,32,219,228,122,129,96,108,202,8,108,13,213,232,126,225,120,12,51,22,186,134,148,211,165,198,249,70,103,58,14,204,28,206,122,236,145,211,251,139,168,36,229,16,113,81,169,17,215,70,20,51,91,86,21,88,167,15,65,170,169,8,103,72,44,195,16,71,213,172,96,78,209,210,127,51,60,36,158,99,71,89,89,44,16,79,40,3,32,29,169,88,164,24,219,163,71,70,117,175,102,236,213,23,72,175,233,212,74,10,189,57,2,65,43,60,233,62,179,44,175,48,25,212,209,129,146,196,101,5,57,78,40,223,143,120,170,107,125,212,110,63,234,2,30,70,110,24,4,97,221,141,220,120,223,199,121,23,204,168,110,143,94,20,183,146,38,135,31,87,55,44,163,235,89,71,56,14,18,16,191,116,157,237,49,120,143,56,36,111,165,82,28,238,224,120,63,63,246,24,97,227,140,106,170,216,71,200,149,165,112,177,71,71,166,29,229,7,58,155,8,99,121,64,144,66,111,249,108,74,21,113,112,237,54,106,55,62,121,166,116,10,212,72,159,88,234,19,156,37,253,7,11,101,136,72,99,229,139,103,138,174,85,198,55,80,39,228,91,134,253,38,66,89,119,47,52,166,47,255,186,27,89,10,182,192,139,34,92,253,153,243,40,7,1,117,174,177,3,48,116,109,220,32,9,105,32,14,196,103,116,160,173,125,135,18,136,100,130,231,86,95,132,151,230,32,31,30,209,215,90,153,97,65,238,1,173,29,104,27,139,128,96,83,211,104,66,187,57,241,18,87,5,86,45,43,194,42,118,41,183,148,52,21,255,38,52,237,4,19,126,202,191,124,251,90,197,57,19,237,101,227,196,32,201,157,101,134,145,32,198,92,244,69,58,142,197,221,204,82,130,51,146,142,197,243,20,30,29,152,122,181,98,212,29,126,70,128,0,60,60,72,189,173,67,66,159,64,108,104,217,208,72,98,39,220,35,240,251,250,230,5,202,4,52,138,22,249,5,8,80,232,179,80,18,139,171,133,110,104,132,96,90,117,133,92,215,56,189,182,171,34,69,26,138,62,238,134,240,87,214,179,77,87,215,102,52,12,54,8,188,37,102,155,103,70,6,253,243,231,29,90,42,250,22,44,210,56,199,186,237,251,90,106,122,64,55,204,191,72,85,93,191,195,128,92,11,68,224,154,199,92,34,95,42,68,101,25,243,219,196,208,98,245,164,226,82,220,145,67,105,151,169,108,143,170,192,43,53,129,18,168,24,107,57,255,245,139,160,169,207,166,14,199,177,96,190,142,242,195,47,69,55,235,91,217,241,34,95,131,127,180,51,53,101,95,255,122,107,216,232,218,120,130,180,245,252,8,65,27,83,195,13,173,12,132,9,105,124,41,196,204,72,58,188,121,142,49,178,185,174,79,196,95,133,1,177,143,254,112,181,29,149,213,96,92,96,86,251,198,71,48,254,148,95,37,26,50,101,148,110,37,52,133,37,74,221,178,180,142,121,178,114,123,80,91,43,174,0,43,51,116,237,196,147,229,208,136,235,209,7,116,102,163,31,5,217,53,255,254,223,46,129,152,224,218,117,150,25,221,55,77,15,44,31,163,120,177,244,83,237,147,124,96,222,10,145,49,13,168,72,51,22,105,39,228,201,182,183,129,240,237,128,92,36,31,169,214,2,14,32,150,252,143,49,176,18,65,14,151,229,119,79,5,245,139,246,94,77,244,171,208,189,118,157,128,230,16,106,100,166,253,46,31,117,159,99,51,141,149,121,83,2,135,49,168,22,228,172,25,151,96,135,5,254,42,86,52,2,210,146,117,38,14,71,158,6,4,166,95,252,43,232,103,192,39,103,255,34,56,240,186,53,173,198,97,159,212,244,206,78,176,6,74,252,31,250,161,241,24,126,246,104,42,212,75,210,108,200,168,143,227,210,163,134,65,250,216,214,33,248,241,206,42,122,222,131,126,124,193,130,212,80,13,230,41,60,49,85,185,161,46,43,165,233,161,181,236,27,17,96,148,119,38,42,97,34,93,220,171,97,161,30,95,72,131,221,219,142,178,210,71,37,99,48,163,239,112,247,117,15,247,251,28,199,3,211,131,20,76,103,164,187,72,226,43,30,38,23,47,151,81,150,225,219,245,247,242,59,138,73,17,189,53,228,179,71,55,200,113,141,203,74,121,22,76,201},
} ;

static void test_decode_653xint32_impl(long long impl)
{
  unsigned char *x = test_decode_653xint32_x;
  unsigned char *s = test_decode_653xint32_s;
  unsigned char *x2 = test_decode_653xint32_x2;
  unsigned char *s2 = test_decode_653xint32_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_653xint32_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_653xint32(impl);
    printf("decode_653xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_653xint32_implementation(impl),ntruprime_dispatch_decode_653xint32_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_653xint32;
    printf("decode_653xint32 selected implementation %s compiler %s\n",ntruprime_decode_653xint32_implementation(),ntruprime_decode_653xint32_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_653xint32_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_653xint32_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_653xint32_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_653xint32_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_653xint32_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_653xint32_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_653xint32(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"653xint32")) return;
  storage_decode_653xint32_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_653xint32_x = aligned(storage_decode_653xint32_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_653xint32_s = callocplus(crypto_decode_STRBYTES);
  test_decode_653xint32_s = aligned(storage_decode_653xint32_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_653xint32_x2 = callocplus(maxalloc);
  test_decode_653xint32_x2 = aligned(storage_decode_653xint32_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_653xint32_s2 = callocplus(maxalloc);
  test_decode_653xint32_s2 = aligned(storage_decode_653xint32_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_653xint32 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_653xint32();++impl)
      forked(test_decode_653xint32_impl,impl);
    ++test_decode_653xint32_x;
    ++test_decode_653xint32_s;
    ++test_decode_653xint32_x2;
    ++test_decode_653xint32_s2;
  }
  free(storage_decode_653xint32_s2);
  free(storage_decode_653xint32_x2);
  free(storage_decode_653xint32_s);
  free(storage_decode_653xint32_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

