/* ----- decode/761xint16, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_761xint16_checksums[] = {
  "49e6aca48717c2e93b56d9706189b6c5b21781086c569bf421628343fec2bc06",
  "fd2f7ecff81bea4ae8e08a3bf1b6d4e57d328c481f773c60d3f1a773c25dbfca",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_761xint16_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_761xint16_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_761xint16_ITEMBYTES

static void *storage_decode_761xint16_x;
static unsigned char *test_decode_761xint16_x;
static void *storage_decode_761xint16_s;
static unsigned char *test_decode_761xint16_s;
static void *storage_decode_761xint16_x2;
static unsigned char *test_decode_761xint16_x2;
static void *storage_decode_761xint16_s2;
static unsigned char *test_decode_761xint16_s2;

#define precomputed_decode_761xint16_NUM 4

static const uint16_t precomputed_decode_761xint16_x[precomputed_decode_761xint16_NUM][crypto_decode_ITEMS] = {
  {65242,45043,62201,1582,47736,58606,47938,23416,14159,11360,49282,21308,46093,63341,61728,31773,36798,31653,52023,18360,28639,51258,31498,52992,65052,34358,42808,56007,44052,52456,53746,2797,40893,51903,52905,21316,16321,51247,18169,1865,30224,26042,49922,11969,59156,8316,65259,1222,59191,20061,47365,7166,49724,22047,245,16848,23300,15366,3275,36305,47211,57251,47160,39006,27825,54350,18170,5670,11108,63190,26213,3493,13597,48045,5577,26026,21359,45232,11514,9745,54573,31052,53932,38111,35163,36325,26515,53881,17898,3225,40666,22195,40017,62248,31409,27235,35073,44860,36031,27868,24616,12316,9015,48366,5909,8241,39125,44772,54921,37060,62892,27304,24185,39824,60591,49048,16875,64925,11120,46238,30358,44219,47534,31679,51908,13758,1552,52093,7462,51742,34510,31918,39138,21991,46326,59992,52097,24864,64199,60366,9055,31707,5678,44681,42290,24264,7005,7892,47397,27796,15296,63148,57983,65318,50887,56813,60586,33338,40534,3694,19964,60835,20103,55301,35777,59063,24504,10117,64399,56896,38122,60978,46890,9094,15385,27155,30055,29294,41112,52408,26740,25341,3899,35053,50193,47909,43404,29772,61641,58940,10223,24874,35733,17577,12352,218,27564,19322,31369,36712,2890,53351,14870,63201,48034,60464,65162,55595,22070,55687,38778,1866,19428,58706,2819,62032,18054,17068,950,34541,65266,40590,21756,6135,25941,62149,31151,16928,25840,14730,10987,38335,16757,38521,38154,3361,61589,14393,48871,4467,64986,29601,46216,52025,48700,34938,28355,34634,13112,41805,34947,24518,56237,11111,42869,9624,41338,11355,33016,34640,28153,46253,1605,43059,48783,50922,11654,48784,32725,39847,56637,2293,2797,6280,17060,18944,7957,17593,24575,45845,14925,31683,32354,35106,6633,1857,63641,6123,61119,57576,2722,5530,60686,22037,51727,12103,50100,53619,34318,42284,21334,45787,51440,37631,54553,882,8288,46628,58259,16050,40796,35720,4603,900,15340,17015,7626,43407,41418,43509,13133,1673,7157,58274,22036,58033,59374,39995,921,33932,47262,404,42465,16152,40653,48633,44709,45248,34917,20811,8525,52470,38269,49422,50025,21620,13327,12978,32400,47020,56270,41317,23088,4419,47616,15679,19342,17528,55250,40180,19208,48563,61794,44112,4502,48449,5952,12550,60591,21346,7089,29379,44907,4160,30013,7975,22853,12264,3337,40607,56495,31237,46787,44797,44753,55269,59778,61623,47384,53608,6349,63399,34546,53863,24345,18318,36327,23852,48795,42218,17603,51683,17829,34197,1080,20330,49364,63624,58674,13221,25336,46088,13198,21843,58705,26821,40491,58848,58585,27400,57826,29377,60916,20551,22457,9508,55251,27261,63873,10597,26302,3527,33415,10836,43073,31874,37236,50727,14311,40135,37541,20888,2805,12677,36458,2992,29989,45381,25330,36238,7090,45332,5710,64916,44871,48698,24528,40367,13441,47806,14012,46004,19306,3822,41454,47053,11739,3714,41367,63027,3168,20698,59181,16745,40446,32172,30398,2878,12495,28613,48620,61189,17121,29610,45222,13769,37790,29055,41584,63359,21861,10177,64293,55286,60822,40093,3020,8777,37610,8618,8575,36343,19687,59056,17169,34125,8663,25591,59154,41494,53599,35509,34071,48409,60810,39962,29649,28436,47206,17248,34167,7857,26597,11300,9464,22118,18314,61586,7791,4761,25831,8829,17348,24817,43352,20712,53770,26429,23252,20352,55678,23465,42787,54734,27813,43432,5476,27267,58245,31389,55358,40191,28309,30278,39660,30213,34705,53174,64120,58271,45059,64665,28623,16569,38361,52041,25008,18435,5157,17944,12876,14743,20254,62467,59368,64487,13235,4851,44994,58511,39427,21655,4258,41622,55122,29834,33731,44592,31198,30717,29876,5354,32285,21203,22411,22153,25946,37115,58626,18834,12356,37453,51990,12972,27593,5510,38276,33795,48056,11599,63432,29883,29124,28943,32633,24566,53674,43374,45918,33882,9063,28421,4978,56501,26135,38599,60395,4788,56860,28038,58516,25136,60638,41418,63445,30164,38694,64662,2057,13196,27796,10974,31296,38826,37138,44537,44242,20695,42455,54525,2166,57918,16191,3121,16574,41119,63599,24152,45382,60158,10487,349,19371,60723,64104,20059,21641,12633,45753,62132,18484,53340,18753,11698,51609,2148,15121,6310,2344,27383,20368,18102,18161,13554,38042,8475,64626,34491,34301,17169,50043,64436,11258,32805,25262,5930,43615,19509,35535,61349,14753,48980,300,47326,43490,24598,22996,58726,10699,32922,29055,51925,45467,58732,37832,52821,36156,17793,36892,21341,4130,35466,9886,5298,35624,20403,5859,60016,49931,11110,11264,58760,37167,53039,32293,21188,63211,24761,34891,28764,58988,53747,45101,51664,33319,59784,24228,8468,25923,44662,29533,33509,24682,18225,2773,34841,42849,28919,38103,58745,45025},
  {8803,6695,61775,23769,65225,31880,46039,26284,2538,20973,21596,45309,730,8136,14985,46635,15538,7499,7113,5422,2510,16184,6933,40877,5593,17213,30657,9518,2244,43438,17469,35957,64030,15131,3725,6453,48488,38625,55167,13064,30363,6359,7968,231,14278,911,46985,58039,23896,46692,34682,61114,4978,12611,7494,57236,29587,13693,10872,6086,34832,55365,6580,25978,19154,58843,30186,47111,17612,57301,63972,24949,6947,28140,56569,19381,6103,27913,6446,58276,43295,10588,8378,62831,27144,21491,20800,59619,6449,59083,59977,59968,17981,39370,40504,13331,14854,4408,52365,27969,48727,38328,19083,31972,49867,58001,30564,29520,62312,41907,54160,44408,33818,44067,20889,17761,12720,3794,58153,9587,50190,23386,26234,61881,22733,14290,3536,57731,41563,21482,5944,6532,30442,22119,12597,6010,61532,21462,18082,61369,31131,26171,51104,64093,50674,54304,5877,37873,34621,63983,39839,45687,4087,53181,50417,1518,6304,42145,28311,17939,21193,61711,16435,23309,13124,14979,2038,11612,22984,54009,16883,33955,1289,14371,23585,28484,18605,7783,14288,29115,22447,49106,42226,21183,2780,17092,38913,46901,64201,2921,60531,60726,49070,5291,45973,26975,55390,58623,11604,65153,31778,210,6042,28927,49290,34937,20005,25213,60345,4708,39427,37510,56537,23933,5884,12253,3116,5202,62376,4612,18166,39766,3522,12730,63318,10776,3347,37138,54370,60937,19192,10770,6243,15718,2872,24231,17969,29493,4848,18694,51327,34419,11918,24484,61677,39821,29009,44101,34651,33924,57033,47924,32520,45462,59810,28837,14684,58016,19052,26916,26309,4200,33832,1604,3501,49536,60260,33316,27069,59793,10199,60262,49719,16345,20959,27426,15398,50998,48523,37706,10235,45817,19052,42300,52073,32896,1304,5289,7510,33721,50848,38230,2154,42445,3739,41241,46930,57326,18626,60431,31560,7293,21029,10025,42726,42214,22943,17083,65263,54827,5150,44085,13670,18039,42758,61350,48392,50348,53261,26839,33770,42387,18569,57808,24233,55032,46096,49840,35955,65535,1572,55265,57348,3662,47377,12344,26996,40445,30363,57804,14755,58488,62650,55477,17970,35532,21571,20913,63144,47265,1548,38949,34532,11681,19355,15164,13463,36966,11984,26917,54077,55335,50462,50245,46641,12908,59682,39389,26514,32810,50236,20176,52374,36517,52101,42643,6717,22873,27319,54118,47977,11055,30647,63627,6958,16357,31007,46020,16871,56488,42622,36767,35182,35414,32192,53065,33235,31920,61380,10323,43107,27261,4736,45616,21106,33563,52888,34380,12077,5087,17431,16188,29401,23152,4072,27221,26956,40956,37917,40132,4854,60547,43486,65381,32023,4473,33736,24100,34176,42851,41678,48949,63037,4495,21341,32301,57226,2918,50737,7630,11631,27138,4294,35666,62015,18482,22025,9749,6209,62340,3688,31345,30456,3485,21746,55351,29347,25981,38070,42120,54527,63137,11543,13059,42823,44345,60392,41894,51379,41078,2101,4735,46751,13504,58600,54970,40729,61447,52966,12257,23462,13403,770,23594,4458,45997,21926,14205,64602,59643,10480,15597,30925,36709,3108,58827,5502,20135,43727,57927,33385,20582,4350,30021,12792,5672,31231,31472,62660,9735,23184,47856,55816,38923,62900,16734,52878,53788,60697,10439,31677,57742,27052,26069,64666,48525,16936,39282,49443,29289,58174,65208,11098,1367,36770,56855,36522,8196,54533,45372,38254,49604,46548,62380,52267,49450,11297,48178,63698,28644,48918,55456,19127,64444,47845,43313,42785,55104,40044,50205,52872,8785,47132,21922,61446,60089,53942,33252,54262,33994,14532,35557,7280,4363,13840,39570,5948,50761,56488,9088,22187,34608,24604,58360,32069,26791,56546,57711,36349,33942,5744,16731,16924,58930,19665,48700,30342,14633,26122,64395,20767,23152,6871,46328,51318,47203,16711,50346,15125,59810,51866,49767,43798,48101,29033,21598,44394,27453,12807,57578,59068,59241,29856,21014,48151,23248,1428,11673,47298,28556,59038,51423,46869,44426,17407,59989,12068,39536,32467,24632,23799,197,54900,52971,22646,24508,64468,5999,40432,2422,62801,6601,33684,35957,3730,35858,29542,57744,34260,53371,59983,1134,14030,30931,3456,39001,29257,51587,56122,19430,42200,30932,64099,54021,47161,3692,16292,26329,28200,30637,1708,38142,29060,12218,58785,58678,33713,29629,42720,17008,58493,50158,48166,51296,19213,59118,41613,22677,15374,64123,27966,24278,13469,1585,38446,34419,46572,58253,44175,17639,3701,62742,48733,51304,2477,62853,18494,35382,37541,56910,47832,27405,56135,34773,47042,18592,62496,61119,13136,22030,13123,43927,62217,32956,5165,46891,33789,53930,24238,56831,14805,8325,53724,58846,3008,58847,8519,22875,9654,30634,28597,20525,32677,13174,9976,27144,60641,3398,36229,45414,1664},
  {64583,37438,35151,43912,65324,62911,7763,7635,48616,47240,12834,7163,55967,34931,38988,19532,26977,15941,63132,40660,20946,59660,51499,28933,11581,19315,51580,32913,12265,36546,21558,59004,63702,41602,8173,62491,59848,54246,50468,28932,15347,12991,28427,28200,30013,43461,61796,48278,4376,45454,12128,39530,62626,13229,42364,30940,3404,42569,45349,47792,26174,26149,45536,48400,18325,21648,27318,8027,6111,52128,4147,44404,12954,26879,25597,14506,34887,20160,43443,55493,27347,21413,51296,8336,47072,44860,29981,44349,63273,56253,27709,39159,15974,3789,13466,9115,13108,4862,39742,53392,37969,26822,206,59604,7755,31278,54297,58896,37064,16144,6002,38755,47503,13876,23598,46176,1558,16530,4592,64175,26884,43721,58886,12142,52816,18782,35734,22096,45142,33862,50609,18587,33426,23673,34064,29528,48832,58633,282,12931,47304,51560,6234,43738,37282,47468,53820,2298,65387,35062,8358,29950,63331,49056,47772,65155,60688,32846,27432,34848,4025,43134,58487,58811,24493,43319,2879,687,13444,5015,35896,56982,55270,44766,9683,25704,53778,64695,25343,617,17786,40165,935,29583,1051,63069,43901,29371,52181,33363,16042,29084,54532,46287,56390,30565,37171,45633,15529,50681,3558,18075,8856,15121,43205,15820,39039,27527,34110,39117,55459,12305,28417,63915,21388,11383,58220,3610,6596,24469,3784,53071,47567,39055,14628,45696,43756,46765,10191,35296,4609,24165,55742,26352,16829,18132,12975,63633,1086,24357,9442,34930,51473,14741,59802,42544,62338,44657,47245,12921,61205,14431,18722,41851,37798,5122,55633,64793,1629,45758,28949,13432,46676,47247,1637,10245,57654,49585,12230,60785,48010,32797,8470,21661,25293,28413,63688,7344,30288,27106,61353,53173,739,46629,33861,40181,18228,10810,65405,45366,42510,53809,39403,43797,27225,50276,3869,11766,22736,33599,58880,27246,18442,518,15750,18039,37817,41529,39152,43441,34000,14060,6745,5846,20850,40093,40109,29994,12163,12714,18609,58854,7965,48314,9930,35891,20450,40248,58638,45916,9849,36182,62125,53412,40398,39668,16312,7864,63399,53807,64597,13596,17363,11748,5147,32325,50940,10200,8457,15675,32617,58300,36288,411,32229,19374,45945,34892,58528,25642,57384,30382,5453,2575,59585,38849,41051,51229,40869,21781,29200,46577,27322,42897,55713,59406,57229,10611,15649,64190,48980,35451,15885,56790,29296,31199,10741,51252,7213,61743,40510,36603,16836,12763,45842,45950,11177,23621,33717,13429,21800,47458,19972,37192,12265,34397,6712,43014,41607,29467,14174,37112,35714,54633,4030,47826,28284,20022,5848,14605,8828,33202,28804,1060,59935,45647,1879,927,28581,53559,45834,37438,42175,15725,42513,1095,56026,19560,16129,47013,25762,1102,24500,29730,2263,65084,20687,12949,59430,27857,6003,58357,19942,55216,47422,28454,53206,32404,3781,50704,62816,56918,29650,49350,44087,56521,21115,13403,28783,48209,416,11703,43633,12274,18633,26250,65124,15803,10942,5234,39166,58731,65381,1700,59774,26303,43039,26615,33505,62059,4842,40509,20854,1386,59333,2634,37226,58590,16883,22772,32844,12131,7522,39710,20682,37079,2382,31686,25627,57464,20178,60454,43343,52861,9135,35529,33091,36520,22082,30729,56185,1326,27526,64739,61135,4709,47893,58384,24423,58846,50700,20927,58975,44935,23092,14054,31278,38063,391,64062,63229,60260,36007,16969,45523,50032,46111,28685,50448,18443,12226,26328,56378,6517,44907,52001,2119,11105,40241,12720,2669,15166,62699,12031,8971,8832,41173,17502,14640,48962,48145,56989,61645,29415,3180,56071,26082,45223,62113,19969,5102,48853,3598,9080,18660,38780,17685,59136,38473,35805,24097,8046,44341,20663,38172,6841,53404,42064,49925,29688,30581,24698,64417,36390,32786,61695,23820,50428,26778,34281,59109,53428,57868,39214,15885,36900,53964,38507,27160,56105,54416,24447,60744,64266,7096,8182,60290,26481,15675,3635,55654,3804,9593,38047,43655,2604,57473,48936,53767,40514,21252,10796,56339,49076,1931,62137,53100,51837,10265,61866,38784,11828,14252,15206,59229,56279,10226,61198,56259,63089,31623,51776,41606,59538,25544,12919,34658,36412,57571,62659,24444,44003,9631,49245,14126,64200,59837,3656,40333,19320,57631,56214,9224,55480,48702,59964,47076,981,31426,15633,47856,25051,50806,35527,45450,48206,11610,6722,4418,3715,22176,1987,1071,24836,53242,32739,50778,43479,4725,25154,8472,40660,54414,56374,28411,20119,32645,61026,46096,7091,49167,64372,2520,18417,12922,40504,37010,58311,19508,16125,40965,28881,34779,39402,51270,13405,10541,5304,3772,61047,36273,29755,8426,57833,59580,36601,50048,10946,59518,39591,26751,46770,34994,38524,49596,10580,30681,40301,49824,15187,65438},
  {45147,35056,49220,12142,44176,55257,44888,63143,36853,8026,50217,45235,29081,14568,60161,18853,3362,2177,23035,45236,29804,65084,13661,41806,58780,20989,20326,33515,50913,39094,33529,65449,16782,37582,45304,2241,61824,15933,62017,23126,40297,25872,56580,59743,46220,45963,3318,52785,22875,27980,62534,64099,63255,41206,58925,47928,33392,16915,105,44046,43449,52227,28519,53169,52530,51320,33333,11234,57839,62115,36465,30631,8196,58,10170,40726,63953,53073,49455,29601,65401,1817,38384,32255,35278,23659,58499,63885,58698,36069,50707,35187,795,57038,45623,8934,17081,24797,3997,40593,772,15353,29488,45376,514,65273,8170,20287,38523,61335,63265,5085,25766,37600,36037,15371,33373,28026,53991,8410,37116,3924,5011,7264,24650,14531,65342,49818,20480,22147,18765,63990,30155,54082,8648,29506,6224,88,45985,12130,37929,45796,6030,47051,19024,36735,34591,53271,31545,13901,7296,61579,15461,11880,27653,33671,31995,55464,53096,20480,44877,34872,56946,48749,50579,6985,40825,52601,42971,16294,52486,43555,38703,19204,11743,13333,32052,9618,48042,470,16036,8541,6911,40167,1057,13934,32729,21140,26437,25160,15917,9561,38607,18612,31773,4161,33296,40735,14232,55289,54054,40013,9582,21487,54217,56728,21202,55360,34423,3335,14835,25264,3005,33238,50150,38585,38345,8752,32231,59851,57221,4831,39664,29932,58703,17048,14713,64408,21268,22228,24838,36821,13514,16883,63831,6123,55442,39382,16998,58701,31255,50251,19843,42175,7544,21437,2902,53898,57212,33913,11980,18230,58175,56331,42074,33990,64696,35247,50786,3828,40148,64854,55751,8666,18813,31981,32584,21303,3510,40955,58107,58252,55561,56222,30796,31358,14484,37106,51890,15026,6106,62826,52202,17808,5558,53810,29311,61118,40365,30497,21568,27512,5363,48045,15513,33295,53894,47225,41223,36010,16173,20368,27041,29968,19788,11225,28544,50751,17636,1181,34518,51828,39877,18182,40059,8648,51738,19280,46861,5158,58131,40792,64678,11055,65237,26477,28645,42936,9038,36703,53162,15878,37058,46713,52500,65114,40029,19365,4062,28790,28399,2467,11556,15368,53519,61808,45879,45625,18118,37652,57862,34570,31482,42723,11442,11126,62563,64978,11731,42063,37885,15636,42177,61654,4357,22393,37407,2815,35970,61298,38400,29507,51490,32969,49064,49632,37791,50871,9507,6457,35195,30973,28127,65027,62095,8405,13547,24888,2950,42656,13324,36232,65123,14866,49131,10101,53539,43334,63430,12415,51569,7522,57574,64756,21213,8949,22318,45615,45864,21221,29439,11039,44759,42809,56713,49635,8247,4051,57129,5569,48129,54256,51957,59493,14270,16600,44162,11832,39135,45919,22686,40072,2501,16097,5610,51454,63544,23310,40678,46047,44731,41763,64059,64070,55240,22940,17585,31750,63905,8700,30663,28988,64048,38179,30591,12807,44551,12330,8406,35749,6788,63185,44519,2754,40733,58091,34477,4862,29260,63623,35363,13937,43358,16199,34692,2358,36836,15646,9716,54261,29168,15917,33853,12202,25605,26913,8967,33948,40465,36136,6593,17218,14675,65102,13533,13715,22615,35741,17367,8665,47463,48116,4623,64500,5565,51284,57154,23073,46295,64407,62294,61836,55296,1886,64470,20227,52780,51369,17352,54453,45235,58741,38957,821,8909,10667,50303,33130,10549,35589,49689,58489,22777,44011,46686,61847,38449,45273,43577,8867,36581,31166,24728,28296,23525,13671,71,31317,33636,25976,15583,8717,47876,27363,2850,27374,29575,45437,28976,8484,30784,29736,18196,60275,3643,31067,14368,28102,2883,48288,23778,3172,35452,12436,40667,58348,39519,21655,37733,4921,60303,42187,10710,37359,45365,19852,36505,53477,62852,48575,56846,18054,21931,62784,40164,61279,64331,40208,17242,12889,33999,6046,49724,50888,12736,26560,47120,5813,64470,24557,16253,17110,48844,1462,18296,6024,31578,36804,28324,60374,53504,27492,17119,38469,23347,31337,47182,14667,22752,29775,3954,30406,14009,36575,1456,41807,47763,63170,20654,62854,12287,46188,6950,12079,1735,26843,61101,47014,24644,1441,62916,60279,56941,63436,51204,16726,35153,49635,13563,835,40597,11686,60916,7026,21030,19524,62716,58511,14910,53020,15147,53619,30669,8838,10444,53083,33027,32343,48323,22772,32342,38138,62708,31656,15769,47975,9669,1440,22323,31557,24223,21573,41291,34054,62491,55920,26390,16969,4925,19123,34415,57582,16991,54321,18121,26942,51242,7714,34677,40385,56659,40323,13089,47812,45169,22680,35066,34354,20938,60290,19736,23157,33012,16412,55138,7448,42892,15460,32221,52805,33720,40530,5126,21645,1513,6275,37389,35738,5251,3489,54082,54997,3093,50100,55153,35319,61975,43793,23308,12335,53870,33075,44523,29939,50568,30835,60627,30572,63546,17605,9311},
} ;

static const unsigned char precomputed_decode_761xint16_s[precomputed_decode_761xint16_NUM][crypto_decode_STRBYTES] = {
  {218,254,243,175,249,242,46,6,120,186,238,228,66,187,120,91,79,55,96,44,130,192,60,83,13,180,109,247,32,241,29,124,190,143,165,123,55,203,184,71,223,111,58,200,10,123,0,207,28,254,54,134,56,167,199,218,20,172,232,204,242,209,237,10,189,159,191,202,169,206,68,83,193,63,47,200,249,70,73,7,16,118,186,101,2,195,193,46,20,231,124,32,235,254,198,4,55,231,93,78,5,185,254,27,60,194,31,86,245,0,208,65,4,91,6,60,203,12,209,141,107,184,163,223,56,184,94,152,177,108,78,212,250,70,38,22,100,43,214,246,101,102,165,13,29,53,173,187,201,21,170,101,111,83,176,176,250,44,17,38,45,213,76,121,172,210,223,148,91,137,229,141,147,103,121,210,234,69,153,12,218,158,179,86,81,156,40,243,177,122,99,106,1,137,60,175,191,140,220,108,40,96,28,48,55,35,238,188,21,23,49,32,213,152,228,174,137,214,196,144,172,245,168,106,121,94,144,155,175,236,152,191,235,65,157,253,112,43,158,180,150,118,187,172,174,185,191,123,196,202,190,53,16,6,125,203,38,29,30,202,206,134,174,124,226,152,231,85,246,180,88,234,129,203,32,97,199,250,206,235,95,35,219,123,46,22,137,174,50,165,200,94,93,27,212,30,37,185,148,108,192,59,172,246,127,226,38,255,199,198,237,221,170,236,58,130,86,158,110,14,252,77,163,237,135,78,5,216,193,139,183,230,184,95,133,39,143,251,64,222,234,148,50,238,42,183,134,35,25,60,19,106,103,117,110,114,152,160,184,204,116,104,253,98,59,15,237,136,17,196,37,187,140,169,76,116,201,240,60,230,239,39,42,97,149,139,169,68,64,48,218,0,172,107,122,75,137,122,104,143,74,11,103,208,22,58,225,246,162,187,48,236,138,254,43,217,54,86,135,217,122,151,74,7,228,75,82,229,3,11,80,242,134,70,172,66,182,3,237,134,242,254,142,158,252,84,247,23,85,101,197,242,175,121,32,66,240,100,138,57,235,42,191,149,117,65,121,150,10,149,33,13,149,240,57,56,231,190,115,17,218,253,161,115,136,180,57,203,60,190,122,136,195,110,74,135,56,51,77,163,131,136,198,95,173,219,103,43,117,167,152,37,122,161,91,44,248,128,80,135,249,109,173,180,69,6,51,168,143,190,234,198,134,45,144,190,213,127,167,155,61,221,245,8,237,10,136,24,164,66,0,74,21,31,185,68,255,95,21,179,77,58,195,123,98,126,34,137,233,25,65,7,153,248,235,23,191,238,232,224,162,10,154,21,14,237,21,86,15,202,71,47,180,195,115,209,14,134,44,165,86,83,219,178,240,200,255,146,25,213,114,3,96,32,36,182,147,227,178,62,92,159,136,139,251,17,132,3,236,59,119,66,202,29,143,169,202,161,245,169,77,51,137,6,245,27,162,227,20,86,177,226,238,231,59,156,153,3,140,132,158,184,148,1,225,165,24,63,205,158,249,189,165,174,192,176,101,136,75,81,77,33,246,204,125,149,14,193,105,195,116,84,15,52,178,50,144,126,172,183,206,219,101,161,48,90,67,17,0,186,63,61,142,75,120,68,210,215,244,156,8,75,179,189,98,241,80,172,150,17,65,189,64,23,6,49,175,236,98,83,177,27,195,114,107,175,64,16,61,117,39,31,69,89,232,47,9,13,159,158,175,220,5,122,195,182,253,174,209,174,229,215,130,233,183,240,24,185,104,209,205,24,167,247,242,134,103,210,25,95,142,71,231,141,44,93,155,190,234,164,195,68,227,201,165,69,149,133,56,4,106,79,212,192,136,248,50,229,165,51,248,98,8,180,142,51,83,85,81,229,197,104,43,158,224,229,217,228,8,107,226,225,193,114,244,237,71,80,185,87,36,37,211,215,125,106,129,249,101,41,190,102,199,13,135,130,84,42,65,168,130,124,116,145,39,198,231,55,199,156,165,146,152,81,245,10,133,49,106,142,176,11,37,117,69,177,242,98,142,141,178,27,20,177,78,22,148,253,71,175,58,190,208,95,175,157,129,52,190,186,188,54,180,179,106,75,238,14,238,161,205,183,219,45,130,14,151,161,51,246,96,12,218,80,45,231,105,65,254,157,172,125,190,118,62,11,207,48,197,111,236,189,5,239,225,66,170,115,166,176,201,53,158,147,127,113,112,162,127,247,101,85,193,39,37,251,246,215,150,237,157,156,204,11,73,34,234,146,170,33,127,33,247,141,231,76,176,230,17,67,77,133,215,33,247,99,18,231,22,162,95,209,181,138,23,133,25,189,138,237,26,156,209,115,20,111,102,184,96,67,119,133,177,30,229,103,36,44,248,36,102,86,138,71,146,240,111,30,153,18,231,100,125,34,196,67,241,96,88,169,232,80,10,210,61,103,212,90,128,79,126,217,169,91,35,167,206,213,165,108,168,169,100,21,131,106,133,227,157,122,62,216,255,156,149,110,70,118,236,154,5,118,145,135,182,207,120,250,159,227,3,176,153,252,207,111,185,64,217,149,73,203,176,97,3,72,37,20,24,70,76,50,151,57,30,79,3,244,232,231,231,251,179,51,243,18,194,175,143,228,3,154,151,84,162,16,150,162,82,215,138,116,195,131,48,174,222,121,253,119,180,116,234,20,29,126,211,82,139,87,137,86,90,101,251,144,2,229,146,73,68,48,77,146,22,203,172,50,201,107,134,21,132,149,3,132,184,187,79,45,200,247,187,116,196,113,15,113,121,127,246,95,170,209,110,169,94,179,90,132,103,35,5,111,114,19,181,220,23,102,199,150,235,235,180,18,28,222,134,109,148,228,48,98,222,236,202,161,213,247,212,117,38,151,150,252,9,8,140,51,148,108,222,42,64,122,170,151,18,145,249,173,210,172,215,80,215,165,253,212,118,8,62,226,63,63,49,12,190,64,159,160,111,248,88,94,70,177,254,234,247,40,93,1,171,75,51,237,104,250,91,78,137,84,89,49,185,178,180,242,52,72,92,208,65,73,178,45,153,201,100,8,17,59,166,24,40,9,247,106,144,79,182,70,241,70,242,52,154,148,27,33,114,252,187,134,253,133,17,67,123,195,180,251,250,43,37,128,174,98,42,23,95,170,53,76,207,138,165,239,161,57,84,191,44,1,222,184,226,169,22,96,212,89,102,229,203,41,154,128,127,113,213,202,155,177,108,229,200,147,85,206,60,141,129,69,28,144,93,83,34,16,138,138,158,38,178,20,40,139,179,79,227,22,112,234,11,195,102,43,0,44,136,229,47,145,47,207,37,126,196,82,235,246,185,96,75,136,92,112,108,230,243,209,45,176,208,201,39,130,136,233,164,94,20,33,67,101,118,174,93,115,229,130,106,96,49,71,213,10,25,136,97,167,247,112,215,148,121,229,225,175},
  {99,34,39,26,79,241,217,92,201,254,136,124,215,179,172,102,234,9,237,81,92,84,253,176,218,2,200,31,137,58,43,182,178,60,75,29,201,27,46,21,206,9,56,63,21,27,173,159,217,21,61,67,193,119,46,37,196,8,174,169,61,68,117,140,30,250,27,59,141,14,53,25,104,189,225,150,127,215,8,51,155,118,215,24,32,31,231,0,198,55,143,3,137,183,183,226,88,93,100,182,122,135,186,238,114,19,67,49,70,29,148,223,147,115,125,53,120,42,198,23,16,136,69,216,180,25,122,101,210,74,219,229,234,117,7,184,204,68,213,223,228,249,117,97,35,27,236,109,249,220,181,75,215,23,9,109,46,25,164,227,31,169,92,41,186,32,111,245,8,106,243,83,64,81,227,232,49,25,203,230,73,234,64,234,61,70,202,153,56,158,19,52,6,58,56,17,141,204,65,109,87,190,184,149,139,74,228,124,203,194,145,226,100,119,80,115,104,243,179,163,144,211,120,173,26,132,35,172,153,81,97,69,176,49,210,14,41,227,115,37,14,196,90,91,122,102,185,241,205,88,210,55,208,13,131,225,91,162,234,83,56,23,132,25,234,118,103,86,53,49,122,23,92,240,214,83,162,70,185,239,155,121,59,102,160,199,93,250,242,197,32,212,245,22,241,147,61,135,239,249,159,155,119,178,247,15,189,207,241,196,238,5,160,24,161,164,151,110,19,70,201,82,15,241,51,64,13,91,68,51,131,58,246,7,92,45,200,89,249,210,243,65,163,132,9,5,35,56,33,92,68,111,173,72,103,30,208,55,187,113,175,87,210,191,242,164,191,82,220,10,196,66,1,152,53,183,201,250,105,11,115,236,54,237,174,191,171,20,149,179,95,105,94,216,255,228,84,45,129,254,34,124,210,0,154,23,255,112,138,192,121,136,37,78,125,98,185,235,100,18,3,154,134,146,217,220,125,93,252,22,221,47,44,12,82,20,168,243,4,18,246,70,86,155,194,13,186,49,86,247,24,42,19,13,18,145,98,212,9,238,248,74,18,42,99,24,102,61,56,11,167,94,49,70,53,115,240,18,6,73,127,200,115,134,142,46,164,95,237,240,141,155,81,113,69,172,91,135,132,132,201,222,52,187,8,127,150,177,162,233,165,112,92,57,160,226,108,74,36,105,197,102,104,16,40,132,68,6,173,13,128,193,100,235,36,130,189,105,145,233,215,39,102,235,55,194,217,63,223,81,34,107,38,60,54,199,139,189,74,147,251,39,249,178,108,74,60,165,105,203,128,128,24,5,169,20,86,29,185,131,160,198,86,149,106,8,205,165,155,14,25,161,82,183,238,223,194,72,15,236,72,123,125,28,37,82,41,39,230,166,230,164,159,89,187,66,239,254,43,214,30,20,53,172,102,53,119,70,6,167,166,239,8,189,172,196,13,208,215,104,234,131,147,165,137,72,208,225,169,94,248,214,16,180,176,194,115,140,255,255,36,6,225,215,4,224,78,14,17,185,56,48,116,105,253,157,155,118,204,225,163,57,120,228,186,244,181,216,50,70,204,138,67,84,177,81,168,246,161,184,12,6,37,152,228,134,161,45,155,75,60,59,151,52,102,144,208,46,37,105,61,211,39,216,30,197,69,196,49,182,108,50,34,233,221,153,146,103,42,128,60,196,208,78,150,204,165,142,133,203,147,166,61,26,89,89,183,106,102,211,105,187,47,43,183,119,139,248,46,27,229,63,31,121,196,179,231,65,168,220,126,166,159,143,110,137,86,138,192,125,73,207,211,129,176,124,196,239,83,40,99,168,125,106,128,18,48,178,114,82,27,131,152,206,76,134,45,47,223,19,23,68,60,63,217,114,112,90,232,15,85,106,76,105,252,159,29,148,196,156,246,18,131,236,222,169,101,255,23,125,121,17,200,131,36,94,128,133,99,167,206,162,53,191,61,246,143,17,93,83,45,126,138,223,102,11,49,198,206,29,111,45,2,106,198,16,82,139,63,242,50,72,9,86,21,38,65,24,132,243,104,14,113,122,248,118,157,13,242,84,55,216,163,114,125,101,182,148,136,164,255,212,161,246,23,45,3,51,71,167,57,173,232,235,166,163,179,200,118,160,53,8,127,18,159,182,192,52,232,228,186,214,25,159,7,240,230,206,225,47,166,91,91,52,2,3,42,92,106,17,173,179,166,85,125,55,90,252,251,232,240,40,237,60,205,120,101,143,36,12,203,229,126,21,167,78,207,170,71,226,105,130,102,80,254,16,69,117,248,49,40,22,255,121,240,122,196,244,7,38,144,90,240,186,8,218,11,152,180,245,94,65,142,206,28,210,25,237,199,40,189,123,142,225,172,105,213,101,154,252,141,189,40,66,114,153,35,193,105,114,62,227,184,254,90,43,87,5,162,143,23,222,170,142,4,32,5,213,60,177,110,149,196,193,212,181,172,243,43,204,42,193,33,44,50,188,210,248,228,111,22,191,160,216,183,74,188,251,229,186,49,169,33,167,64,215,108,156,29,196,136,206,81,34,28,184,162,85,6,240,185,234,182,210,228,129,246,211,202,132,196,56,229,138,112,28,11,17,16,54,146,154,60,23,73,198,168,220,128,35,171,86,48,135,28,96,248,227,69,125,167,104,226,220,111,225,253,141,150,132,112,22,91,65,28,66,50,230,209,76,60,190,134,118,41,57,10,102,139,251,31,81,112,90,215,26,248,180,118,200,99,184,71,65,170,196,21,59,162,233,154,202,103,194,22,171,229,187,105,113,94,84,106,173,61,107,7,50,234,224,188,230,105,231,160,116,22,82,23,188,208,90,148,5,153,45,194,184,140,111,158,230,223,200,21,183,138,173,255,67,85,234,36,47,112,154,211,126,56,96,247,92,197,0,116,214,235,206,118,88,188,95,212,251,111,23,240,157,118,9,81,245,201,25,148,131,117,140,146,14,18,140,102,115,144,225,212,133,123,208,79,234,110,4,206,54,211,120,128,13,89,152,73,114,131,201,58,219,230,75,216,164,212,120,99,250,5,211,57,184,108,14,164,63,217,102,40,110,173,119,172,6,254,148,132,113,186,47,161,229,54,229,177,131,189,115,224,166,112,66,125,228,238,195,38,188,96,200,13,75,238,230,141,162,149,88,14,60,123,250,62,109,214,94,157,52,49,6,46,150,115,134,236,181,141,227,143,172,231,68,117,14,22,245,93,190,104,200,173,9,133,245,62,72,54,138,165,146,78,222,216,186,13,107,71,219,213,135,194,183,160,72,32,244,191,238,80,51,14,86,67,51,151,171,9,243,188,128,45,20,43,183,253,131,170,210,174,94,255,221,213,57,133,32,220,209,222,229,192,11,223,229,71,33,91,89,182,37,170,119,181,111,45,80,165,127,118,51,248,38,8,106,225,236,70,13,133,141,102,177,128,6},
  {71,252,62,146,79,137,136,171,44,255,191,245,83,30,211,29,232,189,136,184,34,50,251,27,159,218,115,136,76,152,76,76,97,105,69,62,156,246,212,158,210,81,12,233,43,201,5,113,61,45,115,75,124,201,145,128,233,47,194,142,54,84,124,230,214,248,130,162,237,31,27,244,200,233,230,211,36,197,4,113,243,59,191,50,11,111,40,110,61,117,197,169,100,241,150,188,24,17,142,177,96,47,106,154,162,244,173,51,124,165,220,120,76,13,73,166,37,177,176,186,62,102,37,102,224,177,16,189,149,71,144,84,182,106,91,31,223,23,160,203,51,16,116,173,154,50,255,104,253,99,170,56,71,136,192,78,179,169,197,216,211,106,165,83,96,200,144,32,224,183,60,175,29,117,61,173,41,247,189,219,61,108,247,152,102,62,205,14,154,52,155,35,52,51,254,18,62,155,144,208,81,148,198,104,206,0,212,232,75,30,46,122,25,212,16,230,200,144,16,63,114,23,99,151,143,185,52,54,46,92,96,180,22,6,146,64,240,17,175,250,4,105,201,170,6,230,110,47,80,206,94,73,150,139,80,86,86,176,70,132,177,197,155,72,146,130,121,92,16,133,88,115,192,190,9,229,26,1,131,50,200,184,104,201,90,24,218,170,162,145,108,185,60,210,250,8,107,255,246,136,166,32,254,116,99,247,160,191,156,186,131,254,16,237,78,128,40,107,32,136,185,15,126,168,119,228,187,229,173,95,55,169,63,11,175,2,132,52,151,19,56,140,150,222,230,215,222,174,211,37,104,100,18,210,183,252,255,98,105,2,122,69,229,156,167,3,143,115,27,4,93,246,125,171,187,114,213,203,83,130,170,62,156,113,4,213,207,180,70,220,101,119,51,145,65,178,169,60,249,197,230,13,155,70,152,34,17,59,197,168,204,61,127,152,135,107,62,133,205,152,163,216,17,48,1,111,171,249,140,83,119,44,108,227,26,14,196,25,149,95,200,14,79,207,207,185,143,152,36,57,128,178,236,170,173,182,207,39,224,137,1,18,101,94,190,217,240,102,189,65,212,70,175,50,145,248,62,4,37,95,226,36,114,136,17,201,149,57,154,233,48,166,130,243,113,174,141,184,121,50,21,239,95,56,34,73,123,163,166,147,2,20,81,217,25,253,93,6,190,178,21,113,120,52,84,182,143,184,101,6,5,40,54,225,177,193,198,47,113,237,138,187,29,128,22,33,157,84,205,98,253,110,200,248,176,28,80,118,226,105,169,239,181,207,227,2,37,182,69,132,245,156,52,71,58,42,125,255,54,177,14,166,49,210,235,153,21,171,89,106,100,196,29,15,246,45,208,88,63,131,0,230,110,106,10,72,6,2,134,61,119,70,185,147,57,162,240,152,177,169,208,132,236,54,89,26,214,22,114,81,157,156,173,156,42,117,131,47,170,49,177,72,230,229,29,31,186,188,202,38,51,140,226,79,56,157,14,229,92,179,121,38,86,141,173,242,164,208,206,157,244,154,184,63,184,30,167,247,47,210,85,252,28,53,211,67,228,45,27,20,69,126,252,198,216,39,9,33,59,61,105,127,188,227,192,141,155,1,229,125,174,75,121,179,76,136,160,228,42,100,40,224,174,118,77,21,15,10,193,232,193,151,91,160,29,200,165,159,21,85,16,114,241,181,186,106,145,167,161,217,14,232,141,223,115,41,33,61,190,250,84,191,123,138,13,62,214,221,112,114,223,121,245,41,52,200,45,28,47,241,62,158,251,142,196,65,219,49,18,179,126,179,169,43,69,92,181,131,117,52,40,85,98,185,4,78,72,145,233,47,93,134,56,26,6,168,135,162,27,115,94,55,248,144,130,139,105,213,190,15,210,186,124,110,54,78,216,22,13,57,124,34,178,129,132,112,36,4,31,234,79,178,87,7,159,3,165,111,55,209,10,179,62,146,191,164,109,61,17,166,71,4,218,218,104,76,1,63,165,183,162,100,78,4,180,95,34,116,215,8,60,254,207,80,149,50,38,232,209,108,115,23,245,227,230,77,176,215,62,185,38,111,214,207,148,126,197,14,16,198,96,245,86,222,210,115,198,192,55,172,201,220,123,82,91,52,111,112,81,188,160,1,183,45,113,170,242,47,201,72,138,102,100,254,187,61,190,42,114,20,254,152,107,229,101,255,164,6,126,233,191,102,31,168,247,103,225,130,107,242,234,18,61,158,118,81,106,5,197,231,74,10,106,145,222,228,243,65,244,88,76,128,99,47,98,29,30,155,202,80,215,144,78,9,198,123,27,100,120,224,210,78,38,236,79,169,125,206,175,35,201,138,67,129,168,142,66,86,9,120,121,219,46,5,134,107,227,252,207,238,101,18,21,187,16,228,103,95,222,229,12,198,191,81,95,230,135,175,52,90,230,54,46,122,175,148,135,1,62,250,253,246,100,235,167,140,73,66,211,177,112,195,31,180,13,112,16,197,11,72,194,47,216,102,58,220,117,25,107,175,33,203,71,8,97,43,49,157,176,49,109,10,62,59,235,244,255,46,11,35,128,34,213,160,94,68,48,57,66,191,17,188,157,222,205,240,231,114,108,12,7,219,226,101,167,176,161,242,1,78,238,19,213,190,14,14,120,35,228,72,124,151,21,69,0,231,73,150,221,139,33,94,110,31,53,173,183,80,28,149,185,26,156,208,80,164,5,195,248,115,117,119,122,96,161,251,38,142,18,128,255,240,12,93,252,196,154,104,233,133,229,230,180,208,12,226,46,153,13,62,36,144,204,210,107,150,24,106,41,219,144,212,127,95,72,237,10,251,184,27,246,31,130,235,113,103,59,61,51,14,102,217,220,14,121,37,159,148,135,170,44,10,129,224,40,191,7,210,66,158,4,83,44,42,19,220,180,191,139,7,185,242,108,207,125,202,25,40,170,241,128,151,52,46,172,55,102,59,93,231,215,219,242,39,14,239,195,219,113,246,135,123,64,202,134,162,146,232,200,99,119,50,98,135,60,142,227,224,195,244,124,95,227,171,159,37,93,192,46,55,200,250,189,233,72,14,141,157,120,75,31,225,150,219,8,36,184,216,62,190,60,234,228,183,213,3,194,122,17,61,240,186,219,97,118,198,199,138,138,177,78,188,90,45,66,26,66,17,131,14,160,86,195,7,47,4,4,97,250,207,227,127,90,198,215,169,117,18,66,98,24,33,212,158,142,212,54,220,251,110,151,78,133,127,98,238,16,180,179,27,15,192,116,251,216,9,241,71,122,50,56,158,146,144,199,227,52,76,253,62,5,160,209,112,219,135,234,153,70,200,93,52,45,41,184,20,188,14,119,238,177,141,59,116,234,32,233,225,188,232,249,142,128,195,194,42,126,232,167,154,127,104,178,182,178,136,124,150,188,193,84,41,217,119,109,157,160,194,83,59,158,255},
  {91,176,240,136,68,192,110,47,144,172,217,215,88,175,167,246,245,143,90,31,41,196,179,176,153,113,232,56,1,235,165,73,34,13,129,8,251,89,180,176,108,116,60,254,93,53,78,163,156,229,253,81,102,79,235,130,225,198,182,152,249,130,169,255,142,65,206,146,248,176,193,8,128,241,61,62,65,242,86,90,105,157,16,101,4,221,95,233,140,180,139,179,246,12,49,206,91,89,76,109,70,244,99,250,23,247,246,160,45,230,56,187,112,130,19,66,105,0,14,172,185,169,3,204,103,111,177,207,50,205,120,200,53,130,226,43,239,225,163,242,113,142,167,119,4,32,58,0,186,39,22,159,209,249,81,207,47,193,161,115,121,255,25,7,240,149,255,125,206,137,107,92,131,228,141,249,74,229,229,140,19,198,115,137,27,3,206,222,55,178,230,34,185,66,221,96,157,15,145,158,4,3,249,59,48,115,64,177,2,2,249,254,234,31,63,79,123,150,151,239,33,247,221,19,166,100,224,146,197,140,11,60,93,130,122,109,231,210,218,32,252,144,84,15,147,19,96,28,74,96,195,56,62,255,154,194,0,80,131,86,77,73,246,249,203,117,66,211,200,33,66,115,80,24,88,0,161,179,98,47,41,148,228,178,142,23,203,183,80,74,127,143,31,135,23,208,57,123,77,54,128,28,139,240,101,60,104,46,5,108,135,131,251,124,168,216,104,207,0,80,77,175,56,136,114,222,109,190,147,197,73,27,121,159,121,205,219,167,166,63,6,205,35,170,47,151,4,75,223,45,21,52,52,125,146,37,170,187,214,1,164,62,93,33,255,26,231,156,33,4,110,54,217,127,148,82,69,103,72,98,45,62,89,37,207,150,180,72,29,124,65,16,16,130,31,159,152,55,249,215,38,211,77,156,110,37,239,83,201,211,152,221,210,82,64,216,119,134,7,13,243,57,176,98,189,11,214,129,230,195,185,150,201,149,48,34,231,125,203,233,133,223,223,18,240,154,236,116,79,229,152,66,121,57,152,251,20,83,212,86,6,97,213,143,202,52,243,65,87,249,235,23,146,216,214,153,102,66,77,229,23,122,75,196,131,77,191,164,120,29,189,83,86,11,138,210,124,223,121,132,204,46,54,71,63,227,11,220,90,164,198,132,184,252,175,137,98,198,244,14,212,156,86,253,199,217,218,33,125,73,237,124,72,127,55,83,182,13,251,159,251,226,140,227,9,217,158,219,76,120,126,122,148,56,242,144,178,202,178,58,218,23,106,245,234,203,144,69,182,21,50,210,127,114,190,238,173,157,33,119,64,84,120,107,243,20,173,187,153,60,15,130,134,210,121,184,7,161,170,140,45,63,144,79,161,105,16,117,76,77,217,43,128,111,63,198,228,68,157,4,214,134,116,202,197,155,6,71,123,156,200,33,26,202,80,75,13,183,38,20,19,227,88,159,166,252,47,43,213,254,109,103,229,111,184,167,78,35,95,143,170,207,6,62,194,144,121,182,20,205,90,254,93,156,165,75,222,15,118,112,239,110,163,9,36,45,8,60,15,209,112,241,55,179,57,178,198,70,20,147,6,226,10,135,250,122,227,166,178,44,118,43,99,244,210,253,211,45,79,164,253,147,20,61,193,164,214,240,5,17,121,87,31,146,255,10,130,140,114,239,0,150,67,115,34,201,201,128,168,191,224,193,159,147,183,198,35,37,57,25,123,137,253,120,223,109,3,254,143,242,213,32,235,52,56,97,134,11,160,166,12,52,136,141,99,254,18,58,235,191,117,39,35,209,70,169,198,247,127,48,113,201,98,29,230,224,244,252,221,82,245,34,46,87,47,178,40,179,229,82,255,114,31,43,215,174,57,167,137,221,227,193,55,32,211,15,41,223,193,21,1,188,240,211,245,202,101,232,190,55,216,64,130,172,56,46,223,152,95,179,158,88,136,156,197,9,225,62,234,21,254,200,56,248,14,91,230,158,223,179,187,174,35,163,59,250,70,250,200,215,156,89,177,68,6,124,161,249,252,33,199,119,60,113,48,250,35,149,127,119,7,50,7,174,42,48,214,32,165,139,132,26,209,246,231,173,194,10,29,159,235,226,173,134,254,18,76,114,135,248,35,138,113,54,94,169,71,63,132,135,54,9,228,143,30,61,244,37,245,211,240,113,45,62,61,132,170,47,5,100,33,105,7,35,156,132,17,158,40,141,193,25,66,67,83,57,78,254,221,52,147,53,87,88,157,139,215,67,217,33,103,185,244,187,15,18,244,251,189,21,84,200,66,223,33,90,215,180,151,251,86,243,140,241,0,216,94,7,214,251,3,79,44,206,169,200,200,67,181,212,179,176,117,229,45,152,53,3,205,34,171,41,127,196,106,129,53,41,5,139,25,194,121,228,249,88,235,171,94,182,151,241,49,150,217,176,57,170,163,34,229,142,190,121,152,96,136,110,229,91,103,53,71,0,85,122,100,131,120,101,223,60,13,34,4,187,227,106,34,11,238,106,135,115,125,177,48,113,36,33,64,120,40,116,20,71,115,235,59,14,91,121,32,56,198,109,67,11,160,188,226,92,100,12,124,138,148,48,219,158,236,227,95,154,151,84,101,147,57,19,143,235,203,164,214,41,239,145,53,177,140,77,153,142,229,208,132,245,191,189,14,222,134,70,171,85,64,245,228,156,95,239,75,251,16,157,90,67,89,50,207,132,158,23,60,194,200,198,192,49,192,103,16,184,181,22,214,251,237,95,125,63,214,66,204,190,182,5,120,71,136,23,90,123,196,143,164,110,214,235,0,209,100,107,223,66,69,150,51,91,105,122,78,184,75,57,224,88,79,116,114,15,198,118,185,54,223,142,176,5,79,163,147,186,194,246,174,80,134,245,255,47,108,180,38,27,47,47,199,6,219,104,173,238,166,183,68,96,161,5,196,245,119,235,109,222,204,247,4,200,86,65,81,137,227,193,251,52,67,3,149,158,166,45,244,237,114,27,38,82,68,76,252,244,143,228,62,58,28,207,43,59,115,209,205,119,134,34,204,40,91,207,3,129,87,126,195,188,244,88,86,126,250,148,244,244,168,123,153,61,103,187,197,37,160,5,51,87,69,123,159,94,69,84,75,161,6,133,27,244,112,218,22,103,73,66,61,19,179,74,111,134,238,224,95,66,49,212,201,70,62,105,42,200,34,30,117,135,193,157,83,221,131,157,33,51,196,186,113,176,152,88,250,136,50,134,202,81,130,235,24,77,117,90,244,128,28,64,98,215,24,29,140,167,100,60,221,125,69,206,184,131,82,158,6,20,141,84,233,5,131,24,13,146,154,139,131,20,161,13,66,211,213,214,21,12,180,195,113,215,247,137,23,242,17,171,12,91,47,48,110,210,51,129,235,173,243,116,136,197,115,120,211,236,108,119,58,248,197,68,95,36},
} ;

static void test_decode_761xint16_impl(long long impl)
{
  unsigned char *x = test_decode_761xint16_x;
  unsigned char *s = test_decode_761xint16_s;
  unsigned char *x2 = test_decode_761xint16_x2;
  unsigned char *s2 = test_decode_761xint16_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_761xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_761xint16(impl);
    printf("decode_761xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761xint16_implementation(impl),ntruprime_dispatch_decode_761xint16_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_761xint16;
    printf("decode_761xint16 selected implementation %s compiler %s\n",ntruprime_decode_761xint16_implementation(),ntruprime_decode_761xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_761xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_761xint16_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_761xint16_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_761xint16_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_761xint16_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_761xint16_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_761xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761xint16")) return;
  storage_decode_761xint16_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_761xint16_x = aligned(storage_decode_761xint16_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_761xint16_s = callocplus(crypto_decode_STRBYTES);
  test_decode_761xint16_s = aligned(storage_decode_761xint16_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_761xint16_x2 = callocplus(maxalloc);
  test_decode_761xint16_x2 = aligned(storage_decode_761xint16_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_761xint16_s2 = callocplus(maxalloc);
  test_decode_761xint16_s2 = aligned(storage_decode_761xint16_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_761xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_761xint16();++impl)
      forked(test_decode_761xint16_impl,impl);
    ++test_decode_761xint16_x;
    ++test_decode_761xint16_s;
    ++test_decode_761xint16_x2;
    ++test_decode_761xint16_s2;
  }
  free(storage_decode_761xint16_s2);
  free(storage_decode_761xint16_x2);
  free(storage_decode_761xint16_s);
  free(storage_decode_761xint16_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

