/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  /usr/bin/gengetopt --file-name=goid-tool-cmdline --output-dir=. 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "goid-tool-cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: goid-tool [OPTION]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -r, --reader=STRING           Number of the reader to use. By default, the\n                                  first reader with a present card is used. If\n                                  the argument is an ATR, the reader with a\n                                  matching card will be chosen.",
  "  -v, --verbose                 Use (several times) to be more verbose",
  "  -p, --verify-pin              Verify PIN",
  "  -b, --verify-bio              Verify finger print",
  "      --verify-pin-or-bio       Verify PIN or finger print (user's choice)",
  "\nReport bugs to https://github.com/OpenSC/OpenSC/issues\n\nWritten by Frank Morgner <frankmorgner@gmail.com>",
  "\n Mode: soc\n  Options for SoCManager Applet",
  "      --new-pin                 Change PIN",
  "      --new-bio                 Use (several times) to change one or more\n                                  biometric templates",
  "      --info                    Dump Information about the SoCManager's\n                                  configuration",
  "\n Mode: pxs\n  Options for PAccess Applet",
  "  -c, --certificate=FILENAME    Use (several times) to pass CV certificates",
  "  -k, --key=FILENAME            Private key for the CV certificate",
  "      --print-cardid            Print the card ID",
  "      --write-cardid=CARDID     Write the specified card ID",
  "      --print-paccessid         Print the PAccess ID",
  "      --write-paccessid=PACCESSID\n                                Write the specified PAccess ID",
  "      --read-dg=ID              Read the specified data group; use several\n                                  times to read out multiple files",
  "      --out-file=FILENAME       Write output to a file instead of printing it;\n                                  use once for each use of `--read-dg'",
  "      --write-dg=ID             Write the specified data group; use several\n                                  times to write multiple files",
  "      --in-file=FILENAME        Read input from a file; use once for each use\n                                  of `--write-dg'",
  "      --delete-dg=ID            Delete the specified data group; use several\n                                  times to delete multiple files",
  "      --create-dg=ID            Create the specified data group; use several\n                                  times to create multiple files",
  "      --new-size=SIZE           File size of newly created DGs  (default=`256')",
  "      --new-read-ac=STRING      Access condition for reading newly created DGs\n                                  (possible values=\"always\", \"never\",\n                                  \"ta\", \"sm\" default=`sm')",
  "      --new-read-ac-chatbit=INDEX\n                                Required access bits in certificate's CHAT for\n                                  reading newly created DGs",
  "      --new-write-ac=STRING     Access condition for writing newly created DGs\n                                  (possible values=\"always\", \"never\",\n                                  \"ta\", \"sm\" default=`sm')",
  "      --new-write-ac-chatbit=INDEX\n                                Required access bits in certificate's CHAT for\n                                  reading newly created DGs",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
  , ARG_INT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

const char *cmdline_parser_new_read_ac_values[] = {"always", "never", "ta", "sm", 0}; /*< Possible values for new-read-ac. */
const char *cmdline_parser_new_write_ac_values[] = {"always", "never", "ta", "sm", 0}; /*< Possible values for new-write-ac. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->reader_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->verify_pin_given = 0 ;
  args_info->verify_bio_given = 0 ;
  args_info->verify_pin_or_bio_given = 0 ;
  args_info->new_pin_given = 0 ;
  args_info->new_bio_given = 0 ;
  args_info->info_given = 0 ;
  args_info->certificate_given = 0 ;
  args_info->key_given = 0 ;
  args_info->print_cardid_given = 0 ;
  args_info->write_cardid_given = 0 ;
  args_info->print_paccessid_given = 0 ;
  args_info->write_paccessid_given = 0 ;
  args_info->read_dg_given = 0 ;
  args_info->out_file_given = 0 ;
  args_info->write_dg_given = 0 ;
  args_info->in_file_given = 0 ;
  args_info->delete_dg_given = 0 ;
  args_info->create_dg_given = 0 ;
  args_info->new_size_given = 0 ;
  args_info->new_read_ac_given = 0 ;
  args_info->new_read_ac_chatbit_given = 0 ;
  args_info->new_write_ac_given = 0 ;
  args_info->new_write_ac_chatbit_given = 0 ;
  args_info->pxs_mode_counter = 0 ;
  args_info->soc_mode_counter = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->reader_arg = NULL;
  args_info->reader_orig = NULL;
  args_info->certificate_arg = NULL;
  args_info->certificate_orig = NULL;
  args_info->key_arg = NULL;
  args_info->key_orig = NULL;
  args_info->write_cardid_arg = NULL;
  args_info->write_cardid_orig = NULL;
  args_info->write_paccessid_arg = NULL;
  args_info->write_paccessid_orig = NULL;
  args_info->read_dg_arg = NULL;
  args_info->read_dg_orig = NULL;
  args_info->out_file_arg = NULL;
  args_info->out_file_orig = NULL;
  args_info->write_dg_arg = NULL;
  args_info->write_dg_orig = NULL;
  args_info->in_file_arg = NULL;
  args_info->in_file_orig = NULL;
  args_info->delete_dg_arg = NULL;
  args_info->delete_dg_orig = NULL;
  args_info->create_dg_arg = NULL;
  args_info->create_dg_orig = NULL;
  args_info->new_size_arg = 256;
  args_info->new_size_orig = NULL;
  args_info->new_read_ac_arg = gengetopt_strdup ("sm");
  args_info->new_read_ac_orig = NULL;
  args_info->new_read_ac_chatbit_arg = NULL;
  args_info->new_read_ac_chatbit_orig = NULL;
  args_info->new_write_ac_arg = gengetopt_strdup ("sm");
  args_info->new_write_ac_orig = NULL;
  args_info->new_write_ac_chatbit_arg = NULL;
  args_info->new_write_ac_chatbit_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->reader_help = gengetopt_args_info_help[2] ;
  args_info->verbose_help = gengetopt_args_info_help[3] ;
  args_info->verbose_min = 0;
  args_info->verbose_max = 0;
  args_info->verify_pin_help = gengetopt_args_info_help[4] ;
  args_info->verify_bio_help = gengetopt_args_info_help[5] ;
  args_info->verify_pin_or_bio_help = gengetopt_args_info_help[6] ;
  args_info->new_pin_help = gengetopt_args_info_help[9] ;
  args_info->new_bio_help = gengetopt_args_info_help[10] ;
  args_info->new_bio_min = 0;
  args_info->new_bio_max = 0;
  args_info->info_help = gengetopt_args_info_help[11] ;
  args_info->certificate_help = gengetopt_args_info_help[13] ;
  args_info->certificate_min = 0;
  args_info->certificate_max = 0;
  args_info->key_help = gengetopt_args_info_help[14] ;
  args_info->print_cardid_help = gengetopt_args_info_help[15] ;
  args_info->write_cardid_help = gengetopt_args_info_help[16] ;
  args_info->print_paccessid_help = gengetopt_args_info_help[17] ;
  args_info->write_paccessid_help = gengetopt_args_info_help[18] ;
  args_info->read_dg_help = gengetopt_args_info_help[19] ;
  args_info->read_dg_min = 0;
  args_info->read_dg_max = 0;
  args_info->out_file_help = gengetopt_args_info_help[20] ;
  args_info->out_file_min = 0;
  args_info->out_file_max = 0;
  args_info->write_dg_help = gengetopt_args_info_help[21] ;
  args_info->write_dg_min = 0;
  args_info->write_dg_max = 0;
  args_info->in_file_help = gengetopt_args_info_help[22] ;
  args_info->in_file_min = 0;
  args_info->in_file_max = 0;
  args_info->delete_dg_help = gengetopt_args_info_help[23] ;
  args_info->delete_dg_min = 0;
  args_info->delete_dg_max = 0;
  args_info->create_dg_help = gengetopt_args_info_help[24] ;
  args_info->create_dg_min = 0;
  args_info->create_dg_max = 0;
  args_info->new_size_help = gengetopt_args_info_help[25] ;
  args_info->new_read_ac_help = gengetopt_args_info_help[26] ;
  args_info->new_read_ac_chatbit_help = gengetopt_args_info_help[27] ;
  args_info->new_read_ac_chatbit_min = 0;
  args_info->new_read_ac_chatbit_max = 0;
  args_info->new_write_ac_help = gengetopt_args_info_help[28] ;
  args_info->new_write_ac_chatbit_help = gengetopt_args_info_help[29] ;
  args_info->new_write_ac_chatbit_min = 0;
  args_info->new_write_ac_chatbit_max = 0;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}

/**
 * The passed arg parameter is NOT set to 0 from this function
 */
static void
free_multiple_field(unsigned int len, void *arg, char ***orig)
{
  unsigned int i;
  if (arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*orig)[i]));
      }

    free (arg);
    free (*orig);
    *orig = 0;
  }
}

static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->reader_arg));
  free_string_field (&(args_info->reader_orig));
  free_multiple_string_field (args_info->certificate_given, &(args_info->certificate_arg), &(args_info->certificate_orig));
  free_string_field (&(args_info->key_arg));
  free_string_field (&(args_info->key_orig));
  free_string_field (&(args_info->write_cardid_arg));
  free_string_field (&(args_info->write_cardid_orig));
  free_string_field (&(args_info->write_paccessid_arg));
  free_string_field (&(args_info->write_paccessid_orig));
  free_multiple_field (args_info->read_dg_given, (void *)(args_info->read_dg_arg), &(args_info->read_dg_orig));
  args_info->read_dg_arg = 0;
  free_multiple_string_field (args_info->out_file_given, &(args_info->out_file_arg), &(args_info->out_file_orig));
  free_multiple_field (args_info->write_dg_given, (void *)(args_info->write_dg_arg), &(args_info->write_dg_orig));
  args_info->write_dg_arg = 0;
  free_multiple_string_field (args_info->in_file_given, &(args_info->in_file_arg), &(args_info->in_file_orig));
  free_multiple_field (args_info->delete_dg_given, (void *)(args_info->delete_dg_arg), &(args_info->delete_dg_orig));
  args_info->delete_dg_arg = 0;
  free_multiple_field (args_info->create_dg_given, (void *)(args_info->create_dg_arg), &(args_info->create_dg_orig));
  args_info->create_dg_arg = 0;
  free_string_field (&(args_info->new_size_orig));
  free_string_field (&(args_info->new_read_ac_arg));
  free_string_field (&(args_info->new_read_ac_orig));
  free_multiple_field (args_info->new_read_ac_chatbit_given, (void *)(args_info->new_read_ac_chatbit_arg), &(args_info->new_read_ac_chatbit_orig));
  args_info->new_read_ac_chatbit_arg = 0;
  free_string_field (&(args_info->new_write_ac_arg));
  free_string_field (&(args_info->new_write_ac_orig));
  free_multiple_field (args_info->new_write_ac_chatbit_given, (void *)(args_info->new_write_ac_chatbit_arg), &(args_info->new_write_ac_chatbit_orig));
  args_info->new_write_ac_chatbit_arg = 0;
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->reader_given)
    write_into_file(outfile, "reader", args_info->reader_orig, 0);
  write_multiple_into_file(outfile, args_info->verbose_given, "verbose", 0, 0);
  if (args_info->verify_pin_given)
    write_into_file(outfile, "verify-pin", 0, 0 );
  if (args_info->verify_bio_given)
    write_into_file(outfile, "verify-bio", 0, 0 );
  if (args_info->verify_pin_or_bio_given)
    write_into_file(outfile, "verify-pin-or-bio", 0, 0 );
  if (args_info->new_pin_given)
    write_into_file(outfile, "new-pin", 0, 0 );
  write_multiple_into_file(outfile, args_info->new_bio_given, "new-bio", 0, 0);
  if (args_info->info_given)
    write_into_file(outfile, "info", 0, 0 );
  write_multiple_into_file(outfile, args_info->certificate_given, "certificate", args_info->certificate_orig, 0);
  if (args_info->key_given)
    write_into_file(outfile, "key", args_info->key_orig, 0);
  if (args_info->print_cardid_given)
    write_into_file(outfile, "print-cardid", 0, 0 );
  if (args_info->write_cardid_given)
    write_into_file(outfile, "write-cardid", args_info->write_cardid_orig, 0);
  if (args_info->print_paccessid_given)
    write_into_file(outfile, "print-paccessid", 0, 0 );
  if (args_info->write_paccessid_given)
    write_into_file(outfile, "write-paccessid", args_info->write_paccessid_orig, 0);
  write_multiple_into_file(outfile, args_info->read_dg_given, "read-dg", args_info->read_dg_orig, 0);
  write_multiple_into_file(outfile, args_info->out_file_given, "out-file", args_info->out_file_orig, 0);
  write_multiple_into_file(outfile, args_info->write_dg_given, "write-dg", args_info->write_dg_orig, 0);
  write_multiple_into_file(outfile, args_info->in_file_given, "in-file", args_info->in_file_orig, 0);
  write_multiple_into_file(outfile, args_info->delete_dg_given, "delete-dg", args_info->delete_dg_orig, 0);
  write_multiple_into_file(outfile, args_info->create_dg_given, "create-dg", args_info->create_dg_orig, 0);
  if (args_info->new_size_given)
    write_into_file(outfile, "new-size", args_info->new_size_orig, 0);
  if (args_info->new_read_ac_given)
    write_into_file(outfile, "new-read-ac", args_info->new_read_ac_orig, cmdline_parser_new_read_ac_values);
  write_multiple_into_file(outfile, args_info->new_read_ac_chatbit_given, "new-read-ac-chatbit", args_info->new_read_ac_chatbit_orig, 0);
  if (args_info->new_write_ac_given)
    write_into_file(outfile, "new-write-ac", args_info->new_write_ac_orig, cmdline_parser_new_write_ac_values);
  write_multiple_into_file(outfile, args_info->new_write_ac_chatbit_given, "new-write-ac-chatbit", args_info->new_write_ac_chatbit_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->verbose_given, args_info->verbose_min, args_info->verbose_max, "'--verbose' ('-v')"))
     error_occurred = 1;
  
  if (args_info->soc_mode_counter && check_multiple_option_occurrences(prog_name, args_info->new_bio_given, args_info->new_bio_min, args_info->new_bio_max, "'--new-bio'"))
     error_occurred = 1;
  
  if (args_info->pxs_mode_counter && check_multiple_option_occurrences(prog_name, args_info->certificate_given, args_info->certificate_min, args_info->certificate_max, "'--certificate' ('-c')"))
     error_occurred = 1;
  
  if (args_info->pxs_mode_counter && check_multiple_option_occurrences(prog_name, args_info->read_dg_given, args_info->read_dg_min, args_info->read_dg_max, "'--read-dg'"))
     error_occurred = 1;
  
  if (args_info->pxs_mode_counter && check_multiple_option_occurrences(prog_name, args_info->out_file_given, args_info->out_file_min, args_info->out_file_max, "'--out-file'"))
     error_occurred = 1;
  
  if (args_info->pxs_mode_counter && check_multiple_option_occurrences(prog_name, args_info->write_dg_given, args_info->write_dg_min, args_info->write_dg_max, "'--write-dg'"))
     error_occurred = 1;
  
  if (args_info->pxs_mode_counter && check_multiple_option_occurrences(prog_name, args_info->in_file_given, args_info->in_file_min, args_info->in_file_max, "'--in-file'"))
     error_occurred = 1;
  
  if (args_info->pxs_mode_counter && check_multiple_option_occurrences(prog_name, args_info->delete_dg_given, args_info->delete_dg_min, args_info->delete_dg_max, "'--delete-dg'"))
     error_occurred = 1;
  
  if (args_info->pxs_mode_counter && check_multiple_option_occurrences(prog_name, args_info->create_dg_given, args_info->create_dg_min, args_info->create_dg_max, "'--create-dg'"))
     error_occurred = 1;
  
  if (args_info->pxs_mode_counter && check_multiple_option_occurrences(prog_name, args_info->new_read_ac_chatbit_given, args_info->new_read_ac_chatbit_min, args_info->new_read_ac_chatbit_max, "'--new-read-ac-chatbit'"))
     error_occurred = 1;
  
  if (args_info->pxs_mode_counter && check_multiple_option_occurrences(prog_name, args_info->new_write_ac_chatbit_given, args_info->new_write_ac_chatbit_min, args_info->new_write_ac_chatbit_max, "'--new-write-ac-chatbit'"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */
  if (args_info->certificate_given && ! args_info->key_given)
    {
      fprintf (stderr, "%s: '--certificate' ('-c') option depends on option 'key'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->key_given && ! args_info->certificate_given)
    {
      fprintf (stderr, "%s: '--key' ('-k') option depends on option 'certificate'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->new_size_given && ! args_info->create_dg_given)
    {
      fprintf (stderr, "%s: '--new-size' option depends on option 'create-dg'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->new_read_ac_given && ! args_info->create_dg_given)
    {
      fprintf (stderr, "%s: '--new-read-ac' option depends on option 'create-dg'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->new_read_ac_chatbit_given && ! args_info->create_dg_given)
    {
      fprintf (stderr, "%s: '--new-read-ac-chatbit' option depends on option 'create-dg'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->new_write_ac_given && ! args_info->create_dg_given)
    {
      fprintf (stderr, "%s: '--new-write-ac' option depends on option 'create-dg'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->new_write_ac_chatbit_given && ! args_info->create_dg_given)
    {
      fprintf (stderr, "%s: '--new-write-ac-chatbit' option depends on option 'create-dg'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

static int check_modes(
  int given1[], const char *options1[],
                       int given2[], const char *options2[])
{
  int i = 0, j = 0, errors = 0;
  
  while (given1[i] >= 0) {
    if (given1[i]) {
      while (given2[j] >= 0) {
        if (given2[j]) {
          ++errors;
          fprintf(stderr, "%s: option %s conflicts with option %s\n",
                  package_name, options1[i], options2[j]);
        }
        ++j;
      }
    }
    ++i;
  }
  
  return errors;
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * certificate_list = NULL;
  struct generic_list * read_dg_list = NULL;
  struct generic_list * out_file_list = NULL;
  struct generic_list * write_dg_list = NULL;
  struct generic_list * in_file_list = NULL;
  struct generic_list * delete_dg_list = NULL;
  struct generic_list * create_dg_list = NULL;
  struct generic_list * new_read_ac_chatbit_list = NULL;
  struct generic_list * new_write_ac_chatbit_list = NULL;
  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "reader",	1, NULL, 'r' },
        { "verbose",	0, NULL, 'v' },
        { "verify-pin",	0, NULL, 'p' },
        { "verify-bio",	0, NULL, 'b' },
        { "verify-pin-or-bio",	0, NULL, 0 },
        { "new-pin",	0, NULL, 0 },
        { "new-bio",	0, NULL, 0 },
        { "info",	0, NULL, 0 },
        { "certificate",	1, NULL, 'c' },
        { "key",	1, NULL, 'k' },
        { "print-cardid",	0, NULL, 0 },
        { "write-cardid",	1, NULL, 0 },
        { "print-paccessid",	0, NULL, 0 },
        { "write-paccessid",	1, NULL, 0 },
        { "read-dg",	1, NULL, 0 },
        { "out-file",	1, NULL, 0 },
        { "write-dg",	1, NULL, 0 },
        { "in-file",	1, NULL, 0 },
        { "delete-dg",	1, NULL, 0 },
        { "create-dg",	1, NULL, 0 },
        { "new-size",	1, NULL, 0 },
        { "new-read-ac",	1, NULL, 0 },
        { "new-read-ac-chatbit",	1, NULL, 0 },
        { "new-write-ac",	1, NULL, 0 },
        { "new-write-ac-chatbit",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVr:vpbc:k:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'r':	/* Number of the reader to use. By default, the first reader with a present card is used. If the argument is an ATR, the reader with a matching card will be chosen..  */
        
        
          if (update_arg( (void *)&(args_info->reader_arg), 
               &(args_info->reader_orig), &(args_info->reader_given),
              &(local_args_info.reader_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "reader", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Use (several times) to be more verbose.  */
        
          local_args_info.verbose_given++;
        
          break;
        case 'p':	/* Verify PIN.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->verify_pin_given),
              &(local_args_info.verify_pin_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "verify-pin", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* Verify finger print.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->verify_bio_given),
              &(local_args_info.verify_bio_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "verify-bio", 'b',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Use (several times) to pass CV certificates.  */
          args_info->pxs_mode_counter += 1;
        
          if (update_multiple_arg_temp(&certificate_list, 
              &(local_args_info.certificate_given), optarg, 0, 0, ARG_STRING,
              "certificate", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'k':	/* Private key for the CV certificate.  */
          args_info->pxs_mode_counter += 1;
        
        
          if (update_arg( (void *)&(args_info->key_arg), 
               &(args_info->key_orig), &(args_info->key_given),
              &(local_args_info.key_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "key", 'k',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Verify PIN or finger print (user's choice).  */
          if (strcmp (long_options[option_index].name, "verify-pin-or-bio") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->verify_pin_or_bio_given),
                &(local_args_info.verify_pin_or_bio_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "verify-pin-or-bio", '-',
                additional_error))
              goto failure;
          
          }
          /* Change PIN.  */
          else if (strcmp (long_options[option_index].name, "new-pin") == 0)
          {
            args_info->soc_mode_counter += 1;
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->new_pin_given),
                &(local_args_info.new_pin_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "new-pin", '-',
                additional_error))
              goto failure;
          
          }
          /* Use (several times) to change one or more biometric templates.  */
          else if (strcmp (long_options[option_index].name, "new-bio") == 0)
          {
            args_info->soc_mode_counter += 1;
          
            local_args_info.new_bio_given++;
          
          }
          /* Dump Information about the SoCManager's configuration.  */
          else if (strcmp (long_options[option_index].name, "info") == 0)
          {
            args_info->soc_mode_counter += 1;
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->info_given),
                &(local_args_info.info_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "info", '-',
                additional_error))
              goto failure;
          
          }
          /* Print the card ID.  */
          else if (strcmp (long_options[option_index].name, "print-cardid") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->print_cardid_given),
                &(local_args_info.print_cardid_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "print-cardid", '-',
                additional_error))
              goto failure;
          
          }
          /* Write the specified card ID.  */
          else if (strcmp (long_options[option_index].name, "write-cardid") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->write_cardid_arg), 
                 &(args_info->write_cardid_orig), &(args_info->write_cardid_given),
                &(local_args_info.write_cardid_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-cardid", '-',
                additional_error))
              goto failure;
          
          }
          /* Print the PAccess ID.  */
          else if (strcmp (long_options[option_index].name, "print-paccessid") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->print_paccessid_given),
                &(local_args_info.print_paccessid_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "print-paccessid", '-',
                additional_error))
              goto failure;
          
          }
          /* Write the specified PAccess ID.  */
          else if (strcmp (long_options[option_index].name, "write-paccessid") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->write_paccessid_arg), 
                 &(args_info->write_paccessid_orig), &(args_info->write_paccessid_given),
                &(local_args_info.write_paccessid_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "write-paccessid", '-',
                additional_error))
              goto failure;
          
          }
          /* Read the specified data group; use several times to read out multiple files.  */
          else if (strcmp (long_options[option_index].name, "read-dg") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
            if (update_multiple_arg_temp(&read_dg_list, 
                &(local_args_info.read_dg_given), optarg, 0, 0, ARG_INT,
                "read-dg", '-',
                additional_error))
              goto failure;
          
          }
          /* Write output to a file instead of printing it; use once for each use of `--read-dg'.  */
          else if (strcmp (long_options[option_index].name, "out-file") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
            if (update_multiple_arg_temp(&out_file_list, 
                &(local_args_info.out_file_given), optarg, 0, 0, ARG_STRING,
                "out-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Write the specified data group; use several times to write multiple files.  */
          else if (strcmp (long_options[option_index].name, "write-dg") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
            if (update_multiple_arg_temp(&write_dg_list, 
                &(local_args_info.write_dg_given), optarg, 0, 0, ARG_INT,
                "write-dg", '-',
                additional_error))
              goto failure;
          
          }
          /* Read input from a file; use once for each use of `--write-dg'.  */
          else if (strcmp (long_options[option_index].name, "in-file") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
            if (update_multiple_arg_temp(&in_file_list, 
                &(local_args_info.in_file_given), optarg, 0, 0, ARG_STRING,
                "in-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Delete the specified data group; use several times to delete multiple files.  */
          else if (strcmp (long_options[option_index].name, "delete-dg") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
            if (update_multiple_arg_temp(&delete_dg_list, 
                &(local_args_info.delete_dg_given), optarg, 0, 0, ARG_INT,
                "delete-dg", '-',
                additional_error))
              goto failure;
          
          }
          /* Create the specified data group; use several times to create multiple files.  */
          else if (strcmp (long_options[option_index].name, "create-dg") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
            if (update_multiple_arg_temp(&create_dg_list, 
                &(local_args_info.create_dg_given), optarg, 0, 0, ARG_INT,
                "create-dg", '-',
                additional_error))
              goto failure;
          
          }
          /* File size of newly created DGs.  */
          else if (strcmp (long_options[option_index].name, "new-size") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->new_size_arg), 
                 &(args_info->new_size_orig), &(args_info->new_size_given),
                &(local_args_info.new_size_given), optarg, 0, "256", ARG_INT,
                check_ambiguity, override, 0, 0,
                "new-size", '-',
                additional_error))
              goto failure;
          
          }
          /* Access condition for reading newly created DGs.  */
          else if (strcmp (long_options[option_index].name, "new-read-ac") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->new_read_ac_arg), 
                 &(args_info->new_read_ac_orig), &(args_info->new_read_ac_given),
                &(local_args_info.new_read_ac_given), optarg, cmdline_parser_new_read_ac_values, "sm", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "new-read-ac", '-',
                additional_error))
              goto failure;
          
          }
          /* Required access bits in certificate's CHAT for reading newly created DGs.  */
          else if (strcmp (long_options[option_index].name, "new-read-ac-chatbit") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
            if (update_multiple_arg_temp(&new_read_ac_chatbit_list, 
                &(local_args_info.new_read_ac_chatbit_given), optarg, 0, 0, ARG_INT,
                "new-read-ac-chatbit", '-',
                additional_error))
              goto failure;
          
          }
          /* Access condition for writing newly created DGs.  */
          else if (strcmp (long_options[option_index].name, "new-write-ac") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
          
            if (update_arg( (void *)&(args_info->new_write_ac_arg), 
                 &(args_info->new_write_ac_orig), &(args_info->new_write_ac_given),
                &(local_args_info.new_write_ac_given), optarg, cmdline_parser_new_write_ac_values, "sm", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "new-write-ac", '-',
                additional_error))
              goto failure;
          
          }
          /* Required access bits in certificate's CHAT for reading newly created DGs.  */
          else if (strcmp (long_options[option_index].name, "new-write-ac-chatbit") == 0)
          {
            args_info->pxs_mode_counter += 1;
          
            if (update_multiple_arg_temp(&new_write_ac_chatbit_list, 
                &(local_args_info.new_write_ac_chatbit_given), optarg, 0, 0, ARG_INT,
                "new-write-ac-chatbit", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->certificate_arg),
    &(args_info->certificate_orig), args_info->certificate_given,
    local_args_info.certificate_given, 0,
    ARG_STRING, certificate_list);
  update_multiple_arg((void *)&(args_info->read_dg_arg),
    &(args_info->read_dg_orig), args_info->read_dg_given,
    local_args_info.read_dg_given, 0,
    ARG_INT, read_dg_list);
  update_multiple_arg((void *)&(args_info->out_file_arg),
    &(args_info->out_file_orig), args_info->out_file_given,
    local_args_info.out_file_given, 0,
    ARG_STRING, out_file_list);
  update_multiple_arg((void *)&(args_info->write_dg_arg),
    &(args_info->write_dg_orig), args_info->write_dg_given,
    local_args_info.write_dg_given, 0,
    ARG_INT, write_dg_list);
  update_multiple_arg((void *)&(args_info->in_file_arg),
    &(args_info->in_file_orig), args_info->in_file_given,
    local_args_info.in_file_given, 0,
    ARG_STRING, in_file_list);
  update_multiple_arg((void *)&(args_info->delete_dg_arg),
    &(args_info->delete_dg_orig), args_info->delete_dg_given,
    local_args_info.delete_dg_given, 0,
    ARG_INT, delete_dg_list);
  update_multiple_arg((void *)&(args_info->create_dg_arg),
    &(args_info->create_dg_orig), args_info->create_dg_given,
    local_args_info.create_dg_given, 0,
    ARG_INT, create_dg_list);
  update_multiple_arg((void *)&(args_info->new_read_ac_chatbit_arg),
    &(args_info->new_read_ac_chatbit_orig), args_info->new_read_ac_chatbit_given,
    local_args_info.new_read_ac_chatbit_given, 0,
    ARG_INT, new_read_ac_chatbit_list);
  update_multiple_arg((void *)&(args_info->new_write_ac_chatbit_arg),
    &(args_info->new_write_ac_chatbit_orig), args_info->new_write_ac_chatbit_given,
    local_args_info.new_write_ac_chatbit_given, 0,
    ARG_INT, new_write_ac_chatbit_list);

  args_info->verbose_given += local_args_info.verbose_given;
  local_args_info.verbose_given = 0;
  args_info->new_bio_given += local_args_info.new_bio_given;
  local_args_info.new_bio_given = 0;
  args_info->certificate_given += local_args_info.certificate_given;
  local_args_info.certificate_given = 0;
  args_info->read_dg_given += local_args_info.read_dg_given;
  local_args_info.read_dg_given = 0;
  args_info->out_file_given += local_args_info.out_file_given;
  local_args_info.out_file_given = 0;
  args_info->write_dg_given += local_args_info.write_dg_given;
  local_args_info.write_dg_given = 0;
  args_info->in_file_given += local_args_info.in_file_given;
  local_args_info.in_file_given = 0;
  args_info->delete_dg_given += local_args_info.delete_dg_given;
  local_args_info.delete_dg_given = 0;
  args_info->create_dg_given += local_args_info.create_dg_given;
  local_args_info.create_dg_given = 0;
  args_info->new_read_ac_chatbit_given += local_args_info.new_read_ac_chatbit_given;
  local_args_info.new_read_ac_chatbit_given = 0;
  args_info->new_write_ac_chatbit_given += local_args_info.new_write_ac_chatbit_given;
  local_args_info.new_write_ac_chatbit_given = 0;
  
  if (args_info->pxs_mode_counter && args_info->soc_mode_counter) {
    int pxs_given[] = {args_info->certificate_given, args_info->key_given, args_info->print_cardid_given, args_info->write_cardid_given, args_info->print_paccessid_given, args_info->write_paccessid_given, args_info->read_dg_given, args_info->out_file_given, args_info->write_dg_given, args_info->in_file_given, args_info->delete_dg_given, args_info->create_dg_given, args_info->new_size_given, args_info->new_read_ac_given, args_info->new_read_ac_chatbit_given, args_info->new_write_ac_given, args_info->new_write_ac_chatbit_given,  -1};
    const char *pxs_desc[] = {"--certificate", "--key", "--print-cardid", "--write-cardid", "--print-paccessid", "--write-paccessid", "--read-dg", "--out-file", "--write-dg", "--in-file", "--delete-dg", "--create-dg", "--new-size", "--new-read-ac", "--new-read-ac-chatbit", "--new-write-ac", "--new-write-ac-chatbit",  0};
    int soc_given[] = {args_info->new_pin_given, args_info->new_bio_given, args_info->info_given,  -1};
    const char *soc_desc[] = {"--new-pin", "--new-bio", "--info",  0};
    error_occurred += check_modes(pxs_given, pxs_desc, soc_given, soc_desc);
  }
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (certificate_list, 1 );
  free_list (read_dg_list, 0 );
  free_list (out_file_list, 1 );
  free_list (write_dg_list, 0 );
  free_list (in_file_list, 1 );
  free_list (delete_dg_list, 0 );
  free_list (create_dg_list, 0 );
  free_list (new_read_ac_chatbit_list, 0 );
  free_list (new_write_ac_chatbit_list, 0 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
