#ifndef EXPORTCCDLG_H
#define EXPORTCCDLG_H

#include <QObject>
#include <QWidget>
#include <QtGui>
#include <QDialog>
#include <QGridLayout>
#include <QLineEdit>
#include <QPlainTextEdit>
#include <QComboBox>
#include <QSpinBox>
#include <QCheckBox>
#include <QDialogButtonBox>
#include "molecule.h"

#if defined Q_WS_WIN || defined Q_OS_WIN
#define FONTFAM "Lucida Console"
#elif defined Q_WS_MAC || defined Q_OS_MAC
#define FONTFAM "Monaco"
#else
#define FONTFAM "Droid Sans Mono"
#endif
class ExportCCDlg : public QDialog{
Q_OBJECT
public:
    ExportCCDlg(QString _dirName,Molecule *_mole,QString fn);
public slots:
    void makeHeader();
protected slots:
void accept () ;
private:
    QFile f;
    QString dirName;
    Molecule *mole;
    QGridLayout *glt;
    QLineEdit *titlE;
    QPlainTextEdit *pe;
    QComboBox *calcbox;
    QSpinBox *nproc;
    QSpinBox *mem;
    QSpinBox *charge;
    QSpinBox *multipl;
    QComboBox *membx;
    QComboBox *theorbox;
    QComboBox *basisbox;
    QComboBox *outputLevel;
    QCheckBox *sve;
    QCheckBox *chk;
    QCheckBox *spec;
    QDialogButtonBox *bb;
    QString headerQM, bodyQM, footerQM, filenameQM;
};

#endif // EXPORTCCDLG_H
