-- DROP COLUMN examples
ALTER TABLE x DROP COLUMN y;
ALTER TABLE x DROP COLUMN IF EXISTS y;
ALTER TABLE x ON CLUSTER '{cluster}' DROP COLUMN y;
ALTER TABLE x ON CLUSTER '{cluster}' DROP COLUMN IF EXISTS y;
ALTER TABLE visits DROP COLUMN browser;

-- ADD COLUMN examples
ALTER TABLE x ADD COLUMN y Int32;
ALTER TABLE x ADD COLUMN y Int32 DEFAULT 1;
ALTER TABLE x ADD COLUMN IF NOT EXISTS y Int32;
ALTER TABLE x ADD COLUMN IF NOT EXISTS y Int32 DEFAULT 1;

ALTER TABLE alter_test ADD COLUMN Added1 UInt32 FIRST;
ALTER TABLE alter_test ADD COLUMN Added2 UInt32 AFTER NestedColumn;
ALTER TABLE alter_test ADD COLUMN Added3 UInt32 AFTER ToDrop;

ALTER TABLE x ON CLUSTER '{cluster}' ADD COLUMN y Int32;
ALTER TABLE x ON CLUSTER '{cluster}' ADD COLUMN y Int32 DEFAULT 1;
ALTER TABLE x ON CLUSTER '{cluster}' ADD COLUMN IF NOT EXISTS y Int32;
ALTER TABLE x ON CLUSTER '{cluster}' ADD COLUMN IF NOT EXISTS y Int32 DEFAULT 1;

-- ADD COLUMN with CODEC and AFTER/FIRST
ALTER TABLE x ADD COLUMN z Int32 CODEC(ZSTD);
ALTER TABLE x ADD COLUMN z Int32 AFTER y;
ALTER TABLE x ADD COLUMN z Int32 FIRST;
ALTER TABLE x ADD COLUMN z Int32 DEFAULT 0 CODEC(ZSTD) AFTER y;

-- RENAME COLUMN examples
ALTER TABLE x RENAME COLUMN old_name TO new_name;
ALTER TABLE x RENAME COLUMN IF EXISTS old_name TO new_name;
ALTER TABLE x ON CLUSTER '{cluster}' RENAME COLUMN old_name TO new_name;
ALTER TABLE x ON CLUSTER '{cluster}' RENAME COLUMN IF EXISTS old_name TO new_name;
ALTER TABLE visits RENAME COLUMN webBrowser TO browser;

-- COMMENT COLUMN examples
ALTER TABLE x COMMENT COLUMN col_name 'This is a comment';
ALTER TABLE x COMMENT COLUMN IF EXISTS col_name 'Column description';
ALTER TABLE x ON CLUSTER '{cluster}' COMMENT COLUMN col_name 'Cluster-wide comment';
ALTER TABLE x ON CLUSTER '{cluster}' COMMENT COLUMN IF EXISTS col_name 'Cluster-wide description';
ALTER TABLE visits COMMENT COLUMN browser 'This column shows the browser used for accessing the site.';

-- COMMENT TABLE examples
ALTER TABLE x COMMENT 'This is a table comment';
ALTER TABLE x ON CLUSTER '{cluster}' COMMENT 'This is a table comment';
ALTER TABLE x MODIFY COMMENT '';

-- MODIFY COLUMN examples
ALTER TABLE x MODIFY COLUMN col_name Int64;
ALTER TABLE x MODIFY COLUMN IF EXISTS col_name Int64;
ALTER TABLE x MODIFY COLUMN col_name Int64 DEFAULT 0;
ALTER TABLE x MODIFY COLUMN col_name Int64 CODEC(ZSTD);
ALTER TABLE x MODIFY COLUMN col_name Int64 AFTER other_col;
ALTER TABLE x MODIFY COLUMN col_name Int64 FIRST;
ALTER TABLE x ON CLUSTER '{cluster}' MODIFY COLUMN col_name Int64 DEFAULT 0 CODEC(ZSTD) AFTER other_col;
ALTER TABLE visits MODIFY COLUMN browser Array(String);
ALTER TABLE users MODIFY COLUMN c2 String FIRST;
ALTER TABLE users MODIFY COLUMN c2 TYPE String AFTER c1;

-- MATERIALIZE COLUMN examples
ALTER TABLE x MATERIALIZE COLUMN col_name;
ALTER TABLE x MATERIALIZE COLUMN col_name IN PARTITION partition_name;
ALTER TABLE x MATERIALIZE COLUMN col_name IN PARTITION ID 'partition_id';
ALTER TABLE x ON CLUSTER '{cluster}' MATERIALIZE COLUMN col_name;
ALTER TABLE x ON CLUSTER '{cluster}' MATERIALIZE COLUMN col_name IN PARTITION partition_name;
ALTER TABLE tmp ADD COLUMN s String MATERIALIZED toString(x);
ALTER TABLE tmp MODIFY COLUMN s String MATERIALIZED toString(round(100/x));
ALTER TABLE tmp MATERIALIZE COLUMN s;

-- ALIAS examples
ALTER TABLE x ADD ALIAS alias_name FOR col_name;
ALTER TABLE x ADD ALIAS IF NOT EXISTS alias_name FOR col_name;
ALTER TABLE x ON CLUSTER '{cluster}' MODIFY COLUMN y ALIAS z/10;
ALTER TABLE x ON CLUSTER '{cluster}' ADD ALIAS alias_name FOR col_name;
ALTER TABLE x ON CLUSTER '{cluster}' MODIFY COLUMN y REMOVE ALIAS;
ALTER TABLE x ON CLUSTER '{cluster}' ADD COLUMN IF NOT EXISTS y Float32 ALIAS z*100;

-- TTL examples
ALTER TABLE table_with_ttl MODIFY COLUMN column_ttl REMOVE TTL;
ALTER TABLE table_with_ttl REMOVE TTL;
ALTER TABLE table_with_ttl ON CLUSTER '{cluster}' REMOVE TTL;
ALTER TABLE table_name ON CLUSTER '{cluster}' MODIFY TTL event_time + INTERVAL 3 MONTH;

-- ALIAS examples
ALTER TABLE x ADD COLUMN y Int32 ALIAS z + 10;
ALTER TABLE x ON CLUSTER '{cluster}' ADD COLUMN IF NOT EXISTS y Float32 ALIAS z * 100;
ALTER TABLE x MODIFY COLUMN y ALIAS z/10;
ALTER TABLE x ON CLUSTER '{cluster}' MODIFY COLUMN y REMOVE ALIAS;

-- Basic ALTER TABLE MODIFY QUERY examples
ALTER TABLE mv MODIFY QUERY SELECT * FROM source_table;
ALTER TABLE mv MODIFY QUERY SELECT id, name, value FROM source_table WHERE value > 0;

-- With ON CLUSTER clause
ALTER TABLE mv ON CLUSTER cluster1 MODIFY QUERY SELECT * FROM source_table;
ALTER TABLE mv ON CLUSTER '{cluster}' MODIFY QUERY SELECT id, name, value FROM source_table WHERE value > 0;

-- With complex SELECT queries
ALTER TABLE mv MODIFY QUERY
  SELECT
    id,
    name,
    sum(value) AS total_value
  FROM source_table
  GROUP BY id, name
  HAVING total_value > 100
  ORDER BY total_value DESC
  LIMIT 10;

ALTER TABLE mv MODIFY QUERY
  SELECT
    t1.id,
    t1.name,
    t2.value
  FROM table1 AS t1
  JOIN table2 AS t2 ON t1.id = t2.id
  WHERE t1.active = 1;

-- DROP PARTITION examples
ALTER TABLE x DROP PARTITION y;
ALTER TABLE x ON CLUSTER '{cluster}' DROP PARTITION 'y';
ALTER TABLE x DROP PART 'y';
ALTER TABLE x ON CLUSTER '{cluster}' DROP PART 'y';

-- REPLACE PARTITION examples
ALTER TABLE x REPLACE PARTITION 'y' FROM z;
ALTER TABLE x ON CLUSTER '{cluster}' REPLACE PARTITION 'y' FROM z;
