#include <iostream>

#include "CommandlineOptions.hh"

#include "Facets.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing the facets of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  Cocircuits cocircuits;
  if (cocircuits.read_string(std::cin)) {
    MessageStreams::result() << Facets(cocircuits) << std::endl;
    return 0;
  }
  else {
    return 1;
  }
}

// eof cocircuits2facets.cc
