#include <iostream>

#include "CommandlineOptions.hh"

#include "PlacingTriang.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing a placing triangulation of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  PointConfiguration points;
  if (std::cin >> points) {
    if (points.rank() < points.rowdim()) {
      MessageStreams::verbose() << "point configuration has " << points.rowdim() << " rows of rank " << points.rank() << std::endl;
      points.transform_to_full_rank();
      MessageStreams::verbose() << "resulting no of rows after transformation: " << points.rank() << std::endl;
      points.pretty_print(MessageStreams::verbose());
    }
    if ((points.no() < 1) || (points.rank() < 1)) {
      MessageStreams::forced() << "no of points and rank must be at least one." << std::endl;
      return 1;
    }
    if (points.rank() > points.no()) {
      MessageStreams::forced() << "rank must not be larger than no of points." << std::endl;
      return 1;
    }
    Chirotope chiro(points, false);
    MessageStreams::result() << PlacingTriang(chiro) << std::endl;
    return 0;
  }
  else {
    MessageStreams::forced() << "chiro2placingtriang: error while reading point configuration."
			     << std::endl;
    return 1;
  }
}

// eof points2placingtriang.cc
