/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JLineup
extends JPanel {
    private ArrayList<Unit> content = new ArrayList();
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    private int dir;
    private int padding;

    public JLineup(int dir) {
        this.dir = dir;
        this.padding = 0;
    }

    public JLineup(int dir, int padding) {
        this.dir = dir;
        this.padding = padding;
    }

    public void clear() {
        for (int n = 0; n < this.content.size(); ++n) {
            Unit u = this.content.get(n);
            super.remove(u.c);
            if (u.label == null) continue;
            super.remove(u.label);
        }
        this.content.clear();
    }

    public void remove(Component c) {
        for (int n = 0; n < this.content.size(); ++n) {
            Unit u = this.content.get(n);
            if (u.c != c) continue;
            super.remove(c);
            if (u.label == null) continue;
            super.remove(u.label);
        }
    }

    public Component add(Component c) {
        return this.add(c, null, 0, 0);
    }

    public Component add(Component c, String title) {
        return this.add(c, title, 0, 0);
    }

    public Component add(Component c, String title, int stretchX, int stretchY) {
        super.add(c);
        Unit u = new Unit();
        u.c = c;
        u.label = null;
        u.stretchX = stretchX;
        u.stretchY = stretchY;
        if (title != null) {
            u.label = new JLabel(title);
            super.add(u.label);
        }
        this.content.add(u);
        this.invalidate();
        return c;
    }

    public Dimension getMinimumSize() {
        Dimension sz = new Dimension(0, 0);
        if (this.dir == 1) {
            int mw = 0;
            for (int n = 0; n < this.content.size(); ++n) {
                Unit u = this.content.get(n);
                mw = Math.max(mw, u.c.getPreferredSize().width);
                sz.height = sz.height + Math.max(u.label == null ? 0 : u.label.getPreferredSize().height, u.c.getPreferredSize().height);
            }
            sz.width = this.calculateTitleWidth() + mw + 2 * this.padding;
            sz.height += this.padding * (this.content.size() + 1);
        } else {
            boolean mh = false;
            for (int n = 0; n < this.content.size(); ++n) {
                Unit u = this.content.get(n);
                if (u.label != null) {
                    sz.width += u.label.getPreferredSize().width + this.padding;
                    sz.height = Math.max(sz.height, u.label.getPreferredSize().height);
                }
                sz.width += u.c.getPreferredSize().width;
                sz.height = Math.max(sz.height, u.c.getPreferredSize().height);
            }
            sz.width += this.padding * (this.content.size() + 1);
            sz.height += this.padding * 2;
        }
        return sz;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        Dimension sz = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        boolean anyX = false;
        boolean anyY = false;
        boolean y = false;
        for (int n = 0; n < this.content.size(); ++n) {
            Unit u = this.content.get(n);
            anyX = anyX || u.stretchX > 0;
            anyY = anyY || u.stretchY > 0;
        }
        if (!anyX || !anyY) {
            Dimension psz = this.getPreferredSize();
            if (!anyX) {
                sz.width = psz.width;
            }
            if (!anyY) {
                sz.height = psz.height;
            }
        }
        return sz;
    }

    public void doLayout() {
        if (this.dir == 1) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
    }

    private void layoutVertical() {
        Dimension prefsz = this.getPreferredSize();
        Dimension cursz = this.getSize();
        int totalStretch = 0;
        int stretchPoints = cursz.height - prefsz.height;
        if (stretchPoints > 0) {
            for (int n = 0; n < this.content.size(); ++n) {
                totalStretch += this.content.get((int)n).stretchY;
            }
        }
        int tw = this.calculateTitleWidth();
        int residual = stretchPoints;
        int cw = cursz.width - tw - 2 * this.padding;
        int y = this.padding;
        for (int n = 0; n < this.content.size(); ++n) {
            Unit u = this.content.get(n);
            int h = Math.max(u.label == null ? 0 : u.label.getPreferredSize().height, u.c.getPreferredSize().height);
            if (u.stretchY > 0 && stretchPoints > 0) {
                int extra = (int)Math.min(Math.ceil((double)(stretchPoints * u.stretchY) / (double)totalStretch), (double)residual);
                h += extra;
                residual -= extra;
            }
            if (u.label != null) {
                int ly = y;
                if (u.c instanceof JComponent) {
                    int delta = ((JComponent)u.c).getBaseline(tw, h) - u.label.getBaseline(cw, u.label.getPreferredSize().height);
                    ly += delta > 0 ? delta : 0;
                }
                u.label.setBounds(this.padding, ly, tw, u.label.getPreferredSize().height);
            }
            u.c.setBounds(this.padding + tw, y, u.stretchX == 0 ? u.c.getPreferredSize().width : cw, h);
            y += h + this.padding;
        }
    }

    private void layoutHorizontal() {
        Dimension prefsz = this.getPreferredSize();
        Dimension cursz = this.getSize();
        int totalStretch = 0;
        int stretchPoints = cursz.height - prefsz.height - 2 * this.padding;
        if (stretchPoints > 0) {
            for (int n = 0; n < this.content.size(); ++n) {
                totalStretch += this.content.get((int)n).stretchX;
            }
        }
        int residual = stretchPoints;
        int x = this.padding;
        for (int n = 0; n < this.content.size(); ++n) {
            int ch;
            Unit u = this.content.get(n);
            int w = u.c.getPreferredSize().width;
            int h = cursz.height - 2 * this.padding;
            int n2 = ch = u.stretchY == 0 ? u.c.getPreferredSize().height : h;
            if (u.stretchX > 0 && stretchPoints > 0) {
                int extra = (int)Math.min(Math.ceil((double)(stretchPoints * u.stretchX) / (double)totalStretch), (double)residual);
                w += extra;
                residual -= extra;
            }
            if (u.label != null) {
                int ly = this.padding;
                Dimension lsz = u.label.getPreferredSize();
                if (u.c instanceof JComponent) {
                    int delta = ((JComponent)u.c).getBaseline(w, ch) - u.label.getBaseline(lsz.width, lsz.height);
                    ly += delta > 0 ? delta : 0;
                }
                u.label.setBounds(x, ly, lsz.width, lsz.height);
                x += lsz.width + this.padding;
            }
            u.c.setBounds(x, this.padding, w, ch);
            x += w + this.padding;
        }
    }

    private int calculateTitleWidth() {
        int w = 0;
        for (int n = 0; n < this.content.size(); ++n) {
            Unit u = this.content.get(n);
            if (u.label == null) continue;
            w = Math.max(w, u.label.getPreferredSize().width);
        }
        if (w > 0) {
            w += this.padding;
        }
        return w;
    }

    class Unit {
        Component c;
        JLabel label;
        int stretchX;
        int stretchY;

        Unit() {
        }
    }
}

